/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.CCompile;

import UI_Components.Dialog.OpenFileDialog;
import UI_Components.GBC;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.CCompile.CCompileTool;
import Utilities.FileUtils;
import Utilities.VectorUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class KFilePathsPanel
extends KTitledPanel
implements ActionListener {
    private static final int MAX_POPUP_TEXT_LENGTH = 19;
    private static final String EMPTY_LIST_STR = "empty list";
    private KTextField pathTextField = new KTextField(15);
    private PathsComboPanel pathsComboPanel = new PathsComboPanel(this.pathTextField);
    private JButton addButton = new JButton(" Add... ");
    private JButton rmvButton = new JButton("Delete");
    private String beginStr;
    private String endStr;
    private OpenFileDialog openFileDialog = OpenFileDialog.getInstance(Cutter.desktop);
    private int fileSelectionMode = 1;
    private String approveButtonText = "Choose Directory";
    private File prevDir = null;
    private final String title;

    public KFilePathsPanel(String title) {
        super(title);
        this.title = title;
        this.beginStr = this.beginStr;
        this.endStr = this.endStr;
        this.pathsComboPanel.setPreferredSize(new Dimension(170, 25));
        this.pathsComboPanel.setMinimumSize(this.pathsComboPanel.getPreferredSize());
        this.addButton.setMargin(new Insets(2, 5, 0, 5));
        this.rmvButton.setMargin(new Insets(2, 5, 0, 5));
        this.rmvButton.setEnabled(true);
        this.add(this.pathsComboPanel, new GBC(0, 0, 2, 1, 1.0, 0.0, 0, -4, 18, 0, new Insets(0, 15, 0, 5)));
        this.add(this.pathTextField, new GBC(0, 1, 2, 1, 1.0, 0.0, 0, 2, 18, 0, new Insets(10, 16, 2, 5)));
        this.add(this.addButton, new GBC(1, 2, 1, 1, 0.0, 0.0, 0, 0, 12, 0, new Insets(5, 60, 10, 5)));
        this.add(new JPanel(), new GBC(2, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(0, 0, 0, 0)));
        this.add(this.rmvButton, new GBC(0, 2, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(5, 15, 10, 5)));
        this.pathTextField.usesModelDialog = true;
        this.pathTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentText = KFilePathsPanel.this.pathTextField.getText();
                if (currentText == null || currentText.trim().length() == 0) {
                    currentText = KFilePathsPanel.EMPTY_LIST_STR;
                }
                int n = KFilePathsPanel.this.pathsComboPanel.getSelectedIndex();
                PathItem currentItem = KFilePathsPanel.this.pathsComboPanel.getSelectedItem();
                if (currentItem != null && !currentItem.isEmptyListItem()) {
                    PathItem newItem = new PathItem(currentText);
                    KFilePathsPanel.this.pathsComboPanel.removeItem(currentItem);
                    KFilePathsPanel.this.pathsComboPanel.insertItemAt(newItem, n);
                    KFilePathsPanel.this.pathsComboPanel.setSelectedIndex(n);
                    KFilePathsPanel.this.rmvButton.setEnabled(true);
                }
                if (!new File(KFilePathsPanel.this.pathTextField.getText()).exists()) {
                    KFilePathsPanel.this.pathTextField.setForeground(Color.red);
                } else {
                    KFilePathsPanel.this.pathTextField.setForeground(Color.black);
                }
            }
        });
        this.rmvButton.addActionListener(this);
        if (this.pathsComboPanel.getSelectedItem().isEmptyListItem()) {
            this.rmvButton.setEnabled(false);
        } else {
            this.rmvButton.setEnabled(true);
        }
        this.addButton.addActionListener(this);
        this.pathsComboPanel.addEmptyPathItem();
    }

    public void setFileSelectionMode(int mode) {
        this.fileSelectionMode = mode;
    }

    public void setApproveButtonText(String str) {
        this.approveButtonText = str;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.rmvButton) {
            PathItem item = this.pathsComboPanel.getSelectedItem();
            this.pathsComboPanel.removeItem(item);
            if (this.pathsComboPanel.getSelectedItem().isEmptyListItem()) {
                this.rmvButton.setEnabled(false);
            }
            CCompileTool.tool.saveSelf();
            return;
        }
        if (e.getSource() == this.addButton) {
            File dir = this.choosePath();
            if (dir == null) {
                Cutter.setLog("choosePath returned null");
                return;
            }
            PathItem item = new PathItem(dir.getPath());
            this.pathsComboPanel.addItem(item);
            this.rmvButton.setEnabled(true);
            CCompileTool.tool.saveSelf();
        }
    }

    public void clearAllPaths() {
        this.pathsComboPanel.removeAllItems();
    }

    public void addPaths(String[] paths) {
        if (paths == null || paths.length == 0) {
            Cutter.setLog("    Warning:KFilePathsPanel (" + this.title + ") addPaths() - paths is null or empty");
            return;
        }
        for (int n = 0; n < paths.length; ++n) {
            PathItem item = new PathItem(paths[n]);
            this.pathsComboPanel.addItem(item);
            this.pathsComboPanel.setSelectedItem(item);
        }
        this.rmvButton.setEnabled(true);
    }

    private File choosePath() {
        PathItem obj = this.pathsComboPanel.getSelectedItem();
        String path = null;
        if (obj instanceof PathItem) {
            path = obj.longform;
        }
        File oldDir = this.openFileDialog.getPrevFile();
        if (this.prevDir == null && path != null && new File(path).exists()) {
            this.prevDir = new File(path);
        } else if (this.prevDir != null) {
            this.openFileDialog.setPrevFile(this.prevDir);
        } else {
            this.openFileDialog.setPrevFile(FileUtils.getPWDFile());
        }
        File[] files = this.openFileDialog.showSelf(null, this.approveButtonText, this.fileSelectionMode);
        this.openFileDialog.setPrevFile(oldDir);
        if (files == null || files.length == 0) {
            return null;
        }
        this.prevDir = files[0];
        return files[0];
    }

    public String[] getPaths() {
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < this.pathsComboPanel.getItemCount(); ++n) {
            PathItem item = this.pathsComboPanel.getItemAt(n);
            if (item.isEmptyListItem()) continue;
            v.addElement(item.longform);
        }
        if (v.size() == 0) {
            return null;
        }
        return VectorUtils.toStringArray(v);
    }

    public class PathsComboPanel
    extends JPanel
    implements ActionListener {
        private PathItem defaultItem;
        private JComboBox<PathItem> combo;
        private KTextField pathField;

        public PathsComboPanel(KTextField pathField) {
            this.defaultItem = new PathItem(KFilePathsPanel.EMPTY_LIST_STR);
            this.combo = new JComboBox();
            this.pathField = pathField;
            this.addEmptyPathItem();
            this.setSelectedIndex(0);
            this.combo.setMaximumRowCount(10);
            this.setLayout(new GridBagLayout());
            this.combo.setFont(Cutter.defaultFont.font);
            this.add(this.combo, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
            this.combo.addActionListener(this);
        }

        public void checkPathValidity() {
            if (!new File(this.pathField.getText()).exists()) {
                this.pathField.setForeground(Color.red);
            } else {
                this.pathField.setForeground(Color.black);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JComboBox cb = (JComboBox)evt.getSource();
            PathItem item = (PathItem)cb.getSelectedItem();
            if (item == null) {
                return;
            }
            String str = item.longform;
            this.pathField.setText(str == null ? "ERROR line 120" : str);
            this.checkPathValidity();
        }

        public void addEmptyPathItem() {
            int num = this.combo.getItemCount();
            for (int n = 0; n < num; ++n) {
                PathItem pi = this.combo.getItemAt(n);
                if (pi == null || !pi.isEmptyListItem()) continue;
                return;
            }
            this.combo.addItem(this.defaultItem);
        }

        public int removeEmptyPathItem() {
            int num = this.combo.getItemCount();
            int count = 0;
            for (int n = 0; n < num; ++n) {
                PathItem pi = this.combo.getItemAt(n);
                if (pi == null || !pi.isEmptyListItem()) continue;
                this.combo.removeItemAt(n);
                ++count;
            }
            return count;
        }

        public void addItem(PathItem item) {
            if (item == null) {
                return;
            }
            int num = this.combo.getItemCount();
            for (int n = 0; n < num; ++n) {
                PathItem pi = this.combo.getItemAt(n);
                if (!item.isSameAs(pi)) continue;
                return;
            }
            this.combo.addItem(item);
            int count = this.removeEmptyPathItem();
            this.setSelectedItem(item);
        }

        public void removeItem(PathItem item) {
            if (item == null) {
                return;
            }
            if (this.combo.getItemCount() == 1 && this.getSelectedItem().isEmptyListItem()) {
                return;
            }
            this.combo.removeItem(item);
            if (this.getItemCount() == 0) {
                this.addEmptyPathItem();
            }
        }

        public void removeItemAt(int n) {
            this.combo.removeItemAt(n);
            if (this.getItemCount() == 0) {
                this.addEmptyPathItem();
            }
        }

        public void removeAllItems() {
            this.combo.removeAllItems();
            this.addEmptyPathItem();
        }

        public int getSelectedIndex() {
            return this.combo.getSelectedIndex();
        }

        public PathItem getSelectedItem() {
            return (PathItem)this.combo.getSelectedItem();
        }

        public void setSelectedItem(PathItem item) {
            this.combo.setSelectedItem(item);
        }

        public void insertItemAt(PathItem newItem, int n) {
            this.combo.insertItemAt(newItem, n);
        }

        public void setSelectedIndex(int n) {
            this.combo.setSelectedIndex(n);
        }

        public int getItemCount() {
            return this.combo.getItemCount();
        }

        public PathItem getItemAt(int n) {
            return this.combo.getItemAt(n);
        }
    }

    public class PathItem
    extends JComponent {
        private String longform = "";
        private String shortform = "";
        private boolean isEmptyListItem = false;

        public PathItem(String str) {
            this.isEmptyListItem = str.equals(KFilePathsPanel.EMPTY_LIST_STR);
            this.shortform = str;
            this.longform = str;
            if (str.length() > 19) {
                this.shortform = "..." + str.substring(str.length() - 19);
            }
        }

        public boolean isEmptyListItem() {
            return this.isEmptyListItem;
        }

        @Override
        public String toString() {
            return this.shortform;
        }

        public boolean isSameAs(PathItem item) {
            return item.longform.equals(this.longform);
        }
    }
}

