/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.DsoServer;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KButton.PathSearchButton;
import UI_Components.KLabelledField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Script.BuildMsgListener;
import UI_Script.PixarDev.ProceduralPrimitive.ProceduralPrimitiveScriptHandler;
import UI_Script.PixarDev.RixPlugins.RixPluginScriptHandler;
import UI_Script.ScriptHandler;
import UI_Script.SolidAngleDev.Shaders.AiShaderScriptHandler;
import UI_Tools.DsoServer.FileQuerry;
import UI_Tools.DsoServer.Zipper;
import UI_Tools.KTools;
import Utilities.DateTimeUtils;
import Utilities.FileUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;

public class DsoServerTool
extends KTools
implements BuildMsgListener {
    private static int PXR_RIXPLUGIN = 1;
    private static int PXR_PROCPRIM = 2;
    private static int ARNOLD_SHADER = 3;
    public static final int SLEEP_TIME = 500;
    public static final int BUILD_TIME = 5000;
    private boolean kill = false;
    boolean security;
    WatcherThread watcher = null;
    File currentBuildInfoFile = null;
    File dropBoxDir = null;
    File cmpDir = null;
    File targetSrcDir = null;
    File targetSrcHostDir = null;
    protected static DsoServerTool tool = null;
    DropBoxPanel dropBoxPanel = new DropBoxPanel();
    CompilationPanel cmpPanel = new CompilationPanel();
    private static String RUN = " Start ";
    private static String KILL = " Stop ";
    JButton runButton = new JButton(RUN);
    private static int report_counter = 0;

    public static DsoServerTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new DsoServerTool(menuItem);
        return tool;
    }

    private DsoServerTool(JMenuItem menuItem) {
        super("DsoServer Tool", menuItem, Preferences.TOOL_DSO_SERVER);
        this.contentPane.add((Component)this.dropBoxPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)this.cmpPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)this.runButton, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 12, 0, new Insets(5, 5, 2, 5)));
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DsoServerTool.this.runButton.getText().equals(RUN)) {
                    DsoServerTool.this.start();
                    DsoServerTool.this.runButton.setText(KILL);
                    DsoServerTool.this.cmpPanel.setEnabled(false);
                    DsoServerTool.this.dropBoxPanel.setEnabled(false);
                } else {
                    DsoServerTool.this.stop();
                    DsoServerTool.this.runButton.setText(RUN);
                    DsoServerTool.this.cmpPanel.setEnabled(true);
                    DsoServerTool.this.dropBoxPanel.setEnabled(true);
                }
            }
        });
        this.pack();
        this.setVisible(false);
        this.setInitialPosition();
    }

    public void start() {
        this.dropBoxDir = new File(this.dropBoxPanel.getPath());
        this.cmpDir = new File(this.cmpPanel.getPath());
        if (this.dropBoxDir == null) {
            Cutter.setLog("DsoSeverTool.start() - dropbox is null");
            return;
        }
        report_counter = 0;
        this.kill = false;
        this.watcher = new WatcherThread(this.dropBoxDir);
        Cutter.setLog("DsoServerTool.start() - starting watcher.start()");
        this.watcher.start();
    }

    public void stop() {
        Cutter.input.debug = true;
        this.kill = true;
    }

    public boolean isRunning() {
        if (this.watcher != null) {
            return this.watcher.isAlive();
        }
        return false;
    }

    public File pickSrcDirectory(File dropBoxDir) {
        if (dropBoxDir == null) {
            return null;
        }
        String[] list = dropBoxDir.list();
        if (list == null) {
            return null;
        }
        Vector<File> listOfNamedDirs = new Vector<File>();
        for (int n = 0; n < list.length; ++n) {
            File f = new File(dropBoxDir, list[n]);
            if (f == null || !f.isDirectory() || f.getName().startsWith("_") || f.getName().startsWith(".")) continue;
            listOfNamedDirs.addElement(f);
        }
        if (listOfNamedDirs.size() == 0) {
            Cutter.setLog("DsoSeverTool.pickSrcDirectory() - cannot find any named folders, returning null");
            return null;
        }
        int i = DsoServerTool.randBetween(0, listOfNamedDirs.size());
        this.targetSrcHostDir = (File)listOfNamedDirs.elementAt(i);
        File out = null;
        boolean hasZip = false;
        boolean hasSrcCode = false;
        list = this.targetSrcHostDir.list();
        for (int n = 0; n < list.length; ++n) {
            File f = new File(this.targetSrcHostDir, list[n]);
            if (f.getName().equalsIgnoreCase("src_code.zip")) {
                hasZip = true;
            }
            if ((!f.isDirectory() || !f.getName().equalsIgnoreCase("src_code")) && !f.getName().equalsIgnoreCase("src_cpp") && !f.getName().equalsIgnoreCase("src_c++")) continue;
            String[] srcNames = f.list();
            if (srcNames.length == 0) {
                hasSrcCode = false;
                continue;
            }
            hasSrcCode = true;
            out = f;
            break;
        }
        if (!hasSrcCode) {
            return null;
        }
        if (hasSrcCode) {
            return out;
        }
        return null;
    }

    public static synchronized int randBetween(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    @Override
    public void buildStarted() {
    }

    @Override
    public void buildSentString(String msg) {
        msg = msg + "\r\n\r\n";
        FileUtils.appendFile(this.currentBuildInfoFile, msg);
    }

    @Override
    public void buildFinished(String msg) {
        msg = msg + "\r\n\r\n";
        FileUtils.appendFile(this.currentBuildInfoFile, msg);
    }

    @Override
    public void buildFailed(String msg) {
        msg = msg + "\r\n\r\n";
        FileUtils.appendFile(this.currentBuildInfoFile, msg);
    }

    @Override
    protected void toolSelectionHappened() {
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docname) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
        this.dropBoxPanel.saveSelf();
        this.cmpPanel.saveSelf();
    }

    private class WatcherThread
    extends Thread {
        public WatcherThread(File srcDir) {
            Cutter.input.debug = false;
        }

        @Override
        public void run() {
            Cutter.setLog("DsoServerTool.run() start time: ");
            Cutter.setLog(DateTimeUtils.getDateTime());
            StringBuffer buff = new StringBuffer();
            while (!DsoServerTool.this.kill) {
                String[] exts;
                String[] srcDocs;
                try {
                    WatcherThread.sleep(500L);
                }
                catch (InterruptedException e) {
                    System.out.println("Exception during sleep " + e);
                    continue;
                }
                if (!DsoServerTool.this.dropBoxDir.exists()) {
                    Cutter.setLog("DsoServerTool.run() dropbox became unavaiable at: ");
                    Cutter.setLog(DateTimeUtils.getDateTime());
                    return;
                }
                DsoServerTool.this.targetSrcDir = DsoServerTool.this.pickSrcDirectory(DsoServerTool.this.dropBoxDir);
                if (DsoServerTool.this.targetSrcDir == null || (srcDocs = FileUtils.getListOfFileNames(DsoServerTool.this.targetSrcDir, exts = new String[]{".cpp", ".h"})) == null || srcDocs.length == 0) continue;
                String[] inputPaths = new String[srcDocs.length];
                String[] outputPaths = new String[srcDocs.length];
                File cmpSrcDuplicateDir = new File(DsoServerTool.this.cmpDir, DsoServerTool.this.targetSrcDir.getName());
                cmpSrcDuplicateDir.mkdir();
                for (int n = 0; n < srcDocs.length; ++n) {
                    inputPaths[n] = new File(DsoServerTool.this.targetSrcDir, srcDocs[n]).getPath();
                    outputPaths[n] = new File(cmpSrcDuplicateDir, srcDocs[n]).getPath();
                }
                FileUtils.copyAll(inputPaths, outputPaths);
                DsoServerTool.this.currentBuildInfoFile = new File(cmpSrcDuplicateDir, "Build_Info.txt");
                FileUtils.writeFile(DsoServerTool.this.currentBuildInfoFile, "");
                String[] docs = cmpSrcDuplicateDir.list();
                ProceduralPrimitiveScriptHandler procprim = new ProceduralPrimitiveScriptHandler();
                RixPluginScriptHandler rixplugin = new RixPluginScriptHandler();
                AiShaderScriptHandler aishader = new AiShaderScriptHandler();
                if (docs == null || docs.length == 0) continue;
                Hashtable<File, ScriptHandler> table = new Hashtable<File, ScriptHandler>();
                for (int n = 0; n < docs.length; ++n) {
                    File doc = new File(cmpSrcDuplicateDir, docs[n]);
                    String ext = FileUtils.getExtension(doc);
                    if (ext == null || !ext.equalsIgnoreCase(".cpp")) continue;
                    if (procprim.canHandle(doc)) {
                        table.put(doc, procprim);
                        continue;
                    }
                    if (rixplugin.canHandle(doc)) {
                        table.put(doc, rixplugin);
                        continue;
                    }
                    if (!aishader.canHandle(doc)) continue;
                    table.put(doc, aishader);
                }
                if (!table.isEmpty()) {
                    Enumeration e = table.keys();
                    while (e.hasMoreElements()) {
                        File file = (File)e.nextElement();
                        ScriptHandler handler = (ScriptHandler)table.get(file);
                        if (handler instanceof ProceduralPrimitiveScriptHandler) {
                            ((ProceduralPrimitiveScriptHandler)handler).addBuildListener(DsoServerTool.this);
                        } else if (handler instanceof RixPluginScriptHandler) {
                            ((RixPluginScriptHandler)handler).addBuildListener(DsoServerTool.this);
                        } else if (handler instanceof AiShaderScriptHandler) {
                            ((AiShaderScriptHandler)handler).addBuildListener(DsoServerTool.this);
                        }
                        handler.execute(file);
                        try {
                            WatcherThread.sleep(5000L);
                        }
                        catch (InterruptedException ee) {
                            System.out.println("Exception during sleep " + e);
                        }
                    }
                }
                try {
                    long size = cmpSrcDuplicateDir.length();
                    String name = cmpSrcDuplicateDir.getName();
                    File destZipFile = new File(cmpSrcDuplicateDir.getParent(), name + ".zip");
                    Zipper zipper = new Zipper(cmpSrcDuplicateDir, destZipFile);
                    zipper.save();
                    byte[] bytes = FileUtils.readAsBinary(destZipFile.getPath());
                    File outfile = new File(DsoServerTool.this.targetSrcDir.getParentFile(), DsoServerTool.this.targetSrcDir.getName() + ".zip");
                    FileUtils.writeAsBinary(outfile, bytes);
                    destZipFile.delete();
                    FileQuerry q = new FileQuerry(cmpSrcDuplicateDir);
                    q.delete();
                    q = new FileQuerry(DsoServerTool.this.targetSrcDir);
                    q.delete();
                }
                catch (Exception ex) {}
            }
        }
    }

    private class DropBoxPanel
    extends KTitledPanel {
        private KLabelledField dropboxField;
        private PathSearchButton search;

        public DropBoxPanel() {
            super(" Dropbox Directory ", "DsoServerTool.SourcePanel.info");
            this.dropboxField = new KLabelledField(" Path", 20, "");
            this.search = new PathSearchButton(this.dropboxField, "?", "Choose Directory", 1);
            this.dropboxField.field.setText(Preferences.get(Preferences.TOOL_DSO_SERVER_DROPBOX_PATH));
            this.add(this.dropboxField, new GBC(0, 1, 1, 1, 1.0, 0.0, -5, 0, 18, 2, new Insets(5, 0, 0, 0)));
            this.add(this.search, new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(5, 0, 0, 5)));
        }

        private void saveSelf() {
            Preferences.write(Preferences.TOOL_DSO_SERVER_DROPBOX_PATH, this.getPath());
        }

        public void updateUI(File f) {
            this.saveSelf();
        }

        public String getPath() {
            return this.dropboxField.field.getText();
        }
    }

    private class CompilationPanel
    extends KTitledPanel {
        private KLabelledField compilationField;
        private PathSearchButton search;

        public CompilationPanel() {
            super(" Compilation Directory ", "DsoServerTool.SourcePanel.info");
            this.compilationField = new KLabelledField(" Path", 20, "");
            this.search = new PathSearchButton(this.compilationField, "?", "Choose Directory", 1);
            this.compilationField.field.setText(Preferences.get(Preferences.TOOL_DSO_SERVER_COMPILATION_PATH));
            this.add(this.compilationField, new GBC(0, 1, 1, 1, 1.0, 0.0, -5, 0, 18, 2, new Insets(5, 0, 0, 0)));
            this.add(this.search, new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(5, 0, 0, 5)));
        }

        private void saveSelf() {
            Preferences.write(Preferences.TOOL_DSO_SERVER_COMPILATION_PATH, this.getPath());
        }

        public void updateUI(File f) {
            this.saveSelf();
        }

        public String getPath() {
            return this.compilationField.field.getText();
        }
    }
}

