/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.DsoServer;

import Utilities.TextUtils;
import java.io.File;
import java.util.Vector;

public class FileQuerry {
    public static final char WACKY_ICON_CHAR = '\r';
    public static final String WACKY_ICON_NAME = "Icon\r";
    public static final String WIN_THUMBS_DB = "Thumbs.db";
    private Vector<String> listOfPaths = new Vector();
    private String[] rawPaths = null;
    private File root;

    public FileQuerry(File dir) {
        this.root = dir;
    }

    public String[] getAllPaths() {
        this.listOfPaths.removeAllElements();
        if (!this.getStructureOf(this.root)) {
            return null;
        }
        this.rawPaths = this.vectorToArray(this.listOfPaths);
        return this.rawPaths;
    }

    private String[] vectorToArray(Vector v) {
        String[] out = new String[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (String)v.elementAt(n);
        }
        return out;
    }

    private boolean getStructureOf(File dir) {
        this.listOfPaths.addElement(dir.getPath());
        if (dir.isFile()) {
            return false;
        }
        String[] files = dir.list();
        if (files == null) {
            return false;
        }
        for (int n = 0; n < files.length; ++n) {
            File f = new File(dir, files[n]);
            if (f == null || !f.isDirectory() && !f.isFile()) continue;
            this.getStructureOf(f);
        }
        return true;
    }

    public long getTotalSize() {
        String[] paths = this.getAllPaths();
        long total = 0L;
        if (paths == null) {
            return 0L;
        }
        for (int n = 0; n < paths.length; ++n) {
            File f = new File(paths[n]);
            if (!f.exists()) continue;
            total += f.length();
        }
        return total;
    }

    public String[] trim(String[] rawpaths, File baseDir) {
        int baselength = baseDir.getPath().length() + 1;
        Vector<String> vector = new Vector<String>();
        Vector<String> listOfAccepted = new Vector<String>();
        for (int n = 0; n < rawpaths.length; ++n) {
            String path = rawpaths[n];
            File file = new File(path);
            String name = file.getName();
            if (file.isDirectory() && file.getName().equals("cutter_history") || file.isDirectory() && file.getName().trim().length() != 0 && name.charAt(0) == '.' || file.isDirectory() && file.getName().equalsIgnoreCase(WIN_THUMBS_DB) || !file.isFile()) continue;
            String[] parts = TextUtils.tokenize(file.getPath(), File.separator);
            boolean ignore = false;
            if (parts != null) {
                for (int k = 0; k < parts.length; ++k) {
                    if (!parts[k].equalsIgnoreCase("cutter_history") && !parts[k].startsWith(".")) continue;
                    ignore = true;
                }
            }
            if (ignore || name.trim().length() == 0 || name.charAt(0) == '.' || name.equals(WACKY_ICON_NAME) || name.equalsIgnoreCase(WIN_THUMBS_DB) || name.startsWith("TMP") && name.endsWith(".htm") && name.length() == 17) continue;
            listOfAccepted.addElement("Accepted: " + path.substring(baselength));
            vector.addElement(path.substring(baselength));
        }
        return this.vectorToArray(vector);
    }

    public void delete() {
        this.getAllPaths();
        if (this.rawPaths == null) {
            return;
        }
        for (int n = this.rawPaths.length - 1; n >= 0; --n) {
            File f = new File(this.rawPaths[n]);
            f.delete();
        }
    }
}

