/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.DsoServer;

import UI_Tools.DsoServer.FileQuerry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private File srcDir;
    private File destZipFile;
    private byte[] buff = new byte[1024];
    private String[] relativePaths;

    public Zipper(File srcDir, File destZipFile) {
        this.srcDir = srcDir;
        this.destZipFile = destZipFile;
        FileQuerry querry = new FileQuerry(srcDir);
        String[] rawPaths = querry.getAllPaths();
        this.relativePaths = querry.trim(rawPaths, srcDir.getParentFile());
    }

    public void save() {
        if (this.relativePaths == null || this.relativePaths.length == 0 || this.srcDir == null) {
            return;
        }
        File baseDir = this.srcDir.getParentFile();
        long totalSize = 0L;
        try {
            FileOutputStream filestream = new FileOutputStream(this.destZipFile);
            ZipOutputStream zipstream = new ZipOutputStream(filestream);
            for (int i = 0; i < this.relativePaths.length; ++i) {
                int numBytes;
                String name;
                String relativePath = this.relativePaths[i];
                if (relativePath == null) continue;
                File entry = new File(relativePath);
                File inputFile = new File(baseDir, relativePath);
                if (inputFile.isDirectory() || !inputFile.exists() || (name = inputFile.getName()).trim().length() == 0 || name.length() > 0 && name.charAt(0) == '.') continue;
                totalSize += inputFile.length();
                FileInputStream inputstream = new FileInputStream(inputFile);
                ZipEntry zipentry = new ZipEntry(relativePath);
                zipstream.putNextEntry(zipentry);
                while ((numBytes = inputstream.read(this.buff, 0, this.buff.length)) != -1) {
                    zipstream.write(this.buff, 0, numBytes);
                }
                zipstream.closeEntry();
                inputstream.close();
            }
            zipstream.close();
            filestream.close();
        }
        catch (IOException e) {
            this.destZipFile.delete();
            System.out.println("doZip - base " + baseDir.getPath());
            if (this.relativePaths.length > 0) {
                System.out.println("doZip - file " + this.relativePaths[0]);
            }
            System.out.println("doZip - " + e.toString());
            return;
        }
    }
}

