/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Find;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.PathSearchButton;
import UI_Components.KFileSelectable;
import UI_Components.KFileTextArea;
import UI_Components.KLabel;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Tools.Find.FindTool;
import UI_Tools.Zipper.FileQuery;
import UI_Tools.Zipper.ZipOutput;
import Utilities.DateTimeUtils;
import Utilities.FileUtils;
import Utilities.MemoryUtils;
import Utilities.RegExpUtils;
import Utilities.ResourceUtils;
import Utilities.TextUtils;
import Utilities.TimerUtils;
import Utilities.VectorUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class BatchFindPanel
extends JPanel
implements ActionListener,
KFileSelectable {
    private static final long serialVersionUID = 1L;
    private final int BATCH_FIND_SLEEP_PERIOD = 5;
    public static final String NO_MATCH_STR = "No matches found.";
    public final String BATCH_REPLACE = "============================================\n== Batch Replacing $ files\n============================================\n";
    public final String BATCH_FIND = "============================================\n== Batch Find searching $ files\n============================================\n";
    public final String BATCH_COPY = "============================================\n== Batch Copy searching $ files\n============================================\n";
    private KTitledPanel setupPanel = new KTitledPanel(" Batch ", "FindTool.BatchFindPanel.info");
    private KTitledPanel resultsPanel = new KTitledPanel(" Results ");
    private FindTool owner = null;
    private ImageIcon dirIcon = ResourceUtils.getIconResource("/resources/directories.gif");
    private KLabel dirLabel = new KLabel("folder");
    private KSerialTextField dirField = new KSerialTextField("FindToolBatchDir", "", 19);
    private PathSearchButton dirButton = new PathSearchButton(this.dirField, (Icon)this.dirIcon, "Choose Directory", 2);
    private JCheckBox recursive = new JCheckBox("recurse", false);
    private KLabel extLabel = new KLabel("    ext");
    private KSerialTextField extField = new KSerialTextField("FindToolBatchExt", ".*", 13);
    private KFileTextArea resultsArea = null;
    private KButton batchFind = new KButton("Find All", this);
    private KButton batchReplace = new KButton("Replace All", this);
    private KButton stopBatch = new KButton("  Stop  ", this);
    private KButton batchCopyAll = new KButton("Copy All", this);
    private File rootOfBatchSearch = null;
    private boolean userWantsToStop = false;
    private JCheckBox logCB = new JCheckBox("log", false);
    private int logWindowID = 1;
    private String logWindowTitle = "Batch_Search_Log_";
    private String currentLogWindowTitle = "";

    public BatchFindPanel(FindTool owner) {
        super.setLayout(new GridBagLayout());
        this.owner = owner;
        this.dirField.usesModelDialog = true;
        this.resultsArea = new KFileTextArea(10, 25, this, "FindToolBatchResults");
        this.add((Component)this.setupPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        this.add((Component)this.resultsPanel, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        JPanel upper = new JPanel();
        JPanel middle = new JPanel();
        JPanel lower = new JPanel();
        upper.setLayout(new GridBagLayout());
        middle.setLayout(new GridBagLayout());
        lower.setLayout(new GridBagLayout());
        this.setupPanel.add(upper, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 5, 5, 0)));
        this.setupPanel.add(middle, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 1, new Insets(0, 5, 0, 0)));
        this.setupPanel.add(lower, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 5, 0, 0)));
        upper.add((Component)this.dirLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 5, 0, 0)));
        upper.add((Component)this.dirField, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 2, new Insets(0, 5, 0, 0)));
        upper.add((Component)this.dirButton, new GBC(2, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(0, 9, 0, 5)));
        middle.add((Component)this.extLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(5, 5, 0, 2)));
        middle.add((Component)this.extField, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(5, 5, 0, 0)));
        middle.add((Component)this.recursive, new GBC(2, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(5, 4, 0, 0)));
        middle.add((Component)this.batchFind, new GBC(3, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(5, 2, 0, 5)));
        lower.add((Component)this.batchReplace, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 42, 0, 0)));
        lower.add((Component)this.batchCopyAll, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 7, 0, 0)));
        lower.add((Component)this.logCB, new GBC(2, 0, 1, 1, 0.0, 1.0, 0, 0, 18, 0, new Insets(5, 4, 5, 5)));
        lower.add((Component)this.stopBatch, new GBC(3, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(5, 25, 5, 5)));
        this.stopBatch.setEnabled(false);
        String mode = Preferences.get(Preferences.TOOL_FIND_BATCH_RECURSIVE);
        this.recursive.setSelected(mode.equals("true"));
        this.resultsArea.setEditable(false);
        this.resultsArea.setMargin(new Insets(2, 5, 2, 1));
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.resultsArea);
        scroller.getViewport().setMinimumSize(scroller.getViewport().getPreferredSize());
        this.resultsPanel.add(scroller, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, -2, 18, 1, new Insets(0, 4, 8, 4)));
    }

    private void enableStopButton(boolean flag) {
        this.batchFind.setEnabled(!flag);
        this.batchReplace.setEnabled(!flag);
        this.stopBatch.setEnabled(flag);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String regexp;
        String src = FindTool.findPanel.getText();
        final RegExpUtils re = new RegExpUtils();
        String string = FindTool.findPanel.usingRegExp ? src : (regexp = re.encodeAsRE(src, FindTool.doIgnoreCase, FindTool.doWholeWord));
        if (!re.checkPattern(regexp)) {
            return;
        }
        Cutter.setLog("    Info:BatchFindPanel.actionPerformed() using the following regexp\n           " + regexp);
        if (e.getSource() == this.stopBatch) {
            this.userWantsToStop = true;
            return;
        }
        if (e.getSource() == this.batchFind) {
            this.batchFind.setEnabled(false);
            this.batchReplace.setEnabled(false);
            this.stopBatch.setEnabled(true);
            final StringBuffer sb = new StringBuffer();
            Thread runner = new Thread(){

                @Override
                public void run() {
                    TimerUtils.start();
                    String[][] findData = BatchFindPanel.this.doBatchFind(regexp);
                    FindTool.statusField.setText("time taken [" + TimerUtils.end() + " ms]");
                    BatchFindPanel.this.enableStopButton(false);
                    BatchFindPanel.this.resultsArea.setCaretPosition(BatchFindPanel.this.resultsArea.getDocument().getLength());
                    if (BatchFindPanel.this.logCB.isSelected() && findData[0] != null) {
                        BatchFindPanel.this.currentLogWindowTitle = BatchFindPanel.this.logWindowTitle + BatchFindPanel.this.logWindowID;
                        BatchFindPanel.this.logWindowID++;
                        sb.append("=================================================================\n");
                        sb.append("                          FILES SEARCHED                         \n");
                        sb.append("=================================================================\n");
                        for (int n = 0; n < findData[0].length; ++n) {
                            sb.append(findData[0][n]).append("\n");
                        }
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BBxt.newDocument(BatchFindPanel.this.currentLogWindowTitle, sb);
                                }
                            });
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            runner.start();
            return;
        }
        if (e.getSource() == this.batchReplace) {
            String dirPath = this.dirField.getText();
            File test = new File(dirPath);
            Cutter.setLog("    Debug: BatchFindPanel.batchReplace() File.canWrite() = " + test.canWrite());
            if (!test.canWrite()) {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "You do not have sufficient permissions to  \nperform a batch \"replace all\" on any files\nlocated in the directory:\n        " + test.getName() + "\n", "Insufficient Permissions Error", 0);
                return;
            }
            this.enableStopButton(true);
            this.userWantsToStop = false;
            final StringBuffer sb = new StringBuffer();
            Thread runner = new Thread(){

                @Override
                public void run() {
                    BatchFindPanel.this.owner;
                    String rawdest = FindTool.replacePanel.getText();
                    String dest = re.doEscape(rawdest);
                    String[][] findData = BatchFindPanel.this.doBatchFind(regexp);
                    if (findData == null || findData[1] != null && findData[1].length == 0) {
                        BatchFindPanel.this.enableStopButton(false);
                        BatchFindPanel.this.resultsArea.setCaretPosition(BatchFindPanel.this.resultsArea.getDocument().getLength());
                        return;
                    }
                    if (BatchFindPanel.this.logCB.isSelected() && findData[0] != null) {
                        BatchFindPanel.this.currentLogWindowTitle = BatchFindPanel.this.logWindowTitle + BatchFindPanel.this.logWindowID;
                        BatchFindPanel.this.logWindowID++;
                        sb.append("=================================================================\n");
                        sb.append("                          FILES SEARCHED                         \n");
                        sb.append("=================================================================\n");
                        for (int n = 0; n < findData[0].length; ++n) {
                            sb.append(findData[0][n]).append("\n");
                        }
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BBxt.newDocument(BatchFindPanel.this.currentLogWindowTitle, sb);
                                }
                            });
                        }
                        catch (Exception n) {
                            // empty catch block
                        }
                    }
                    String[] filenames = findData[1];
                    String[] fnames = FileUtils.toNamesArray(filenames, false);
                    String[] partialPaths = FileUtils.getPathRelativeTo(BatchFindPanel.this.rootOfBatchSearch.getParent(), filenames);
                    String[] fullPathTotal = FileUtils.join(BatchFindPanel.this.rootOfBatchSearch.getParent(), partialPaths);
                    BatchFindPanel.this.resultsArea.setText("");
                    MemoryUtils mu = new MemoryUtils();
                    File zipfile = null;
                    try {
                        zipfile = BatchFindPanel.this.getDatedZipFile();
                        ZipOutput zipout = new ZipOutput(BatchFindPanel.this.rootOfBatchSearch, partialPaths, null, null);
                        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                        zipout.writeZipDataTo(bstream, true);
                        byte[] dataBytes = bstream.toByteArray();
                        if (dataBytes != null) {
                            FileUtils.writeAsBinary(zipfile, dataBytes);
                            dataBytes = null;
                        }
                    }
                    catch (Exception ex) {
                        Cutter.setLog("    Exception:BatchFindPanel.batchReplace() - zipping backups\n" + ex.toString());
                        zipfile = null;
                        Cutter.setLog("    Warning:BatchFindPanel.batchReplace() - not attempting to do a zip file");
                    }
                    String text = null;
                    String temp = null;
                    if (fullPathTotal != null) {
                        BatchFindPanel.this.setResultsTitle("============================================\n== Batch Replacing $ files\n============================================\n", fullPathTotal.length);
                    }
                    int insertOffset = BatchFindPanel.this.resultsArea.getDocument().getLength();
                    if (fullPathTotal != null) {
                        for (int n = 0; n < fullPathTotal.length; ++n) {
                            File f;
                            String path;
                            if (BatchFindPanel.this.userWantsToStop) {
                                BatchFindPanel.this.enableStopButton(false);
                                return;
                            }
                            if (n % 1 == 0) {
                                BatchFindPanel.this.updateResultsCounter(fullPathTotal.length - n);
                            }
                            if ((path = fullPathTotal[n]) == null || (f = new File(path)).isDirectory() || f.getName().endsWith(".DS_Store") || (text = BatchFindPanel.this.read(path)) == null) continue;
                            try {
                                temp = text.replaceAll(regexp, dest);
                            }
                            catch (Exception ex) {
                                Cutter.setLog("    Exception: BatchFindPanel.replaceAll() file >" + f.getPath() + "<\n          " + ex.toString());
                                temp = null;
                                text = null;
                                continue;
                            }
                            FileUtils.writeFile(f, temp);
                            temp = null;
                            text = null;
                            String tail = FileUtils.getPathRelativeTo(BatchFindPanel.this.rootOfBatchSearch.getPath(), filenames[n]);
                            if (tail == null) continue;
                            BatchFindPanel.this.updateResultsFileName(tail);
                        }
                    }
                    BatchFindPanel.this.updateResultsCounter(0);
                    BatchFindPanel.this.enableStopButton(false);
                    BatchFindPanel.this.userWantsToStop = false;
                    if (zipfile != null) {
                        JOptionPane.showMessageDialog(KDesktop.desktopPane, "Copies of the original files have been saved in \na ZIP file named:\n    Cutter_Backups / " + zipfile.getName() + "\nThe backups folder in the same directory as the \ncutter.jar file.\n", "Automatic Backup Information", 1);
                    }
                }
            };
            runner.start();
        }
        if (e.getSource() == this.batchCopyAll) {
            this.batchCopyAll.setEnabled(false);
            this.stopBatch.setEnabled(true);
            StringBuffer sb = new StringBuffer();
            Thread runner = new Thread(){

                @Override
                public void run() {
                    TimerUtils.start();
                    final StringBuffer outBuf = new StringBuffer();
                    String[][] findData = BatchFindPanel.this.doBatchCopyAll(regexp, outBuf);
                    FindTool.statusField.setText("time taken [" + TimerUtils.end() + " ms]");
                    BatchFindPanel.this.enableStopButton(false);
                    BatchFindPanel.this.batchCopyAll.setEnabled(true);
                    BatchFindPanel.this.resultsArea.setCaretPosition(BatchFindPanel.this.resultsArea.getDocument().getLength());
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BBxt.newDocument("Results.txt", outBuf);
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            runner.start();
            return;
        }
    }

    @Override
    public File getRootDirectory() {
        return this.rootOfBatchSearch;
    }

    @Override
    public void setRootDirectory(File f) {
        if (f != null) {
            this.dirField.setText(f.getPath());
        }
    }

    private String[][] doBatchFind(String regexp) {
        String[][] out = new String[][]{null, null};
        MemoryUtils mu = new MemoryUtils();
        try {
            this.resultsArea.setText("");
            String extStrs = this.extField.getText();
            String dirPath = this.dirField.getText();
            if (dirPath.trim().length() == 0) {
                this.rootOfBatchSearch = null;
                Cutter.setLog("    Debug: BatchFindPanel.doBatchFind() - dirField returned null");
                this.resultsArea.setText("\n\nAn empty string cannot be used to specify a target folder.");
                return null;
            }
            this.rootOfBatchSearch = new File(dirPath);
            if (!this.rootOfBatchSearch.exists()) {
                this.rootOfBatchSearch = null;
                Cutter.setLog("    Debug: BatchFindPanel.doBatchFind() - rootOfBatchSearch does not exist");
                this.resultsArea.setText("\n\nThe target folder does not exist.");
                return null;
            }
            String[] relativePathTotal = new String[]{};
            if (extStrs.trim().length() == 0 || extStrs.trim().equals(".*")) {
                relativePathTotal = FileUtils.getListOfFileNames(this.rootOfBatchSearch, null, this.recursive.isSelected());
                Cutter.setLog("    Debug: BatchFindPanel.doBatchFind() - info no extensions list of " + relativePathTotal.length + " files to be searched");
            } else {
                String[] exts = TextUtils.tokenize(extStrs);
                if (exts == null) {
                    this.rootOfBatchSearch = null;
                    Cutter.setLog("    Debug: BatchFindPanel.doBatchFind() tokenized extension strings yielded a null");
                    return null;
                }
                StringBuffer buff = new StringBuffer();
                for (int n = 0; n < exts.length; ++n) {
                    if (exts[n].equals(".*")) continue;
                    buff.append(exts[n] + " ");
                }
                extStrs = buff.toString();
                String[] extItems = TextUtils.tokenize(extStrs.trim());
                for (int n = 0; n < extItems.length; ++n) {
                    String[] files = FileUtils.getListOfFileNames(this.rootOfBatchSearch, extItems[n], this.recursive.isSelected());
                    relativePathTotal = VectorUtils.toStringArray(files, relativePathTotal);
                }
            }
            if (relativePathTotal == null || relativePathTotal.length == 0) {
                FindTool.statusField.setText("");
                Cutter.setLog("    Debug: BatchFindPanel.doBatchFind() relativePathTotal is empty");
                this.resultsArea.setText("\n\nNo files match the specified file extension(s).");
                this.rootOfBatchSearch = null;
                return null;
            }
            String[] fullPathTotal = FileUtils.join(this.rootOfBatchSearch, relativePathTotal);
            FileQuery querry = new FileQuery(this.rootOfBatchSearch);
            String[] folders = new String[]{"cutter_history"};
            String[] trimmedPaths = querry.trim(fullPathTotal, this.rootOfBatchSearch, folders, null, 0, null);
            fullPathTotal = FileUtils.join(this.rootOfBatchSearch, trimmedPaths);
            out[0] = fullPathTotal;
            String str = null;
            Vector<String> listOfHitFiles = new Vector<String>();
            this.setResultsTitle("============================================\n== Batch Find searching $ files\n============================================\n", fullPathTotal.length);
            this.userWantsToStop = false;
            for (int n = 0; n < fullPathTotal.length; ++n) {
                File infile;
                if (n % 1 == 0) {
                    this.updateResultsCounter(fullPathTotal.length - n);
                }
                if (this.userWantsToStop) {
                    Cutter.setLog("    Debug: BatchFindPanel.doBatchFind() - user stopping");
                    return null;
                }
                if (fullPathTotal[n] == null || (infile = new File(fullPathTotal[n])).isDirectory() || infile.getName().endsWith(".DS_Store")) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                str = this.read(fullPathTotal[n]);
                int hits = this.owner.hasAnOccurancesOf(regexp, str);
                if (hits > 0) {
                    this.updateResultsFileName(trimmedPaths[n]);
                    listOfHitFiles.addElement(trimmedPaths[n]);
                }
                str = null;
            }
            if (listOfHitFiles.size() == 0) {
                this.resultsArea.setText("");
                this.resultsArea.append("\nNo matches found.");
                this.resultsArea.setCaretPosition(0);
            } else {
                this.updateResultsCounter(0);
            }
            String[] hitPathTotal = VectorUtils.toStringArray(listOfHitFiles);
            this.setFinalTextAreaResults(hitPathTotal);
            hitPathTotal = FileUtils.join(this.rootOfBatchSearch, hitPathTotal);
            out[1] = hitPathTotal;
            this.resultsArea.addToList();
            return out;
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception: BatchFindPanel.doBatchFind()\n           " + ex.toString());
            return null;
        }
    }

    private String[][] doBatchCopyAll(String regexp, StringBuffer outBuf) {
        String[][] out = new String[][]{null, null};
        MemoryUtils mu = new MemoryUtils();
        try {
            this.resultsArea.setText("");
            String extStrs = this.extField.getText();
            String dirPath = this.dirField.getText();
            if (dirPath.trim().length() == 0) {
                this.rootOfBatchSearch = null;
                Cutter.setLog("    Debug: BatchFindPanel.doBatchCopyAll() - dirField returned null");
                return null;
            }
            this.rootOfBatchSearch = new File(dirPath);
            if (!this.rootOfBatchSearch.exists()) {
                this.rootOfBatchSearch = null;
                Cutter.setLog("    Debug: BatchFindPanel.doBatchCopyAll() - rootOfBatchSearch does not exist");
                return null;
            }
            String[] relativePathTotal = new String[]{};
            if (extStrs.trim().length() == 0 || extStrs.trim().equals(".*")) {
                relativePathTotal = FileUtils.getListOfFileNames(this.rootOfBatchSearch, null, this.recursive.isSelected());
                Cutter.setLog("    Debug: BatchFindPanel.doBatchCopyAll() - info no extensions list of " + relativePathTotal.length + " files to be searched");
            } else {
                String[] exts = TextUtils.tokenize(extStrs);
                if (exts == null) {
                    this.rootOfBatchSearch = null;
                    Cutter.setLog("    Debug: BatchFindPanel.doBatchCopyAll() tokenized extension strings yielded a null");
                    return null;
                }
                StringBuffer buff = new StringBuffer();
                for (int n = 0; n < exts.length; ++n) {
                    if (exts[n].equals(".*")) continue;
                    buff.append(exts[n] + " ");
                }
                extStrs = buff.toString();
                String[] extItems = TextUtils.tokenize(extStrs.trim());
                for (int n = 0; n < extItems.length; ++n) {
                    String[] files = FileUtils.getListOfFileNames(this.rootOfBatchSearch, extItems[n], this.recursive.isSelected());
                    relativePathTotal = VectorUtils.toStringArray(files, relativePathTotal);
                }
            }
            if (relativePathTotal == null || relativePathTotal.length == 0) {
                FindTool.statusField.setText("no matches found");
                Cutter.setLog("    Debug: BatchFindPanel.doBatchCopyAll() relativePathTotal is empty");
                this.rootOfBatchSearch = null;
                return null;
            }
            String[] fullPathTotal = FileUtils.join(this.rootOfBatchSearch, relativePathTotal);
            FileQuery query = new FileQuery(this.rootOfBatchSearch);
            String[] folders = new String[]{"cutter_history"};
            String[] trimmedPaths = query.trim(fullPathTotal, this.rootOfBatchSearch, folders, null, 0, null);
            fullPathTotal = FileUtils.join(this.rootOfBatchSearch, trimmedPaths);
            out[0] = fullPathTotal;
            String str = null;
            Vector<String> listOfHitFiles = new Vector<String>();
            this.setResultsTitle("============================================\n== Batch Copy searching $ files\n============================================\n", fullPathTotal.length);
            this.userWantsToStop = false;
            for (int n = 0; n < fullPathTotal.length; ++n) {
                File infile;
                if (n % 1 == 0) {
                    this.updateResultsCounter(fullPathTotal.length - n);
                }
                if (this.userWantsToStop) {
                    Cutter.setLog("    Debug: BatchFindPanel.doBatchCopyAll() - user stopping");
                    return null;
                }
                if (fullPathTotal[n] == null || (infile = new File(fullPathTotal[n])).isDirectory() || infile.getName().endsWith(".DS_Store")) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mu.memoryAvailable();
                str = this.read(fullPathTotal[n]);
                int hits = 0;
                if (str == null || str.length() == 0) continue;
                int beginSearchAt = 0;
                boolean done = false;
                while (!done) {
                    StringBuffer sb = new StringBuffer();
                    if ((beginSearchAt = this.doFind(str, regexp, beginSearchAt, sb)) < 0) {
                        done = true;
                        continue;
                    }
                    outBuf.append(sb.toString()).append("\n");
                    ++hits;
                }
                if (hits > 0) {
                    this.updateResultsFileName(trimmedPaths[n]);
                    listOfHitFiles.addElement(trimmedPaths[n]);
                }
                str = null;
            }
            if (listOfHitFiles.size() == 0) {
                this.resultsArea.append("\nNo matches found");
                this.resultsArea.setCaretPosition(0);
            } else {
                this.updateResultsCounter(0);
            }
            String[] hitPathTotal = VectorUtils.toStringArray(listOfHitFiles);
            hitPathTotal = FileUtils.join(this.rootOfBatchSearch, hitPathTotal);
            out[1] = hitPathTotal;
            return out;
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception: BatchFindPanel.doBatchFind()\n           " + ex.toString());
            return null;
        }
    }

    private void setResultsTitle(String intitle, int numfiles) {
        final String outtitle = intitle.replaceAll("\\$", "" + numfiles);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BatchFindPanel.this.resultsArea.setText(outtitle);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearResultsTextArea() {
        this.resultsArea.selectAll();
        this.resultsArea.setText("");
    }

    private void updateResultsCounter(int num) {
        String s = this.resultsArea.getText();
        s = num > 0 ? s.replaceAll("[\\d]+ files", num + " files") : s.replaceAll("[\\d]+ files", "");
        this.resultsArea.setText(s);
    }

    private void updateResultsFileName(String filename) {
        try {
            int begin = this.resultsArea.getLineStartOffset(3);
            this.resultsArea.insert(filename + "\n", begin);
            this.resultsArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setFinalTextAreaResults(String[] data) {
        if (data == null) {
            return;
        }
        this.clearResultsTextArea();
        int offset = 0;
        for (int n = 0; n < data.length; ++n) {
            this.resultsArea.insert(data[n] + "\n", offset);
            offset += data[n].length() + 1;
        }
    }

    public void readFromPrefs() {
    }

    public void saveSelf() {
        this.dirField.saveSelf();
        this.extField.saveSelf();
        Preferences.write(Preferences.TOOL_FIND_BATCH_RECURSIVE, this.recursive.isSelected() ? "true" : "false");
    }

    private File getDatedZipFile() {
        File dir = new File(FileUtils.getPWD(), "Cutter_Backups");
        if (!dir.exists()) {
            dir.mkdir();
        }
        String rawDateStr = DateTimeUtils.getDateStamp();
        String filename = TextUtils.replace(rawDateStr, ':', "_");
        filename = TextUtils.replace(filename, ' ', "_");
        filename = TextUtils.replace(filename, '.', "_");
        return new File(dir, filename + ".zip");
    }

    private String read(String filename) {
        FileReader reader = null;
        if (filename == null || filename.trim().length() == 0) {
            return null;
        }
        try {
            reader = new FileReader(filename);
            File f = new File(filename);
            long size = f.length();
            if (size <= 0L) {
                reader.close();
                return null;
            }
            Runtime rt = Runtime.getRuntime();
            rt.gc();
            long aval = rt.freeMemory();
            if (size > 5000000L) {
                Cutter.setLog("    Warning:BatchFindPanel.read() - the file           \"" + filename + "\"           is too large to read and while not be searched.\n");
                reader.close();
                return null;
            }
            char[] buff = new char[(int)size];
            int count = 0;
            while ((count = reader.read(buff)) >= 0) {
            }
            reader.close();
            return new String(buff).replaceAll("[\r]", "");
        }
        catch (Exception e) {
            Cutter.setLog("    Error: BatchFindPanel.read() - cannot open file named " + filename + "\n" + e.toString());
            return null;
        }
    }

    public int doFind(String src, String regexp, int startAt, StringBuffer outBuf) {
        if (src == null) {
            Cutter.setLog("    Error: BatchFindPanel.doFind() - src is null");
            return -1;
        }
        if (startAt >= src.length()) {
            return -1;
        }
        if (regexp == null || regexp.length() == 0) {
            Cutter.setLog("    Error: BatchFindPanel.doFind() - regexp is an empty string");
            return -1;
        }
        String[] parts = null;
        int diff = 0;
        int absEnd = -1;
        int absBegin = -1;
        Object out = null;
        try {
            src = src.substring(startAt);
            parts = src.split(regexp, 2);
            if (parts != null && parts.length > 1) {
                int part0Length = parts[0].length();
                int part1Length = parts[1].length();
                diff = src.length() - (part0Length + part1Length);
                int beginOffset = parts[0].length();
                absBegin = beginOffset + startAt;
                absEnd = absBegin + diff;
                outBuf.append(src.substring(absBegin, absEnd));
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: BatchFindPanel.find() absBegin = " + absBegin + " absEnd = " + absEnd + " src length = " + src.length() + "\n          " + e.toString());
            return -1;
        }
        if (parts != null && parts.length > 1) {
            return absEnd;
        }
        return -1;
    }

    private class KButton
    extends JButton {
        public KButton(String t, ActionListener listener) {
            super(t);
            this.setMargin(new Insets(1, 5, 1, 5));
            if (listener != null) {
                this.addActionListener(listener);
            }
            this.setEnabled(true);
        }

        @Override
        public void setEnabled(boolean doEnable) {
            if (this.getLabel().equals("Stop Batch") && BatchFindPanel.this.batchFind.isEnabled()) {
                super.setEnabled(false);
            } else {
                super.setEnabled(doEnable);
            }
        }
    }
}

