/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Find;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KCheckBox;
import UI_Components.KTextField.KEscapeEncodedField;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTitledPanel;
import UI_Components.LabelledTextField;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Script.Help.KAbstractHelp;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Find.BatchFindPanel;
import UI_Tools.KTools;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.BrowserUtils;
import Utilities.FileUtils;
import Utilities.RegExpUtils;
import Utilities.ResourceUtils;
import Utilities.TimerUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;

public class FindTool
extends KTools
implements ItemListener {
    private static final long serialVersionUID = 1L;
    public static final String REGEXP_DOC_PATH = "Cutter_Help/regexp/java_regexp.html";
    public static final File REGEXP_DOC = new File(FileUtils.getPWD(), "Cutter_Help/regexp/java_regexp.html");
    public static boolean _debug = false;
    protected static final String FIND_REPLACE_HELP_PATH = "find_replace/index.html";
    public static LabelledTextField statusField;
    public static boolean doIgnoreCase;
    public static boolean doWholeWord;
    public static InputPanel findPanel;
    public static InputPanel replacePanel;
    public static ButtonPanel buttonPanel;
    private BatchFindButton batchFindButton = new BatchFindButton();
    private static BatchFindPanel batchFindPanel;
    private static boolean batchFindPanelIsActive;
    private static FindTool tool;
    protected static final String FIND = " Find ";
    protected static final String REPLACE = " Replace ";
    public static final String IGNORE_CASE_TITLE = "Ignore Case";
    public static final String WHOLE_WORD_TITLE = "Whole Word";
    private static KCheckBox ignoreCase;
    private static KCheckBox wholeWord;
    private int[] offset = null;

    public static FindTool init() {
        if (tool != null) {
            return tool;
        }
        JMenuItem menuItem = KDesktop.findReplaceItem;
        tool = new FindTool(menuItem, FIND_REPLACE_HELP_PATH);
        return tool;
    }

    public static String getFindText() {
        if (tool == null) {
            return null;
        }
        return findPanel.getText();
    }

    public static void setFindText(String text, boolean asRegExp) {
        if (tool != null) {
            findPanel.setFindText(text, asRegExp);
        }
    }

    public static void clickFindButton() {
        if (tool != null) {
            FindTool.buttonPanel.findButton.doClick();
        }
    }

    public static void ignoreCase(boolean state) {
        if (tool != null) {
            ignoreCase.setSelected(state);
        }
    }

    public static void wholeWord(boolean state) {
        if (tool != null) {
            wholeWord.setSelected(state);
        }
    }

    private FindTool(JMenuItem menuItem, String helpDocPath) {
        super("Find/Replace Tool", menuItem, Preferences.TOOL_FIND);
        findPanel = new InputPanel(FIND, true, "FindTool.FindPanel.info");
        replacePanel = new InputPanel(REPLACE, false, null);
        buttonPanel = new ButtonPanel();
        statusField = new LabelledTextField("status: ", 13, true, Color.lightGray, null);
        statusField.setEditable(false);
        statusField.setText("");
        Font f = (Font)UIManager.get("Button.font");
        FindTool.statusField.label.setFont(f);
        ignoreCase = new KCheckBox(IGNORE_CASE_TITLE, true);
        wholeWord = new KCheckBox(WHOLE_WORD_TITLE, false);
        ignoreCase.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                doIgnoreCase = KTools.getCheckBoxState(e);
            }
        });
        wholeWord.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                doWholeWord = KTools.getCheckBoxState(e);
            }
        });
        batchFindPanel = new BatchFindPanel(this);
        this.contentPane.add((Component)findPanel, new GBC(0, 0, 3, 2, 0.0, 0.0, 0, 0, 17, 1, new Insets(0, 5, 0, 5)));
        this.contentPane.add((Component)statusField, new GBC(0, 2, 3, 1, 0.0, 0.0, 0, 0, 17, 1, new Insets(5, 10, 5, 8)));
        this.contentPane.add((Component)replacePanel, new GBC(0, 3, 3, 2, 0.0, 0.0, 0, 0, 17, 1, new Insets(0, 5, 0, 5)));
        this.contentPane.add((Component)ignoreCase, new GBC(0, 5, 1, 1, 0.0, 0.0, 0, 0, 17, 1, new Insets(0, 5, 5, 0)));
        this.contentPane.add((Component)wholeWord, new GBC(1, 5, 1, 1, 0.0, 0.0, 0, 0, 17, 1, new Insets(0, 0, 5, 13)));
        this.contentPane.add((Component)this.batchFindButton, new GBC(2, 5, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 0, 5, 0)));
        this.contentPane.add((Component)buttonPanel, new GBC(3, 0, 2, 6, 0.0, 0.0, 0, 0, 18, 1, new Insets(0, 5, 0, 0)));
        this.contentPane.add((Component)new JSeparator(), new GBC(0, 6, 5, 1, 0.0, 0.0, 0, 0, 17, 1, new Insets(2, 4, 0, 5)));
        this.contentPane.add((Component)batchFindPanel, new GBC(0, 7, 5, 10, 1.0, 1.0, 0, 0, 17, 1, new Insets(5, 4, 2, 5)));
        findPanel.addFieldListener(FindTool.buttonPanel.findButton);
        replacePanel.addFieldListener(FindTool.buttonPanel.replaceButton);
        replacePanel.addFieldListener(FindTool.buttonPanel.replaceFindButton);
        replacePanel.addFieldListener(FindTool.buttonPanel.replaceAllButton);
        this.setTitle(this.title);
        String mode = Preferences.get(Preferences.TOOL_FIND_BATCH_MODE);
        this.batchFindButton.setSelected(mode.equals("true"));
        batchFindPanel.setVisible(this.batchFindButton.isSelected());
        this.pack();
        findPanel.setMinimumSize(findPanel.getPreferredSize());
        this.setInitialPosition();
        this.setVisible(false);
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
        findPanel.saveSelf();
        replacePanel.saveSelf();
        batchFindPanel.saveSelf();
        Preferences.write(Preferences.TOOL_FIND_BATCH_MODE, this.batchFindButton.isSelected() ? "true" : "false");
    }

    @Override
    public void showSelf() {
        super.showSelf();
        FindTool.findPanel.textfield.grabFocus();
        FindTool.findPanel.textfield.selectAll();
    }

    @Override
    protected void toolSelectionHappened() {
    }

    public void forceFocusOfDefaultComponent() {
        FindTool.findPanel.textfield.grabFocus();
        FindTool.findPanel.textfield.selectAll();
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
        this.lastFocusedComponent = compLostFocus;
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    public boolean canFindNext() {
        return FindTool.buttonPanel.findNextButton.isEnabled();
    }

    public boolean canFind() {
        return findPanel.getText().length() > 0;
    }

    public boolean doFind(int startAt, boolean quiet) {
        return this.doFind(startAt, quiet, null);
    }

    public boolean doFind(int startAt, boolean quiet, String regexp) {
        Segment seg = BBxt.getWindowText(startAt, -1);
        if (seg == null) {
            Cutter.setLog("    Error: FindTool.doFind() - cannot get the segment from offsets " + startAt);
            return false;
        }
        String output = "";
        RegExpUtils re = new RegExpUtils();
        if (regexp == null) {
            String src = findPanel.getText();
            String string = regexp = FindTool.findPanel.usingRegExp ? src : re.encodeAsRE(src, doIgnoreCase, doWholeWord);
            if (!re.checkPattern(regexp)) {
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:FindTool.doFind() - \"" + regexp + "\" is not a valid regex pattern");
                }
                return false;
            }
        }
        if (!quiet) {
            Cutter.setLog("    Info: FindTool.doFind() >" + regexp + "<");
        }
        String[] parts = null;
        TimerUtils.start();
        int diff = 0;
        try {
            parts = seg.toString().split(regexp, 2);
            if (parts != null && parts.length > 1) {
                int part0Length = parts[0].length();
                int part1Length = parts[1].length();
                diff = seg.count - (part0Length + part1Length);
                int beginOffset = parts[0].length();
                int absBegin = beginOffset + startAt;
                int absEnd = absBegin + diff;
                BBxt.setSelection(absBegin, absEnd);
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: FindTool.find()\n          " + e.toString());
            return false;
        }
        boolean status = false;
        if (parts != null && parts.length > 1) {
            if (diff == 0 && parts[0].length() == 0) {
                statusField.setText("Warning: Matched current cursor \nposition", true);
            } else {
                statusField.setText("found " + (parts.length - 1) + " [" + TimerUtils.end() + " ms]");
            }
            status = true;
        } else {
            statusField.setText("none found [" + TimerUtils.end() + " ms]");
        }
        FindTool.buttonPanel.findNextButton.setEnabled(status);
        return status;
    }

    private int doReplace() {
        if (BBxt.getSelectionLength() == 0) {
            Cutter.setLog("    Error:FindTool.doReplace() - selection zero");
            return -1;
        }
        String dest = replacePanel.getText();
        if (dest == null) {
            dest = "";
        } else if (FindTool.replacePanel.applyEscapes.isSelected()) {
            RegExpUtils re = new RegExpUtils();
            dest = re.doEscape(dest);
        }
        BBxt.suspendWordHiliter();
        BBxt.suspendColoration();
        int selectionEnd = BBxt.replaceSelection(dest);
        BBxt.resumeColoration();
        BBxt.resumeWordHiliter();
        return selectionEnd;
    }

    private void doReplaceAll() {
        String regexp;
        Segment seg = BBxt.getWindowText(0, -1);
        if (seg == null) {
            Cutter.setLog("    Error: FindTool.doReplaceAll() - cannot get the segement from 0 to the end of the document");
            return;
        }
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null || !(textpane instanceof KTextPane)) {
            Cutter.setLog("    Error: FindTool.doReplaceAll() - textpane is either null or not an instance of KTextPane");
            return;
        }
        ((KTextPane)textpane).getFrame().addToHistory();
        String src = findPanel.getText();
        String dest = replacePanel.getText();
        String temp = "";
        RegExpUtils re = new RegExpUtils();
        dest = FindTool.replacePanel.applyEscapes.isSelected() ? re.doEscape(dest) : re.addEscape(dest);
        String string = regexp = FindTool.findPanel.usingRegExp ? src : re.encodeAsRE(src, doIgnoreCase, doWholeWord);
        if (!re.checkPattern(regexp)) {
            return;
        }
        Cutter.setLog("    Info: FindTool.doReplaceAll() using the following regular expression\n              " + regexp + "\n              and this replacement text\n              " + dest);
        BBxt.suspendSyntaxColoration();
        TimerUtils.start();
        try {
            temp = seg.toString().replaceAll(regexp, dest);
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception: FindTool.doReplaceAll()\n          " + ex.toString());
            temp = null;
        }
        if (temp != null) {
            Pattern pattern = Pattern.compile(regexp);
            String[] strs = pattern.split(seg.toString());
            if (strs != null && strs.length > 1) {
                statusField.setText("" + (strs.length - 1) + " [" + TimerUtils.end() + " ms]");
            } else {
                statusField.setText("none found [" + TimerUtils.end() + " ms]");
            }
            try {
                Document doc = textpane.getDocument();
                if (doc == null) {
                    Cutter.setLog("    Error: FindTool.doReplaceAll() - front window has a null document");
                    return;
                }
                doc.remove(0, doc.getLength());
                doc.insertString(0, temp, null);
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Exception: FindTool.doReplaceAll()" + ex);
            }
        }
        BBxt.resumeSyntaxColoration();
        BBxt.parseAll();
        BBxt.setSelection(0, 0);
    }

    public int hasAnOccurancesOf(String regexp, String str) {
        if (str == null || str.trim().length() == 0 || regexp == null) {
            return 0;
        }
        RegExpUtils re = new RegExpUtils();
        if (!re.checkPattern(regexp)) {
            return 0;
        }
        int num = 0;
        try {
            String[] parts = str.split(regexp, 2);
            if (parts != null && parts.length > 1) {
                num = parts.length;
            }
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception: FindTool.countOccurancesOf()" + ex);
            num = 0;
        }
        return num;
    }

    private int countOccurancesOf(String regexp, Segment seg) {
        RegExpUtils re = new RegExpUtils();
        if (!re.checkPattern(regexp)) {
            return 0;
        }
        int num = 0;
        TimerUtils.start();
        try {
            Pattern pattern = Pattern.compile(regexp);
            String[] strs = pattern.split(seg.toString());
            num = strs == null || strs.length == 1 ? 0 : strs.length - 1;
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception: FindTool.countOccurancesOf()" + ex);
            num = 0;
        }
        if (num > 0) {
            statusField.setText("found " + num + " matches [" + TimerUtils.end() + " ms]");
        } else {
            statusField.setText("no matches found [" + TimerUtils.end() + " ms]");
        }
        return num;
    }

    public boolean canReplaceFind() {
        return FindTool.buttonPanel.replaceFindButton.isEnabled();
    }

    public boolean doReplaceFind() {
        this.doReplace();
        return this.doFind(BBxt.getSelectionEnd(), false);
    }

    public String _getReplacementText() {
        String str = KEscapeEncodedField.decode(replacePanel.getText());
        return str == null ? "" : str;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }

    static {
        try {
            Field[] fields = new Field[]{FindTool.class.getDeclaredField("_debug")};
            Cutter.addDebug(FindTool.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: FindTool.static - " + ex.toString());
        }
        statusField = null;
        doIgnoreCase = true;
        doWholeWord = false;
        findPanel = null;
        replacePanel = null;
        buttonPanel = null;
        batchFindPanel = null;
        batchFindPanelIsActive = false;
        tool = null;
    }

    public class InputPanel
    extends KTitledPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        public KSerialTextField textfield;
        private JLabel reglabel;
        public KSerialTextField regfield;
        private KCheckBox regcheck;
        public KCheckBox applyEscapes;
        private Vector<TextFieldListener> listOfListeners;
        public boolean usingRegExp;

        public InputPanel(String title, boolean usesRegExp, String resStr) {
            super(title, resStr);
            this.textfield = null;
            this.reglabel = null;
            this.regfield = null;
            this.regcheck = null;
            this.applyEscapes = new KCheckBox("Apply Escapes", true);
            this.listOfListeners = new Vector();
            this.usingRegExp = false;
            this.textfield = new KSerialTextField("FindTool" + title.trim(), "", 18);
            this.textfield.lineEditorDeactivatesDesktop(false);
            if (usesRegExp) {
                JPanel regPanel = new JPanel();
                this.regcheck = new KCheckBox();
                this.reglabel = new JLabel("RE");
                this.reglabel.setForeground(new Color(0, 0, 142));
                this.reglabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        String url = KAbstractHelp.configurePath(REGEXP_DOC.getPath());
                        if (url.endsWith("\\") || url.endsWith("/")) {
                            url = url.substring(0, url.length() - 1);
                        }
                        if (e.getClickCount() == 1) {
                            BrowserUtils.open(url, e.isShiftDown());
                            if (!e.isShiftDown() && Cutter.htmlWindow != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Cutter.htmlWindow.invalidate();
                                        Cutter.htmlWindow.setVisible(true);
                                        KAbstractDesktop.toFront(Cutter.htmlWindow);
                                    }
                                });
                            }
                        }
                    }
                });
                this.regfield = new KSerialTextField("FindToolRegExp", "", 15);
                this.regfield.lineEditorDeactivatesDesktop(false);
                regPanel.setLayout(new GridBagLayout());
                regPanel.add((Component)this.regfield, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 2, 5, 0)));
                regPanel.add((Component)this.reglabel, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 4, 5, -2)));
                regPanel.add((Component)this.regcheck, new GBC(2, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 5, 0)));
                this.add(this.textfield, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 2, new Insets(0, 5, 5, 5)));
                this.add(regPanel, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 5, 5, 5)));
                this.regcheck.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        InputPanel.this.textfield.setEnabled(!KTools.getCheckBoxState(e));
                        InputPanel.this.regfield.setEnabled(KTools.getCheckBoxState(e));
                        ignoreCase.setEnabled(!KTools.getCheckBoxState(e));
                        wholeWord.setEnabled(!KTools.getCheckBoxState(e));
                        FindTool.buttonPanel.copyAllButton.setEnabled(KTools.getCheckBoxState(e));
                    }
                });
                this.regcheck.setSelected(false);
                this.regfield.setEnabled(false);
                this.regfield.addActionListener(this);
                this.regfield.usesModelDialog = true;
            } else {
                this.add(this.textfield, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 5, 0, 5)));
                this.add(this.applyEscapes, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 5, 0, 5)));
            }
            this.textfield.addActionListener(this);
            this.textfield.usesModelDialog = true;
            this.textfield.setEnabled(true);
        }

        private void initFields(String encoded, String regexp) {
            if (encoded == null) {
                encoded = "";
            }
            this.textfield.setText(encoded.equals(" ") ? "" : encoded);
            this.enableListeners(!encoded.equals(" "));
        }

        public void addFieldListener(TextFieldListener l) {
            this.listOfListeners.addElement(l);
            if (this.getText() != null) {
                l.setEnabled(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!e.getActionCommand().equals("released")) {
                return;
            }
            if (this.getText() == null) {
                this.enableListeners(false);
            } else {
                this.enableListeners(true);
            }
        }

        private void enableListeners(boolean flag) {
            for (int n = 0; n < this.listOfListeners.size(); ++n) {
                JComponent comp = (JComponent)((Object)this.listOfListeners.elementAt(n));
                if (!(comp instanceof JButton)) continue;
                comp.setEnabled(flag);
            }
        }

        public String getText() {
            boolean bl = this.usingRegExp = !this.textfield.isEnabled();
            if (this.usingRegExp && this.regfield == null) {
                return null;
            }
            if (!this.usingRegExp && this.textfield == null) {
                return null;
            }
            return this.textfield.isEnabled() ? this.textfield.getText() : this.regfield.getText();
        }

        public void setFindText(String text, boolean asRegExp) {
            this.regcheck.setSelected(asRegExp);
            this.regfield.setEnabled(asRegExp);
            if (asRegExp) {
                this.regfield.setText(text);
            } else {
                this.textfield.setText(text);
            }
        }

        public void saveSelf() {
            this.textfield.saveSelf();
            if (this.regfield != null) {
                this.regfield.saveSelf();
            }
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            if (this.regcheck == null) {
                this.textfield.setEnabled(flag);
                return;
            }
            this.regfield.setEnabled(flag && this.regcheck.isSelected());
            this.textfield.setEnabled(this.regcheck.isEnabled() && !this.regcheck.isSelected());
        }
    }

    private class ButtonPanel
    extends JPanel
    implements ActionListener {
        public KButton findButton = new KButton("Find", false, this);
        public KButton findNextButton = new KButton("Find Next", false, this);
        public KButton replaceButton = new KButton("Replace", true, this);
        public KButton replaceFindButton = new KButton("Replace & Find", true, this);
        public KButton replaceAllButton = new KButton("Replace All", false, this);
        public KButton countButton = new KButton("Count ", false, this);
        public KButton copyAllButton = new KButton("Copy All", false, this);
        private boolean found = false;

        public ButtonPanel() {
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.add((Component)this.findButton, new GBC(0, n++, 1, 1, 1.0, 0.0, 0, 0, 18, 3, new Insets(8, 0, 0, 0)));
            this.add((Component)this.findNextButton, new GBC(0, n++, 1, 1, 1.0, 0.0, 0, 0, 18, 3, new Insets(5, 0, 0, 0)));
            this.add((Component)this.replaceButton, new GBC(0, n++, 1, 1, 1.0, 0.0, 0, 0, 18, 3, new Insets(5, 0, 0, 0)));
            this.add((Component)this.replaceFindButton, new GBC(0, n++, 1, 1, 1.0, 0.0, 0, 0, 18, 3, new Insets(5, 0, 0, 5)));
            this.add((Component)this.replaceAllButton, new GBC(0, n++, 1, 1, 1.0, 0.0, 0, 0, 18, 3, new Insets(5, 0, 0, 0)));
            this.add((Component)this.countButton, new GBC(0, n++, 1, 1, 1.0, 0.0, 0, 0, 18, 3, new Insets(5, 0, 0, 0)));
            this.add((Component)this.copyAllButton, new GBC(0, n++, 1, 1, 1.0, 0.0, 0, 0, 18, 3, new Insets(5, 0, 0, 0)));
            this.add((Component)new JPanel(), new GBC(0, n++, 1, 1, 1.0, 1.0, 0, 0, 18, 3, new Insets(0, 0, 0, 0)));
            this.findButton.setRequestFocusEnabled(false);
            this.findNextButton.setRequestFocusEnabled(false);
            this.replaceButton.setRequestFocusEnabled(false);
            this.replaceFindButton.setRequestFocusEnabled(false);
            this.replaceFindButton.setRequestFocusEnabled(false);
            this.replaceAllButton.setRequestFocusEnabled(false);
            this.copyAllButton.setRequestFocusEnabled(false);
            this.copyAllButton.setEnabled(false);
            this.countButton.setEnabled(true);
            this.replaceAllButton.setEnabled(false);
        }

        public void deselectWholeWordCheckBox() {
            wholeWord.setSelected(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane pane;
            KAbstractWindow win = BBxt.frontWindow();
            if (win != null && (pane = BBxt.getTextPane(win)) != null) {
                pane.requestFocus();
            }
            if (e.getSource() == FindTool.buttonPanel.findButton) {
                int selectionStart = BBxt.getSelectionStart();
                if (selectionStart == -1) {
                    Cutter.setLog("    Error: FindTool.actionPerformed() selectionStart is -1");
                    return;
                }
                this.found = FindTool.this.doFind(selectionStart, false);
                if (this.found && BBxt.canReplaceText()) {
                    this.replaceButton.setEnabled(true);
                    this.replaceAllButton.setEnabled(true);
                    this.replaceFindButton.setEnabled(true);
                } else if (BBxt.frontWindow() instanceof KTextWindow) {
                    BBxt.setSelection(selectionStart, selectionStart);
                    this.replaceButton.setEnabled(false);
                    this.replaceAllButton.setEnabled(false);
                    this.replaceFindButton.setEnabled(false);
                }
                return;
            }
            if (e.getSource() == FindTool.buttonPanel.copyAllButton) {
                this.found = FindTool.this.doFind(0, true);
                if (!this.found) {
                    return;
                }
                StringBuffer buff = new StringBuffer();
                Hashtable<String, String> table = new Hashtable<String, String>();
                String text = BBxt.getSelection();
                int end = BBxt.getSelectionEnd();
                if (text.trim().length() == 0) {
                    return;
                }
                table.put(text, text);
                while (FindTool.this.doFind(end, true) && (text = BBxt.getSelection()).trim().length() > 0) {
                    table.put(text, text);
                    end = BBxt.getSelectionEnd();
                }
                Enumeration en = table.keys();
                while (en.hasMoreElements()) {
                    String k = (String)en.nextElement();
                    buff.append(k).append("\n");
                }
                BBxt.newDocument("Results.txt", buff);
                return;
            }
            if (e.getSource() == FindTool.buttonPanel.findNextButton) {
                int selectionEnd = BBxt.getSelectionEnd();
                this.found = FindTool.this.doFind(selectionEnd, false);
                this.findNextButton.setEnabled(this.found);
                this.replaceButton.setEnabled(this.found);
                this.replaceFindButton.setEnabled(this.found);
                if (!this.found) {
                    BBxt.setSelection(selectionEnd, selectionEnd);
                }
                return;
            }
            if (e.getSource() == FindTool.buttonPanel.replaceButton) {
                FindTool.this.doReplace();
                return;
            }
            if (e.getSource() == FindTool.buttonPanel.replaceAllButton) {
                FindTool.this.doReplaceAll();
                return;
            }
            if (e.getSource() == FindTool.buttonPanel.replaceFindButton) {
                boolean found = FindTool.this.doReplaceFind();
                int selectionEnd = BBxt.getSelectionEnd();
                if (found && BBxt.canReplaceText()) {
                    this.findNextButton.setEnabled(true);
                    this.replaceButton.setEnabled(true);
                } else {
                    BBxt.setSelection(selectionEnd, selectionEnd);
                    this.findNextButton.setEnabled(false);
                    this.replaceButton.setEnabled(false);
                }
                return;
            }
            if (e.getSource() == FindTool.buttonPanel.countButton) {
                Segment seg = BBxt.getWindowText(0, -1);
                if (seg == null) {
                    Cutter.setLog("    Error: FindTool.buttonPanel.countButton - cannot get the segment from 0 to the end of the document");
                    return;
                }
                String src = findPanel.getText();
                RegExpUtils re = new RegExpUtils();
                String regexp = FindTool.findPanel.usingRegExp ? src : re.encodeAsRE(src, doIgnoreCase, doWholeWord);
                FindTool.this.countOccurancesOf(regexp, seg);
                return;
            }
        }

        private class KButton
        extends JButton
        implements TextFieldListener {
            public boolean checkSelection;

            public KButton(String t, boolean flag, ActionListener listener) {
                super(t);
                this.checkSelection = false;
                this.checkSelection = flag;
                this.setMargin(new Insets(1, 5, 1, 5));
                if (listener != null) {
                    this.addActionListener(listener);
                }
                this.setEnabled(false);
            }

            @Override
            public void setEnabled(boolean doEnable) {
                if (doEnable && this.checkSelection) {
                    super.setEnabled(BBxt.isSelection());
                } else if (doEnable) {
                    super.setEnabled(true);
                } else {
                    super.setEnabled(false);
                }
            }
        }
    }

    private class BatchFindButton
    extends JToggleButton {
        private ImageIcon icon = ResourceUtils.getIconResource("/resources/batchFind.gif");

        private BatchFindButton() {
            this.setIcon(this.icon);
            this.setMargin(new Insets(-1, 0, 1, 2));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BatchFindButton.this.isSelected()) {
                        batchFindPanelIsActive = true;
                        batchFindPanel.setVisible(true);
                        FindTool.this.pack();
                    } else {
                        batchFindPanelIsActive = false;
                        batchFindPanel.setVisible(false);
                        FindTool.this.pack();
                    }
                }
            });
        }
    }

    private static interface TextFieldListener {
        public void setEnabled(boolean var1);
    }
}

