/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.FindLineTool;

import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KTextField.KIntTextField;
import UI_Desktop.Cutter;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.KTools;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DocumentUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;

public class FindLineTool
extends KTools {
    protected static FindLineTool tool = null;
    private KButton goLineButton = new KButton("  Line  ");
    public KIntTextField goLineField = new KIntTextField(5);
    private KButton goCharButton = new KButton("  Char ");
    public KIntTextField goCharField = new KIntTextField(5);
    private KButton shoLinesButton = new KButton(" Show Line Numbers ");
    private int lastLineUsed = 1;
    private int lastCharUsed = 0;

    public static FindLineTool init() {
        if (tool != null) {
            return tool;
        }
        tool = new FindLineTool();
        return tool;
    }

    protected FindLineTool() {
        super("Find Line", JLayeredPane.PALETTE_LAYER);
        this.goLineButton.setMargin(new Insets(-1, 5, -1, 5));
        this.goLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindLineTool.this.gotoLine();
            }
        });
        this.goLineField.setMargin(new Insets(0, 0, 0, 0));
        this.goLineField.setMinimumSize(this.goLineField.getPreferredSize());
        this.goCharButton.setMargin(new Insets(-1, 5, -1, 5));
        this.goCharButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindLineTool.this.gotoChar();
            }
        });
        this.goCharField.setMargin(new Insets(0, 0, 0, 0));
        this.goCharField.setMinimumSize(this.goCharField.getPreferredSize());
        this.shoLinesButton.setMargin(new Insets(-1, 5, -1, 5));
        this.shoLinesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KAbstractWindow fw = BBxt.frontWindow();
                if (fw != null && fw instanceof KTextWindow) {
                    boolean flag = ((KTextWindow)fw).lineNumberingIsVisible();
                    ((KTextWindow)fw).showLineNumbering(!flag);
                    if (!(!flag)) {
                        FindLineTool.this.shoLinesButton.setText("Show Line Numbers");
                    } else {
                        FindLineTool.this.shoLinesButton.setText("Hide Line Numbers");
                    }
                    FindLineTool.this.setVisible(false);
                }
            }
        });
        this.shoLinesButton.setMargin(new Insets(0, 0, 0, 0));
        this.shoLinesButton.setMinimumSize(this.goCharField.getPreferredSize());
        this.contentPane.add((Component)this.goLineButton, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 11, new Insets(5, 10, 5, 0)));
        this.contentPane.add((Component)this.goLineField, new GBC(1, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 11, new Insets(5, 5, 5, 8)));
        this.contentPane.add((Component)this.goCharButton, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 11, new Insets(0, 10, 8, 0)));
        this.contentPane.add((Component)this.goCharField, new GBC(1, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 11, new Insets(0, 5, 8, 8)));
        this.contentPane.add((Component)this.shoLinesButton, new GBC(0, 2, 2, 1, 1.0, 1.0, 0, 0, 17, 11, new Insets(0, 8, 8, 5)));
        this.pack();
        this.setInitialPosition();
        this.setVisible(false);
    }

    private void gotoLine() {
        JEditorPane pane = BBxt.getTextPane();
        if (!(pane instanceof KTextPane)) {
            return;
        }
        KTextPane textpane = (KTextPane)pane;
        Integer integer = this.goLineField.getInt();
        int line = integer == null ? 1 : integer;
        int offset = this.getLineOffset(line, textpane.getDocument());
        if (line < 1) {
            this.goLineField.setText("1");
        }
        int[] lineOffsets = DocumentUtils.getElementOffsets(textpane.getDocument(), offset);
        textpane.setSelectionStart(lineOffsets[1]);
        textpane.setSelectionEnd(lineOffsets[2] - 1);
        textpane.requestFocus();
    }

    private void gotoChar() {
        JEditorPane pane;
        int offset;
        Integer integer = this.goCharField.getInt();
        int n = offset = integer == null ? 1 : integer - 1;
        if (offset < 1) {
            this.goCharField.setText("1");
            ++offset;
        }
        if (!((pane = BBxt.getTextPane()) instanceof KTextPane)) {
            return;
        }
        pane.setSelectionStart(offset);
        pane.setSelectionEnd(offset + 1);
        pane.requestFocus();
    }

    @Override
    public void showSelf() {
        KAbstractWindow fw = BBxt.frontWindow();
        if (fw != null && fw instanceof KTextWindow) {
            boolean flag = ((KTextWindow)fw).lineNumberingIsVisible();
            if (!flag) {
                this.shoLinesButton.setText("Show Line Numbers");
            } else {
                this.shoLinesButton.setText("Hide Line Numbers");
            }
        }
        super.showSelf();
    }

    @Override
    protected void toolSelectionHappened() {
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docExt) {
        KAbstractWindow fw = BBxt.frontWindow();
        if (fw == null) {
            return;
        }
        if (fw instanceof KTextWindow) {
            KTextWindow ktw = (KTextWindow)fw;
            if (ktw.lineNumberingIsVisible()) {
                this.shoLinesButton.setText(" Hide Line Numbers ");
            } else {
                this.shoLinesButton.setText(" Show Line Numbers ");
            }
        }
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }

    private int getLineOffset(int line, Document document) {
        int n;
        if (line <= 1) {
            return 0;
        }
        int length = document.getLength();
        Segment segment = new Segment();
        try {
            document.getText(0, length, segment);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: GotoLineDialog.getLineOffset() " + ex);
            return 0;
        }
        int lineCount = 1;
        for (n = 0; n < segment.count; ++n) {
            if (segment.array[segment.offset + n] == '\n') {
                ++lineCount;
            }
            if (lineCount != line) continue;
            this.lastLineUsed = line;
            return n + 1;
        }
        this.lastLineUsed = n;
        return n;
    }
}

