/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.FtpSendTool;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.PathSearchButton;
import UI_Components.KCheckBox;
import UI_Components.KLabelledField;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.KTools;
import Utilities.EncryptionUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.HTMLUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class FtpSendTool
extends KTools
implements ActionListener,
CaretListener,
ProcListener {
    protected static FtpSendTool tool = null;
    HostPanel hostPanel = new HostPanel();
    NamePasswordPanel namePassPanel = new NamePasswordPanel();
    RemoteDirPanel remotePanel = new RemoteDirPanel();
    SendOptionsPanel optionsPanel = new SendOptionsPanel();
    JButton sendButton = new JButton("Send File");
    File ftpOutfile = null;
    File htmFile = null;
    private boolean processError = false;

    public static FtpSendTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new FtpSendTool(menuItem);
        return tool;
    }

    public FtpSendTool(JMenuItem menuItem) {
        super("FtpSend Tool", menuItem, Preferences.TOOL_FTPSEND);
        this.contentPane.add((Component)this.sendButton, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 12, 0, new Insets(10, 5, 2, 5)));
        this.contentPane.add((Component)this.sendButton, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 12, 0, new Insets(10, 5, 2, 5)));
        this.contentPane.add((Component)this.hostPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)this.namePassPanel, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)this.remotePanel, new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)this.optionsPanel, new GBC(0, 4, 1, 1, 1.0, 1.0, 0, 0, 12, 2, new Insets(0, 5, 2, 5)));
        this.sendButton.setEnabled(false);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String htmlText;
                StringBuffer buf = new StringBuffer();
                if (EnvUtils.isWinEnvironment()) {
                    buf.append("open ").append(FtpSendTool.this.hostPanel.getHostName()).append("\n");
                } else {
                    buf.append("ftp -n ").append(FtpSendTool.this.hostPanel.getHostName()).append(" << EOF\n");
                }
                buf.append("quote USER ").append(FtpSendTool.this.namePassPanel.getUserName()).append("\n");
                buf.append("quote PASS ").append(FtpSendTool.this.namePassPanel.getPassword()).append("\n");
                buf.append("cd ").append(FtpSendTool.this.remotePanel.getPath()).append("\n");
                Object localFullPath = null;
                String localName = null;
                String localDir = null;
                File f = BBxt.getWindowFile();
                if (f == null) {
                    return;
                }
                localName = f.getName();
                localDir = f.getParent();
                BBxt.save();
                if (FtpSendTool.this.optionsPanel.sendAsHTML() && (htmlText = HTMLUtils.generateHTML(null, false)).trim().length() > 0) {
                    if (FtpSendTool.this.optionsPanel.sendAsIndex()) {
                        localName = "index";
                    }
                    localName = localName + ".htm";
                    FtpSendTool.this.htmFile = new File(localDir, localName);
                    FileUtils.writeFile(FtpSendTool.this.htmFile, htmlText);
                }
                buf.append("put \"./").append(localName).append("\"\n");
                buf.append("quit\n");
                buf.append("EOf\n");
                FtpSendTool.this.ftpOutfile = EnvUtils.isWinEnvironment() ? new File(localDir, "ftp_send") : new File(localDir, ".ftp_send");
                FileUtils.writeFile(FtpSendTool.this.ftpOutfile, buf.toString());
                FtpSendTool.this.ftpOutfile.setExecutable(true, false);
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            File envDir = FtpSendTool.this.ftpOutfile.getParentFile();
                            if (!EnvUtils.isWinEnvironment()) {
                                String[] item1 = new String[]{"./" + FtpSendTool.this.ftpOutfile.getName()};
                                ProcessManager fp1 = new ProcessManager("untitled");
                                fp1.launch(item1, envDir, false, FtpSendTool.this, true);
                            } else {
                                String[] items = new String[]{"C:\\WINDOWS\\system32\\cmd", "/C", "ftp -v -n -s:" + FtpSendTool.this.ftpOutfile.getName()};
                                ProcessManager fp2 = new ProcessManager("Dos");
                                fp2.launch(items, envDir, false, FtpSendTool.this, true);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.pack();
        this.setVisible(false);
        this.setInitialPosition();
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
        this.processError = false;
        this.sendButton.setForeground(Color.BLUE);
        this.sendButton.setEnabled(false);
    }

    @Override
    public void processFinished(String[] progarray) {
        if (!this.processError) {
            this.sendButton.setForeground(Color.BLACK);
        } else {
            this.sendButton.setForeground(Color.RED);
        }
        this.sendButton.setEnabled(true);
        Cutter.setLog("    Info:FtpSendTool = processFinished()");
        if (this.ftpOutfile != null && this.ftpOutfile.exists()) {
            this.ftpOutfile.delete();
            this.ftpOutfile = null;
        }
        if (this.htmFile != null && this.htmFile.exists()) {
            this.htmFile.delete();
            this.htmFile = null;
        }
    }

    @Override
    public void processSentString(String procName, String output) {
        if (output.contains("failed") || output.contains("No") || output.contains("Not ") || output.contains("not ")) {
            this.processError = true;
            this.sendButton.setEnabled(true);
            if (EnvUtils.isWinEnvironment() && output.contains(" No ")) {
                this.processError = false;
            } else {
                Cutter.setLog("    Error: FtpSendTool.processSentString() - " + output);
            }
        }
    }

    @Override
    protected void toolSelectionHappened() {
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docname) {
        this.checkToolStatus();
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
        this.hostPanel.saveSelf();
        this.namePassPanel.saveSelf();
        this.remotePanel.saveSelf();
        this.optionsPanel.saveSelf();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!e.getActionCommand().equals("released")) {
            return;
        }
        this.checkToolStatus();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.checkToolStatus();
    }

    public void checkToolStatus() {
        String hostname = this.hostPanel.getHostName();
        char[] username = this.namePassPanel.getUserName();
        char[] userpass = this.namePassPanel.getPassword();
        String filepath = "";
        String remotepath = this.remotePanel.getPath();
        boolean isOK = true;
        if (filepath.trim().length() == 0 && BBxt.getWindowFile() == null) {
            isOK = false;
        }
        if (isOK && hostname.trim().length() == 0) {
            isOK = false;
        }
        if (isOK && username.length == 0) {
            isOK = false;
        }
        if (isOK && userpass.length == 0) {
            isOK = false;
        }
        if (isOK && remotepath.trim().length() == 0) {
            isOK = false;
        }
        if (isOK) {
            this.sendButton.setText("Send " + BBxt.getWindowTitle());
        }
        this.sendButton.setEnabled(isOK);
    }

    private class HostPanel
    extends KTitledPanel {
        private KLabelledField hostField;

        public HostPanel() {
            super(" FTP Host Name ");
            this.hostField = new KLabelledField(" Name", 20, "");
            this.hostField.field.setText(Preferences.get(Preferences.TOOL_FTPSEND_HOSTNAME));
            this.add(this.hostField, new GBC(0, 0, 1, 1, 1.0, 1.0, -5, 0, 18, 2, new Insets(5, 0, 0, 0)));
            this.hostField.field.addActionListener(FtpSendTool.this);
        }

        private void saveSelf() {
            Preferences.write(Preferences.TOOL_FTPSEND_HOSTNAME, this.getHostName());
        }

        public void updateUI(File f) {
            this.saveSelf();
        }

        public String getHostName() {
            return this.hostField.field.getText();
        }

        boolean isHostTextField(KTextField field) {
            return field == this.hostField.field;
        }
    }

    private class NamePasswordPanel
    extends KTitledPanel {
        JLabel name_label;
        JPasswordField nameField;
        JLabel pass_label;
        JPasswordField passField;

        public NamePasswordPanel() {
            super(" User Name & Password ");
            this.name_label = new JLabel(" Name");
            this.nameField = new JPasswordField("");
            this.pass_label = new JLabel(" Password");
            this.passField = new JPasswordField("");
            String encryptedUserName = "";
            String encryptedPassword = "";
            try {
                encryptedUserName = Preferences.get(Preferences.TOOL_FTPSEND_USERNAME);
                String decryptedUserName = EncryptionUtils.decrypt(encryptedUserName);
                this.nameField.setText(decryptedUserName);
                encryptedPassword = Preferences.get(Preferences.TOOL_FTPSEND_USERPASS);
                String decryptedPassword = EncryptionUtils.decrypt(encryptedPassword);
                this.passField.setText(decryptedPassword);
            }
            catch (Exception e) {
                Cutter.setLog("   Error: Exception: FtpSendTool EncryptionUtils.decrypt " + e.toString());
            }
            this.nameField.setColumns(15);
            this.passField.setColumns(15);
            this.add(this.name_label, new GBC(0, 0, 1, 1, 1.0, 0.0, -5, 0, 18, 2, new Insets(5, 0, 0, 0)));
            this.add(this.nameField, new GBC(1, 0, 1, 1, 1.0, 0.0, -5, 0, 18, 2, new Insets(5, 0, 0, 0)));
            this.add(this.pass_label, new GBC(0, 1, 1, 1, 1.0, 0.0, -5, 0, 18, 2, new Insets(5, 0, 0, 0)));
            this.add(this.passField, new GBC(1, 1, 1, 1, 1.0, 1.0, -5, 0, 18, 2, new Insets(5, 0, 0, 0)));
            this.nameField.addCaretListener(FtpSendTool.this);
            this.passField.addCaretListener(FtpSendTool.this);
        }

        public void saveSelf() {
            try {
                String encryptedName = EncryptionUtils.encrypt(this.getUserName());
                Preferences.write(Preferences.TOOL_FTPSEND_USERNAME, encryptedName);
                String encryptedPassword = EncryptionUtils.encrypt(this.getPassword());
                Preferences.write(Preferences.TOOL_FTPSEND_USERPASS, encryptedPassword);
            }
            catch (Exception e) {
                System.out.println("Writing: " + e.toString());
            }
        }

        public void updateUI(File f) {
            this.saveSelf();
        }

        public char[] getUserName() {
            return this.nameField.getPassword();
        }

        public char[] getPassword() {
            return this.passField.getPassword();
        }

        boolean isNameField(JPasswordField field) {
            return field == this.nameField;
        }

        boolean isPasswordField(JPasswordField field) {
            return field == this.passField;
        }
    }

    private class RemoteDirPanel
    extends KTitledPanel {
        private KSerialTextField remotePathField;

        public RemoteDirPanel() {
            super(" Remote Directory to Receive ");
            this.remotePathField = new KSerialTextField(" Path", "", 18);
            this.remotePathField.setText(Preferences.get(Preferences.TOOL_FTPSEND_HOST_PWD));
            this.add(this.remotePathField, new GBC(0, 0, 1, 1, 1.0, 1.0, -5, 0, 18, 2, new Insets(5, 0, 0, 0)));
            this.remotePathField.addActionListener(FtpSendTool.this);
        }

        private void saveSelf() {
            Preferences.write(Preferences.TOOL_FTPSEND_HOST_PWD, this.getPath());
            this.remotePathField.saveSelf();
        }

        public void updateUI(File f) {
            this.saveSelf();
        }

        public String getPath() {
            return this.remotePathField.getText();
        }
    }

    private class SendOptionsPanel
    extends KTitledPanel {
        private KCheckBox sendAsHTML;
        private KCheckBox sendAsIndex;

        public SendOptionsPanel() {
            super(" Options ");
            this.sendAsHTML = new KCheckBox("Send as html", false);
            this.sendAsIndex = new KCheckBox("Send as index.htm", false);
            this.sendAsHTML.setSelected(Preferences.get(Preferences.TOOL_FTPSEND_SEND_AS_HTML) != "false");
            this.sendAsIndex.setSelected(Preferences.get(Preferences.TOOL_FTPSEND_SEND_AS_INDEX_HTML) != "false");
            this.add(this.sendAsHTML, new GBC(0, 0, 1, 1, 1.0, 0.0, -5, 0, 18, 2, new Insets(0, 0, 0, 0)));
            this.add(this.sendAsIndex, new GBC(0, 1, 1, 1, 1.0, 1.0, -5, 0, 18, 2, new Insets(2, 0, 0, 0)));
            this.sendAsIndex.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        SendOptionsPanel.this.sendAsHTML.setSelected(true);
                    }
                }
            });
        }

        private void saveSelf() {
            Preferences.write(Preferences.TOOL_FTPSEND_SEND_AS_HTML, this.sendAsHTML.isSelected() ? "true" : "false");
            Preferences.write(Preferences.TOOL_FTPSEND_SEND_AS_INDEX_HTML, this.sendAsIndex.isSelected() ? "true" : "false");
        }

        public void updateUI(File f) {
            this.saveSelf();
        }

        public boolean sendAsHTML() {
            return this.sendAsHTML.isSelected();
        }

        public boolean sendAsIndex() {
            return this.sendAsIndex.isSelected();
        }
    }

    private class LocalDirFilePanel
    extends KTitledPanel {
        private KLabelledField filepathField;
        private PathSearchButton filesearch;

        public LocalDirFilePanel() {
            super(" Local File to Send ");
            this.filepathField = new KLabelledField(" Path", 20, "");
            this.filesearch = new PathSearchButton(this.filepathField, "?", "Choose Directory", 0);
            this.filepathField.field.setText(Preferences.get(Preferences.TOOL_FTPSEND_FILENAME));
            this.add(this.filepathField, new GBC(0, 0, 1, 1, 1.0, 0.0, -5, 0, 18, 2, new Insets(5, 0, 0, 0)));
            this.add(this.filesearch, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(5, 0, 0, 5)));
            this.filepathField.field.addActionListener(FtpSendTool.this);
        }

        private void saveSelf() {
            Preferences.write(Preferences.TOOL_FTPSEND_FILENAME, this.getPath());
        }

        public void updateUI(File f) {
            this.saveSelf();
        }

        public String getPath() {
            return this.filepathField.field.getText();
        }

        public String getDir() {
            File f = new File(this.filepathField.field.getText());
            return f.getParent();
        }
    }
}

