/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.HTMLSearchTool;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTabbedPane.KTabbedPane;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Help.Url;
import UI_Script.Mel.MELSearch;
import UI_Script.Mel.MelDocsDB;
import UI_Script.Rib.RibHelp;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Tools.HTMLSearchTool.SearchPanel.HTMLSearchPanel;
import UI_Tools.HTMLSearchTool.TargetPanel.HTMLTargetPanel;
import UI_Tools.KTools;
import Utilities.FileUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import kernal.Searchers.HTMLSearch;
import kernal.Searchers.SearchResult;

public class HTMLSearchTool
extends KTools
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static KTabbedPane tabbedPane = new KTabbedPane();
    protected static HTMLSearchTool tool = null;
    protected static HTMLTargetPanel targetsPanel = null;
    protected static HTMLSearchPanel searchPanel = null;
    public static String searchPath = Preferences.get(Preferences.TOOL_HTML_SEARCH_PATH);
    public static String searchButtonTitle = "Search";

    public static HTMLSearchTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new HTMLSearchTool(menuItem);
        return tool;
    }

    private HTMLSearchTool(JMenuItem menuItem) {
        super("HTML Search Tool", menuItem, Preferences.TOOL_HTML_SEARCH);
        targetsPanel = new HTMLTargetPanel(this);
        searchPanel = new HTMLSearchPanel(this);
        tabbedPane.addTab("Search", searchPanel);
        tabbedPane.addTab("Target", targetsPanel);
        this.contentPane.add((Component)tabbedPane, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(0, 0, 0, 0)));
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane tab = (JTabbedPane)e.getSource();
                if (tab.getSelectedIndex() == 0) {
                    String path = targetsPanel.getCustomFieldText();
                    if (!path.equals(Preferences.get(Preferences.TOOL_HTML_SEARCH_USER_DOCS))) {
                        Preferences.write(Preferences.TOOL_HTML_SEARCH_USER_DOCS, path);
                    }
                    if (HTMLSearchTool.targetsPanel.custom.isSelected()) {
                        searchPath = Preferences.get(Preferences.TOOL_HTML_SEARCH_USER_DOCS);
                    }
                    searchPanel.setSearchButtonTitle();
                }
            }
        });
        this.setTitle(this.title);
        this.pack();
        this.setInitialPosition();
        this.setVisible(false);
    }

    @Override
    protected void toolSelectionHappened() {
        HTMLSearchTool.searchPanel.findfield.textfield.requestFocus();
        HTMLSearchTool.searchPanel.findfield.textfield.selectAll();
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
        Preferences.write(Preferences.TOOL_HTML_SEARCH_PATH, searchPath);
        searchPanel.saveSelf();
        targetsPanel.saveSelf();
    }

    public boolean doRecursiveSearch() {
        return targetsPanel.doRecursiveSearch();
    }

    public static String searchPathToTargetName() {
        if (searchPath.equals("") && targetsPanel != null) {
            return targetsPanel.getNameOfSelectedButton();
        }
        String ratDocsRootPath = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        String pixarShadersDocsPath = Url.join(ratDocsRootPath, Url.ri.shaders_dir);
        String rispec_htmlPath = RibHelp.getRPSDocsIndex();
        if (pixarShadersDocsPath.equals(searchPath)) {
            return "Pixar Shaders";
        }
        if (Preferences.get(Preferences.PATH_3DELIGHT_DOCS_SHADERS).equals(searchPath)) {
            return "3Delight Shaders";
        }
        if (Preferences.get(Preferences.PATH_BMRT_DOCS_SHADERS).equals(searchPath)) {
            return "BMRT Shaders";
        }
        if (Preferences.get(Preferences.PATH_AIR_DOCS_SHADERS).equals(searchPath)) {
            return "Air Shaders";
        }
        if (rispec_htmlPath.equals(searchPath)) {
            return "RiSpec";
        }
        if (ratDocsRootPath.equals(searchPath)) {
            return "Rat";
        }
        if (Preferences.get(Preferences.PATH_MEL_DOCS).equals(searchPath)) {
            return "Mel";
        }
        if (Preferences.get(Preferences.PATH_VEX_DOCS).equals(searchPath)) {
            return "Vex";
        }
        if (Preferences.get(Preferences.PATH_TCL_DOCS).equals(searchPath)) {
            return "Tcl";
        }
        if (searchPath.equals(new File(FileUtils.getPWD(), "Cutter_Help/tcl/ActiveTcl/tcl/TclCmd").getPath())) {
            return "Tcl";
        }
        return "Custom";
    }

    public static void setSearchPath(int prefID) {
        searchPath = Preferences.get(prefID);
    }

    public static String getSearchPath() {
        return searchPath == null ? "undefined" : searchPath;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (searchPath == null || searchPath.trim().length() == 0) {
            HTMLSearchTool.TargetNotSpecifiedMessage();
            return;
        }
        HTMLSearchTool.searchPanel.resultsArea.setText("");
        Thread thread = new Thread("searcher thread"){

            @Override
            public void run() {
                int numFound;
                String[] paths;
                int maxReports = 10;
                HTMLSearch search = null;
                if (searchPath.equals(Preferences.get(Preferences.PATH_MEL_DOCS))) {
                    ScriptHandler handler;
                    if (MelDocsDB.cache == null && (handler = ScriptRegistry.getHandlerForExtension(".mel")) != null) {
                        handler.loadCache(null);
                    }
                    search = new MELSearch(HTMLSearchTool.searchPanel.progressPanel.bar);
                    paths = search.getTargetPaths();
                } else {
                    search = new HTMLSearch(searchPath, HTMLSearchTool.searchPanel.progressPanel.bar);
                    paths = HTMLSearchTool.this.doRecursiveSearch() ? search.getTargetPaths(10) : search.getTargetPaths();
                }
                int numSearched = paths == null ? 0 : paths.length;
                String searchStr = HTMLSearchTool.searchPanel.findfield.getText();
                Vector list = search.find(searchStr, maxReports, HTMLSearchTool.searchPanel.doIgnoreCase, HTMLSearchTool.searchPanel.doWholeWord);
                int n = numFound = list == null ? 0 : list.size();
                if (list == null) {
                    HTMLSearchTool.searchPanel.resultsArea.setText("__ " + numSearched + " Files searched __\n  no matches found");
                    return;
                }
                StringBuffer buffer = new StringBuffer("__Found " + numFound + " out of " + numSearched + " Files__\n");
                for (int n2 = 0; n2 < list.size(); ++n2) {
                    SearchResult result = (SearchResult)list.elementAt(n2);
                    buffer.append(result.hits + ": " + result.docName + "\n");
                }
                HTMLSearchTool.searchPanel.resultsArea.setText(buffer.toString());
                HTMLSearchTool.searchPanel.resultsArea.setCaretPosition(0);
            }
        };
        thread.start();
    }

    private static void TargetNotSpecifiedMessage() {
        JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The target directory for a search has not been specified.\nUse the Targets tab to select the type of documentation\nyou wish to search.", "Search Target Not Specified", 2);
    }

    private static void MissingDocumentationMessage() {
        JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "Cutter cannot find any documentation at:\n   \"" + searchPath + "\nReset the path using the preferences tool.", "Missing Documentation Error", 0);
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }
}

