/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.HTMLSearchTool.SearchPanel;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTabbedPane.KTabPanel;
import UI_Components.KTextArea;
import UI_Components.KTitledPanel;
import UI_Components.LabelTextField;
import UI_Desktop.Cutter;
import UI_Script.Html.HtmlTokenizer;
import UI_Tools.HTMLSearchTool.HTMLSearchTool;
import UI_Tools.KTools;
import Utilities.BrowserUtils;
import Utilities.DialogUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;

public class HTMLSearchPanel
extends KTabPanel {
    private static final long serialVersionUID = 1L;
    public static final String IGNORE_CASE_TITLE = "Ignore Case";
    public static final String WHOLE_WORD_TITLE = "Whole Word";
    public KTitledPanel inputPanel = null;
    private JCheckBox ignoreCase;
    private JCheckBox wholeWord;
    public boolean doIgnoreCase = true;
    public boolean doWholeWord = false;
    public ProgressPanel progressPanel = new ProgressPanel();
    private Karet caret = new Karet();
    public JButton doSearchButton = new JButton("Search");
    public KTextArea resultsArea = new KTextArea(5, 11);
    public LabelTextField findfield = new LabelTextField("Find: ", Preferences.get(Preferences.TOOL_HTML_SEARCH_STRING), 2, 0, 12);
    private HTMLSearchTool parent;

    public HTMLSearchPanel(HTMLSearchTool parent) {
        this.parent = parent;
        this.inputPanel = new KTitledPanel(" Pattern ", "HTMLSearchPanel.inputPanel.info");
        this.inputPanel.add(this.findfield, new GBC(0, 0, 2, 1, 1.0, 1.0, 0, 0, 12, 2, new Insets(0, 5, 5, 5)));
        this.ignoreCase = new JCheckBox(IGNORE_CASE_TITLE, true);
        this.ignoreCase.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HTMLSearchPanel.this.doIgnoreCase = KTools.getCheckBoxState(e);
            }
        });
        this.wholeWord = new JCheckBox(WHOLE_WORD_TITLE, false);
        this.wholeWord.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HTMLSearchPanel.this.doWholeWord = KTools.getCheckBoxState(e);
            }
        });
        this.inputPanel.add(this.ignoreCase, new GBC(0, 1, 1, 1, 0.0, 0.0, 0, 0, 12, 0, new Insets(0, 5, 2, 0)));
        this.inputPanel.add(this.wholeWord, new GBC(1, 1, 1, 1, 0.0, 1.0, 0, 0, 12, 0, new Insets(0, 0, 2, 5)));
        this.resultsArea.setSelectionColor(new Color(1.0f, 1.0f, 0.0f));
        this.caret.setBlinkRate(((DefaultCaret)this.resultsArea.getCaret()).getBlinkRate());
        this.resultsArea.setMargin(new Insets(2, 5, 2, 1));
        this.resultsArea.setCaret(this.caret);
        this.resultsArea.setEditable(false);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.resultsArea);
        this.doSearchButton.addActionListener(parent);
        this.doSearchButton.setMargin(new Insets(2, 3, 2, 3));
        this.setSearchButtonTitle();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.inputPanel, new GBC(0, 0, 4, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.add((Component)this.progressPanel, new GBC(0, 1, 4, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(2, 5, 3, 5)));
        this.add((Component)scroller, new GBC(0, 2, 4, 1, 1.0, 1.0, 0, 0, 12, 1, new Insets(5, 7, 5, 7)));
        this.add((Component)this.doSearchButton, new GBC(1, 3, 1, 1, 1.0, 0.0, 0, 0, 13, 0, new Insets(5, 2, 10, 7)));
        this.defaultFocusedField = this.findfield.textfield;
    }

    public void setSearchButtonTitle() {
        this.doSearchButton.setText("Search " + HTMLSearchTool.searchButtonTitle);
    }

    public void saveSelf() {
        Preferences.write(Preferences.TOOL_HTML_SEARCH_STRING, this.findfield.getText());
    }

    public class ProgressPanel
    extends KTitledPanel {
        public JProgressBar bar;

        public ProgressPanel() {
            super(" Progress ");
            this.bar = new JProgressBar();
            this.add(this.bar, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 2, new Insets(0, 5, 5, 5)));
        }
    }

    private class Karet
    extends DefaultCaret {
        private String urlStr = null;
        private boolean useCutterBrowser = true;

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            boolean bl = this.useCutterBrowser = !e.isShiftDown();
            if (e.getClickCount() == 2) {
                this.selectWord(this.getMark());
            }
        }

        private void selectWord(int offset) {
            try {
                int line = HTMLSearchPanel.this.resultsArea.getLineOfOffset(offset);
                int begin = HTMLSearchPanel.this.resultsArea.getLineStartOffset(line);
                int end = HTMLSearchPanel.this.resultsArea.getLineEndOffset(line);
                HTMLSearchPanel.this.resultsArea.setSelectionStart(begin);
                HTMLSearchPanel.this.resultsArea.setSelectionEnd(end - 1);
                this.openBrowserFor(HTMLSearchPanel.this.resultsArea.getSelectedText());
            }
            catch (BadLocationException e) {
                Cutter.setLog("HTMLSearchTool.Karet" + e.toString());
            }
        }

        private void openBrowserFor(String lineOfText) {
            if (lineOfText.endsWith("null")) {
                return;
            }
            if (lineOfText == null || lineOfText.length() == 0) {
                return;
            }
            String[] item = TextUtils.tokenize(lineOfText);
            for (int n = 0; n < item.length; ++n) {
                if (!TextUtils.contains(item[n], '.')) continue;
                this.urlStr = HtmlTokenizer.isHTTP(HTMLSearchTool.getSearchPath()) ? HTMLSearchTool.getSearchPath() + "/" + item[n] : "file:" + HTMLSearchTool.getSearchPath() + "/" + item[n];
            }
            if (this.urlStr == null) {
                return;
            }
            try {
                if (this.useCutterBrowser) {
                    Cutter.htmlWindow.setFindField(HTMLSearchPanel.this.findfield.textfield.getText());
                    Cutter.htmlWindow.setPage(this.urlStr, null);
                    Cutter.htmlWindow.setVisible(true);
                } else {
                    BrowserUtils.open(this.urlStr);
                }
            }
            catch (Exception ex) {
                String[] msg = new String[]{"Cutters browser cannot display text for", "this item. The server that provides this", "page is not responding"};
                DialogUtils.showWarningMessage("No Connection Error", msg);
                Cutter.setLog("HTMLSearchTool.Karet 1" + ex.toString());
            }
        }
    }
}

