/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.HTMLSearchTool.TargetPanel;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTitledPanel;
import UI_Components.PrefsReadWriters.PrefTextField;
import UI_Script.Help.Url;
import UI_Script.Rib.RibHelp;
import UI_Tools.HTMLSearchTool.HTMLSearchTool;
import Utilities.FileUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class HTMLTargetPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JRadioButton recurse = new JRadioButton("Search Sub-Directories");
    private KTitledPanel shaderDocsPanel = null;
    private JRadioButton pixar = new JRadioButton("Pixar");
    private JRadioButton delight = new JRadioButton("3Delight");
    private JRadioButton bmrt = new JRadioButton("BMRT");
    private JRadioButton air = new JRadioButton("Air");
    private KTitledPanel generalDocsPanel = null;
    private JRadioButton rispec = new JRadioButton("RiSpec");
    private JRadioButton rat = new JRadioButton("Rat");
    private JRadioButton mel = new JRadioButton("Mel");
    private JRadioButton vex = new JRadioButton("Vex");
    private JRadioButton tcl = new JRadioButton("Tcl");
    public JRadioButton custom = new JRadioButton("Custom...");
    CustomTargetPanel customPanel = new CustomTargetPanel();
    public ButtonGroup group = new ButtonGroup();
    private HTMLSearchTool parent;

    public HTMLTargetPanel(HTMLSearchTool parent) {
        this.parent = parent;
        this.setLayout(new GridBagLayout());
        this.shaderDocsPanel = new KTitledPanel(" Shader Docs ", "HTMLTargetPanel.ShaderDocsPanel.info");
        this.shaderDocsPanel.add(this.pixar, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        this.shaderDocsPanel.add(this.delight, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        this.shaderDocsPanel.add(this.bmrt, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        this.shaderDocsPanel.add(this.air, new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        this.generalDocsPanel = new KTitledPanel(" General Docs ", "HTMLTargetPanel.GeneralDocsPanel.info");
        this.generalDocsPanel.add(this.rispec, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        this.generalDocsPanel.add(this.rat, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        this.generalDocsPanel.add(this.mel, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        this.generalDocsPanel.add(this.vex, new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        this.generalDocsPanel.add(this.tcl, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        this.generalDocsPanel.add(this.custom, new GBC(1, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        this.add((Component)this.recurse, new GBC(0, 0, 1, 1, 1.0, 1.0, 1, 0, 18, 0, new Insets(0, 5, 0, 0)));
        this.add((Component)this.shaderDocsPanel, new GBC(0, 1, 1, 1, 1.0, 1.0, 1, 0, 18, 2, new Insets(5, 5, 5, 5)));
        this.add((Component)this.generalDocsPanel, new GBC(0, 2, 1, 1, 1.0, 1.0, 1, 0, 18, 2, new Insets(5, 5, 5, 5)));
        this.add((Component)this.customPanel, new GBC(0, 3, 1, 1, 1.0, 1.0, 1, 1, 17, 1, new Insets(0, 5, 5, 5)));
        String flag = Preferences.get(Preferences.TOOL_HTML_SEARCH_RECURSE);
        if (flag != null && flag.equals("true")) {
            this.recurse.setSelected(true);
        } else {
            this.recurse.setSelected(false);
        }
        this.group.add(this.pixar);
        this.pixar.addActionListener(this);
        this.group.add(this.delight);
        this.delight.addActionListener(this);
        this.group.add(this.bmrt);
        this.bmrt.addActionListener(this);
        this.group.add(this.air);
        this.air.addActionListener(this);
        this.group.add(this.rispec);
        this.rispec.addActionListener(this);
        this.group.add(this.rat);
        this.rat.addActionListener(this);
        this.group.add(this.mel);
        this.mel.addActionListener(this);
        this.group.add(this.vex);
        this.vex.addActionListener(this);
        this.group.add(this.tcl);
        this.tcl.addActionListener(this);
        this.group.add(this.custom);
        this.custom.addActionListener(this);
        HTMLSearchTool.searchPath = Preferences.get(Preferences.TOOL_HTML_SEARCH_PATH);
        this.initRadioButton();
    }

    public String getCustomFieldText() {
        return this.customPanel.getTextFromField();
    }

    public String getNameOfSelectedButton() {
        if (this.pixar.isSelected()) {
            return this.pixar.getText();
        }
        if (this.delight.isSelected()) {
            return this.delight.getText();
        }
        if (this.bmrt.isSelected()) {
            return this.bmrt.getText();
        }
        if (this.air.isSelected()) {
            return this.air.getText();
        }
        if (this.rispec.isSelected()) {
            return this.rispec.getText();
        }
        if (this.rat.isSelected()) {
            return this.rat.getText();
        }
        if (this.mel.isSelected()) {
            return this.mel.getText();
        }
        if (this.vex.isSelected()) {
            return this.vex.getText();
        }
        if (this.tcl.isSelected()) {
            return this.tcl.getText();
        }
        if (this.custom.isSelected()) {
            return this.custom.getText();
        }
        return null;
    }

    private void initRadioButton() {
        this.customPanel.setEnabled(false);
        String ratDocsRootPath = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        String pixarShadersDocsPath = Url.join(ratDocsRootPath, Url.ri.shaders_dir);
        String rispec_htmlPath = RibHelp.getRPSDocsIndex();
        if (pixarShadersDocsPath.equals(HTMLSearchTool.searchPath)) {
            this.pixar.doClick();
        } else if (Preferences.get(Preferences.PATH_3DELIGHT_DOCS_SHADERS).equals(HTMLSearchTool.searchPath)) {
            this.delight.doClick();
        } else if (Preferences.get(Preferences.PATH_BMRT_DOCS_SHADERS).equals(HTMLSearchTool.searchPath)) {
            this.bmrt.doClick();
        } else if (Preferences.get(Preferences.PATH_AIR_DOCS_SHADERS).equals(HTMLSearchTool.searchPath)) {
            this.air.doClick();
        } else if (rispec_htmlPath.equals(HTMLSearchTool.searchPath)) {
            this.rispec.doClick();
        } else if (ratDocsRootPath.equals(HTMLSearchTool.searchPath)) {
            this.rat.doClick();
        } else if (Preferences.get(Preferences.PATH_MEL_DOCS).equals(HTMLSearchTool.searchPath)) {
            this.mel.doClick();
        } else if (Preferences.get(Preferences.PATH_VEX_DOCS).equals(HTMLSearchTool.searchPath)) {
            this.vex.doClick();
        } else if (Preferences.get(Preferences.PATH_TCL_DOCS).equals(HTMLSearchTool.searchPath)) {
            this.tcl.doClick();
        } else {
            this.customPanel.setEnabled(true);
            this.custom.doClick();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String ratDocsRootPath = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        String pixarShadersDocsPath = Url.join(ratDocsRootPath, Url.ri.shaders_dir);
        String rispec_htmlPath = RibHelp.getRPSDocsIndex();
        if (e.getSource() == this.pixar) {
            HTMLSearchTool.searchPath = pixarShadersDocsPath;
        } else if (e.getSource() == this.delight) {
            HTMLSearchTool.searchPath = Preferences.get(Preferences.PATH_3DELIGHT_DOCS_SHADERS);
        } else if (e.getSource() == this.bmrt) {
            HTMLSearchTool.searchPath = Preferences.get(Preferences.PATH_BMRT_DOCS_SHADERS);
        } else if (e.getSource() == this.air) {
            HTMLSearchTool.searchPath = Preferences.get(Preferences.PATH_AIR_DOCS_SHADERS);
        } else if (e.getSource() == this.rispec) {
            HTMLSearchTool.searchPath = rispec_htmlPath;
        } else if (e.getSource() == this.rat) {
            HTMLSearchTool.searchPath = ratDocsRootPath;
        } else if (e.getSource() == this.mel) {
            HTMLSearchTool.searchPath = Preferences.get(Preferences.PATH_MEL_DOCS);
        } else if (e.getSource() == this.vex) {
            HTMLSearchTool.searchPath = Preferences.get(Preferences.PATH_VEX_DOCS);
        } else if (e.getSource() == this.tcl) {
            String str = Preferences.get(Preferences.PATH_TCL_DOCS);
            HTMLSearchTool.searchPath = str.equals("") ? new File(FileUtils.getPWD(), "Cutter_Help/tcl/ActiveTcl/tcl/TclCmd").getPath() : str;
        } else if (e.getSource() == this.custom) {
            this.customPanel.setEnabled(true);
            HTMLSearchTool.searchPath = Preferences.get(Preferences.TOOL_HTML_SEARCH_USER_DOCS);
        }
        if (e.getSource() != this.custom) {
            this.customPanel.setEnabled(false);
        }
        HTMLSearchTool.searchButtonTitle = HTMLSearchTool.searchPathToTargetName();
    }

    public void saveSelf() {
        if (this.recurse.isSelected()) {
            Preferences.write(Preferences.TOOL_HTML_SEARCH_RECURSE, "true");
        } else {
            Preferences.write(Preferences.TOOL_HTML_SEARCH_RECURSE, "false");
        }
    }

    public boolean doRecursiveSearch() {
        return this.recurse.isSelected();
    }

    private class CustomTargetPanel
    extends KTitledPanel {
        private static final long serialVersionUID = 1L;
        private int[] singleID;
        private String[] singleKey;
        public PrefTextField ptf;

        private CustomTargetPanel() {
            super(" Custom html Docs ", "HTMLTargetPanel.CustomTargetPanel.info");
            this.singleID = new int[]{Preferences.TOOL_HTML_SEARCH_USER_DOCS};
            this.singleKey = new String[]{"ignore"};
            this.ptf = new PrefTextField("\"html\"", this.singleKey, this.singleID, 12, 1, true);
            JPanel holder = new JPanel();
            this.ptf.addToParent(holder, 1, true);
            this.add(holder, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.ptf.setEnabled(flag);
        }

        private String getTextFromField() {
            return this.ptf.getTextFromField();
        }
    }
}

