/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Journal.JournalManager;

import UI_Tools.Journal.JournalManager.KJournalManager;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Vector;

public class Journal {
    DBItem journalDB = new DBItem("JournalDB", 0);

    public Journal(File journalDir) {
        String[] list = FileUtils.getListOfFileNames(journalDir, ".html", true);
        Vector<File> rawlist = null;
        if (list != null && list.length > 0) {
            rawlist = new Vector<File>();
            for (int i = 0; i < list.length; ++i) {
                if (list[i].endsWith("index.html")) continue;
                rawlist.addElement(new File(KJournalManager.getJournalDir(), list[i]));
            }
            File[] files = new File[rawlist.size()];
            for (int i = 0; i < rawlist.size(); ++i) {
                files[i] = (File)rawlist.elementAt(i);
            }
            String[] sorted = FileUtils.sortByModification(files);
            sorted = FileUtils.getPathRelativeTo(KJournalManager.getJournalDir().getPath(), sorted);
            Vector v = new Vector();
            for (int n = sorted.length - 1; n >= 0; --n) {
                String dirName = new File(sorted[n]).getParent();
                String entryName = new File(sorted[n]).getName();
                String[] ymd = TextUtils.tokenize(dirName, "_");
                if (ymd == null || ymd.length != 3) continue;
                int year = Integer.parseInt(ymd[2]);
                int month = Integer.parseInt(ymd[0]);
                int day = Integer.parseInt(ymd[1]);
                DBItem yearItem = this.journalDB.putItem("Year", year);
                DBItem monthItem = yearItem.putItem("Month", month);
                DBItem dayItem = monthItem.putItem("Day", day);
                String[] hms = TextUtils.tokenize(TextUtils.removeExtension(entryName), "_");
                if (hms == null || hms.length < 3) continue;
                int hour = Integer.parseInt(hms[hms.length - 3]);
                int min = Integer.parseInt(hms[hms.length - 2]);
                int sec = Integer.parseInt(hms[hms.length - 1]);
                DBItem entryItem = dayItem.putItem(dirName, entryName);
                String AmPm = "am";
                if (hour > 12) {
                    AmPm = "pm";
                    hour -= 12;
                }
                entryItem.hms = hour + ":" + min + AmPm + " " + sec + "sec";
                entryItem.path = sorted[n];
            }
        }
    }

    public DBItem getDB() {
        return this.journalDB;
    }

    public String toString() {
        return this.journalDB.toString();
    }

    public class DBItem {
        Vector<DBItem> listOfItems = new Vector();
        public String DESC = "unknown";
        public int ID = -1;
        public String STR = null;
        public String hms = "";
        public String path = "";

        public DBItem() {
        }

        public DBItem(String desc, int id) {
            this.DESC = desc;
            this.ID = id;
        }

        public DBItem(String desc, String str) {
            this.DESC = desc;
            this.STR = str;
        }

        public DBItem[] getAllItems() {
            DBItem[] out = new DBItem[this.listOfItems.size()];
            for (int n = 0; n < out.length; ++n) {
                out[n] = this.listOfItems.elementAt(n);
            }
            return out;
        }

        public DBItem getItem(int id) {
            for (int i = 0; i < this.listOfItems.size(); ++i) {
                DBItem item = this.listOfItems.elementAt(i);
                if (item.ID != id) continue;
                return item;
            }
            return null;
        }

        public DBItem getItem(String str) {
            for (int i = 0; i < this.listOfItems.size(); ++i) {
                DBItem item = this.listOfItems.elementAt(i);
                if (!item.STR.equals(str)) continue;
                return item;
            }
            return null;
        }

        public DBItem putItem(String desc, int id) {
            DBItem item = this.getItem(id);
            if (item == null) {
                item = new DBItem(desc, id);
                this.listOfItems.addElement(item);
            }
            return item;
        }

        public DBItem putItem(String desc, String str) {
            DBItem item = this.getItem(str);
            if (item == null) {
                item = new DBItem(desc, str);
                this.listOfItems.addElement(item);
            }
            return item;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < this.listOfItems.size(); ++i) {
                DBItem item = this.listOfItems.elementAt(i);
                if (item.ID != -1) {
                    b.append(item.DESC + " " + item.ID + "\n");
                }
                if (item.STR != null) {
                    b.append(item.DESC + " " + item.STR + "\n");
                }
                b.append(item.toString());
            }
            return b.toString();
        }
    }
}

