/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Journal.JournalManager;

import UI_Desktop.Cutter;
import UI_Tools.AssetManagement.HtmlWriter;
import UI_Tools.Journal.JournalManager.Journal;
import Utilities.DateTimeUtils;
import Utilities.TextUtils;
import java.io.File;
import java.io.IOException;

public class KJournalHtmlWriter
extends HtmlWriter {
    @Override
    public StringBuffer getOutputBuffer() {
        return this.buff;
    }

    public KJournalHtmlWriter(File file) throws IOException {
        super(file, (File)null);
        String name = file.getName();
        this.tightHostDirName = this.removeExtension(name);
    }

    @Override
    public void writeHeader() {
        this.writeHeader(null);
    }

    @Override
    public void writeHeader(String pagetitle) {
        this.buff.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\n");
        this.buff.append("\t\t\t\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n");
        this.buff.append("<!-- Auto page generation by Cutter. Software written by Malcolm Kesson -->\n");
        this.buff.append("<HTML>\n");
        this.buff.append("<HEAD>\n");
        if (pagetitle == null) {
            this.buff.append("<TITLE>Command Index</TITLE>\n");
        } else {
            this.buff.append("<TITLE>" + pagetitle + "</TITLE>\n");
        }
        this.buff.append("<STYLE type=\"text/css\"><!--\n");
        this.buff.append("A:link    { text-decoration: none;\n");
        this.buff.append("\t\t     color: #3D271A;\n");
        this.buff.append("\t\t   }\n");
        this.buff.append("A:visited { text-decoration: none;\n");
        this.buff.append("\t\t\t color: #3D271A;\n");
        this.buff.append("\t\t   }\n");
        this.buff.append("H3 {\tfont-family: Helvetica, sans-serif;\n");
        this.buff.append("\t\tfont-size: 12pt;\n");
        this.buff.append("\t\tline-height: 14pt;\n");
        this.buff.append("\t\tfont-weight: bold;\n");
        this.buff.append("\t\tmargin-left: 0pt;\n");
        this.buff.append("\t\tmargin-bottom: 0pt;\n");
        this.buff.append("\t}\n");
        this.buff.append("P {\tfont-family: Helvetica, sans-serif;\n");
        this.buff.append("\t\tfont-size: 11pt;\n");
        this.buff.append("   \tline-height: 15pt;\n");
        this.buff.append("   \tmargin-right: 0pt;\n");
        this.buff.append("\t\tmargin-left: 0pt;\n");
        this.buff.append("\t\tmargin-top: 0pt;\n");
        this.buff.append("\t\tmargin-bottom: 0pt;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".year {margin-left: 0pt;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".month {\n");
        this.buff.append("\t\tmargin-left: 20pt;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".day {\n");
        this.buff.append("\t\tmargin-left: 40pt;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".entry {\n");
        this.buff.append("\t\tfont-size: 10pt;\n");
        this.buff.append("   \tline-height: 13pt;\n");
        this.buff.append("\t\tmargin-left: 60pt;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".datestamp {\n");
        this.buff.append("\t\tfont-size: 10pt;\n");
        this.buff.append("   \tline-height: 13pt;\n");
        this.buff.append("\t\tcolor: #999999;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".notation {\n");
        this.buff.append("\t\tfont-size: 10pt;\n");
        this.buff.append("   \tline-height: 13pt;\n");
        this.buff.append("\t\tcolor: #555555;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".index {\n");
        this.buff.append("\t\tfont-size: 10pt;\n");
        this.buff.append("   \tline-height: 16pt;\n");
        this.buff.append("\t\tcolor: #000000;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".css { display: none }\n");
        this.buff.append("-->\n");
        this.buff.append("</STYLE>\n");
        this.buff.append("</HEAD>\n");
        this.buff.append("<BODY BGCOLOR=\"#ffffff\">\n");
    }

    public void writePageTitle(String title, String dateStamp, String path) {
        this.buff.append("<TABLE BORDER=\"0\" CELLSPACING=\"0\">\n");
        this.buff.append("\t<TR>\n");
        this.buff.append("\t\t<TD WIDTH=\"20\" NOWRAP><!-- left hand margin --></TD>\n");
        this.buff.append("\t\t<TD ALIGN=\"LEFT\" NOWRAP>\n");
        this.buff.append("\t\t\t<H3>" + title + "</H3>\n");
        if (dateStamp != null && dateStamp.trim().length() > 0) {
            this.buff.append("\t\t\t<P class=\"index\"><A HREF=\"../index.html\">[index]</A></P>\n");
            this.buff.append("\t\t\t<P class=\"datestamp\">" + dateStamp + "<BR>\n");
            if (path != null && path.trim().length() > 0) {
                this.buff.append("\t\t\t" + path + "</P>\n");
            }
        }
        this.buff.append("\t\t</TD>\n");
        this.buff.append("\t</TR>\n");
        this.buff.append("</TABLE>\n");
    }

    public void writeNotation(String text) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        String[] lines = TextUtils.tokenize(text, "\n");
        this.buff.append("<TABLE BORDER=\"0\" CELLSPACING=0 NOWRAP>\n");
        this.buff.append("\t<TR>\n");
        this.buff.append("\t\t<TD WIDTH=\"20\" NOWRAP><!-- left hand margin --></TD>\n");
        this.buff.append("\t\t<TD WIDTH=\"500\" VALIGN=\"TOP\" ALIGN=\"LEFT\" NOWRAP>\n");
        this.buff.append("\t\t    <HR SIZE=1 noshade width=500 ALIGN=\"LEFT\" NOWRAP>\n");
        this.buff.append("\t\t\t<P class=\"notation\">\n");
        if (lines != null) {
            for (int n = 0; n < lines.length; ++n) {
                if (n < lines.length - 1) {
                    this.buff.append(lines[n]).append("<BR>\n");
                    continue;
                }
                this.buff.append(lines[n]).append("\n");
            }
        }
        this.buff.append("\t\t    </P>\n");
        this.buff.append("\t\t    <HR SIZE=1 noshade width=500 ALIGN=\"LEFT\" NOWRAP>\n");
        this.buff.append("\t\t</TD\n");
        this.buff.append("\t</TR>\n");
        this.buff.append("</TABLE>\n");
    }

    public void writePreformattedTable(String text) {
        if (text == null) {
            return;
        }
        this.buff.append("<BR>\n");
        this.buff.append("<TABLE BORDER=\"0\" CELLSPACING=0 NOWRAP>\n");
        this.buff.append("\t<TR>\n");
        this.buff.append("\t\t<TD WIDTH=\"20\" NOWRAP><!-- left hand margin --></TD>\n");
        this.buff.append("\t\t<TD VALIGN=\"TOP\" ALIGN=\"LEFT\" NOWRAP>\n");
        this.buff.append(text);
        this.buff.append("\n");
        this.buff.append("\t\t</TD\n");
        this.buff.append("\t</TR>\n");
        this.buff.append("</TABLE>\n");
    }

    public void writeJournal(int width, Journal journal) throws IOException {
        if (journal == null) {
            return;
        }
        Journal.DBItem db = journal.getDB();
        Journal.DBItem[] years = db.getAllItems();
        if (years == null) {
            Cutter.setLog("    Error:KJournalHtmlWriter.writeJournal() - cannot obtain data from the journal!");
            return;
        }
        this.buff.append("<TABLE BORDER=\"0\" CELLSPACING=0>\n");
        this.buff.append("\t<TR>\n");
        this.buff.append("\t\t<TD WIDTH=\"20\" NOWRAP> </TD>\n");
        this.buff.append("\t\t<TD ALIGN=\"left\" VALIGN=\"top\" NOWRAP>\n");
        for (int y = 0; y < years.length; ++y) {
            Journal.DBItem year = years[y];
            this.buff.append("\t\t\t<P class=\"year\">" + year.ID + "</P>\n");
            Journal.DBItem[] months = year.getAllItems();
            for (int m = 0; m < months.length; ++m) {
                Journal.DBItem month = months[m];
                this.buff.append("\t\t\t<P class=\"month\">" + DateTimeUtils.getMonthOfYear(month.ID) + "</P>\n");
                Journal.DBItem[] days = month.getAllItems();
                for (int d = 0; d < days.length; ++d) {
                    Journal.DBItem day = days[d];
                    String str = DateTimeUtils.getDayOfWeek(year.ID, month.ID, day.ID);
                    this.buff.append("\t\t\t<P class=\"day\">" + str + " " + day.ID + DateTimeUtils.getThSt(day.ID) + "</P>\n");
                    Journal.DBItem[] entries = day.getAllItems();
                    for (int e = 0; e < entries.length; ++e) {
                        Journal.DBItem entry = entries[e];
                        String fullPath = entry.DESC + "/" + entry.STR;
                        StringBuffer shortName = new StringBuffer();
                        String[] t = TextUtils.tokenize(entry.STR, "_");
                        if (t == null || t.length <= 3) continue;
                        for (int n = 0; n < t.length - 3; ++n) {
                            shortName.append(t[n]).append(".");
                        }
                        String name = TextUtils.trimTrailingChar(shortName.toString(), '.');
                        this.buff.append("\t\t\t<P class=\"entry\"><A HREF=\"" + fullPath + "\">" + name + "</A> &nbsp; <Font color=#777777>" + entry.hms + "</Font></P>\n");
                    }
                }
            }
        }
        this.buff.append("\t\t</TD>\n");
        this.buff.append("\t</TR>\n");
        this.buff.append("</TABLE>\n");
        this.buff.append("<BR>\n");
    }
}

