/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Journal.JournalManager;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.Url;
import UI_Tools.Journal.JournalManager.Journal;
import UI_Tools.Journal.JournalManager.KJournalHtmlWriter;
import UI_Tools.Journal.JournalTool;
import Utilities.BrowserUtils;
import Utilities.DateTimeUtils;
import Utilities.FileUtils;
import Utilities.HTMLUtils;
import Utilities.TextUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class KJournalManager {
    private static String defaultJournalDirName = "Cutter_Journal";
    public static File defaultJournal;
    private static File journalDir;
    private static File journalIndex;

    public static File getJournalDir() {
        return journalDir;
    }

    public static File getJournalIndex() {
        return journalIndex;
    }

    public static void setJournalDir(File j) {
        journalDir = j == null ? defaultJournal : j;
        journalIndex = new File(journalDir, "index.html");
    }

    public static boolean dirExists() {
        return journalDir.exists();
    }

    public static boolean indexExists() {
        return journalIndex.exists();
    }

    public static boolean entriesExist() {
        if (!KJournalManager.dirExists()) {
            return false;
        }
        String[] list = FileUtils.getListOfFileNames(journalDir, ".html", true);
        return list != null && list.length != 0;
    }

    public static String addToJournal(String notes) {
        boolean success;
        String[] dt = DateTimeUtils.getDateTime();
        String dirname = dt[0].replace('.', '_');
        File dir = new File(journalDir, dirname);
        if (!journalDir.exists() && !(success = journalDir.mkdir())) {
            Cutter.setLog("    Warning:KJournalManager.addToJournal() - cannot make directory \"" + journalDir.getPath() + "\"");
        }
        if (!dir.exists() && !(success = dir.mkdir())) {
            Cutter.setLog("    Warning:KJournalManager.addToJournal() - cannot make directory \"" + dir.getPath() + "\"");
        }
        String winTitle = BBxt.getWindowTitle();
        String[] t = TextUtils.tokenize(dt[1], ":");
        String rawHour = t[0];
        if (dt[2].equals("PM")) {
            int hour = Integer.parseInt(t[0]) + 12;
            t[0] = "" + hour;
        }
        String htmlname = winTitle + "_" + t[0] + "_" + t[1] + "_" + t[2] + ".html";
        String timeStamp = DateTimeUtils.dateToText(dt[0]) + " &nbsp; " + rawHour + ":" + t[1] + dt[2].toLowerCase() + " " + t[2] + "sec";
        File journalledFile = new File(dir, htmlname);
        KJournalHtmlWriter.createHostDir(journalledFile);
        try {
            KJournalHtmlWriter htmlWriter = new KJournalHtmlWriter(journalledFile);
            htmlWriter.writeHeader(winTitle);
            htmlWriter.writePageTitle(winTitle, timeStamp, BBxt.getWindowFile().getPath());
            htmlWriter.writeNotation(notes);
            htmlWriter.writePreformattedTable(HTMLUtils.generateHTML(null, false));
            htmlWriter.writeTail();
            htmlWriter.writeSelf();
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:KJournalManager.addToJournal " + ex);
            return null;
        }
        KJournalManager.writeJournalIndex();
        return Url.join(KAbstractHelp.configurePath(dir.getPath()), htmlname);
    }

    private static void writeJournalIndex() {
        Journal journal = new Journal(journalDir);
        try {
            File index = new File(journalDir, "index.html");
            KJournalHtmlWriter.createHostDir(index);
            KJournalHtmlWriter htmlWriter = new KJournalHtmlWriter(index);
            htmlWriter.writeHeader("Journal Index");
            htmlWriter.writePageTitle("Journal Entries", null, null);
            htmlWriter.writeJournal(400, journal);
            htmlWriter.writeTail();
            htmlWriter.writeSelf();
        }
        catch (Exception ex) {
            Cutter.setLog("Exception:KJournalManager.writeJournalIndex " + ex);
            return;
        }
    }

    static {
        journalDir = defaultJournal = new File(FileUtils.getPWDFile(), defaultJournalDirName);
        journalIndex = new File(journalDir, "index.html");
    }

    public static class AddToJournalAction
    extends AbstractAction {
        private JMenuItem menuItem = null;

        public AddToJournalAction(JMenuItem menuItem) {
            this.menuItem = menuItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JournalTool.getInstance(this.menuItem).showSelf();
        }
    }

    public static class OpenJournalAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!KJournalManager.indexExists()) {
                KJournalManager.writeJournalIndex();
            }
            try {
                String index = Url.join(KAbstractHelp.configurePath(journalDir.getPath()), "index.html");
                BrowserUtils.open(index, true);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KJournalManager.OpenJournalAction " + ex.toString());
            }
        }
    }
}

