/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Journal;

import Preferences.Preferences;
import UI_Components.Dialog.OpenFileDialog;
import UI_Components.Dialog.SaveFileDialog;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KComboItem;
import UI_Components.KTextArea;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledKComboItemBox;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.Journal.JournalManager.KJournalManager;
import UI_Tools.KTools;
import Utilities.BrowserUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class JournalTool
extends KTools
implements ItemListener {
    static String pathAtStartup = "";
    private static KTextField pathField;
    private static KTextArea textarea;
    private static JournalTool tool;
    private static JPanel upperPanel;
    private static KTitledPanel centerPanel;
    private static JPanel lowerPanel;
    private static KTitledPanel journalPanel;
    private static KButton newJButton;
    private static KButton delJButton;
    private static KTitledKComboItemBox prevCB;
    private static KTitledPanel entryPanel;
    private static KButton addButton;

    public static JournalTool getInstance(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new JournalTool(menuItem);
        return tool;
    }

    private JournalTool(JMenuItem menuItem) {
        super("Journal", menuItem, Preferences.TOOL_JOURNAL, null, JLayeredPane.PALETTE_LAYER, true);
        pathField = new KTextField("temp");
        pathField.setGrayMetalBackground();
        pathField.setDarkControlForeground();
        pathField.setBorder(new EmptyBorder(0, 0, 0, 0));
        pathField.setEditable(false);
        newJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File prev = OpenFileDialog.prevFile;
                if (prev != null) {
                    prev = new File(prev.getPath());
                }
                OpenFileDialog.prevFile = KJournalManager.getJournalDir();
                OpenFileDialog dialog = OpenFileDialog.getInstance(Cutter.desktop);
                File[] files = dialog.showSelf(null, "Choose Journal Directory", 1);
                if (files == null || files.length == 0) {
                    return;
                }
                JournalTool.this.setPathField(files[0]);
                prevCB.combo.insertItemAt(new KComboItem(files[0].getName(), files[0].getPath()), 0);
                prevCB.combo.setSelectedIndex(0);
                OpenFileDialog.prevFile = prev;
            }
        });
        delJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (prevCB.combo.getItemCount() > 0) {
                    prevCB.combo.removeItemAt(0);
                    File f = KJournalManager.defaultJournal;
                    if (prevCB.combo.getItemCount() == 0) {
                        prevCB.combo.insertItemAt(new KComboItem(f.getName(), f.getPath()), 0);
                        prevCB.combo.setSelectedIndex(0);
                    } else {
                        KComboItem curr = (KComboItem)prevCB.combo.getSelectedItem();
                        f = new File(curr.tiptext);
                    }
                    JournalTool.this.setPathField(f);
                }
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = KJournalManager.addToJournal(textarea.getText());
                JournalTool.this.checkPathValidity();
                if (url != null) {
                    BrowserUtils.open(url, true);
                }
            }
        });
        prevCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                if (combo.getSelectedItem() instanceof KComboItem) {
                    KComboItem item = (KComboItem)combo.getSelectedItem();
                    if (item.action != null) {
                        item.action.actionPerformed(new ActionEvent(item, 0, null));
                    }
                }
            }
        });
        JournalTool.prevCB.combo.setPreferredSize(new Dimension(128, 25));
        String str = Preferences.get(Preferences.TOOL_JOURNAL_FAVORITES);
        if (str != null) {
            String[] items = TextUtils.tokenize(str, "'");
            if (items != null) {
                for (int n = 0; n < items.length; ++n) {
                    FileUtils.applyFileSeparator(items[n]);
                    File f = new File(items[n]);
                    if (!f.exists()) continue;
                    prevCB.addItem(new KComboItem(f.getName(), f.getPath()));
                }
            }
            if (JournalTool.prevCB.combo.getItemCount() == 0) {
                File f = KJournalManager.defaultJournal;
                prevCB.addItem(new KComboItem(f.getName(), f.getPath()));
            }
            KComboItem item = (KComboItem)JournalTool.prevCB.combo.getSelectedItem();
            pathAtStartup = item.tiptext;
        }
        prevCB.addItemListener(this);
        textarea.setBorder(BorderFactory.createEtchedBorder());
        textarea.setEditable(true);
        textarea.setLineWrap(true);
        textarea.setMargin(new Insets(5, 5, 5, 5));
        JScrollPane scroller = new JScrollPane();
        JViewport port = scroller.getViewport();
        scroller.getViewport().setPreferredSize(new Dimension(350, 100));
        scroller.getViewport().setMinimumSize(scroller.getViewport().getPreferredSize());
        port.add(textarea);
        upperPanel.setLayout(new GridBagLayout());
        centerPanel.setLayout(new BorderLayout());
        lowerPanel.setLayout(new GridBagLayout());
        lowerPanel.setOpaque(true);
        upperPanel.add((Component)pathField, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 2, new Insets(5, 10, 0, 10)));
        centerPanel.add("Center", scroller);
        lowerPanel.add((Component)journalPanel, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(0, 5, 5, 0)));
        journalPanel.add(prevCB, new GBC(0, 0, 2, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 10, 5, 25)));
        journalPanel.add(newJButton, new GBC(0, 1, 1, 1, 0.0, 1.0, 0, 0, 18, 0, new Insets(0, 35, 5, 5)));
        journalPanel.add(delJButton, new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 5, 25)));
        lowerPanel.add((Component)entryPanel, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 1, new Insets(0, 5, 5, 5)));
        entryPanel.add(addButton, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 14, 0, new Insets(0, 15, 5, 5)));
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add("North", upperPanel);
        this.contentPane.add("Center", centerPanel);
        this.contentPane.add("South", lowerPanel);
        this.setTitle(this.title);
        this.pack();
        this.setInitialPosition();
        Dimension d = upperPanel.getSize();
        this.setMinimumSize(this.getSize());
        this.setPathField(new File(pathAtStartup));
        this.setVisible(false);
        this.lastFocusedComponent = textarea;
    }

    private void setPathField(File f) {
        if (f == null) {
            return;
        }
        pathField.setText(f.getPath());
        this.checkPathValidity();
        KJournalManager.setJournalDir(f);
    }

    private void checkPathValidity() {
        File f = new File(pathField.getText());
        if (f.exists()) {
            pathField.setForeground(Color.black);
        } else {
            pathField.setForeground(Color.red);
        }
    }

    private File getUserFile() {
        SaveFileDialog saveFileDialog = SaveFileDialog.getInstance(Cutter.desktop, "ignore");
        int response = saveFileDialog.showSelf("Save Journal Directory As");
        if (response == -2) {
            return null;
        }
        if (response == 1) {
            return null;
        }
        if (response == 0) {
            return saveFileDialog.getSelectedFile();
        }
        return null;
    }

    @Override
    protected void toolSelectionHappened() {
        if (this.lastFocusedComponent != null) {
            this.lastFocusedComponent.requestFocus();
            this.lastFocusedComponent.selectAll();
        }
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    protected void toggleText(JMenuItem menuItem) {
    }

    @Override
    protected void saveSelf() {
        File f = KJournalManager.getJournalDir();
        if (f != null && f.exists()) {
            Preferences.write(Preferences.TOOL_JOURNAL_DIRECTORY, f.getPath());
        }
        StringBuffer buffer = new StringBuffer();
        Vector<KComboItem> list = new Vector<KComboItem>();
        for (int n = 0; n < JournalTool.prevCB.combo.getItemCount(); ++n) {
            KComboItem obj = JournalTool.prevCB.combo.getItemAt(n);
            if (!(obj instanceof KComboItem) || list.contains(obj)) continue;
            list.addElement(obj);
        }
        Object curr = JournalTool.prevCB.combo.getSelectedItem();
        list.remove(curr);
        list.insertElementAt((KComboItem)curr, 0);
        for (int n = 0; n < list.size(); ++n) {
            KComboItem item = (KComboItem)list.elementAt(n);
            buffer.append(item.tiptext);
            buffer.append("'");
        }
        Preferences.write(Preferences.TOOL_JOURNAL_FAVORITES, buffer.toString());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        Object obj = JournalTool.prevCB.combo.getSelectedItem();
        if (obj != null && obj instanceof KComboItem) {
            File f = new File(((KComboItem)obj).tiptext);
            this.setPathField(f);
        }
    }

    static {
        textarea = new KTextArea();
        tool = null;
        upperPanel = new JPanel();
        centerPanel = new KTitledPanel(" Notation ", "JournalTool.NotationPanel.info");
        lowerPanel = new JPanel();
        journalPanel = new KTitledPanel(" Journals ");
        newJButton = new KButton("New", new Insets(2, 5, 0, 5));
        delJButton = new KButton(" Remove ", new Insets(2, 5, 0, 5));
        prevCB = new KTitledKComboItemBox("Set  ", 2, 0, -2);
        entryPanel = new KTitledPanel(" Entries ");
        addButton = new KButton("  Add to Journal ", new Insets(2, 5, 0, 5));
    }
}

