/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Delegates.KToolsUI;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Script.Help.KAbstractHelp;
import Utilities.ComponentUtils;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DesktopManager;
import javax.swing.FocusManager;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class KTools
extends JInternalFrame
implements VetoableChangeListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    private static final double WITHIN_DESKTOP_BOUNDS_TOLERANCE = 1.0;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    public static final int CENTER = 4;
    public static final int LAZY = 5;
    static final String uiClassID = "KToolsUI";
    protected static int snapDistance = 15;
    private static Vector<KTools> listOfTools = new Vector();
    private boolean toolsDebug = false;
    protected int dynamicDesktopPosition = 5;
    protected JPanel contentPane = new JPanel();
    protected HelpMenu helpMenu = null;
    protected JTextComponent lastFocusedComponent = null;
    protected String TOOL_NAME = "";
    protected int prefItem = 0;
    public JMenuItem menuItem = null;
    public JMenuItem[] menuItems = null;
    private Action closeToolAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            KTools.this.showSelf();
        }
    };
    private Dimension preCallapse = null;

    private static void removeFromList(KTools t) {
        listOfTools.removeElement(t);
    }

    private static void addToList(KTools t) {
        listOfTools.addElement(t);
    }

    public static KTools getToolWithName(String name) {
        for (int n = 0; n < listOfTools.size(); ++n) {
            KTools tool = listOfTools.elementAt(n);
            if (!tool.TOOL_NAME.equalsIgnoreCase(name)) continue;
            return tool;
        }
        return null;
    }

    public static JEditorPane getFocusedEditorPane() {
        FocusManager fm = FocusManager.getCurrentManager();
        Component c = fm.getFocusOwner();
        if (c instanceof JEditorPane) {
            return (JEditorPane)c;
        }
        return null;
    }

    public static boolean getCheckBoxState(ItemEvent e) {
        return e.getStateChange() == 1;
    }

    public static void updateUI(String docExt) {
        for (int n = 0; n < listOfTools.size(); ++n) {
            KTools tool = listOfTools.elementAt(n);
            tool.adjustUI(docExt);
        }
    }

    public static void updateUI(File file) {
        for (int n = 0; n < listOfTools.size(); ++n) {
            KTools tool = listOfTools.elementAt(n);
            tool.adjustUI(file);
        }
    }

    public static void saveAll() {
        for (int n = 0; n < listOfTools.size(); ++n) {
            KTools tool = listOfTools.elementAt(n);
            tool.saveSelf();
        }
    }

    public static String getResourceString(ResourceBundle rb, String nm) {
        String str;
        try {
            str = rb.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public static void repositionAll() {
        if (listOfTools.size() == 0) {
            return;
        }
        for (int n = 0; n < listOfTools.size(); ++n) {
            KTools tool = listOfTools.elementAt(n);
            tool.setDynamicDesktopPosition(true);
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public JMenu getMenuWithName(String name) {
        return null;
    }

    protected abstract void adjustUI(String var1);

    protected abstract void adjustUI(int var1);

    protected void adjustUI(File file) {
    }

    protected abstract void toolSelectionHappened();

    protected abstract void toolDeSelectionHappened(JTextComponent var1);

    public void childHasLostFocus(final JTextComponent compLostFocus) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean toolHasFocus = false;
                    ComponentUtils util = new ComponentUtils(KTools.this, "");
                    Component[] comps = util.getAll();
                    for (int n = 0; n < comps.length; ++n) {
                        if (comps[n].isFocusOwner()) {
                            toolHasFocus = true;
                        }
                        if (!(comps[n] instanceof KTextField) || ((KTextField)comps[n]).popupLineEditor == null) continue;
                        toolHasFocus = true;
                    }
                    if (!toolHasFocus) {
                        KTools.this.toolDeSelectionHappened(compLostFocus);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showSelf() {
        this.setVisible(!this.isVisible());
        if (this.isVisible() && !this.isWithinDesktopBounds()) {
            this.setInitialPosition();
        }
        if (this.menuItem == null && this.menuItems == null) {
            return;
        }
        if (this.menuItem != null) {
            this.toggleText(this.menuItem);
        } else {
            this.toggleText(this.menuItems);
        }
    }

    protected void enable(Component comp, boolean flag) {
        if (comp == null) {
            return;
        }
        if (comp instanceof JTextField) {
            ((JTextField)comp).setEnabled(flag);
            return;
        }
        if (comp instanceof KTitledPanel || comp instanceof Container) {
            for (int n = 0; n < ((Container)comp).getComponentCount(); ++n) {
                this.enable(((Container)comp).getComponent(n), flag);
            }
        }
        if (comp instanceof Component) {
            comp.setEnabled(flag);
            return;
        }
    }

    public void activateSelf() {
        JMenuBar jmb;
        this.enable(this.getContentPane(), true);
        String title = this.getTitle();
        if (title == null) {
            title = "unknow tool";
        }
        if ((jmb = this.getJMenuBar()) == null) {
            if (this.toolsDebug) {
                Cutter.setLog("    Warning: \"" + title + "\" KTools.activateSelf() getJMenuBar() return null!");
            }
            return;
        }
        Component[] comps = this.getJMenuBar().getComponents();
        if (comps == null || comps.length == 0) {
            if (this.toolsDebug) {
                Cutter.setLog("    Warning: KTools.activateSelf() getComponents() return null!");
            }
            return;
        }
        for (int n = 0; n < comps.length; ++n) {
            if (!(comps[n] instanceof JMenu)) continue;
            comps[n].setEnabled(true);
        }
    }

    public void deactivateSelf() {
        this.enable(this.getContentPane(), false);
        JMenuBar jmb = this.getJMenuBar();
        String title = this.getTitle();
        if (title == null) {
            title = "unknow tool";
        }
        if (jmb == null) {
            if (this.toolsDebug) {
                Cutter.setLog("    Warning: \"" + title + "\" KTools.deactivateSelf() getJMenuBar() return null!");
            }
            return;
        }
        Component[] comps = jmb.getComponents();
        if (comps == null || comps.length == 0) {
            if (this.toolsDebug) {
                Cutter.setLog("    Warning: KTools.deactivateSelf() getComponents() return null!");
            }
            return;
        }
        for (int n = 0; n < comps.length; ++n) {
            if (comps[n] == null || !(comps[n] instanceof JMenu)) continue;
            comps[n].setEnabled(false);
        }
    }

    protected KTools() {
    }

    protected KTools(String title, Integer layer) {
        this(title, null, -1, null, layer, false);
    }

    protected KTools(String title, JMenuItem menuItem, int prefItem) {
        this(title, menuItem, prefItem, null, JLayeredPane.PALETTE_LAYER, false);
    }

    protected KTools(String title, JMenuItem menuItem1, JMenuItem menuItem2, int prefItem) {
        this(title, menuItem1, menuItem2, prefItem, null, JLayeredPane.PALETTE_LAYER, false);
    }

    protected KTools(String title, JMenuItem menuItem, int prefItem, String helpDocPath) {
        this(title, menuItem, prefItem, helpDocPath, JLayeredPane.PALETTE_LAYER, false);
    }

    protected KTools(String title, boolean resizable) {
        this(title, null, -1, null, JLayeredPane.PALETTE_LAYER, resizable);
    }

    protected KTools(String title, JMenuItem menuItem, int prefItem, String helpDocPath, Integer layer, boolean resizable) {
        super(title, resizable, true, false, false);
        this.TOOL_NAME = title;
        KAbstractDesktop.desktopPane.add((Component)this, layer);
        this.menuItem = menuItem;
        this.prefItem = prefItem;
        KTools.addToList(this);
        this.addVetoableChangeListener(this);
        this.addComponentListener(this);
        this.setDefaultCloseOperation(1);
        this.getRootPane().setOpaque(true);
        this.setOpaque(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.contentPane, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        this.contentPane.setLayout(new GridBagLayout());
        this.contentPane.setOpaque(true);
        this.setFrameIcon(null);
        this.initDynamicDesktopPosition();
        this.setEscKeyStroke();
    }

    protected KTools(String title, JMenuItem menuItem1, JMenuItem menuItem2, int prefItem, String helpDocPath, Integer layer, boolean resizable) {
        super(title, resizable, true, false, false);
        this.TOOL_NAME = title;
        KAbstractDesktop.desktopPane.add((Component)this, layer);
        this.menuItems = new JMenuItem[2];
        this.menuItems[0] = menuItem1;
        this.menuItems[1] = menuItem2;
        this.prefItem = prefItem;
        KTools.addToList(this);
        this.addVetoableChangeListener(this);
        this.addComponentListener(this);
        this.setDefaultCloseOperation(1);
        this.getRootPane().setOpaque(true);
        this.setOpaque(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.contentPane, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        this.contentPane.setLayout(new GridBagLayout());
        this.contentPane.setOpaque(true);
        this.setFrameIcon(null);
        this.initDynamicDesktopPosition();
        this.setEscKeyStroke();
    }

    private void setEscKeyStroke() {
        this.getRootPane().registerKeyboardAction(this.closeToolAction, "", KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void setMenuItem(JMenuItem menuItem) {
        this.menuItem = menuItem;
    }

    protected void toggleText(JMenuItem menuItem) {
        if (menuItem == null) {
            return;
        }
        String[] token = TextUtils.tokenize(menuItem.getText());
        if (token.length <= 0) {
            return;
        }
        String out = this.isVisible() ? "Hide" : "Show";
        for (int n = 1; n < token.length; ++n) {
            out = out + ' ' + token[n];
        }
        menuItem.setText(out);
    }

    protected void toggleText(JMenuItem[] items) {
        if (items == null) {
            return;
        }
        for (int n = 0; n < items.length; ++n) {
            this.toggleText(items[n]);
        }
    }

    protected String getMenuText() {
        return this.menuItem == null ? "" : this.menuItem.getText();
    }

    protected void removeSelfAsVetoableChangeListener() {
        super.removeVetoableChangeListener(this);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        if (name.equals("selected") && (Boolean)value == Boolean.FALSE) {
            return;
        }
        if (name.equals("selected") && (Boolean)value == Boolean.TRUE) {
            Component comp = ComponentUtils.getComponentWithFocus(this);
            if (comp == null) {
                this.toolSelectionHappened();
            }
            this.moveToFront();
            throw new PropertyVetoException("selected", e);
        }
        if (name.equals("closed")) {
            this.setVisible(false);
            if (this.menuItem != null) {
                this.toggleText(this.menuItem);
            }
            throw new PropertyVetoException("tool hidden", e);
        }
    }

    protected void initDynamicDesktopPosition() {
        this.dynamicDesktopPosition = 5;
    }

    public void setDynamicDesktopPosition(boolean onlyIfVisible) {
        if (onlyIfVisible && !this.isVisible()) {
            return;
        }
        int x = 0;
        int y = 0;
        DesktopManager manager = KAbstractDesktop.desktopPane.getDesktopManager();
        Dimension desk = KAbstractDesktop.desktopPane.getSize();
        Dimension tool = this.getSize();
        if (this.dynamicDesktopPosition == 5) {
            if (this.isWithinDesktopBounds()) {
                return;
            }
            Insets margin = this.getDesktopMargins();
            if (margin.left < 0 || margin.right < 0) {
                x = desk.width - tool.width;
                if (x < 0) {
                    x = 0;
                }
                manager.setBoundsForFrame(this, x, this.getBounds().y, tool.width, tool.height);
                if (this.isWithinDesktopBounds()) {
                    return;
                }
            }
            if (margin.top < 0 || margin.bottom < 0) {
                y = desk.height - tool.height;
                if (y < 0) {
                    y = 0;
                }
                manager.setBoundsForFrame(this, this.getBounds().x, y, tool.width, tool.height);
                if (this.isWithinDesktopBounds()) {
                    return;
                }
            }
        }
        switch (this.dynamicDesktopPosition) {
            case 0: {
                break;
            }
            case 1: {
                x = desk.width - tool.width;
                break;
            }
            case 2: {
                x = desk.width - tool.width;
                y = desk.height - tool.height;
                break;
            }
            case 3: {
                y = desk.height - tool.height;
                break;
            }
            case 4: {
                x = desk.width / 2 - tool.width / 2;
                y = desk.height / 2 - tool.height / 2;
                break;
            }
            default: {
                x = desk.width / 2 - tool.width / 2;
                y = desk.height / 2 - tool.height / 2;
            }
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        manager.setBoundsForFrame(this, x, y, tool.width, tool.height);
    }

    protected void setInitialPosition() {
        DesktopManager manager = KAbstractDesktop.desktopPane.getDesktopManager();
        Dimension tool = this.getSize();
        int[] pos = this.getPositionFromPrefs();
        boolean isValidPosition = false;
        if (pos != null) {
            manager.setBoundsForFrame(this, pos[0], pos[1], tool.width, tool.height);
            isValidPosition = this.isWithinDesktopBounds();
        }
        if (!isValidPosition) {
            this.setDynamicDesktopPosition(false);
        }
    }

    protected void setBounds(DesktopManager manager, Dimension desk, Dimension tool) {
        int[] pos = this.getPositionFromPrefs();
        if (pos == null) {
            return;
        }
        manager.setBoundsForFrame(this, pos[0], pos[1], tool.width, tool.height);
    }

    private void savePreCallapseSize() {
        Rectangle r = this.getBounds();
        this.preCallapse = new Dimension(r.width, r.height);
    }

    protected Dimension getPreCallapseSize() {
        return this.preCallapse;
    }

    public boolean isCallapsed() {
        return this.getBounds().height == KToolsUI.CALLAPSED_HEIGHT;
    }

    public void callapseWindow() {
        Rectangle r = this.getBounds();
        if (r.height > KToolsUI.CALLAPSED_HEIGHT) {
            this.callapseWindow(true);
        } else {
            this.callapseWindow(false);
        }
    }

    public void callapseWindow(boolean doCallapse) {
        Dimension dim;
        Rectangle r = this.getBounds();
        Dimension pc = this.getPreCallapseSize();
        Dimension ps = this.getPreferredSize();
        Dimension dimension = dim = pc == null ? ps : pc;
        if (doCallapse && r.height != KToolsUI.CALLAPSED_HEIGHT) {
            this.savePreCallapseSize();
            this.setBounds(r.x, r.y, dim.width, KToolsUI.CALLAPSED_HEIGHT);
        } else if (!doCallapse && r.height == KToolsUI.CALLAPSED_HEIGHT) {
            this.setBounds(r.x, r.y, dim.width, dim.height);
        }
    }

    public boolean isWithinDesktopBounds() {
        double pct = 1.0;
        Rectangle deskrect = KDesktop.getPreferredDesktopBounds();
        Rectangle toolrect = this.getBounds();
        return toolrect.x > 0 && (double)toolrect.x + (double)toolrect.width * pct <= (double)deskrect.width && toolrect.y > 0 && (double)toolrect.y + (double)toolrect.height * pct <= (double)deskrect.height;
    }

    protected Insets getDesktopMargins() {
        Rectangle deskrect = KDesktop.getPreferredDesktopBounds();
        Rectangle toolrect = this.getBounds();
        int top = toolrect.y;
        int left = toolrect.x;
        int right = deskrect.width - (toolrect.x + toolrect.width);
        int bottom = deskrect.height - (toolrect.y + toolrect.height);
        return new Insets(top, left, bottom, right);
    }

    protected void _repositionSelf(int position) {
        int y;
        int x;
        DesktopManager manager = KAbstractDesktop.desktopPane.getDesktopManager();
        Dimension desk = KAbstractDesktop.desktopPane.getSize();
        Dimension tool = this.getSize();
        switch (position) {
            case 0: {
                x = 0;
                y = 0;
                break;
            }
            case 1: {
                x = desk.width - tool.width;
                y = 0;
                break;
            }
            case 2: {
                x = desk.width - tool.width;
                y = desk.height - tool.height;
                break;
            }
            case 3: {
                x = 0;
                y = desk.height - tool.height;
                break;
            }
            case 4: {
                x = desk.width / 2 - tool.width / 2;
                y = desk.height / 2 - tool.height / 2;
                break;
            }
            default: {
                x = desk.width / 2 - tool.width / 2;
                y = desk.height / 2 - tool.height / 2;
            }
        }
        manager.setBoundsForFrame(this, x, y, tool.width, tool.height);
    }

    protected void saveSelf() {
        if (this.prefItem == -1) {
            return;
        }
        Rectangle rect = this.getBounds();
        Preferences.write(this.prefItem + 1, rect.x + " " + rect.y);
        String visible = this.isVisible() ? "open" : "closed";
        Preferences.write(this.prefItem, visible);
    }

    protected int[] getPositionFromPrefs() {
        int y;
        int x;
        if (this.prefItem == -1) {
            return null;
        }
        String[] pos = TextUtils.tokenize(Preferences.get(this.prefItem + 1));
        if (pos == null) {
            int[] out = new int[]{50, 50};
            return out;
        }
        if (pos.length < 2) {
            Cutter.setLog("    Error: KTools.getPreferredPosition() - tool position has less than 2 values");
        }
        Dimension desksize = KAbstractDesktop.desktopPane.getSize();
        Dimension toolsize = this.getSize();
        try {
            x = Integer.parseInt(pos[0]);
            y = Integer.parseInt(pos[1]);
        }
        catch (NumberFormatException e) {
            x = desksize.width / 2 - toolsize.width / 2;
            y = desksize.height / 2 - toolsize.height / 2;
        }
        if (x < 0 || y < 0) {
            x = desksize.width / 2 - toolsize.width / 2;
            y = desksize.height / 2 - toolsize.height / 2;
        }
        int[] out = new int[]{x, y};
        return out;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        if (this.menuItem != null) {
            this.toggleText(this.menuItem);
        }
        this.saveSelf();
    }

    protected class HelpMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;
        private JMenuItem helpItem;

        public HelpMenu(final String docPath) {
            super("Help");
            this.helpItem = null;
            this.helpItem = new JMenuItem("Index");
            ActionListener helpAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String url = KAbstractHelp.HELP_DOCS_BASE_URL + docPath;
                    try {
                        if (Cutter.htmlWindow.setPage(url, evt).equals("internal_browser")) {
                            Cutter.htmlWindow.setVisible(true);
                        }
                    }
                    catch (Exception e) {
                        Cutter.setLog("    Error: RmanMenus.Help cannot load url \"" + url + "\"");
                    }
                }
            };
            this.helpItem.addActionListener(helpAction);
            this.helpItem.setEnabled(true);
            this.add(this.helpItem);
        }
    }
}

