/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.LPE;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KTextArea;
import UI_Desktop.Cutter;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.KTools;
import UI_Tools.LPE.Reader.ExprReader;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DocumentUtils;
import Utilities.NumberUtils;
import Utilities.RegExpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;

public class ExprReaderTool
extends KTools
implements CaretListener {
    protected static ExprReaderTool tool = null;
    private static KTextArea resultsArea = new KTextArea(10, 20);
    private static Document document;
    private static ExprReader lpeReader;

    public static ExprReaderTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new ExprReaderTool(menuItem);
        return tool;
    }

    private ExprReaderTool(JMenuItem item) {
        super("LPE Reader", item, Preferences.TOOL_LPE, null, JLayeredPane.PALETTE_LAYER, true);
        lpeReader = new ExprReader();
        if (item != null) {
            this.menuItem = item;
        }
        resultsArea.setSelectionColor(new Color(1.0f, 1.0f, 0.0f));
        resultsArea.setMargin(new Insets(2, 5, 2, 1));
        resultsArea.setEditable(false);
        resultsArea.setTabSize(4);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(resultsArea);
        this.contentPane.add((Component)scroller, new GBC(0, 0, 4, 1, 1.0, 1.0, 0, 0, 12, 1, new Insets(5, 7, 5, 7)));
        this.setTitle(this.title);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setInitialPosition();
        int width = NumberUtils.strToInt(Preferences.get(Preferences.TOOL_LPE_WIDTH));
        int height = NumberUtils.strToInt(Preferences.get(Preferences.TOOL_LPE_HEIGHT));
        Dimension dim = new Dimension(width, height);
        this.setSize(dim);
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean f) {
        super.setVisible(f);
        if (!f) {
            document = null;
        } else {
            File file;
            KAbstractWindow win = BBxt.frontWindow();
            if (win != null && win instanceof KTextWindow && (file = win.getFile()) != null) {
                String name = file.getName();
                this.adjustUI(name);
            }
        }
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    protected void adjustUI(String docName) {
        if (!this.isVisible()) {
            return;
        }
        if (docName == null || docName.length() < 5) {
            return;
        }
        String ext = docName.substring(docName.length() - 4);
        if (!ext.startsWith(".")) {
            return;
        }
        if (ext.equalsIgnoreCase(".lpe") || ext.equalsIgnoreCase(".rib")) {
            JEditorPane jep = BBxt.getTextPane();
            if (jep == null) {
                return;
            }
            document = jep.getDocument();
            if (document == null) {
                return;
            }
            jep.removeCaretListener(this);
            jep.addCaretListener(this);
        }
    }

    @Override
    public void caretUpdate(CaretEvent evt) {
        Object obj = evt.getSource();
        if (!(obj instanceof KTextPane)) {
            Cutter.setLog("    Debug:ExprReader.caretUpdate() - source is not KTextPane");
            resultsArea.setText("");
            return;
        }
        Font font = ((KTextPane)obj).getFont();
        resultsArea.setFont(font);
        this.processLPE(evt.getMark(), evt.getDot(), document);
    }

    private void processLPE(int mark, int dot, Document doc) {
        boolean isSelection;
        RegExpUtils re;
        String regexp;
        String[] parts;
        boolean valid;
        int offsetMax;
        int offsetMin = dot < mark ? dot : mark;
        int n = offsetMax = dot > mark ? dot : mark;
        if (offsetMax == 0) {
            resultsArea.setText("");
            return;
        }
        int[] lineOffsets = DocumentUtils.getElementOffsets(doc, offsetMax);
        if (lineOffsets == null) {
            resultsArea.setText("");
            return;
        }
        int deltaOffset = offsetMax - lineOffsets[1];
        Element ele = DocumentUtils.getParagraphElement(document, offsetMax);
        Segment seg = DocumentUtils.getSegment(document, ele);
        if (seg == null) {
            resultsArea.setText("");
            return;
        }
        String fullline = seg.toString();
        String lpeLine = fullline.substring(0, deltaOffset);
        int colonIndex = lpeLine.lastIndexOf(":");
        if (colonIndex != -1) {
            lpeLine = "lpe" + lpeLine.substring(colonIndex);
        }
        boolean bl = valid = (parts = lpeLine.split(regexp = (re = new RegExpUtils()).encodeAsRE("lpe:", false, false), 2)) != null && parts.length > 1;
        if (!valid) {
            resultsArea.setText("");
            return;
        }
        boolean bl2 = isSelection = dot != mark;
        if (isSelection) {
            lpeLine = BBxt.getSelection().trim();
            int offsetOfColon = lpeLine.lastIndexOf(":");
            if (lpeLine.indexOf(10) != -1) {
                return;
            }
            StringBuffer resultsBuf = new StringBuffer();
            String english = lpeReader.read(lpeLine, lpeLine, offsetOfColon);
            resultsBuf.append(english);
            resultsArea.setText(resultsBuf.toString());
        } else {
            int offsetOfColon = lpeLine.lastIndexOf(":");
            if (offsetOfColon == -1) {
                resultsArea.setText("");
                return;
            }
            StringBuffer resultsBuf = new StringBuffer();
            resultsBuf.append(lpeLine).append("\n\n");
            String english = lpeReader.read(lpeLine, fullline, offsetOfColon);
            resultsBuf.append(english);
            resultsArea.setText(resultsBuf.toString());
        }
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
        Dimension d = this.getSize();
        Preferences.write(Preferences.TOOL_LPE_WIDTH, d.width);
        Preferences.write(Preferences.TOOL_LPE_HEIGHT, d.height);
    }

    @Override
    protected void toolSelectionHappened() {
        this.grabFocus();
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }
}

