/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.LPE.Reader;

import UI_Desktop.Cutter;
import Utilities.NumberUtils;

public class ExprPlainText {
    public static String convert(char c) {
        return ExprPlainText.convert("" + c);
    }

    public static String convert(String str) {
        String lobe;
        String name;
        if (str == null) {
            Cutter.setLog("Error in convert str is null");
            return "NULL";
        }
        if (str.startsWith("<L.") && (str.endsWith(">") || str.endsWith("'")) && str.indexOf(39) != -1 && (name = ExprPlainText.getLpeGroupIdentifier(str)) != null) {
            return str + "   Only evaluate lights that belong to the " + name + " light_group";
        }
        int num = ExprPlainText.strContainsDigit(str);
        String string = lobe = num >= 0 ? " (lobe " + num + ") " : " ";
        if (str.equals("C")) {
            return "C     Camera";
        }
        if (str.equals("<T")) {
            return str + "     Begin evaluation of transmission and refraction";
        }
        if (str.matches("<TS[\\d]*")) {
            return str + "    From transmission and refraction evaluate specular" + lobe + "scattering";
        }
        if (str.matches("<TS[\\d]*>")) {
            return str + "    Conclude evaluation of specular" + lobe + "scattering from transmission and refraction";
        }
        if (str.equals("<TS")) {
            return str + "    From transmission/refraction evaluate specular" + lobe + "scattering";
        }
        if (str.equals("<TS>")) {
            return str + "   Conclude evaluation of specular" + lobe + "scattering from transmission and refraction";
        }
        if (str.equals("<TD")) {
            return str + "    From transmission/refraction evaluate diffuse" + lobe + "scattering";
        }
        if (str.equals("<TD>")) {
            return str + "   Conclude evaluation of diffuse" + lobe + "scattering from transmission and refraction";
        }
        if (str.equals("<R")) {
            return str + "     Begin evaluation of reflecton event";
        }
        if (str.equals("<RS")) {
            return str + "    From reflecton evaluate specular" + lobe + "scattering";
        }
        if (str.equals("<RS>")) {
            return str + "   Conclude evaluation of specular" + lobe + "scattering from reflecton";
        }
        if (str.equals("<RD")) {
            return str + "    From reflecton evaluate diffuse scattering";
        }
        if (str.equals("<RD>")) {
            return str + "   Conclude evaluation of diffuse scattering from reflecton ";
        }
        if (str.equals("<.")) {
            return str + "     Begin evaluation of light path events arising from transmissions,     refractions or reflectons";
        }
        if (str.equals("<.D")) {
            return str + "    Evaluate ALL diffuse scattering paths";
        }
        if (str.equals("<.D>")) {
            return str + "   Evaluate ALL diffuse scattering paths";
        }
        if (str.equals("<.S")) {
            return str + "    Evaluate ALL specular scattering paths";
        }
        if (str.equals("<.S>")) {
            return str + "   Evaluate ALL specular scattering paths";
        }
        if (str.equals("D")) {
            return str + "     Evaluate ALL diffuse scattering paths";
        }
        if (str.equals("D'")) {
            return str + "    Evaluate diffuse scattering specific to a lpe_group";
        }
        if (str.equals("S")) {
            return str + "     Evaluate All specular and glossy scattering";
        }
        if (str.equals("S'")) {
            return str + "    Evaluate specular and glossy scattering specific to a lpe_group";
        }
        if (str.equals("L")) {
            return str + "     Evaluate a geometric light path";
        }
        if (str.equals("L.")) {
            return str + "    Evaluate all geometric light paths";
        }
        if (str.equals("<L")) {
            return str + "    Evaluate a geometric light path";
        }
        if (str.equals("<L.")) {
            return str + "   Evaluate all geometric light paths";
        }
        if (str.equals("<L.>")) {
            return str + "  Evaluate all geometric light paths";
        }
        if (str.equals("<L.'")) {
            return str + "  Evaluate lights that are members of a named light_group";
        }
        if (str.equals("O")) {
            return str + "      All emissive light paths";
        }
        if (str.equals("[")) {
            return str + "      Regular expression matching begin";
        }
        if (str.equals("]")) {
            return str + "      Regular expression matching end";
        }
        if (str.equals("(")) {
            return str + "      Regular expression group begin";
        }
        if (str.equals(")")) {
            return str + "      Regular expression group end";
        }
        if (str.equals("|")) {
            return str + "      Regular expression OR";
        }
        if (str.equals("<")) {
            return str + "     Begin LPE event evaluation";
        }
        if (str.equals(">")) {
            return str + "     Conclude LPE event evaluation";
        }
        if (str.startsWith("unoccluded")) {
            return "unoccluded   Returns unoccluded or unshadowed result";
        }
        if (str.startsWith("noclamp")) {
            return "noclamp      Returns unclamped result";
        }
        if (str.startsWith("nothruput")) {
            return "nothruput    Does not apply thruput (thruput is the accumulative albedo of the objects hit by rays)";
        }
        if (str.startsWith("shadows")) {
            return "shadows      Returns collected shadows";
        }
        if (str.startsWith("holdouts")) {
            return "holdouts     Returns only holdout light paths (light paths with one or more holdout events)";
        }
        if (str.startsWith("overwrite")) {
            return "overwrite    Instead of outputting the accumulated result, overwrite it.\n             One example of using this is for the albedo output where we\n             do not want an accumulated result";
        }
        if (str.startsWith("noinfinitecheck")) {
            return "noinfinitecheck   Do not do any infinite check";
        }
        return "    Unknown str --" + str + "--";
    }

    private static String getLpeGroupIdentifier(String lpeEventStr) {
        int closeOffset;
        int openOffset = lpeEventStr.indexOf(39);
        if (openOffset != -1 && lpeEventStr.length() > openOffset + 1 && (closeOffset = lpeEventStr.indexOf(39, openOffset + 1)) != -1) {
            return lpeEventStr.substring(openOffset, closeOffset + 1);
        }
        return null;
    }

    private static int strContainsDigit(String s) {
        StringBuffer digitBuf = new StringBuffer();
        for (int n = 0; n < s.length(); ++n) {
            if (!Character.isDigit(s.charAt(n))) continue;
            digitBuf.append(s.charAt(n));
        }
        String digitStr = digitBuf.toString();
        if (digitStr.length() > 0) {
            return NumberUtils.strToInt(digitStr);
        }
        return -1;
    }
}

