/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.LPE.Reader;

import UI_Tools.LPE.Reader.LPE_EventSpec;
import UI_Tools.LPE.Reader.LPE_Prefix;
import UI_Tools.LPE.Reader.LPE_Token;
import Utilities.TextUtils;
import java.util.Vector;

public class ExprReader {
    static final int formatDefaultWidth = 65;
    static final String ERR_MSG = "Error. ";

    public static String format(String s1, String s2) {
        s2 = s2.length() > 65 ? TextUtils.format(s2, 65) : s2 + "\n";
        StringBuffer buf = new StringBuffer();
        buf.append(s1).append("\n");
        String[] lines = TextUtils.tokenize(s2, '\n');
        if (lines != null) {
            for (int n = 0; n < lines.length; ++n) {
                buf.append("\t").append(lines[n]).append("\n");
            }
        } else {
            buf.append("\t").append(s2).append("\n");
        }
        return buf.toString();
    }

    public String read(String lpeLine, String fullLine, int beginOffset) {
        Vector<String> linesOut = new Vector<String>();
        for (int n = beginOffset + 1; n < lpeLine.length(); ++n) {
            char lpeToken = lpeLine.charAt(n);
            if (lpeToken == ' ') continue;
            String compositeToken = null;
            char ahead1 = n < lpeLine.length() - 1 ? lpeLine.charAt(n + 1) : (char)'\u0000';
            boolean lpeTokenIsLower = Character.isLowerCase(lpeToken);
            if (lpeTokenIsLower) {
                LPE_Prefix prefix = new LPE_Prefix(lpeLine, lpeToken, n);
                n = prefix.nextIndex;
                compositeToken = prefix.toString();
            } else if (lpeToken == '<') {
                LPE_EventSpec spec = new LPE_EventSpec(lpeLine, lpeToken, n);
                n = spec.nextIndex;
                compositeToken = spec.toString();
            } else {
                LPE_Token token = new LPE_Token(lpeLine, n, LPE_Token.SOLO);
                if (token.nextIndex != -1) {
                    if (token.tokenCode == 4) {
                        n += token.tokens.length() - 1;
                    } else if (token.tokenCode == 1 || token.tokenCode == 2) {
                        n = token.nextIndex - 1;
                    } else if (token.tokenCode == 5 || token.tokenCode == 6) {
                        n = token.nextIndex - 1;
                    } else if (token.tokenCode == 9 || token.tokenCode == 10) {
                        n = token.nextIndex - 1;
                    } else if (token.tokenCode == 7 || token.tokenCode == 8) {
                        n = token.nextIndex - 1;
                    }
                }
                compositeToken = token.toString();
            }
            if (compositeToken.equals("TOKEN_NOT_HANDLED")) continue;
            linesOut.add(compositeToken + "\n");
        }
        if (linesOut == null) {
            return "ERROR";
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < linesOut.size(); ++n) {
            buf.append((String)linesOut.elementAt(n));
        }
        return buf.toString();
    }
}

