/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.LPE.Reader;

import UI_Tools.LPE.Reader.ExprReader;
import Utilities.TextUtils;

public class LPE_Prefix {
    private static final String[] PREFIX_STRS = new String[]{"unoccluded", "noclamp", "nothruput", "shadows", "holdouts", "overwrite", "noinfinitecheck"};
    public String outStr;
    public int nextIndex;
    public boolean isValidPrefix = true;

    public LPE_Prefix(String lpeLine, char lpeToken, int n) {
        int nextSemiColon = lpeLine.indexOf(59, n);
        if (nextSemiColon != -1) {
            String str = lpeLine.substring(n, nextSemiColon);
            if (this.isPrefix(str)) {
                this.outStr = str + ";";
                this.nextIndex = nextSemiColon;
            } else {
                this.outStr = str + ";";
                this.isValidPrefix = false;
                this.nextIndex = nextSemiColon;
            }
        } else {
            this.outStr = lpeLine.substring(n);
            this.nextIndex = lpeLine.length();
        }
    }

    private boolean isPrefix(String str) {
        for (int n = 0; n < PREFIX_STRS.length; ++n) {
            if (!str.equals(PREFIX_STRS[n])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.outStr.startsWith("unoccluded")) {
            return this.format(this.outStr, "Returns unoccluded or unshadowed result.");
        }
        if (this.outStr.startsWith("noclamp")) {
            return this.format(this.outStr, "Returns unclamped result.");
        }
        if (this.outStr.startsWith("nothruput")) {
            return this.format(this.outStr, "Does not apply thruput (thruput is the accumulative albedo of the objects hit by rays).");
        }
        if (this.outStr.startsWith("shadows")) {
            return this.format(this.outStr, "Returns collected shadows.");
        }
        if (this.outStr.startsWith("holdouts")) {
            return this.format(this.outStr, "Returns only holdout light paths (light paths with one or more holdout events).");
        }
        if (this.outStr.startsWith("overwrite")) {
            return this.format(this.outStr, "Instead of outputting the accumulated result, overwrite it. One example of using this is for the albedo output where we do not want an accumulated result.");
        }
        if (this.outStr.startsWith("noinfinitecheck")) {
            return this.format(this.outStr, "Do not do any infinite check.");
        }
        return "";
    }

    public String format(String s1, String s2) {
        return ExprReader.format(s1, s2);
    }

    public String _format(String s1, String s2) {
        boolean addNewline = false;
        if (s2.length() > 75) {
            s2 = TextUtils.format(s2, 75);
            addNewline = true;
        }
        if (s1.length() >= 15 || addNewline) {
            return s1 + "\n" + s2;
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < 15 - s1.length(); ++n) {
            buf.append(" ");
        }
        return s1 + buf.toString() + s2;
    }
}

