/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.LPE.Reader;

import UI_Tools.LPE.Reader.ExprReader;
import UI_Tools.LPE.Reader.LPE_EventSpec;
import UI_Tools.LPE.Reader.LPE_Token;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.util.Vector;

public class LPE_Regex {
    public static final int UNKNOWN = 0;
    public static final int GROUPNAMES = 1;
    public static final int NOT_GROUPNAMES = 2;
    public static final int INNER_EVENTSPEC = 4;
    public static final int BROKEN_INNER_EVENTSPEC = 4;
    public static final int CURLY_BRACKETS = 5;
    public static final int SQUARE_BRACKETS = 6;
    public String expr = "";
    private String body = "";
    public boolean valid = false;
    public int bodyType = 0;
    public int regexType = 0;
    private String counting_qualifier = "";
    private String lpe_groupNames = "";
    private boolean exludeIsActive = false;
    public char openChar = '\u0000';
    public char closeChar = '\u0000';
    public boolean isSolo = false;
    public int nextIndex = -1;
    Vector<LPE_EventSpec> listOfSpecs = new Vector();

    public LPE_Regex(String lpeLine, int from) {
        this.openChar = lpeLine.charAt(from);
        this.regexType = this.openChar == '[' ? 6 : 5;
        this.closeChar = (char)(this.openChar == '[' ? 93 : 125);
        int close = lpeLine.indexOf(this.closeChar, from);
        if (close == -1) {
            return;
        }
        this.valid = true;
        this.nextIndex = close + 1;
        this.expr = lpeLine.substring(from, this.nextIndex);
        this.body = this.expr.substring(1, this.expr.length() - 1);
        if (this.body.startsWith("^")) {
            this.body = this.body.substring(1);
            this.exludeIsActive = true;
        }
        this.valid = true;
        if (this.valid) {
            LPE_EventSpec spec = this.grabEventSpec();
            while (spec != null) {
                this.listOfSpecs.add(spec);
                spec = this.grabEventSpec();
            }
        }
        this.bodyType = this.valid && this.body.indexOf(39) != -1 ? 1 : 2;
        char peek = LPE_Token.peekNextChar(lpeLine, this.nextIndex);
        if (peek == '+' || peek == '*') {
            this.counting_qualifier = peek + "";
            this.expr = this.expr + peek;
            ++this.nextIndex;
        }
        if ((peek = LPE_Token.peekNextChar(lpeLine, this.nextIndex)) == '\'') {
            close = lpeLine.indexOf(39, this.nextIndex + 1);
            if (close == -1) {
                this.nextIndex = -1;
                this.valid = false;
                return;
            }
            this.lpe_groupNames = lpeLine.substring(this.nextIndex, close + 1);
            this.expr = this.expr + this.lpe_groupNames;
            this.nextIndex = close + 1;
        }
    }

    public String format(String s1, String s2) {
        return ExprReader.format(s1, s2);
    }

    public String toString() {
        String out = "";
        if (this.regexType == 5) {
            int num;
            String[] t = TextUtils.tokenize(this.body, ",");
            int n = num = t == null ? 0 : t.length;
            if (num == 1) {
                out = this.body.equals("1") ? "Evaluate the previous lpe event once only" : "Repeat the evaluation the previous lpe event " + this.body + " times";
            } else if (num == 2) {
                String min = t[0];
                String max = t[1];
                out = "Evaluate the previous lpe event between " + min + " and " + max + " times";
            } else {
                out = "ERROR: curly bracket qualifier must be of the form {n} or {min,max}";
            }
        }
        if (this.regexType == 6) {
            String[] tokens;
            String alternatives = "";
            String andOrStr = this.exludeIsActive ? " and " : " or ";
            String countStr = this.counting_qualifier.equals("+") ? " at least once" : "";
            String string = countStr = this.counting_qualifier.equals("*") ? " zero or more times" : countStr;
            if (this.listOfSpecs.size() > 0) {
                if (this.expr.equals("[<L.>O]") || this.expr.equals("[O<L.>]")) {
                    out = "Evaluate all geometric Light paths or all emissive (glowing) Object light paths";
                } else {
                    int n;
                    tokens = this.getListOfTokens(this.body);
                    int numTokens = tokens == null ? 0 : tokens.length;
                    String[] all = new String[numTokens + this.listOfSpecs.size()];
                    int count = 0;
                    for (n = 0; n < numTokens; ++n) {
                        all[count++] = tokens[n];
                    }
                    for (n = 0; n < this.listOfSpecs.size(); ++n) {
                        all[count++] = "<" + this.listOfSpecs.elementAt((int)n).typeStr + this.listOfSpecs.elementAt((int)n).eventStr + ">";
                    }
                    for (n = 0; n < all.length; ++n) {
                        alternatives = alternatives + all[n];
                        alternatives = alternatives + (n < all.length - 1 ? andOrStr : "");
                    }
                    String plural = all.length > 1 ? "events" : "event";
                    out = this.exludeIsActive ? "Evaluate but ignore the " + plural + " specified by " : "Evaluate an event specified by ";
                    out = out + alternatives + countStr;
                }
            } else if (this.body.length() == 1) {
                String bodyExpanded = this.expand(this.body);
                out = "Evaluate " + bodyExpanded + countStr;
            } else if (this.body.length() == 2) {
                tokens = this.getListOfTokens(this.body);
                String and_or = this.exludeIsActive ? " and " : " or ";
                for (int n = 0; n < tokens.length; ++n) {
                    alternatives = alternatives + this.expand(tokens[n]);
                    alternatives = alternatives + (n < tokens.length - 1 ? and_or : "");
                }
                out = "Evaluate " + alternatives + countStr;
            } else if (out.length() == 0) {
                if (this.body.indexOf(39) != -1) {
                    String prefix;
                    tokens = this.getListOfTokens(this.body);
                    int num = tokens == null ? 0 : tokens.length;
                    String string2 = prefix = num > 1 ? " specific to the lpe groups named " : " specific to the lpe group named ";
                    if (this.exludeIsActive) {
                        prefix = " except those for the" + prefix.substring(16);
                    }
                    for (int n = 0; n < tokens.length; ++n) {
                        alternatives = alternatives + "'" + tokens[n] + "'";
                        alternatives = alternatives + (n < tokens.length - 1 ? andOrStr : "");
                    }
                    out = prefix + alternatives + countStr;
                } else {
                    tokens = this.getListOfTokens(this.body);
                    for (int n = 0; n < tokens.length; ++n) {
                        alternatives = alternatives + this.expand(tokens[n]);
                        alternatives = alternatives + (n < tokens.length - 1 ? andOrStr : "");
                    }
                    out = "Evaluate " + alternatives + countStr;
                }
            }
        }
        return out + (this.isSolo ? "." : "");
    }

    private String expand(char c) {
        return this.expand("" + c);
    }

    private String expand(String exp) {
        String digits;
        if (exp.equals("")) {
            return "";
        }
        String out = exp;
        String lobeStr = "";
        char c = '\u0000';
        String string = digits = exp.length() > 1 ? exp.substring(1) : "";
        if (digits.length() > 0 && Character.isDigit(digits.charAt(0))) {
            lobeStr = " lobe" + digits + "";
            c = exp.charAt(0);
        }
        if (exp.startsWith("D")) {
            out = this.exludeIsActive ? "ignoring Diffuse" + lobeStr + " scattering" : "Diffuse" + lobeStr + " scattering";
        } else if (exp.startsWith("S")) {
            out = this.exludeIsActive ? "ignoring Specular" + lobeStr + " scattering" : "Specular" + lobeStr + " scattering";
        } else if (exp.equals("L")) {
            out = "geometric Light paths";
        } else if (exp.equals("L.")) {
            out = "all geometric Light paths";
        } else if (exp.equals("<L.>")) {
            out = "all geometric Light paths";
        } else if (exp.equals("O")) {
            out = "emissive (glowing) Object light paths";
        } else if (exp.equals("T")) {
            out = "Transmission and Refraction paths";
        } else if (exp.equals("R")) {
            out = "Reflection paths";
        } else if (exp.startsWith("'") && exp.endsWith("'")) {
            out = "found lpe group name";
        }
        return out;
    }

    private String[] getListOfGroups(String str) {
        return TextUtils.tokenize(str, '\'');
    }

    private String[] getListOfTokens(String str) {
        if (str.indexOf(39) != -1) {
            return TextUtils.tokenize(str, "'");
        }
        Vector<String> v = new Vector<String>();
        int n = 0;
        while (n < this.body.length()) {
            String s = this.body.charAt(n) + "";
            if (n < this.body.length() - 1 && Character.isDigit(this.body.charAt(n + 1))) {
                s = s + this.body.charAt(n + 1);
                if ((n += 2) < this.body.length() && Character.isDigit(this.body.charAt(n))) {
                    s = s + this.body.charAt(n);
                    ++n;
                }
            } else {
                ++n;
            }
            v.add(s);
        }
        return VectorUtils.toStringArray(v);
    }

    private LPE_EventSpec grabEventSpec() {
        int j = this.body.indexOf(60);
        int k = this.body.indexOf(62);
        if (j != -1 && k == -1 || j == -1 && k != -1 || j != -1 && k != -1 && j > k) {
            this.valid = false;
            this.bodyType = 4;
            this.nextIndex = -1;
            return null;
        }
        if (j != -1 && k != -1) {
            LPE_EventSpec eventSpec = new LPE_EventSpec(this.body, '<', j);
            if (eventSpec.nextIndex == -1) {
                this.valid = false;
                this.bodyType = 4;
                this.nextIndex = -1;
                return null;
            }
            this.body = this.body.replaceFirst("(\\<[^>]+\\>)", "");
            return eventSpec;
        }
        return null;
    }
}

