/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.LPE.Reader;

import UI_Desktop.Cutter;
import UI_Tools.LPE.Reader.ExprReader;
import UI_Tools.LPE.Reader.LPE_Regex;

public class LPE_Token {
    static final String NOT_HANDLED_STR = "TOKEN_NOT_HANDLED";
    public static final int UNKNOWN = 0;
    public static final int FULL_REGEX = 1;
    public static final int PARTIAL_REGEX = 2;
    public static final int SINGLE_CHAR = 3;
    public static final int CHAR_DIGITS = 4;
    public static final int SINGLE_CHAR_FULL_REGEX = 5;
    public static final int SINGLE_CHAR_PARTIAL_REGEX = 6;
    public static final int SINGLE_CHAR_GROUPNAME = 7;
    public static final int CHAR_DIGITS_GROUPNAME = 8;
    public static final int CHAR_DIGITS_FULL_REGEX = 9;
    public static final int CHAR_DIGITS_PARTIAL_REGEX = 10;
    public static final int SINGLE_CHAR_QUALIFIER_COUNTER = 11;
    public static final int CHAR_DIGITS_QUALIFIER_COUNTER = 4;
    public int tokenCode = 3;
    public static int SPEC_EVENT = 1;
    public static int SPEC_TYPE = 2;
    public static int SOLO = 3;
    private int tokenContext = SOLO;
    public LPE_Regex regex;
    public LPE_Group lpeGroup;
    public String tokens = "";
    private char token;
    public int nextIndex = -1;
    private String lobeDigitStr = "";
    private char qualifierCounter = '\u0000';

    public static char peekNextChar(String str, int at) {
        return at != -1 && at < str.length() ? str.charAt(at) : (char)'\u0000';
    }

    public LPE_Token(String lpeLine, int n, int context) {
        this.tokenContext = context;
        char lpeToken = lpeLine.charAt(n);
        boolean result = false;
        if (lpeToken == 'C') {
            this.tokenCode = 3;
            this.token = lpeToken;
            this.tokens = "" + lpeToken;
            this.nextIndex = -1;
            return;
        }
        if (this.isRegexOpenChar(lpeToken)) {
            this.regex = new LPE_Regex(lpeLine, n);
            this.token = lpeToken;
            if (!this.regex.valid) {
                this.nextIndex = -1;
                this.tokenCode = 2;
                this.regex = null;
                return;
            }
            this.regex.isSolo = true;
            this.tokenCode = 1;
            this.tokens = this.regex.expr;
            this.nextIndex = this.regex.nextIndex;
            return;
        }
        this.tokenCode = 3;
        this.token = lpeToken;
        this.tokens = "" + lpeToken;
        this.nextIndex = n + 1;
        char nextChar = LPE_Token.peekNextChar(lpeLine, this.nextIndex);
        if (nextChar == '+' || nextChar == '*') {
            this.qualifierCounter = nextChar;
            this.tokenCode = 11;
            this.tokens = this.tokens + nextChar;
            ++this.nextIndex;
            return;
        }
        if (Character.isDigit(nextChar)) {
            char peek;
            this.lobeDigitStr = " (lobe " + nextChar + ")";
            this.tokens = this.tokens + nextChar;
            ++this.nextIndex;
            char c = peek = this.nextIndex != -1 && this.nextIndex < lpeLine.length() ? lpeLine.charAt(this.nextIndex) : (char)'\u0000';
            if (Character.isDigit(peek)) {
                this.lobeDigitStr = " (lobe " + nextChar + peek + ")";
                this.tokens = this.tokens + nextChar;
                ++this.nextIndex;
            }
            this.tokenCode = 4;
        }
        if ((nextChar = LPE_Token.peekNextChar(lpeLine, this.nextIndex)) == '+' || nextChar == '*') {
            this.qualifierCounter = nextChar;
            this.tokenCode = 4;
            this.tokens = this.tokens + nextChar;
            ++this.nextIndex;
            return;
        }
        switch (nextChar) {
            case '\'': {
                this.lpeGroup = new LPE_Group(lpeLine, this.nextIndex);
                if (!this.lpeGroup.valid) {
                    this.nextIndex = -1;
                    this.lpeGroup = null;
                    return;
                }
                this.tokenCode = this.tokenCode == 4 ? 8 : 7;
                this.tokens = this.tokens + this.lpeGroup.name;
                this.nextIndex = this.lpeGroup.nextIndex;
                return;
            }
        }
        nextChar = LPE_Token.peekNextChar(lpeLine, this.nextIndex);
        if (nextChar == '[') {
            this.regex = new LPE_Regex(lpeLine, this.nextIndex);
            if (!this.regex.valid) {
                this.nextIndex = -1;
                this.regex = null;
                this.tokens = this.tokens + nextChar;
                this.tokenCode = this.lobeDigitStr.length() == 0 ? 6 : 10;
                return;
            }
            this.regex.isSolo = false;
            if (this.regex.bodyType == 2) {
                this.regex = null;
                return;
            }
            this.tokenCode = this.lobeDigitStr.length() == 0 ? 5 : 9;
            this.tokens = this.tokens + this.regex.expr;
            this.nextIndex = this.regex.nextIndex;
        }
    }

    public String format(String s1, String s2) {
        return ExprReader.format(s1, s2);
    }

    public String toString() {
        String postscript;
        if (this.token == ' ') {
            return NOT_HANDLED_STR;
        }
        String regexStr = this.regex == null ? "regex is null" : "regex is not null";
        String groupStr = this.lpeGroup == null ? "" : this.lpeGroup.toString();
        Cutter.setLog("    Debug:LPE_Token token: " + this.token + " context: " + this.getContext() + " tokens --" + this.tokens + "-- regexStr --" + regexStr);
        Cutter.setLog("    Debug:LPE_Token groupStr --" + groupStr + "--");
        String lpeToString = this.lpeGroup != null ? " specific to the lpe group named " + this.lpeGroup.name : "";
        String regexToString = this.regex != null ? this.regex.toString() : "";
        String string = postscript = lpeToString.equals("") ? regexToString : lpeToString;
        if (this.qualifierCounter == '+') {
            postscript = postscript + " at least once";
        } else if (this.qualifierCounter == '*') {
            postscript = postscript + " zero or more times";
        }
        postscript = postscript + ".";
        String spacer = this.lobeDigitStr.length() == 0 ? "   " : "  ";
        String string2 = spacer = this.tokens.length() == 3 ? "" : spacer;
        if (this.tokenContext == SOLO) {
            if (this.token == 'C') {
                return "C   Light path evaluations begin at the Camera.\n";
            }
            if (this.token == 'L' && this.regex == null) {
                return this.format(this.tokens, "Evaluate all geometric Light paths" + lpeToString + ".");
            }
            if (this.token == 'L' && this.regex != null) {
                return this.format(this.tokens, "Evaluate all geometric Light paths" + regexToString + ".");
            }
            if (this.token == 'O') {
                return this.format(this.tokens, "Evaluate all emissive (glowing) Object light paths" + postscript);
            }
            if (this.token == 'D') {
                if (this.lobeDigitStr.equals("")) {
                    return this.format(this.tokens, "Evaluate all Diffuse scattering paths" + postscript);
                }
                return this.format(this.tokens, "Evaluate Diffuse" + this.lobeDigitStr + " scattering path" + postscript);
            }
            if (this.token == 'S') {
                if (this.lobeDigitStr.equals("")) {
                    return this.format(this.tokens, "Evaluate all Specular scattering paths" + postscript);
                }
                return this.format(this.tokens, "Evaluate Specular" + this.lobeDigitStr + " scattering path" + postscript);
            }
            if (this.token == 'T') {
                return "T   Evaluate all Transmission and Refraction paths";
            }
            if (this.token == 'R') {
                return "R   Evaluate all Reflection paths";
            }
            if (this.token == 'U') {
                return this.tokens + spacer + "Evaluate User material properties" + this.lobeDigitStr + ".";
            }
            if (this.token == '[' && this.regex == null) {
                return "[   Begin regular expression.";
            }
            if (this.token == '[' && this.regex != null) {
                return this.format(this.regex.expr + lpeToString, regexToString);
            }
            if (this.token == '{' && this.regex == null) {
                return "{   Begin regular expression qualifier.";
            }
            if (this.token == '{' && this.regex != null) {
                return this.format(this.regex.expr, this.regex.toString());
            }
            if (this.token == '(') {
                return "(   Begin grouping a sequence of lpe events.";
            }
            if (this.token == ')') {
                return ")   End grouping a sequence of lpe events.";
            }
            if (this.token == '|') {
                return "|   Evaluate either the previous lpe event or the next lpe event.";
            }
        }
        if (this.tokenContext == SPEC_TYPE) {
            if (this.token == '.' && this.regex == null) {
                return "all Reflection, Transmission and Refraction paths.";
            }
            if (this.token == 'L') {
                if (this.lpeGroup == null && this.regex == null) {
                    return "geometric Light paths.";
                }
                if (this.lpeGroup != null && this.regex == null) {
                    if (this.tokens.charAt(1) != '.') {
                        return "Error. There must be period between L token and the " + this.lpeGroup.name + " lpe group. For example <L." + this.lpeGroup.name + ">";
                    }
                    return "geometric Light paths specific to the " + this.lpeGroup.name + " light group.";
                }
                if (this.lpeGroup == null && this.regex != null) {
                    if (this.tokens.charAt(1) != '.') {
                        return "Error. There must be period between L token and " + this.regex.expr + " regular expression. For example <O." + this.regex.expr + ">";
                    }
                    return "geometric Light paths specific to the " + this.regex.toString() + " regular expression.";
                }
            }
            if (this.token == 'O') {
                if (this.lpeGroup == null && this.regex == null) {
                    return "emissive (glowing) Object light paths.";
                }
                if (this.lpeGroup != null && this.regex == null) {
                    if (this.tokens.charAt(1) != '.') {
                        return "Error. There must be period between O token and the " + this.lpeGroup.name + " lpe group. For example <O." + this.lpeGroup.name + ">";
                    }
                    return "emissive (glowing) Object light paths specific to the " + this.lpeGroup.name + " lpe group.";
                }
                if (this.lpeGroup == null && this.regex != null) {
                    if (this.tokens.charAt(1) != '.') {
                        return "Error. There must be period between O token and " + this.regex.expr + " regular expression. For example <O." + this.regex.expr + ">";
                    }
                    return "emissive (glowing) Object light paths specific to the " + this.regex.toString() + " regular expression";
                }
            }
            if (this.token == 'T') {
                if (this.lpeGroup == null && this.regex == null) {
                    return "Transmission and Refraction paths.";
                }
                if (this.lpeGroup != null && this.regex == null) {
                    return "Error. The Transmission event type cannot use a lpe group!";
                }
                if (this.lpeGroup == null && this.regex != null) {
                    return "Error. The Transmission event type cannot use a regular expression!";
                }
            }
            if (this.token == 'R') {
                if (this.lpeGroup == null && this.regex == null) {
                    return "Reflection paths.";
                }
                if (this.lpeGroup != null && this.regex == null) {
                    return "Error. The Reflection event type cannot use a lpe group!";
                }
                if (this.lpeGroup == null && this.regex != null) {
                    return "Error. The Reflection event type cannot use a regular expression!";
                }
            }
            if (this.token == 'S') {
                return "Error. 'S' cannot define an lpe \"type\" only a lpe \"event\"!";
            }
            if (this.token == 'D') {
                return "Error. 'D' cannot define an lpe \"type\" only a lpe \"event\"!";
            }
        }
        if (this.tokenContext == SPEC_EVENT) {
            if (this.token == 'D') {
                if (this.lpeGroup == null && this.regex == null) {
                    return "Evaluate Diffuse" + this.lobeDigitStr + " scattering for ";
                }
                if (this.lpeGroup != null && this.regex == null) {
                    return "Evaluate Diffuse" + this.lobeDigitStr + " scattering specific to the " + this.lpeGroup.name + " lpe group for ";
                }
                if (this.lpeGroup == null && this.regex != null) {
                    return "Evaluate Diffuse" + this.lobeDigitStr + " scattering specific to the " + this.regex.expr + " regular expression for ";
                }
            }
            if (this.token == 'S') {
                if (this.lpeGroup == null && this.regex == null) {
                    return "Evaluate Specular" + this.lobeDigitStr + " scattering for ";
                }
                if (this.lpeGroup != null && this.regex == null) {
                    return "Evaluate Specular" + this.lobeDigitStr + " scattering specific to the " + this.lpeGroup.name + " lpe group for ";
                }
                if (this.lpeGroup == null && this.regex != null) {
                    return "Evaluate Specular" + this.lobeDigitStr + " scattering specific to the " + this.regex.expr + " regular expression for ";
                }
            }
            if (this.token == '.' && this.lpeGroup == null && this.regex == null) {
                return "Evaluate all ";
            }
            if (this.token == '.' && this.lpeGroup != null) {
                return "Evaluate for the " + this.lpeGroup.name + " lpe group all ";
            }
            if (this.token == '.' && this.regex != null) {
                return "Evaluate for the " + this.regex.expr + " regular expression all ";
            }
        }
        if (this.token == '[' && this.regex != null) {
            return this.format(this.tokens, this.regex.toString());
        }
        return NOT_HANDLED_STR;
    }

    private boolean isRegexOpenChar(char c) {
        return c == '[' || c == '{';
    }

    private String getContext() {
        if (this.tokenContext == SOLO) {
            return "SOLO";
        }
        if (this.tokenContext == SPEC_TYPE) {
            return "SPEC_TYPE";
        }
        if (this.tokenContext == SPEC_EVENT) {
            return "SPEC_EVENT";
        }
        return "Undefined context";
    }

    private class LPE_Group {
        public boolean valid = false;
        public int nextIndex = -1;
        public String name = "";

        public LPE_Group(String lpeLine, int from) {
            int close = lpeLine.indexOf(39, from + 1);
            if (close == -1) {
                return;
            }
            this.valid = true;
            this.nextIndex = close + 1;
            this.name = lpeLine.substring(from, this.nextIndex);
        }

        public String toString() {
            return this.name;
        }
    }
}

