/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Mail;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Tools.KTools;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Vector;
import javax.swing.DesktopManager;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SendMailTool
extends KTools
implements ActionListener {
    static final int SEND_MAIL_TIMEOUT = 2000;
    private static KTitledPanel smtpPanel = new KTitledPanel(" Server ", "SendMailTool.SmtpPanel.info");
    private static KTitledPanel subjectPanel = new KTitledPanel(" Mail ");
    private JTextField from = new JTextField(Preferences.get(Preferences.EMAIL_ADDRESS));
    private JTextField to = new JTextField(Preferences.get(Preferences.EMAIL_ADDRESS));
    private JTextField smtp = new JTextField(Preferences.get(Preferences.SMTP_SERVER), 13);
    private JTextField srcDoc = new JTextField(" ");
    private JTextField subject = new JTextField(" ");
    public JTextField status = new JTextField("Idle");
    private JLabel smptLabel = new JLabel("SMTP", 2);
    private JLabel smptPortLabel = new JLabel("Port", 2);
    private JTextField port = new JTextField(Preferences.get(Preferences.SMTP_PORT), 6);
    private JLabel fromLabel = new JLabel("From", 2);
    private JLabel toLabel = new JLabel("To", 2);
    private JLabel subjectLabel = new JLabel("Subject", 2);
    private JLabel statusLabel = new JLabel("Status", 2);
    private static SendMailTool instance = null;
    KButton sendButton = new KButton("Send");
    private BufferedReader in;
    private PrintWriter out;
    Vector<String> gradebody = new Vector();

    public static SendMailTool getInstance(JMenuItem item) {
        if (instance == null) {
            instance = new SendMailTool(item);
        }
        return instance;
    }

    public static String getUsersEmailAddress() {
        return instance == null ? "" : SendMailTool.instance.from.getText();
    }

    public static void setStatusColor(Color c) {
        if (instance == null) {
            return;
        }
        SendMailTool.instance.status.setForeground(c);
    }

    public static void setStatusText(String s) {
        if (instance == null) {
            return;
        }
        SendMailTool.instance.status.setText(s);
    }

    public static void sendGrade() {
        if (instance == null) {
            return;
        }
        instance.parseSelectionAndSend();
    }

    public SendMailTool(JMenuItem item) {
        super("Send Mail", false);
        if (item != null) {
            this.menuItem = item;
        }
        this.sendButton.addActionListener(this);
        this.status.setEditable(false);
        smtpPanel.add(this.smptLabel, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(5, 6, 5, 3)));
        smtpPanel.add(this.smtp, new GBC(1, 0, 3, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(5, 6, 5, 10)));
        smtpPanel.add(this.smptPortLabel, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(5, 6, 5, 3)));
        smtpPanel.add(this.port, new GBC(1, 1, 3, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(5, 6, 5, 10)));
        subjectPanel.add(this.fromLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 6, 0, 3)));
        subjectPanel.add(this.from, new GBC(1, 0, 3, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 6, 0, 10)));
        subjectPanel.add(this.toLabel, new GBC(0, 1, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(5, 6, 0, 3)));
        subjectPanel.add(this.to, new GBC(1, 1, 3, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(5, 6, 0, 10)));
        subjectPanel.add(this.subjectLabel, new GBC(0, 2, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(3, 6, 0, 3)));
        subjectPanel.add(this.subject, new GBC(1, 2, 1, 1, 1.0, 0.0, 1, 0, 17, 2, new Insets(3, 6, 0, 10)));
        subjectPanel.add(this.statusLabel, new GBC(0, 3, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(7, 6, 5, 3)));
        subjectPanel.add(this.status, new GBC(1, 3, 1, 1, 1.0, 1.0, 1, 1, 17, 2, new Insets(7, 6, 5, 10)));
        this.contentPane.add((Component)smtpPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(10, 5, 0, 5)));
        this.contentPane.add((Component)subjectPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(5, 5, 0, 5)));
        this.contentPane.add((Component)this.sendButton, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(7, 0, 7, 7)));
        this.setInitialPosition();
        this.setVisible(false);
        this.setTitle(this.title);
        this.pack();
    }

    @Override
    public void showSelf() {
        this.srcDoc.setText(BBxt.getWindowTitle());
        this.subject.setText(BBxt.getWindowTitle());
        this.status.setText("Idle");
        this.smtp.setText(Preferences.get(Preferences.SMTP_SERVER));
        this.port.setText(Preferences.get(Preferences.SMTP_PORT));
        super.showSelf();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sendButton) {
            this.enterKeyPressed();
        } else {
            this.setVisible(false);
        }
    }

    public void enterKeyPressed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SendMailTool.this.status.setForeground(Color.black);
                SendMailTool.this.status.setText("Trying to connect");
                SendMailTool.this.sendButton.setEnabled(false);
                SendMailTool.this.sendMail();
            }
        });
    }

    public void escKeyPressed() {
    }

    private void sendMail() {
        Cutter.setLog("-------------------- NEW MAIL ----------------------");
        final int portNum = NumberUtils.strToInt(this.port.getText(), 25);
        if (Cutter.input.debug) {
            Cutter.setLog("    Debug:SendMailTool.parseSelectionAndSend()");
            Cutter.setLog("    Debug:Smtp: " + this.smtp.getText());
            Cutter.setLog("    Debug:Port: " + portNum);
            Cutter.setLog("    Debug:From: " + this.from.getText());
            Cutter.setLog("    Debug:To: " + this.to.getText());
            Cutter.setLog("    Debug:Subject: " + this.subject.getText());
            Cutter.setLog("    Debug:Message Begin_________________________");
            Cutter.setLog(BBxt.getWindowText());
            Cutter.setLog("    Debug:Message End___________________________");
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                try {
                    Socket s = new Socket(SendMailTool.this.smtp.getText(), portNum);
                    SendMailTool.this.out = new PrintWriter(s.getOutputStream());
                    SendMailTool.this.in = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    SendMailTool.this.send(null, false);
                    SendMailTool.this.send("HELO " + s.getLocalAddress() + "\r\n", true);
                    SendMailTool.this.send("MAIL FROM: " + SendMailTool.this.from.getText() + "\r\n", true);
                    SendMailTool.this.send("RCPT TO: " + SendMailTool.this.to.getText() + "\r\n", true);
                    SendMailTool.this.send("DATA\r\n", true);
                    SendMailTool.this.send("Date: " + TextUtils.getDate(), false);
                    SendMailTool.this.send("\r\nSubject: " + SendMailTool.this.subject.getText(), false);
                    String text = BBxt.getWindowText();
                    text = text + "\n";
                    if (text != null) {
                        int n;
                        Vector<String> linesList = new Vector<String>();
                        StringBuffer lineBuf = new StringBuffer();
                        for (n = 0; n < text.length(); ++n) {
                            if (text.charAt(n) == '\n') {
                                linesList.addElement(lineBuf.toString());
                                lineBuf.setLength(0);
                                continue;
                            }
                            lineBuf.append(text.charAt(n));
                        }
                        for (n = 0; n < linesList.size(); ++n) {
                            String line = (String)linesList.elementAt(n);
                            line = TextUtils.trimTrailingChar(line, '\n');
                            SendMailTool.this.send("\r\n" + line, false);
                        }
                    }
                    SendMailTool.this.send("\r\n.\r\n", true);
                    SendMailTool.this.send("quit\r\n", true);
                    SendMailTool.this.out.close();
                    SendMailTool.this.in.close();
                    s.close();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "A connection error has occured.\n\n\"" + e.toString() + "\"\n", "Simple Mail - Error", 0);
                    SendMailTool.this.status.setForeground(Color.red);
                    SendMailTool.this.status.setText("Mail has not been sent");
                    SendMailTool.this.sendButton.setEnabled(true);
                    return;
                }
                SendMailTool.this.status.setForeground(Color.blue);
                SendMailTool.this.status.setText("Mail has been sent");
                SendMailTool.this.sendButton.setEnabled(true);
            }
        };
        runner.setPriority(5);
        runner.start();
    }

    public void parseSelectionAndSend() {
        Object[] options;
        int result;
        String selection = BBxt.getSelection();
        if (selection == null || selection.trim().length() == 0) {
            return;
        }
        String[] lines = TextUtils.tokenize(selection, '\n');
        if (lines == null || lines.length < 1) {
            return;
        }
        int numRecips = 0;
        for (int n = 0; n < lines.length; ++n) {
            if (!lines[n].trim().contains("@")) continue;
            ++numRecips;
        }
        if (numRecips > 1 && (result = JOptionPane.showOptionDialog(KAbstractDesktop.desktopPane, "The selected text has more than one email recipient!\nAre you sure you wish to send the email?", "Warning", 0, 3, null, options = new String[]{"Cancel", "Send"}, options[0])) < 1) {
            return;
        }
        String emailAddress = lines[0].trim();
        String gradeTitle = "";
        this.gradebody = new Vector();
        for (int n = 1; n < lines.length; ++n) {
            String line = lines[n];
            if (gradeTitle.length() == 0 && line.trim().length() > 0) {
                gradeTitle = line;
                this.gradebody.add(gradeTitle + "\n");
                continue;
            }
            this.gradebody.add(line);
        }
        this.subject.setText(gradeTitle);
        this.to.setText(emailAddress);
        final int portNum = NumberUtils.strToInt(this.port.getText(), 25);
        if (Cutter.input.debug) {
            Cutter.setLog("    Debug:SendMailTool.parseSelectionAndSend()");
            Cutter.setLog("    Debug:Smtp: " + this.smtp.getText());
            Cutter.setLog("    Debug:Port: " + portNum);
            Cutter.setLog("    Debug:From: " + this.from.getText());
            Cutter.setLog("    Debug:To: " + this.to.getText());
            Cutter.setLog("    Debug:Subject: " + this.subject.getText());
            Cutter.setLog("    Debug:Message Begin_________________________");
            for (int n = 1; n < lines.length; ++n) {
                Cutter.setLog(lines[n]);
            }
            Cutter.setLog("    Debug:Message End___________________________");
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                try {
                    Socket s = new Socket(SendMailTool.this.smtp.getText(), portNum);
                    SendMailTool.this.out = new PrintWriter(s.getOutputStream());
                    SendMailTool.this.in = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    SendMailTool.this.send(null, false);
                    SendMailTool.this.send("HELO " + s.getLocalAddress() + "\r\n", true);
                    SendMailTool.this.send("MAIL FROM: " + SendMailTool.this.from.getText() + "\r\n", true);
                    SendMailTool.this.send("RCPT TO: " + SendMailTool.this.to.getText() + "\r\n", true);
                    SendMailTool.this.send("DATA\r\n", true);
                    SendMailTool.this.send("Date: " + TextUtils.getDate(), false);
                    SendMailTool.this.send("\r\nSubject: " + SendMailTool.this.subject.getText(), false);
                    for (int n = 0; n < SendMailTool.this.gradebody.size(); ++n) {
                        String line = SendMailTool.this.gradebody.elementAt(n);
                        line = TextUtils.trimTrailingChar(line, '\n');
                        SendMailTool.this.send("\r\n" + line, false);
                    }
                    SendMailTool.this.send("\r\n.\r\n", true);
                    SendMailTool.this.send("quit\r\n", true);
                    SendMailTool.this.out.close();
                    SendMailTool.this.in.close();
                    s.close();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "A connection error has occured.\n\n\"" + e.toString() + "\"\n", "Simple Mail - Error", 0);
                    SendMailTool.this.status.setForeground(Color.red);
                    SendMailTool.this.status.setText("Mail has not been sent");
                    SendMailTool.this.sendButton.setEnabled(true);
                    return;
                }
                SendMailTool.this.status.setForeground(Color.blue);
                SendMailTool.this.status.setText("Mail has been sent");
                SendMailTool.this.sendButton.setEnabled(true);
            }
        };
        runner.setPriority(5);
        runner.start();
    }

    private void send(String s, boolean doListen) throws IOException {
        Object nullStr = null;
        if (s != null) {
            if (doListen) {
                Cutter.setLog("    Info:SendMailTool.send() " + s.trim());
            }
            this.out.print(s);
            this.out.flush();
        }
        if (doListen) {
            String line = this.in.readLine();
            Cutter.setLog("    Info:SendMailTool.send() " + line);
        }
    }

    @Override
    protected void toolSelectionHappened() {
        this.grabFocus();
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    protected void adjustUI(String docExt) {
        this.setSendButtonLabel();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            return;
        }
        String fromStr = Preferences.get(Preferences.EMAIL_ADDRESS);
        String smtpStr = Preferences.get(Preferences.SMTP_SERVER);
        if (this.smtp.getText().trim().length() == 0) {
            this.smtp.setText(smtpStr);
        }
        if (this.from.getText().trim().length() == 0) {
            this.from.setText(fromStr);
        }
        if (this.to.getText().trim().length() == 0) {
            this.to.setText(fromStr);
        }
        this.setSendButtonLabel();
    }

    private void setSendButtonLabel() {
        KAbstractWindow w = KAbstractDesktop.getFrontWindow();
        if (w == null || !(w instanceof KAbstractTextWindow)) {
            this.sendButton.setText("Send");
            this.subject.setText("");
            this.sendButton.setEnabled(false);
            return;
        }
        String title = w.getRawTitle();
        if (title == null || title.trim().length() == 0) {
            this.sendButton.setText("Send");
            this.subject.setText("");
            this.sendButton.setEnabled(false);
            return;
        }
        this.sendButton.setEnabled(true);
        this.subject.setText(title);
        if (title.length() >= 11) {
            title = title.substring(0, 11) + "...";
        }
        this.sendButton.setText("Send " + title);
    }

    protected void repositionSelf() {
        DesktopManager manager = KAbstractDesktop.desktopPane.getDesktopManager();
        Dimension deskSize = KAbstractDesktop.desktopPane.getSize();
        Dimension toolSize = this.getSize();
        manager.setBoundsForFrame(this, deskSize.width / 2 - toolSize.width / 2, deskSize.height / 2 - toolSize.height / 2, toolSize.width, toolSize.height);
    }
}

