/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Monitor;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_Components.GBC;
import UI_Components.KTabbedPane.KTabbedPane;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Tools.KTools;
import UI_Tools.Monitor.MonitorPanel;
import UI_Tools.Monitor.MonitorPrefsPanel;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.RmanTool;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;

public class Monitor
extends KTools
implements ProcListener {
    private static final long serialVersionUID = 1L;
    public static final int RENDERER = 1;
    public static final int COMPILER = 2;
    public static final String RMAN_PANEL = "rman_panel";
    public static final String RSL_PANEL = "rsl_panel";
    public static final String STATS_PANEL = "stats_panel";
    public static final String MESSAGES = "Messages";
    public static final String RIB_RENDERER = "RIB Renderer";
    public static final String RSL_COMPILER = "RSL Compiler";
    public static final String OSL_PRMAN_COMPILER = "PRMan OSL Compile";
    public static final String OSL_ARNOLD_COMPILER = "Arnold OSL Compile";
    public static final String OSL_VRAY_COMPILER = "VRay OSL Compile";
    public static final String PXR_DEVKIT = "PxrDevkit";
    public static final String ARNOLD_DEVKIT = "Arnold Shader";
    public static final String STATISTICS = "Statistics";
    private static Font defaultFont = new Font("monospaced", 0, 11);
    private static MonitorPanel rmanPanel = new MonitorPanel("rman_panel");
    private static MonitorPanel rslPanel = new MonitorPanel("rsl_panel");
    public static MonitorPanel statsPanel = new MonitorPanel("stats_panel");
    public static MonitorPrefsPanel guiPrefsPanel = new MonitorPrefsPanel();
    public static KTabbedPane tabbedPane = new KTabbedPane();
    private static Monitor instance = null;
    public static final int DEFAULT_TEXT_STYLE = -1;
    public static final int PLAIN_TEXT_STYLE = 0;
    public static final int WARNING_TEXT_STYLE = 1;
    public static final int ERROR_TEXT_STYLE = 2;
    public static final int BOLD_TEXT_STYLE = 3;
    private static FileWriter logWriter = null;
    public static boolean logFileIsBeingWritten = false;
    public static final String LOGFILE_NAME = "monitor_log.txt";
    static int maxRibLine = 16;
    private int dotCount = 0;

    public static Monitor getInstance() {
        if (instance == null) {
            instance = new Monitor();
        }
        return instance;
    }

    private Monitor() {
        super("Process Monitor", KDesktop.processItem, -1, null, JLayeredPane.PALETTE_LAYER, true);
        this.setVisible(false);
        guiPrefsPanel.setFontSize(Preferences.get(Preferences.TOOL_MONITOR_FONT_SIZE));
        guiPrefsPanel.setFontStyle(Preferences.get(Preferences.TOOL_MONITOR_FONT_STYLE));
        DesktopManager deskmanager = KAbstractDesktop.desktopPane.getDesktopManager();
        tabbedPane.addTab(" Options ", guiPrefsPanel);
        this.contentPane.setLayout(new GridBagLayout());
        this.contentPane.add((Component)tabbedPane, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(1, 1, 5, 1)));
        this.pack();
        Dimension d = KAbstractDesktop.desktopPane.getSize();
        Dimension p = this.getSize();
        this.setMinimumSize(p);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane tab = (JTabbedPane)e.getSource();
                int index = tab.getSelectedIndex();
                try {
                    JComponent comp = (JComponent)tab.getComponentAt(index);
                    if (comp instanceof MonitorPanel) {
                        ((MonitorPanel)comp).editor.grabFocus();
                    }
                }
                catch (Exception ex) {
                    Cutter.setLog("    Exception:Monitor.tabbedPane.stateChanged()\n" + ex.toString());
                }
            }
        });
        this.setInitialPosition();
    }

    private static synchronized MonitorPanel.TextPane addPanel(String title) {
        if (title == null) {
            Cutter.setLog("    Error: Monitor.addPanel() was passed either a null title");
            return null;
        }
        int index = tabbedPane.indexOfTab(title = Monitor.massageTitle(title));
        if (index != -1) {
            Component c = tabbedPane.getComponentAt(index);
            if (!(c instanceof JPanel)) {
                Cutter.setLog("    Warning: Monitor.addPanel() - tabbedPane.getComponentAt(index)\n" + index + "             is not an instance of JPanel");
                return null;
            }
            JPanel p = (JPanel)c;
            if (p instanceof MonitorPanel) {
                return ((MonitorPanel)p).editor;
            }
            Cutter.setLog("    Warning: Monitor.addPanel() - tabbedPane.getComponentAt(index)\n" + index + "             is not an instance of MonitorPanel");
            return null;
        }
        String renderer = RenderInfo.get(3);
        if (renderer != null && title.startsWith(renderer)) {
            return Monitor.rmanPanel.editor;
        }
        String compiler = RenderInfo.get(4);
        if (compiler != null && title.startsWith(compiler)) {
            return Monitor.rslPanel.editor;
        }
        MonitorPanel panel = new MonitorPanel(title);
        tabbedPane.addTab(title, panel);
        panel.setFont(defaultFont);
        return panel.editor;
    }

    public static void echoCommand(String text) {
        Monitor.guiPrefsPanel.echoCmdPanel.echoArea.setText(text);
    }

    public static synchronized void setPanelText(String title, String text) {
        Monitor.setPanelText(title, text, true);
    }

    public static synchronized void setPanelText(String title, String text, boolean stripNewlines) {
        if (title == null || text == null || title.trim().length() == 0) {
            return;
        }
        if (title.equals("chmod")) {
            return;
        }
        MonitorPanel.TextPane textarea = Monitor.getTextAreaOfPanel(title);
        if (textarea == null) {
            Cutter.setLog("    Warning: Monitor.setPanelText() - the textarea of the panel is null");
            return;
        }
        if (!instance.isVisible()) {
            instance.setVisible(true);
        }
        if (!title.equals(MESSAGES) && stripNewlines) {
            text = Monitor.stripEmptyLines(text);
        }
        if (title.equals(RIB_RENDERER) && text.equalsIgnoreCase("Failed to connect")) {
            textarea.append(text);
        }
        textarea.setText(text);
        if (title.equals(MESSAGES)) {
            int i = tabbedPane.indexOfTab(title);
            tabbedPane.setForegroundAt(i, Color.blue);
        }
        int index = tabbedPane.indexOfTab(title);
        tabbedPane.setSelectedIndex(index);
    }

    public static synchronized String getPanelText(String title) {
        MonitorPanel.TextPane textarea = Monitor.getTextAreaOfPanel(title);
        if (textarea == null) {
            Cutter.setLog("    Warning: Monitor.getPanelText() - the textarea of " + title + " is null");
            return "";
        }
        return textarea.getText();
    }

    public static synchronized void appendPanelText(String title, String text) {
        Monitor.appendPanelText(title, text, -1);
    }

    private static void launchIT() {
        String path = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        if (path != null) {
            final File rmsBinDir = new File(path, "bin");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (rmsBinDir.exists()) {
                        String pathToIt = EnvUtils.isOSXEnvironment() ? new File(rmsBinDir, "it.app/Contents/MacOS/it").getPath() : (EnvUtils.isWinEnvironment() ? new File(rmsBinDir, "it").getPath() : new File(rmsBinDir, "it").getPath());
                        ProcessManager fp = new ProcessManager("");
                        String[] cmd = new String[]{pathToIt};
                        fp.launch(cmd, null, true, null, true);
                    }
                }
            });
        }
    }

    public static synchronized void appendPanelText(String title, String text, int textStyleID) {
        Style style;
        if (title == null || text == null || title.trim().length() == 0) {
            return;
        }
        title = Monitor.massageTitle(title);
        text = text.replaceAll("\t", "    ");
        MonitorPanel.TextPane textarea = Monitor.getTextAreaOfPanel(title);
        if (textarea == null) {
            Cutter.setLog("    Warning: Monitor.appendPanelText() - the textarea of the panel is null");
            return;
        }
        if (title.equals(RIB_RENDERER) && text.trim().equalsIgnoreCase("Failed to connect")) {
            Cutter.setLog("     Infor: Monitor.appendPanelText() - Attempting to launch Image Tool.");
            Monitor.launchIT();
        }
        if (title.equals(RIB_RENDERER) && text.trim().endsWith("%")) {
            textarea.setText(text);
            return;
        }
        if (textStyleID == -1) {
            textarea.append(text);
        } else if (textStyleID == 3) {
            style = textarea.getTextStyle(textStyleID);
            textarea.append(text, style);
        } else {
            style = textarea.getTextStyle(textStyleID);
            textarea.append(text);
            Cutter.setLog("non def appendPanelText >" + text + "<");
        }
        textarea.setSelectionStart(textarea.getText().length());
        textarea.setSelectionEnd(textarea.getText().length());
        if (title.equals(MESSAGES)) {
            int i = tabbedPane.indexOfTab(title);
            tabbedPane.setBackgroundAt(i, Color.blue);
        }
        int index = tabbedPane.indexOfTab(title);
        tabbedPane.setSelectedIndex(index);
    }

    public static synchronized void finalizePanelText(String title, String ps) {
        MonitorPanel.TextPane tp = Monitor.getTextAreaOfPanel(title);
        if (tp == null) {
            return;
        }
        tp.setPostscript(ps);
    }

    public static synchronized void initErrorStrings(String title, String[] strs) {
        MonitorPanel mp = Monitor.getPanelForTitle(title);
        if (mp == null) {
            return;
        }
        mp.initErrorStrings(strs);
    }

    public static void setFontSize(int size) {
        int style = defaultFont.getStyle();
        Monitor.setFont(size, style);
    }

    public static void setFontStyle(int style) {
        int size = defaultFont.getSize();
        Monitor.setFont(size, style);
    }

    public static void setFont(int size, int style) {
        defaultFont = new Font("monospaced", style, size);
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            Component c = tabbedPane.getComponentAt(i);
            if (c == null || !(c instanceof MonitorPanel)) continue;
            ((MonitorPanel)c).setFont(defaultFont);
        }
    }

    private static String massageTitle(String title) {
        String[] tokens;
        if (TextUtils.contains(title, '\n') && (tokens = TextUtils.tokenize(title, "\n")) != null && tokens.length > 0) {
            title = tokens[0];
        }
        if (title.startsWith("Compil")) {
            title = "CC";
        }
        if (title.equalsIgnoreCase("untitled")) {
            title = "Untitled";
        }
        return title;
    }

    private static MonitorPanel.TextPane getTextAreaOfPanel(String title) {
        int index;
        if (instance == null) {
            Monitor.getInstance();
        }
        MonitorPanel.TextPane textarea = (index = tabbedPane.indexOfTab(title = Monitor.massageTitle(title))) == -1 ? Monitor.addPanel(title) : Monitor.getTextAreaOfPanel(index);
        return textarea;
    }

    private static MonitorPanel.TextPane getTextAreaOfPanel(int index) {
        if (index == -1) {
            Cutter.setLog("    Warning: Monitor.getTextAreaOfPanel() given an index of -1");
            return null;
        }
        Component c = tabbedPane.getComponentAt(index);
        if (c instanceof MonitorPanel) {
            return ((MonitorPanel)c).editor;
        }
        Cutter.setLog("    Warning: Monitor.getTextAreaOfPanel() - tabbedPane.getComponentAt(index)\n" + index + "             is not an instance of SimpleMonitorPanel. Its an instance of\n             " + c.getClass().getName());
        return null;
    }

    public static MonitorPanel getPanelForTitle(String title) {
        int index;
        if (instance == null) {
            Monitor.getInstance();
        }
        if ((index = tabbedPane.indexOfTab(title = Monitor.massageTitle(title))) == -1) {
            return null;
        }
        Component c = tabbedPane.getComponentAt(index);
        if (c instanceof MonitorPanel) {
            return (MonitorPanel)c;
        }
        return null;
    }

    private static String stripEmptyLines(String text) {
        String[] lines = TextUtils.tokenize(text, "\n", true);
        StringBuffer buf = new StringBuffer();
        if (lines != null) {
            for (int n = 0; n < lines.length; ++n) {
                if (lines[n].trim().length() <= 0) continue;
                buf.append(lines[n]).append("\n");
            }
        } else {
            buf.append(text).append("\n");
        }
        return buf.toString();
    }

    static synchronized boolean logFileIsBeingWritten() {
        return logFileIsBeingWritten;
    }

    static synchronized void setLogFileIsBeingWritten(boolean f) {
        logFileIsBeingWritten = f;
    }

    public static void openLogFile() {
        if (Monitor.logFileIsBeingWritten()) {
            return;
        }
        File logfile = new File(FileUtils.getPWDFile(), LOGFILE_NAME);
        KAbstractWindow window = KAbstractDesktop.getWindowWithFile(logfile);
        if (window != null) {
            try {
                window.setClosed(true);
            }
            catch (PropertyVetoException ee) {
                Cutter.setLog("    Exception:Monitor.openLogFile()");
                Cutter.setLog("            " + ee.toString());
            }
        }
        if (logWriter != null) {
            Monitor.closeLogFile();
        }
        logWriter = null;
        try {
            if (logfile.exists()) {
                logfile.delete();
            }
            logWriter = new FileWriter(logfile, true);
            Monitor.setLogFileIsBeingWritten(true);
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:Monitor.openLogFile()\n" + e.toString());
        }
    }

    public static boolean appendLogFile(String data) {
        if (logWriter == null) {
            return false;
        }
        try {
            logWriter.write(data.trim());
            logWriter.write("\n");
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:Monitor.appendLogFile()\n" + e.toString());
        }
        return true;
    }

    public static boolean closeLogFile() {
        if (logWriter == null) {
            return false;
        }
        try {
            logWriter.flush();
            logWriter.close();
            logWriter = null;
            Monitor.setLogFileIsBeingWritten(false);
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:Monitor.appendLogFile()\n" + e.toString());
        }
        return true;
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
        MonitorPanel mp;
        if (guiPrefsPanel.getDoWriteLog().equals("true")) {
            Monitor.openLogFile();
        }
        if (this.getMenuText().startsWith("Show")) {
            this.toggleText(this.menuItem);
        }
        if ((mp = Monitor.getPanelForTitle(procName)) != null) {
            mp.initMaxLineCount(procName.equals(RIB_RENDERER) ? 128 : 5000);
            mp.currentProcID = procID;
        }
    }

    @Override
    public void processFinished(String[] progarray) {
        String cmd;
        Monitor.closeLogFile();
        if (progarray != null && progarray.length > 0 && (cmd = progarray[0]) != null && cmd.endsWith("shaderdl")) {
            Monitor.finalizePanelText(RSL_COMPILER, "Compilation Completed:\n");
        }
    }

    @Override
    public void processSentString(String procName, String str) {
        if (guiPrefsPanel.getDoWriteLog().equals("true")) {
            Monitor.appendLogFile(str);
        }
        if (procName.equals(ARNOLD_DEVKIT)) {
            if (!str.endsWith("\n")) {
                str = str + "\n";
            }
            str = str.replaceAll("( -I\")", "\n-I\"");
            str = str.replaceAll("( -L\")", "\n-L\"");
            str = str.replaceAll("( -dynamiclib)", "\n-dynamiclib");
            str = str.replaceAll("( -o)", "\n-o");
            str = str.replaceAll("( -lai)", "\n-lai");
            Monitor.appendPanelText(procName, str);
            return;
        }
        if (procName.equals(PXR_DEVKIT)) {
            if (EnvUtils.isWinEnvironment()) {
                if (str.trim().startsWith("1 file(s) moved")) {
                    return;
                }
                String s = str.replaceFirst("( Creating library )", "\nCreating library ");
                String[] tokens = s.split("( and object )");
                if (tokens != null && tokens.length == 2) {
                    Monitor.appendPanelText(procName, tokens[0] + "\n");
                    Monitor.appendPanelText(procName, "and object " + tokens[1] + "\n");
                    Monitor.appendPanelText(procName, "Successful Build:\n", 3);
                    return;
                }
                Monitor.appendPanelText(procName, str);
                return;
            }
            if (str.startsWith("rm ./")) {
                return;
            }
            String[] tokens = str.split("(-o)");
            if (tokens != null && tokens.length == 2) {
                Monitor.appendPanelText(procName, tokens[0] + " \n");
                Monitor.appendPanelText(procName, "Successful Build: \n    " + tokens[1] + "\n", 3);
                return;
            }
            str = str.replaceAll("( -I\"/)", "\n    -I\"/");
            str = str.replaceAll("( -c )", "\n    -c ");
            Monitor.appendPanelText(procName, str + "\n");
            return;
        }
        if (procName.equals("OSL Compiler")) {
            if (!str.endsWith("\n")) {
                str = str + "\n";
            }
            if (TextUtils.contains(str, "->", false)) {
                String s = str.replaceFirst("(->)", "\n->");
                Monitor.appendPanelText(procName, s);
                return;
            }
            if (TextUtils.contains(str, "FAILED", false)) {
                String s = str.replaceFirst("(FAILED)", "\nFAILED");
                Monitor.appendPanelText(procName, s);
                return;
            }
            Monitor.appendPanelText(procName, str);
            return;
        }
        if (procName.equals("Ray")) {
            if (str.trim().length() == 0) {
                return;
            }
            String output = str + "\n";
            try {
                String[] parts = output.split("(\\d+\\.\\d*%)", 2);
                if (parts != null && parts.length > 1) {
                    if (++this.dotCount < 50) {
                        output = ".";
                    } else {
                        output = ".\n";
                        this.dotCount = 0;
                    }
                }
                if ((parts = str.split("(100\\.0%)", 2)) != null && parts.length > 1) {
                    output = ".\n";
                }
            }
            catch (Exception e) {
                Cutter.setLog("    Exception:Monitor.processSentString()\n" + e.toString());
            }
            Monitor.appendPanelText(procName, output);
        } else if (procName.equals("man")) {
            Monitor.appendPanelText(procName, this.formatManPage(str));
        } else if (procName.equals("RslPlugin")) {
            Monitor.appendPanelText(procName, this.formatCompilerMsg(str));
        } else {
            String s;
            if (procName.equals(RSL_COMPILER) && str.trim().length() == 0) {
                return;
            }
            if (procName.equals(RSL_COMPILER)) {
                str = this.formatRSLCompilerStr(str);
            }
            if ((s = str.trim()) == "^") {
                Monitor.appendPanelText(procName, str + "\n");
            } else {
                Monitor.appendPanelText(procName, str + "\n");
            }
        }
    }

    private String formatCompilerMsg(String text) {
        if (text == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        for (int n = 0; n < text.length(); ++n) {
            char ascii = text.charAt(n);
            if (ascii == '\u00c4' || ascii == '\u00f4') continue;
            buff.append(text.charAt(n));
        }
        return buff.toString() + "\n";
    }

    private String formatRSLCompilerStr(String text) {
        String out = text.replaceAll("(?i)([\\s]+(ERROR)[:]+)", "\nERROR:");
        out = out.replaceAll("(?i)([\\s]+(WARNING)[:]+)", "\nWARNING:");
        out = out.replaceAll("(?i)([\\s]+(aborted)[\\s]+)", "\naborted ");
        return out;
    }

    private String formatManPage(String text) {
        StringBuffer buff = new StringBuffer();
        char nextChar = '\u0000';
        Vector listOfBold = new Vector();
        boolean isManPage = false;
        boolean isDosPage = false;
        for (int n = 0; n < text.length(); ++n) {
            nextChar = n + 1 < text.length() ? text.charAt(n + 1) : (char)'\u0000';
            if (text.charAt(n) >= '\u00b3') {
                isDosPage = true;
                buff.append(" ");
                if (nextChar < '\u00b3') continue;
                buff.append(" ");
                ++n;
                continue;
            }
            if (nextChar == '\b') {
                ++n;
                continue;
            }
            buff.append(text.charAt(n));
        }
        return buff.append("\n").toString();
    }

    @Override
    protected void saveSelf() {
        Preferences.write(Preferences.TOOL_MONITOR_FONT_SIZE, guiPrefsPanel.getFontSize());
        Preferences.write(Preferences.TOOL_MONITOR_FONT_STYLE, guiPrefsPanel.getFontStyle());
        Preferences.write(Preferences.TOOL_MONITOR_LOGFILE_WRITE, guiPrefsPanel.getDoWriteLog());
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    protected void adjustUI(String docname) {
        if (docname.endsWith(".rib") || docname.endsWith(".key") && RmanTool.tool != null) {
            this.adjustUI(0);
        } else if (docname.endsWith(".sl") && RmanTool.tool != null) {
            this.adjustUI(1);
        }
    }

    @Override
    protected void toolSelectionHappened() {
        PrefsPanel pp = tabbedPane.getVisiblePrefsPanel();
        if (pp != null) {
            pp.focusDefaultField();
        } else {
            Monitor.guiPrefsPanel.echoCmdPanel.grabFocus();
        }
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
        PrefsPanel pp = tabbedPane.getVisiblePrefsPanel();
        if (pp != null) {
            pp.defaultFocusedField = compLostFocus;
        }
    }

    @Override
    protected void initDynamicDesktopPosition() {
        this.dynamicDesktopPosition = 2;
    }
}

