/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Monitor;

import Processes.ProcListener;
import Processes.ThreadedProcess;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Text.KeyMaps.KKeyMaps;
import UI_Text.Style.KStyleContext;
import UI_Tools.Monitor.Monitor;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.DocumentUtils;
import Utilities.RegExpUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class MonitorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public TextPane editor = new TextPane();
    public String label = "untitled";
    private Vector<ProcListener> listOfProcListeners = new Vector();
    private static final String[] defaultErrorStrs = new String[]{"-->", "error", "unregistered", "can't", "incorrect", "bad", "missing", "cannot", "R05011", "aborted", "fatal"};
    private static final String[] warningStrs = new String[]{"warning", "warn", "unwise", "not"};
    private static final String ourInfoStr = "Cutter Info:";
    public int numErrors = 0;
    public int numWarnings = 0;
    private String[] userErrorStrs;
    private int lineCount = 0;
    public String currentProcID = "";
    private PanelPopup popup = new PanelPopup();
    private int maxLineCount = 5000;

    public MonitorPanel(String label) {
        super(new GridBagLayout());
        this.label = label;
        JPanel textPanel = new JPanel();
        JScrollPane scroller = new JScrollPane();
        this.setVisible(false);
        scroller.getViewport().add(this.editor);
        this.add((Component)scroller, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(3, 3, 3, 3)));
        this.setMinimumSize(new Dimension(Cutter.MONITOR_PANEL_WIDTH, Cutter.MONITOR_PANEL_HEIGHT));
        this.setPreferredSize(new Dimension(Cutter.MONITOR_PANEL_WIDTH, Cutter.MONITOR_PANEL_HEIGHT));
        this.userErrorStrs = new String[defaultErrorStrs.length];
        for (int n = 0; n < defaultErrorStrs.length; ++n) {
            this.userErrorStrs[n] = defaultErrorStrs[n];
        }
        final String title = label;
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                int i;
                if (title.equals("Messages") && (i = Monitor.tabbedPane.indexOfTab("Messages")) != -1) {
                    Monitor.tabbedPane.setForegroundAt(i, Color.black);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.setRequestFocusEnabled(false);
    }

    public void initMaxLineCount(int maxLineCount) {
        this.maxLineCount = maxLineCount;
        this.lineCount = 0;
    }

    public void initErrorStrings(String[] strs) {
        if (strs == null) {
            return;
        }
        this.userErrorStrs = new String[strs.length];
        for (int n = 0; n < strs.length; ++n) {
            this.userErrorStrs[n] = strs[n];
        }
    }

    public TextPane getEditor() {
        return this.editor;
    }

    @Override
    public void setFont(Font f) {
        if (f == null || this.editor == null) {
            return;
        }
        if (this.editor.styleContext == null) {
            this.editor.setFont(f);
        } else {
            this.editor.styleContext.setFont(f);
        }
    }

    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        if (name.equals("selected") && (Boolean)value == Boolean.TRUE) {
            throw new PropertyVetoException("selected", e);
        }
    }

    public void addProcessListener(ProcListener listener) {
        boolean found = false;
        for (int n = 0; n < this.listOfProcListeners.size(); ++n) {
            if (!this.listOfProcListeners.elementAt(n).equals(listener)) continue;
            found = true;
        }
        if (!found) {
            this.listOfProcListeners.addElement(listener);
        }
    }

    public class PanelPopup
    extends JPopupMenu
    implements PopupMenuListener {
        public JMenuItem clearProcItem = new JMenuItem("Clear Text");
        public JMenuItem killProcItem = new JMenuItem("Terminate Process");

        public PanelPopup() {
            this.addPopupMenuListener(this);
            this.add(this.clearProcItem);
            this.add(this.killProcItem);
            ActionListener caction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MonitorPanel.this.editor.setText("\n");
                }
            };
            this.clearProcItem.addActionListener(caction);
            ActionListener taction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ThreadedProcess.killProcWithID(MonitorPanel.this.currentProcID);
                    MonitorPanel.this.numErrors = -1;
                    MonitorPanel.this.editor.setPostscript("");
                }
            };
            this.killProcItem.addActionListener(taction);
            this.pack();
        }

        private void ___POPUP_LISTENER_METHODS________() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x + 5, y);
            MenuElement[] element = this.getSubElements();
            for (int n = 0; n < element.length; ++n) {
                JMenuItem item = (JMenuItem)element[n];
                Graphics g = item.getGraphics();
                item.paint(g);
            }
        }
    }

    public class TextPane
    extends JTextPane {
        public KStyleContext styleContext = new KStyleContext();
        private DefaultStyledDocument document;

        public TextPane() {
            StyleConstants.setForeground(this.styleContext.plainStyle, new Color(0, 0, 0));
            StyleConstants.setForeground(this.styleContext.keywordStyle1, new Color(255, 0, 0));
            StyleConstants.setForeground(this.styleContext.keywordStyle2, new Color(0, 0, 255));
            StyleConstants.setForeground(this.styleContext.keywordStyle3, new Color(113, 3, 113));
            StyleConstants.setForeground(this.styleContext.keywordStyle4, new Color(100, 100, 100));
            StyleConstants.setBold(this.styleContext.keywordStyle3, true);
            this.document = new DefaultStyledDocument(this.styleContext);
            this.setStyledDocument(this.document);
            KKeyMaps.setDefaults(this);
            this.setSelectionColor(new Color(255, 255, 0));
            this.setEditable(false);
            this.setCaret(new Karet());
            this.setCaretColor(new Color(255, 255, 0));
            this.styleContext.setFontSize(4);
        }

        private void handlePopupTrigger(MouseEvent e) {
            MonitorPanel.this.popup.show(MonitorPanel.this.editor, e.getX(), e.getY());
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            try {
                Container parent = this.getParent();
                TextUI ui = this.getUI();
                return parent != null ? ui.getPreferredSize((JComponent)this).width <= parent.getSize().width : true;
            }
            catch (Exception e) {
                Cutter.setLog("    Exception:MonitorPanel.TextPane.getScrollableTracksViewportWidth()\n          " + e.toString());
                return true;
            }
        }

        private boolean isPercentage(String str) {
            return str.trim().length() > 0 && Character.isDigit(str.charAt(0)) && str.trim().endsWith("%") && TextUtils.tokenize(str).length == 1;
        }

        public void append(String text) {
            Element element;
            String[] parts;
            if (text == null || text.length() == 0) {
                return;
            }
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
            if ((MonitorPanel.this.label.equals("Arnold OSL Compile") || MonitorPanel.this.label.equals("PRMan OSL Compile")) && text.contains("->") && (parts = text.split("(->)")) != null && parts.length == 2) {
                String shdName;
                File shd;
                text = parts[0] + "\n->\n" + parts[1].trim();
                if (MonitorPanel.this.label.equals("Arnold OSL Compile") && (shd = new File(parts[1].trim())).exists() && (shdName = shd.getName()) != null && shdName.length() > 4) {
                    String mtdName = shdName.substring(0, shdName.length() - 4);
                    File file = new File(shd.getParent(), mtdName + ".mtd");
                }
            }
            if (this.isPercentage(text)) {
                String[] lines = DocumentUtils.getParagraphs(this.document);
                element = DocumentUtils.getParagraphElement(this.document, this.document.getLength() - 1);
                int begin = element.getStartOffset();
                int end = element.getEndOffset();
                String lastline = "";
                try {
                    lastline = this.document.getText(begin, end - begin);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (this.isPercentage(lastline) && this.document != null) {
                    try {
                        this.document.remove(this.document.getLength() - lastline.length(), lastline.length());
                        this.document.insertString(this.document.getLength(), text, this.styleContext.keywordStyle3);
                    }
                    catch (BadLocationException ex) {
                        Cutter.setLog("    Error: MonitorPanel.append() percentage - " + ex.getMessage());
                    }
                    return;
                }
            }
            MonitorPanel.this.lineCount++;
            if (MonitorPanel.this.lineCount == MonitorPanel.this.maxLineCount) {
                text = "Cutter Info: Remaining text is being ignored.\n";
            }
            if (MonitorPanel.this.lineCount > MonitorPanel.this.maxLineCount) {
                return;
            }
            if (this.document.getLength() == 1) {
                try {
                    this.document.remove(0, this.document.getLength());
                }
                catch (BadLocationException ex) {
                    Cutter.setLog("    Exception:MonitorPanel.append(String) removing\n" + ex.toString());
                }
            }
            try {
                Style style = MonitorPanel.this.label.equals("Statistics") ? this.styleContext.keywordStyle2 : this.getSyntaxStyle(text);
                this.document.insertString(this.document.getLength(), text, style);
                element = DocumentUtils.getParagraphElement(this.document, this.document.getLength());
                if (element == null) {
                    return;
                }
                int begin = element.getStartOffset();
                MonitorPanel.this.editor.setSelectionStart(begin);
                MonitorPanel.this.editor.setSelectionEnd(begin);
            }
            catch (Exception e) {
                Cutter.setLog("    Exception:MonitorPanel.append(String) insert\n" + e.toString());
            }
        }

        @Override
        public void setText(String text) {
            if (text == null || text.length() == 0) {
                return;
            }
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
            MonitorPanel.this.numErrors = 0;
            MonitorPanel.this.numWarnings = 0;
            try {
                if (this.document != null) {
                    this.document.remove(0, this.document.getLength());
                    this.document.insertString(0, text, this.getSyntaxStyle(text));
                }
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Error: MonitorPanel.setText() - " + ex.getMessage());
            }
        }

        public void append(String text, Style style) {
            if (text == null || text.length() == 0) {
                return;
            }
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
            try {
                this.document.insertString(this.document.getLength(), text, style);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setPostscript(String ps) {
            if (ps.length() != 0) {
                this.append(ps.toUpperCase(), this.styleContext.keywordStyle3);
            }
            boolean psContainedWarning = false;
            for (int n = 0; n < warningStrs.length; ++n) {
                if (RegExpUtils.split(ps, warningStrs[n], true) == null) continue;
                psContainedWarning = true;
            }
            if (!psContainedWarning && MonitorPanel.this.numErrors > 0) {
                this.append("    Errors: " + MonitorPanel.this.numErrors + "\n", this.styleContext.keywordStyle1);
                if (MonitorPanel.this.numWarnings > 0) {
                    this.append("    Warnings: " + MonitorPanel.this.numWarnings + "\n", this.styleContext.keywordStyle2);
                }
            } else if (MonitorPanel.this.numErrors == -1) {
                this.append("    Info: Process terminated by user.\n", this.styleContext.keywordStyle1);
            } else {
                if (MonitorPanel.this.numErrors > 0) {
                    this.append("    Errors: " + MonitorPanel.this.numErrors + "\n", this.styleContext.keywordStyle1);
                }
                if (MonitorPanel.this.numWarnings > 0) {
                    this.append("    Warnings: " + MonitorPanel.this.numWarnings + "\n", this.styleContext.keywordStyle2);
                }
            }
            this.setSelectionStart(this.document.getLength());
            this.setSelectionEnd(this.document.getLength());
        }

        @Override
        public void setFont(Font f) {
            if (this.styleContext == null) {
                super.setFont(f);
            } else {
                this.styleContext.setFont(f);
            }
        }

        private Style getSyntaxStyle(String text) {
            int n;
            Style out = this.styleContext.plainStyle;
            if (MonitorPanel.this.label.equals("man")) {
                if (text.startsWith("_") && text.endsWith("_")) {
                    return out;
                }
                if (TextUtils.isAllUpperCase(text)) {
                    return this.styleContext.keywordStyle1;
                }
                return out;
            }
            for (n = 0; n < warningStrs.length; ++n) {
                if (RegExpUtils.split(text, warningStrs[n], true) == null) continue;
                ++MonitorPanel.this.numWarnings;
                out = this.styleContext.keywordStyle2;
            }
            for (n = 0; n < MonitorPanel.this.userErrorStrs.length; ++n) {
                if (RegExpUtils.split(text, MonitorPanel.this.userErrorStrs[n], true) == null) continue;
                ++MonitorPanel.this.numErrors;
                out = this.styleContext.keywordStyle1;
            }
            if (text.startsWith(MonitorPanel.ourInfoStr)) {
                out = this.styleContext.keywordStyle2;
            }
            if (text.startsWith("Finished at ")) {
                Monitor m;
                out = this.styleContext.keywordStyle4;
                if (MonitorPanel.this.numErrors > 0 && !MonitorPanel.this.label.equalsIgnoreCase("untitled") && !(m = Monitor.getInstance()).isWithinDesktopBounds()) {
                    m.setVisible(false);
                    m.showSelf();
                }
            }
            if (MonitorPanel.this.numErrors > 0) {
                Monitor monitor = Monitor.getInstance();
                if (monitor.isCallapsed()) {
                    monitor.callapseWindow(false);
                }
                if (!monitor.isWithinDesktopBounds()) {
                    monitor.setDynamicDesktopPosition(false);
                }
            }
            return out;
        }

        public Style getTextStyle(int styleID) {
            Style out = this.styleContext.plainStyle;
            if (styleID == 1) {
                out = this.styleContext.keywordStyle2;
            } else if (styleID == 2) {
                out = this.styleContext.keywordStyle1;
            } else if (styleID == 3) {
                out = this.styleContext.keywordStyle3;
            }
            return out;
        }

        private class Karet
        extends DefaultCaret {
            @Override
            public void mouseReleased(MouseEvent e) {
                if (e == null) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    TextPane.this.handlePopupTrigger(e);
                    return;
                }
                super.mouseReleased(e);
                if (e.getClickCount() == 2) {
                    this.selectLine(this.getMark());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e == null) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    TextPane.this.handlePopupTrigger(e);
                    return;
                }
                super.mousePressed(e);
            }

            private void selectLine(int offset) {
                int[] offsets = DocumentUtils.getElementOffsets(MonitorPanel.this.editor.document, offset);
                if (offsets == null) {
                    Cutter.setLog("    Debug:MonitorPanel.Karet.selectLine() - offset = " + offset);
                    Cutter.setLog("           The call to DocumentUtils.getElementOffsets(monitor.document) returned null");
                    return;
                }
                int begin = offsets[1];
                int end = offsets[2];
                MonitorPanel.this.editor.setSelectionStart(begin);
                MonitorPanel.this.editor.setSelectionEnd(end - 1);
                KAbstractWindow window = KAbstractDesktop.getWindowOfClass("UI_Window.KWindow.KTextWindow");
                if (window == null) {
                    return;
                }
                Object winDocName = null;
                File f = null;
                if (window != null) {
                    f = window.getFile();
                }
                if (f == null) {
                    Cutter.setLog("    Warning:MonitorPanel.TextPane.Karet.selectLine() - cannot find a file for the front window");
                    return;
                }
                BBxt.autoHiliteError(f, MonitorPanel.this.editor.getSelectedText());
                MonitorPanel.this.editor.setSelectionStart(begin);
                MonitorPanel.this.editor.setSelectionEnd(begin);
            }
        }
    }
}

