/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Monitor;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KTitledComboBox;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.Monitor.Monitor;
import Utilities.FileUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MonitorPrefsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public FontSizePanel fontSizePanel = new FontSizePanel();
    public FontStylePanel fontStylePanel = new FontStylePanel();
    public EchoCommandPanel echoCmdPanel = new EchoCommandPanel();
    public LogFilePanel logFilePanel = new LogFilePanel();

    public MonitorPrefsPanel() {
        this.setLayout(new GridBagLayout());
        JPanel holder = new JPanel();
        holder.setLayout(new GridBagLayout());
        KTitledPanel fontPanel = new KTitledPanel(" Font ", "Monitor.guiPanel.info");
        fontPanel.add(this.fontSizePanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(1, 1, 0, 1)));
        fontPanel.add(this.fontStylePanel, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(1, 1, 1, 1)));
        KTitledPanel logPanel = new KTitledPanel(" Log File ", "Monitor.logPanel.info");
        logPanel.add(this.logFilePanel, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(1, 1, 1, 1)));
        holder.add((Component)fontPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 1, new Insets(1, 1, 1, 1)));
        holder.add((Component)logPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 1, new Insets(1, 1, 1, 1)));
        holder.add((Component)new JPanel(), new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(1, 1, 1, 1)));
        this.add((Component)holder, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 18, 1, new Insets(1, 1, 2, 1)));
        this.add((Component)this.echoCmdPanel, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(1, 5, 2, 1)));
        this.setMinimumSize(new Dimension(Cutter.MONITOR_PANEL_WIDTH, Cutter.MONITOR_PANEL_HEIGHT + 10));
        this.setPreferredSize(new Dimension(Cutter.MONITOR_PANEL_WIDTH, Cutter.MONITOR_PANEL_HEIGHT + 10));
    }

    public int getFontSize() {
        return Integer.parseInt(this.fontSizePanel.combo.getSelectedItem().toString());
    }

    public int getFontStyle() {
        return this.fontStylePanel.bold.isSelected() ? 1 : 0;
    }

    public String getDoWriteLog() {
        return this.logFilePanel.writeCheckBox.isSelected() ? "true" : "false";
    }

    public void setFontSize(String s) {
        String[] sizes = new String[]{"9", "10", "11", "12", "14", "16", "18", "20", "22", "26", "30"};
        this.fontSizePanel.combo.setSelectedIndex(2);
        for (int n = 0; n < sizes.length; ++n) {
            if (!sizes[n].equals(s)) continue;
            this.fontSizePanel.combo.setSelectedIndex(n);
            return;
        }
    }

    public void setFontStyle(String s) {
        this.fontStylePanel.bold.setSelected(s.equalsIgnoreCase("1"));
    }

    private class FontSizePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private String[] sizes = new String[]{"9", "10", "11", "12", "14", "16", "18", "20", "22", "26", "30"};
        private KTitledComboBox combo = new KTitledComboBox("size ");

        public FontSizePanel() {
            this.combo.combo.setPreferredSize(new Dimension(45, 19));
            for (int n = 0; n < this.sizes.length; ++n) {
                this.combo.addItem(this.sizes[n]);
            }
            this.combo.setMaximumRowCount(this.sizes.length);
            this.combo.setSelectedIndex(3);
            this.combo.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String str = FontSizePanel.this.combo.getSelectedItem().toString();
                    int size = Integer.parseInt(str);
                    Monitor.setFontSize(size);
                }
            });
            this.setLayout(new GridBagLayout());
            this.add((Component)this.combo, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 8, 0, 40)));
        }
    }

    public class FontStylePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JCheckBox bold = new JCheckBox("");

        public FontStylePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("bold "), new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 10, 0, 0)));
            this.add((Component)this.bold, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 3, 0, 5)));
            this.bold.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (FontStylePanel.this.bold.isSelected()) {
                        Monitor.setFontStyle(1);
                    } else {
                        Monitor.setFontStyle(0);
                    }
                }
            });
        }
    }

    public class EchoCommandPanel
    extends KTitledPanel {
        public JTextArea echoArea;

        public EchoCommandPanel() {
            super(" Command Echo ", "Monitor.echoCommandPanel.info");
            this.echoArea = new JTextArea(7, 11);
            this.echoArea.setSelectionColor(new Color(1.0f, 1.0f, 0.0f));
            this.echoArea.setEditable(false);
            this.echoArea.setMargin(new Insets(2, 5, 2, 1));
            this.echoArea.setTabSize(4);
            JScrollPane scroller = new JScrollPane();
            scroller.getViewport().add(this.echoArea);
            this.add(scroller, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 3, 3, 3)));
        }
    }

    public class LogFilePanel
    extends JPanel {
        private JCheckBox writeCheckBox = new JCheckBox();
        private KButton openLogButton = new KButton("open");

        public LogFilePanel() {
            this.openLogButton.setMargin(new Insets(1, 2, 3, 2));
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("write "), new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 2, new Insets(0, 5, 0, 0)));
            this.add((Component)this.writeCheckBox, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 5)));
            this.add((Component)this.openLogButton, new GBC(2, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 5, 0, 2)));
            this.openLogButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BBxt.newDocument(new File(FileUtils.getPWDFile(), "monitor_log.txt"));
                }
            });
            this.writeCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
            boolean flag = Preferences.get(Preferences.TOOL_MONITOR_LOGFILE_WRITE).equals("true");
            this.writeCheckBox.setSelected(flag);
        }
    }
}

