/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Monitor;

import UI_Tools.Monitor.ProcessInfoListener;
import Utilities.TextUtils;

public class ProcessInfo
extends Thread {
    public static final int MSG_NONE = 0;
    public static final int MSG_START = 1;
    public static final int MSG_WARNING = 3;
    public static final int MSG_ERROR = 5;
    public static final int MSG_END = 7;
    public static final int MSG_FATAL = 9;
    public static final int MSG_INCORRECT = 11;
    public static final int MSG_INFO = 19;
    private String msg = null;
    private int status = 0;
    private ProcessInfoListener listener = null;

    public ProcessInfo(ProcessInfoListener l, String msg, int status) {
        this.listener = l;
        this.msg = msg;
        this.status = status;
    }

    @Override
    public void run() {
        if (this.msg == null || this.msg.trim().length() == 0) {
            this.listener.displayProcessInfo("no message\n*************************", 0);
            return;
        }
        StringBuffer buff = new StringBuffer();
        String[] token = TextUtils.tokenize(this.msg, "\n");
        if (token == null || token.length == 0) {
            this.listener.displayProcessInfo("no message\n*************************", 0);
            return;
        }
        for (int n = 0; n < token.length; ++n) {
            if (token[n].startsWith("*** ")) continue;
            buff.append(token[n] + "\n");
        }
        this.listener.displayProcessInfo(buff.toString(), this.status);
    }
}

