/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Mover;

import UI_Desktop.Cutter;
import UI_Tools.Mover.MoverTool;
import Utilities.FileUtils;
import Utilities.TextUtils;
import Utilities.ZipUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnZipper {
    private File zipfile;
    private byte[] buff = new byte[MoverTool.BUFFER_SIZE];
    private String head;
    private int numEntries = 0;

    public UnZipper(File zipfile) throws Exception {
        this.zipfile = zipfile;
        String[] entries = ZipUtils.getAllZipEntries(zipfile);
        if (entries == null) {
            throw new Exception("ZipInput constructor null zip entries for \"" + zipfile.getPath() + "\"");
        }
        this.numEntries = entries.length;
    }

    public String getUnZippedDirName() throws Exception {
        ZipEntry zipentry = ZipUtils.getFirstZipEntry(this.zipfile);
        if (zipentry != null && zipentry.isDirectory()) {
            String name = zipentry.getName();
            return FileUtils.removeTrailingSeparator(name, '/', '\\');
        }
        String name = this.zipfile.getName();
        return TextUtils.removeExtension(name);
    }

    public boolean restore() {
        File destDir = this.zipfile.getParentFile();
        byte[] buffer = new byte[1024];
        try {
            File unZippedDir = new File(this.zipfile.getParentFile(), this.getUnZippedDirName());
            if (!unZippedDir.exists()) {
                unZippedDir.mkdir();
            }
            File rootDir = unZippedDir.getParentFile();
            ZipInputStream zis = new ZipInputStream(new FileInputStream(this.zipfile));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                int len;
                File zipEntryFile = new File(rootDir, zipEntry.getName());
                if (zipEntry.getName().endsWith("/")) {
                    if (!zipEntryFile.exists()) {
                        zipEntryFile.mkdir();
                    }
                    zipEntry = zis.getNextEntry();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(zipEntryFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (Exception e) {
            Cutter.setLog("UnZipper.restore() - " + e);
            return false;
        }
        return true;
    }

    public File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    private String[] getSubFilesOf(File file) {
        String path = file.getPath();
        Vector<String> listOfSubs = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(file.getPath(), "" + File.separatorChar);
        Vector<String> subDir = new Vector<String>();
        while (tok.hasMoreTokens()) {
            subDir.addElement(tok.nextToken());
        }
        String subPath = "";
        for (int n = 0; n < subDir.size(); ++n) {
            subPath = subPath.length() == 0 ? (String)subDir.elementAt(n) : subPath + File.separatorChar + (String)subDir.elementAt(n);
            listOfSubs.addElement(subPath);
        }
        return this.vectorToArray(listOfSubs);
    }

    private String[] vectorToArray(Vector v) {
        String[] out = new String[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (String)v.elementAt(n);
        }
        return out;
    }
}

