/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Mover;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KButton.PathSearchButton;
import UI_Components.KLabel;
import UI_Components.KLabelledField;
import UI_Components.KTabbedPane.KTabPanel;
import UI_Components.KTextArea;
import UI_Components.KTextField.KIntTextField;
import UI_Components.KTitledPanel;
import UI_Tools.Mover.WatcherThread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WatcherTabPanel
extends KTabPanel {
    private static String RUN = " Start ";
    private static String KILL = " Stop ";
    private PathsPanel pathsPanel;
    private OptionsPanel optionsPanel;
    private KTextArea resultsArea = new KTextArea(8, 10);
    private JButton runButton = new JButton(RUN);
    private WatcherThread watcher = null;

    public WatcherTabPanel(int srcPrefID, int destPrefID, int maxDirSizeID, int maxFileSizeID) {
        this.pathsPanel = new PathsPanel(srcPrefID, destPrefID);
        this.optionsPanel = new OptionsPanel(maxDirSizeID, maxFileSizeID);
        this.resultsArea.setMargin(new Insets(2, 5, 2, 1));
        this.resultsArea.setEditable(false);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.resultsArea);
        scroller.setPreferredSize(new Dimension(250, 150));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.pathsPanel, new GBC(0, 0, 4, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.add((Component)this.optionsPanel, new GBC(0, 1, 4, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.add((Component)scroller, new GBC(0, 2, 4, 1, 1.0, 1.0, 0, 0, 12, 1, new Insets(5, 7, 5, 7)));
        this.add((Component)this.runButton, new GBC(3, 3, 1, 1, 1.0, 0.0, 0, 0, 13, 0, new Insets(5, 5, 5, 8)));
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WatcherTabPanel.this.runButton.getText().equals(RUN)) {
                    String srcPath = ((PathsPanel)((WatcherTabPanel)WatcherTabPanel.this).pathsPanel).srcField.field.getText();
                    String dstPath = ((PathsPanel)((WatcherTabPanel)WatcherTabPanel.this).pathsPanel).destField.field.getText();
                    File dropBox = new File(srcPath);
                    File destDir = new File(dstPath);
                    if (dropBox.exists() && destDir.exists()) {
                        WatcherTabPanel.this.watcher = new WatcherThread(dropBox, destDir, WatcherTabPanel.this.resultsArea);
                        WatcherTabPanel.this.watcher.start();
                        WatcherTabPanel.this.runButton.setText(KILL);
                    } else {
                        WatcherTabPanel.this.runButton.setText("Path Error");
                    }
                } else if (WatcherTabPanel.this.runButton.getText().equals(KILL)) {
                    if (WatcherTabPanel.this.watcher != null) {
                        ((WatcherTabPanel)WatcherTabPanel.this).watcher.doRun = false;
                    }
                    WatcherTabPanel.this.runButton.setText(RUN);
                }
            }
        });
    }

    public void saveSelf() {
        this.pathsPanel.saveSelf();
        this.optionsPanel.saveSelf();
    }

    private class PathsPanel
    extends KTitledPanel {
        private KLabelledField srcField;
        private PathSearchButton srcSearch;
        private KLabelledField destField;
        private PathSearchButton destSearch;
        private int srcPrefID;
        private int destPrefID;

        public PathsPanel(int srcPrefID, int destPrefID) {
            super(" Paths ");
            this.srcField = new KLabelledField(" Source Dir", 18, "");
            this.srcSearch = new PathSearchButton(this.srcField, "?", "Choose Directory", 1);
            this.destField = new KLabelledField(" Dest Dir   ", 18, "");
            this.destSearch = new PathSearchButton(this.destField, "?", "Choose Directory", 1);
            this.srcPrefID = srcPrefID;
            this.destPrefID = destPrefID;
            if (srcPrefID > 0) {
                this.srcField.field.setText(Preferences.get(srcPrefID));
            }
            if (destPrefID > 0) {
                this.destField.field.setText(Preferences.get(destPrefID));
            }
            this.srcField.field.usesModelDialog = true;
            this.destField.field.usesModelDialog = true;
            this.add(this.srcField, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 0, 0)));
            this.add(this.srcSearch, new GBC(1, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 5)));
            this.add(this.destField, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 0, 0)));
            this.add(this.destSearch, new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 0, 5)));
        }

        private void saveSelf() {
            if (this.srcPrefID > 0) {
                Preferences.write(this.srcPrefID, this.srcField.field.getText());
            }
            if (this.destPrefID > 0) {
                Preferences.write(this.destPrefID, this.destField.field.getText());
            }
        }

        public void updateUI(File f) {
            this.saveSelf();
        }

        public String getPath() {
            return "";
        }
    }

    private class OptionsPanel
    extends KTitledPanel {
        KLabel maxDirLabel;
        KIntTextField maxDirSize;
        KLabel maxFileLabel;
        KIntTextField maxFileSize;
        private int maxDirSizeID;
        private int maxFileSizeID;

        public OptionsPanel(int maxDirSizeID, int maxFileSizeID) {
            super(" Options ");
            this.maxDirLabel = new KLabel(" Max Directory Size (MB) ");
            this.maxDirSize = new KIntTextField(3);
            this.maxFileLabel = new KLabel(" Max File Size (MB)");
            this.maxFileSize = new KIntTextField(3);
            this.maxDirSizeID = maxDirSizeID;
            this.maxFileSizeID = maxFileSizeID;
            this.maxDirSize.setText(Preferences.get(maxDirSizeID));
            this.maxFileSize.setText(Preferences.get(maxFileSizeID));
            this.add(this.maxDirLabel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(5, 5, 0, 0)));
            this.add(this.maxDirSize, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(5, 5, 0, 0)));
            this.add(this.maxFileLabel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(5, 5, 5, 0)));
            this.add(this.maxFileSize, new GBC(1, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(5, 5, 5, 0)));
            this.add(new JPanel(), new GBC(2, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(5, 5, 5, 20)));
        }

        private void saveSelf() {
            if (this.maxDirSize.getInt() != null) {
                Preferences.write(this.maxDirSizeID, this.maxDirSize.getInt());
            }
            if (this.maxFileSize.getInt() != null) {
                Preferences.write(this.maxFileSizeID, this.maxFileSize.getInt());
            }
        }
    }
}

