/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Mover;

import UI_Components.KTextArea;
import UI_Tools.Mover.FileQuerry;
import UI_Tools.Mover.UnZipper;
import UI_Tools.Mover.Zipper;
import Utilities.FileUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Vector;

public class WatcherThread
extends Thread {
    public static final int SLEEP_TIME = 500;
    public static final int BUILD_TIME = 5000;
    private File dropbox;
    private File destDir;
    private KTextArea resultsArea;
    public boolean doRun = true;
    private Vector<String> validUserNames;
    private static int report_counter = 0;

    public WatcherThread(File dropBox, File destDir, KTextArea resultsArea) {
        this.dropbox = dropBox;
        this.destDir = destDir;
        this.resultsArea = resultsArea;
    }

    @Override
    public void run() {
        this.validUserNames = this.getValidUserNames(this.destDir);
        this.resultsArea.append("Number of validUserNames = " + this.validUserNames.size() + "\n");
        StringBuffer buff = new StringBuffer();
        while (this.doRun) {
            try {
                WatcherThread.sleep(500L);
            }
            catch (InterruptedException e) {
                System.out.println("Exception during sleep 1 " + e);
                continue;
            }
            File userDir = this.pickUserDirectory(this.dropbox, this.validUserNames);
            if (userDir == null) continue;
            FileQuerry fq1 = new FileQuerry(userDir);
            long size1 = fq1.getTotalSize();
            try {
                WatcherThread.sleep(2000L);
            }
            catch (InterruptedException e) {
                System.out.println("Exception during sleep 2 " + e);
                continue;
            }
            FileQuerry fq2 = new FileQuerry(userDir);
            long size2 = fq2.getTotalSize();
            if (size1 != size2) continue;
            this.resultsArea.append("_____________________________\n");
            try {
                FileQuerry q;
                String user_name = userDir.getName();
                File dropBoxZipFile = new File(this.dropbox, user_name + ".zip");
                this.resultsArea.append("Writing: \"" + dropBoxZipFile.getName() + "\"\n");
                Zipper zipper = new Zipper(userDir, dropBoxZipFile, this.resultsArea);
                zipper.save();
                if (!dropBoxZipFile.exists()) {
                    this.resultsArea.append("Error: \"" + dropBoxZipFile.getName() + "\" was not written.\n");
                    continue;
                }
                File destZipFile = zipper.duplicateZipTo(this.destDir);
                if (destZipFile == null || !destZipFile.exists()) {
                    this.resultsArea.append("Error: failed to save \"" + destZipFile.getPath() + "\".\n");
                    continue;
                }
                this.resultsArea.append("Copied: \"" + destZipFile.getName() + "\" to \"" + this.destDir.getName() + "\"\n");
                UnZipper unzipper = new UnZipper(destZipFile);
                unzipper.restore();
                if (!destZipFile.exists()) {
                    this.resultsArea.append("Error: unable to unzip \"" + dropBoxZipFile.getName() + "\" in the web folder.\n");
                    continue;
                }
                if (!destZipFile.delete()) {
                    this.resultsArea.append("Error: unable to delete \"" + dropBoxZipFile.getName() + "\" in the web folder.\n");
                    continue;
                }
                if (!dropBoxZipFile.delete()) {
                    this.resultsArea.append("Error: unable to delete \"" + dropBoxZipFile.getName() + "\" from dropbox.\n");
                    continue;
                }
                if (userDir.exists() && !(q = new FileQuerry(userDir)).delete()) {
                    this.resultsArea.append("Error: unable to delete \"" + userDir.getName() + "\" from dropbox.\n");
                    continue;
                }
                q = new FileQuerry(userDir);
                q.delete();
            }
            catch (Exception ex) {}
        }
    }

    private Vector<String> getValidUserNames(File destDir) {
        Vector<String> validUserNames = new Vector<String>();
        String[] list = destDir.list();
        if (list == null || list.length == 0) {
            return validUserNames;
        }
        for (int n = 0; n < list.length; ++n) {
            File f = new File(destDir, list[n]);
            if (f == null || f.isDirectory() || !f.getName().equals("security.txt")) continue;
            String[] names = FileUtils.readLinesAsArray(f.getPath());
            if (names == null || names.length == 0) {
                return validUserNames;
            }
            for (int i = 0; i < names.length; ++i) {
                String name = names[i].trim();
                if (name.length() <= 0) continue;
                validUserNames.add(name);
            }
            return validUserNames;
        }
        return validUserNames;
    }

    public File pickUserDirectory(File dropBoxDir, Vector<String> validUserNames) {
        if (dropBoxDir == null) {
            this.resultsArea.append("Error: Mover.WatcherThread.pickUserDirectory() - dropBoxDir is null.\n");
            return null;
        }
        String[] list = dropBoxDir.list();
        if (list == null || list.length == 0) {
            return null;
        }
        Vector<File> listOfUserDirs = new Vector<File>();
        for (int n = 0; n < list.length; ++n) {
            String[] docs;
            File f = new File(dropBoxDir, list[n]);
            if (f == null || !f.isDirectory() || (docs = f.list()) == null || docs.length == 0) continue;
            if (validUserNames.size() == 0) {
                listOfUserDirs.addElement(f);
            }
            if (!VectorUtils.contains(validUserNames, f.getName())) continue;
            listOfUserDirs.addElement(f);
        }
        if (listOfUserDirs.size() == 0) {
            return null;
        }
        int i = WatcherThread.randBetween(0, listOfUserDirs.size());
        return (File)listOfUserDirs.elementAt(i);
    }

    public static synchronized int randBetween(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }
}

