/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Mover;

import UI_Components.KTextArea;
import UI_Desktop.Cutter;
import UI_Tools.Mover.FileQuerry;
import UI_Tools.Mover.MoverTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private File dropBoxUserDir;
    private File outputZipFile;
    private byte[] buff = new byte[MoverTool.BUFFER_SIZE];
    private String[] acceptablePaths;
    private KTextArea resultsArea;

    public Zipper(File dropBoxUserDir, File destZipFile, KTextArea resultsArea) {
        this.dropBoxUserDir = dropBoxUserDir;
        this.outputZipFile = destZipFile;
        this.resultsArea = resultsArea;
        FileQuerry querry = new FileQuerry(dropBoxUserDir);
        String[] rawPaths = querry.getAllPaths();
        this.acceptablePaths = querry.trim(rawPaths, dropBoxUserDir.getParentFile());
    }

    public void save() {
        if (this.acceptablePaths == null || this.acceptablePaths.length == 0 || this.dropBoxUserDir == null) {
            return;
        }
        File dropBoxDir = this.dropBoxUserDir.getParentFile();
        long totalSize = 0L;
        try {
            FileOutputStream filestream = new FileOutputStream(this.outputZipFile);
            ZipOutputStream zipstream = new ZipOutputStream(filestream);
            this.resultsArea.append("zipping " + this.acceptablePaths.length + " entries/n");
            for (int i = 0; i < this.acceptablePaths.length; ++i) {
                int numBytes;
                String name;
                String relativePath = this.acceptablePaths[i];
                if (relativePath == null) continue;
                File entry = new File(dropBoxDir, relativePath);
                if (entry.isDirectory()) {
                    ZipEntry zipentry = new ZipEntry(!relativePath.endsWith("/") ? relativePath + "/" : relativePath);
                    zipstream.putNextEntry(zipentry);
                    zipstream.closeEntry();
                    continue;
                }
                File inputFile = new File(dropBoxDir, relativePath);
                if (inputFile.isDirectory() || !inputFile.exists() || (name = inputFile.getName()).trim().length() == 0 || name.length() > 0 && name.charAt(0) == '.') continue;
                totalSize += inputFile.length();
                FileInputStream inputstream = new FileInputStream(inputFile);
                ZipEntry zipentry = new ZipEntry(relativePath);
                zipstream.putNextEntry(zipentry);
                while ((numBytes = inputstream.read(this.buff, 0, this.buff.length)) != -1) {
                    zipstream.write(this.buff, 0, numBytes);
                }
                zipstream.closeEntry();
                inputstream.close();
            }
            zipstream.close();
            filestream.close();
        }
        catch (IOException e) {
            Cutter.setLog("Zipper.save() - " + e.toString());
            return;
        }
    }

    public File duplicateZipTo(File destDir) {
        if (!(this.outputZipFile != null && this.outputZipFile.exists() && destDir.exists() && destDir.isDirectory())) {
            return null;
        }
        File file = new File(destDir, this.outputZipFile.getName());
        try {
            int numBytes;
            FileInputStream inputstream = new FileInputStream(this.outputZipFile);
            FileOutputStream outputstream = new FileOutputStream(file);
            while ((numBytes = inputstream.read(this.buff, 0, this.buff.length)) != -1) {
                outputstream.write(this.buff, 0, numBytes);
            }
            inputstream.close();
            outputstream.close();
        }
        catch (IOException e) {
            System.out.println(e);
            return null;
        }
        return file;
    }

    public void updateZipperCount(int num) {
        String s = this.resultsArea.getText();
        s = num > 0 ? s.replaceAll("zipping [\\d]+", "" + num) : s.replaceAll("zipping [\\d]+", "");
        this.resultsArea.setText(s);
    }
}

