/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Net.Panels;

import UI_Components.Dialog.OpenFileDialog;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.Net.NetTool;
import Utilities.FileUtils;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class FilesPanel
extends KTitledPanel {
    PathsPanel srcPanel;
    PathsPanel dstPanel;

    public FilesPanel(NetTool tool, String title, String fStates) {
        super(title);
        final KButton addButton = new KButton("Add");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilesPanel.this.srcPanel.showField();
                addButton.setEnabled(FilesPanel.this.dstPanel.showField());
                NetTool.tool.pack();
            }
        });
        final KButton subButton = new KButton("Remove");
        subButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilesPanel.this.srcPanel.showField();
                subButton.setEnabled(FilesPanel.this.dstPanel.showField());
                NetTool.tool.pack();
            }
        });
        this.dstPanel = new PathsPanel(" Remote Files ", null, null);
        this.srcPanel = new PathsPanel(" Local Files ", fStates, this.dstPanel.getFields());
        this.add(this.srcPanel, new GBC(0, 1, 1, 1, 0.0, 0.0, 1, 1, 12, 2, new Insets(0, 5, 5, 5)));
        this.add(this.dstPanel, new GBC(1, 1, 1, 1, 1.0, 1.0, 1, 1, 12, 2, new Insets(0, 5, 5, 5)));
    }

    public void saveSelf() {
        this.srcPanel.saveSelf();
        this.dstPanel.saveSelf();
    }

    public String[] getSrcPaths() {
        return this.srcPanel.getPaths();
    }

    public boolean[] getActive() {
        return this.srcPanel.getActive();
    }

    public String[] getDstPaths() {
        return this.dstPanel.getPaths();
    }

    public class PathsPanel
    extends KTitledPanel {
        int initialVisible;
        int index;
        int maxnum;
        private Vector<PathField> others;
        private Vector<PathField> fields;
        private Vector<JCheckBox> cboxes;

        public PathsPanel(String name, String fStates, Vector<PathField> others) {
            boolean vis;
            super(name);
            this.initialVisible = 8;
            this.index = this.initialVisible + 1;
            this.maxnum = 8;
            this.others = null;
            this.fields = new Vector();
            this.cboxes = new Vector();
            int num = 0;
            boolean bl = vis = fStates != null;
            if (others != null) {
                this.others = others;
            }
            for (int n = 0; n < this.maxnum; ++n) {
                boolean last = n == this.maxnum - 1;
                JCheckBox cbox = new JCheckBox();
                PathField other = others != null ? others.elementAt(n) : null;
                PathField tf = new PathField("NetTool.sendfiles." + name.trim() + n, 15, cbox, other);
                this.fields.addElement(tf);
                if (vis) {
                    if (fStates.length() >= this.maxnum && fStates.charAt(n) == '1') {
                        cbox.setSelected(true);
                    }
                    this.cboxes.addElement(cbox);
                    this.add(cbox, new GBC(0, num + 1, 1, 1, 0.0, 0.0, 1, 1, 11, 2, new Insets(0, 0, 0, 0)));
                    this.add(tf, new GBC(1, num + 1, 1, 1, 1.0, (double)last, 1, 1, 11, 2, new Insets(1, 0, 0, 5)));
                    if (n > this.initialVisible) {
                        cbox.setVisible(false);
                    }
                } else if (n == 0) {
                    this.add(tf, new GBC(0, num, 1, 1, 1.0, (double)last, 1, 1, 11, 2, new Insets(1, 5, 2, 5)));
                } else {
                    this.add(tf, new GBC(0, num, 1, 1, 1.0, (double)last, 1, 1, 11, 2, new Insets(0, 5, 2, 5)));
                }
                if (n > this.initialVisible) {
                    tf.setVisible(false);
                }
                ++num;
            }
        }

        public boolean[] getActive() {
            if (this.cboxes.size() == 0) {
                return null;
            }
            boolean[] result = new boolean[this.maxnum];
            for (int n = 0; n < this.cboxes.size(); ++n) {
                result[n] = this.cboxes.elementAt(n).isSelected();
            }
            return result;
        }

        public String[] getPaths() {
            String[] result = new String[this.maxnum];
            for (int n = 0; n < this.fields.size(); ++n) {
                result[n] = this.fields.elementAt(n).getText();
            }
            return result;
        }

        public boolean showField() {
            if (this.index == this.maxnum - 1) {
                return false;
            }
            this.fields.elementAt(this.index).setVisible(true);
            if (this.cboxes.size() > 0) {
                this.cboxes.elementAt(this.index).setVisible(true);
            }
            ++this.index;
            return true;
        }

        public Vector<PathField> getFields() {
            return this.fields;
        }

        public void saveSelf() {
            for (int n = 0; n < this.maxnum; ++n) {
                this.fields.elementAt(n).saveSelf();
            }
        }
    }

    public class PathField
    extends KSerialTextField {
        private OpenFileDialog openFileDialog;
        private File prevFile;
        private JCheckBox cbox;
        private PathField other;

        public PathField(String cerealname, int width, JCheckBox box, final PathField other) {
            super(cerealname, "", width);
            this.openFileDialog = OpenFileDialog.getInstance(Cutter.desktop);
            this.prevFile = FileUtils.getPWDFile();
            this.other = null;
            this.cbox = box;
            this.other = other;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        if (PathField.this.openFileBrowser() != null) {
                            PathField.this.cbox.setSelected(true);
                            if (other != null) {
                                other.setText(PathField.this.getText());
                            }
                        } else {
                            PathField.this.cbox.setSelected(false);
                        }
                    }
                }
            });
            this.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    String fieldText = PathField.this.getText();
                    String fullpath = FileUtils.relativeToFull(FileUtils.getPWD(), PathField.this.getText());
                    PathField.this.setToolTipText(fullpath);
                }
            });
        }

        private File openFileBrowser() {
            String fieldText = this.getText();
            String fullpath = FileUtils.relativeToFull(FileUtils.getPWD(), fieldText);
            this.setToolTipText(fullpath);
            File tmp = FileUtils.getParentDirFromPath(fullpath);
            this.prevFile = fieldText.trim().length() == 0 ? FileUtils.getPWDFile() : (tmp != null && tmp.exists() ? tmp : FileUtils.getExistingParent(tmp));
            if (this.prevFile == null) {
                this.prevFile = FileUtils.getPWDFile();
            }
            File f = this.openFileDialog.getPrevFile();
            this.openFileDialog.setCurrentDirectory(this.prevFile);
            File[] files = this.openFileDialog.showSelf(null, "Select", 2);
            if (files == null) {
                this.openFileDialog.setPrevFile(f);
                return null;
            }
            fullpath = files[0].getPath();
            String relative = FileUtils.fullToRelative(FileUtils.getPWD(), files[0].getPath(), "");
            this.setText(relative);
            return files[0];
        }
    }
}

