/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Net.Panels;

import UI_Components.Dialog.OpenFileDialog;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.Net.NetTool;
import Utilities.FileUtils;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JCheckBox;

public class IPsPanel
extends KTitledPanel {
    private Vector<PathField> ipFields = new Vector();
    private Vector<JCheckBox> cboxes = new Vector();
    int maxIPs = 10;
    int charWidth = 15;

    public IPsPanel(NetTool tool, String title, String ipStates) {
        super(title, 2);
        int num = 0;
        int cboxCounter = 0;
        for (int n = 0; n < this.maxIPs; ++n) {
            boolean last = n == this.maxIPs - 1;
            PathField tf = new PathField("NetTool.sendfiles.ips.a." + n, this.charWidth);
            this.ipFields.addElement(tf);
            JCheckBox cbox = new JCheckBox();
            if (ipStates.length() >= this.maxIPs * 2 && ipStates.charAt(cboxCounter) == '1') {
                cbox.setSelected(true);
            }
            ++cboxCounter;
            this.cboxes.addElement(cbox);
            this.add(cbox, new GBC(0, num + 1, 1, 1, 0.0, 0.0, 1, 1, 17, 0, new Insets(-1, 10, -1, 0)));
            this.add(tf, new GBC(1, num + 1, 1, 1, 0.0, (double)last, 1, 1, 17, 0, new Insets(-1, 0, -1, 5)));
            tf = new PathField("NetTool.sendfiles.ips.b." + n, this.charWidth);
            this.ipFields.addElement(tf);
            cbox = new JCheckBox();
            if (ipStates.length() >= this.maxIPs * 2 && ipStates.charAt(cboxCounter) == '1') {
                cbox.setSelected(true);
            }
            ++cboxCounter;
            this.cboxes.addElement(cbox);
            this.add(cbox, new GBC(2, num + 1, 1, 1, 0.0, 0.0, 1, 1, 17, 0, new Insets(-1, 10, -1, 0)));
            this.add(tf, new GBC(3, num + 1, 1, 1, 1.0, (double)last, 1, 1, 17, 0, new Insets(-1, 0, -1, 5)));
            ++num;
        }
        ActionListener cboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        KButton addButton = new KButton("Add");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetTool.tool.pack();
            }
        });
    }

    public void saveSelf() {
        for (int n = 0; n < this.ipFields.size(); ++n) {
            this.ipFields.elementAt(n).saveSelf();
        }
    }

    public String[] getIPs() {
        String[] result = new String[this.maxIPs * 2];
        for (int n = 0; n < this.ipFields.size(); ++n) {
            result[n] = this.ipFields.elementAt(n).getText();
        }
        return result;
    }

    public boolean[] getStates() {
        boolean[] result = new boolean[this.maxIPs * 2];
        for (int n = 0; n < this.cboxes.size(); ++n) {
            result[n] = this.cboxes.elementAt(n).isSelected();
        }
        return result;
    }

    public class PathField
    extends KSerialTextField {
        private OpenFileDialog openFileDialog;
        private File prevFile;

        public PathField(String cerealname, int width) {
            super(cerealname, "", width);
            this.openFileDialog = OpenFileDialog.getInstance(Cutter.desktop);
            this.prevFile = FileUtils.getPWDFile();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
        }
    }
}

