/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Net;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Desktop.Cutter;
import UI_Script.Cutlet.CutletScriptHandler;
import UI_Tools.Net.NetTool;
import UI_Tools.Net.Panels.FilesPanel;
import UI_Tools.Net.Panels.IPsPanel;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import Utilities.DateTimeUtils;
import Utilities.FileUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class SendFilesTabPanel
extends PrefsPanel {
    private static final String panelName = "Send Commands";
    FilesPanel filesPanel = null;
    IPsPanel ipsPanel = null;
    NetTool tool = null;

    public SendFilesTabPanel(NetTool tool) {
        String fstates = Preferences.get(Preferences.TOOL_NET_SENDFILES_FILE_STATES);
        String ipstates = Preferences.get(Preferences.TOOL_NET_SENDFILES_IP_STATES);
        this.filesPanel = new FilesPanel(tool, " File Locations ", fstates);
        this.ipsPanel = new IPsPanel(tool, " IP Recipients ", ipstates);
        this.add((Component)this.filesPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 1, 1, 17, 2, new Insets(5, 5, 5, 5)));
        this.add((Component)this.ipsPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 1, 1, 17, 2, new Insets(5, 5, 5, 5)));
        KButton sendButton = new KButton("Send");
        sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendFilesTabPanel.this.WriteCutletScript();
            }
        });
        this.add((Component)sendButton, new GBC(0, 2, 1, 1, 1.0, 1.0, 1, 1, 13, 0, new Insets(5, 5, 5, 7)));
    }

    private void WriteCutletScript() {
        String[] srcPaths = this.filesPanel.getSrcPaths();
        String[] dstPaths = this.filesPanel.getDstPaths();
        boolean[] activePaths = this.filesPanel.getActive();
        StringBuffer buf = new StringBuffer();
        buf.append("# ").append(DateTimeUtils.getDateStamp()).append('\n');
        for (int n = 0; n < activePaths.length; ++n) {
            String src = srcPaths[n].trim();
            String dst = dstPaths[n].trim();
            if (dst.startsWith("./")) {
                dst = "../" + dst.substring(2);
            } else if (dst.startsWith("../")) {
                dst = "../" + dst;
            }
            if (!activePaths[n] || src.length() <= 0 || dst.length() <= 0) continue;
            buf.append("file.save -src ");
            buf.append("\"").append(src).append("\"");
            buf.append(" -name ");
            buf.append(" \"").append(dst).append("\"\n");
        }
        boolean[] activeIPs = this.ipsPanel.getStates();
        String[] ips = this.ipsPanel.getIPs();
        for (int n = 0; n < activeIPs.length; ++n) {
            if (!activeIPs[n] || ips[n].trim().length() <= 0) continue;
            buf.append(ips[n]).append('\n');
        }
        File out = new File(FileUtils.getPWD(), "send_files_test.cutlet");
        FileUtils.writeFile(out, buf.toString());
        String script = buf.toString().trim();
        CutletScriptHandler handler = new CutletScriptHandler();
        handler.execute(script);
        Cutter.setLog("______ Cutlet Script Begin ______");
        Cutter.setLog(script);
        Cutter.setLog("_______ Cutlet Script End _______\n");
    }

    public void saveSelf() {
        this.filesPanel.saveSelf();
        this.ipsPanel.saveSelf();
        StringBuffer buf = new StringBuffer();
        boolean[] activeFiles = this.filesPanel.getActive();
        for (int n = 0; n < activeFiles.length; ++n) {
            buf.append(activeFiles[n] ? "1" : "0");
        }
        Preferences.write(Preferences.TOOL_NET_SENDFILES_FILE_STATES, buf.toString());
        buf = new StringBuffer();
        boolean[] activeIPs = this.ipsPanel.getStates();
        for (int n = 0; n < activeIPs.length; ++n) {
            buf.append(activeIPs[n] ? "1" : "0");
        }
        Preferences.write(Preferences.TOOL_NET_SENDFILES_IP_STATES, buf.toString());
    }

    @Override
    public void readFromPrefs() {
    }

    @Override
    public String getName() {
        return panelName;
    }
}

