/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.PlaceCamera;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KTextArea;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Script.Rib.RibScriptHandler;
import UI_Tools.KTools;
import Utilities.FileUtils;
import Utilities.NumberUtils;
import Utilities.Point3D;
import Utilities.TextUtils;
import Utilities.TransformUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;

public class PlaceCameraTool
extends KTools {
    private static KTitledPanel inputPanel = new KTitledPanel(" Camera ", "PlaceCameraTool.InputPanel.info");
    private static KTitledPanel outputPanel = new KTitledPanel(" Transformations ", "PlaceCameraTool.OutputPanel.info");
    private static JButton calcButton = new JButton(" Preview ");
    private static JButton applyButton = new JButton(" Apply ");
    private static int width;
    private static int height;
    private static JPanel fromPanel;
    private static JPanel toPanel;
    private static KTextField[] xyzFrom;
    private static KTextField[] xyzTo;
    private static KTextArea textarea;
    private static PlaceCameraTool tool;

    public static PlaceCameraTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new PlaceCameraTool(menuItem);
        return tool;
    }

    private PlaceCameraTool(JMenuItem menuItem) {
        super("Place Camera Tool", menuItem, Preferences.TOOL_RENDERMAN_PLACECAMERA);
        for (int n = 0; n < 3; ++n) {
            PlaceCameraTool.xyzFrom[n] = new KTextField(6);
            PlaceCameraTool.xyzTo[n] = new KTextField(6);
            xyzFrom[n].setText("5.0");
            xyzTo[n].setText("0.0");
        }
        this.initFields();
        width = this.getSize().width;
        height = this.getSize().height;
        fromPanel.setLayout(new GridBagLayout());
        toPanel.setLayout(new GridBagLayout());
        fromPanel.add((Component)new JLabel("Look From"), new GBC(0, 0, 2, 1, 1.0, 1.0, 0, 0, 10, 2, new Insets(2, 15, 5, 15)));
        fromPanel.add((Component)new JLabel("X"), new GBC(0, 1, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 0, 5, 2)));
        fromPanel.add((Component)xyzFrom[0], new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 2, 5, 2)));
        fromPanel.add((Component)new JLabel("Y"), new GBC(0, 2, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 0, 5, 2)));
        fromPanel.add((Component)xyzFrom[1], new GBC(1, 2, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 2, 5, 2)));
        fromPanel.add((Component)new JLabel("Z"), new GBC(0, 3, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 0, 5, 2)));
        fromPanel.add((Component)xyzFrom[2], new GBC(1, 3, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 2, 5, 2)));
        toPanel.add((Component)new JLabel(" Look To "), new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 10, 2, new Insets(2, 15, 5, 15)));
        toPanel.add((Component)xyzTo[0], new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 10, 2, new Insets(0, 2, 5, 2)));
        toPanel.add((Component)xyzTo[1], new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 10, 2, new Insets(0, 2, 5, 2)));
        toPanel.add((Component)xyzTo[2], new GBC(0, 3, 1, 1, 1.0, 1.0, 0, 0, 10, 2, new Insets(0, 2, 5, 2)));
        inputPanel.add(fromPanel, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 18, 2, new Insets(0, 13, 0, 0)));
        inputPanel.add(toPanel, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 2, new Insets(0, 5, 0, 15)));
        calcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaceCameraTool.this.doCalc();
            }
        });
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaceCameraTool.this.doApply();
            }
        });
        calcButton.setMargin(new Insets(1, 5, 1, 5));
        applyButton.setMargin(new Insets(1, 5, 1, 5));
        textarea.setBorder(BorderFactory.createEtchedBorder());
        outputPanel.add(textarea, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 10, 1, new Insets(2, 5, 5, 5)));
        textarea.setText("\n\n\n\n\n\n");
        textarea.setEditable(false);
        this.contentPane.add((Component)inputPanel, new GBC(0, 0, 4, 2, 1.0, 1.0, 0, 0, 12, 1, new Insets(5, 5, 3, 5)));
        this.contentPane.add((Component)outputPanel, new GBC(0, 2, 4, 2, 1.0, 1.0, 0, 0, 12, 1, new Insets(3, 5, 5, 5)));
        this.contentPane.add((Component)calcButton, new GBC(0, 4, 2, 1, 0.0, 0.0, 0, 0, 12, 0, new Insets(5, 8, 10, 10)));
        this.contentPane.add((Component)applyButton, new GBC(2, 4, 2, 1, 1.0, 1.0, 0, 0, 12, 3, new Insets(5, 0, 10, 10)));
        this.setTitle(this.title);
        this.pack();
        this.setInitialPosition();
        this.setVisible(false);
    }

    @Override
    protected void toolSelectionHappened() {
        if (this.lastFocusedComponent == null) {
            xyzFrom[0].requestFocus();
            xyzFrom[0].selectAll();
        } else {
            this.lastFocusedComponent.requestFocus();
            this.lastFocusedComponent.selectAll();
        }
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
        this.lastFocusedComponent = compLostFocus;
    }

    @Override
    protected void adjustUI(String docExt) {
        if (docExt == null) {
            applyButton.setEnabled(false);
            return;
        }
        String ext = FileUtils.getExtension(docExt);
        if (ext == null) {
            applyButton.setEnabled(false);
            return;
        }
        ext = ext.toLowerCase();
        if (docExt.endsWith(".rib") || docExt.endsWith(".RIB")) {
            applyButton.setEnabled(true);
        } else {
            applyButton.setEnabled(false);
        }
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    private String[] doCalc() {
        Point3D from = TransformUtils.toPoint3D(xyzFrom[0].getText(), xyzFrom[1].getText(), xyzFrom[2].getText());
        Point3D to = TransformUtils.toPoint3D(xyzTo[0].getText(), xyzTo[1].getText(), xyzTo[2].getText());
        StringBuffer header = new StringBuffer();
        header.append("# \"from\" [" + from.x + "   " + from.y + "   " + from.z + "]\n");
        header.append("# \"to\"   [" + to.x + "   " + to.y + "   " + to.z + "]\n");
        double[] tforms = TransformUtils.aimZ(from, to);
        if (tforms == null) {
            textarea.setText("Error: \"from\" and \"to\" must\nnot specify the same location");
            return null;
        }
        StringBuffer b = new StringBuffer();
        b.append("Translate 0 0 " + NumberUtils.clip(tforms[2]) + "\n");
        b.append("Rotate " + (tforms[0] > 0.0 ? " " : "") + NumberUtils.clip(tforms[0]) + "   1 0 0\n");
        b.append("Rotate " + (tforms[1] > 0.0 ? " " : "") + NumberUtils.clip(tforms[1]) + "   0 1 0\n");
        b.append("Translate " + NumberUtils.clip(to.x * -1.0) + " " + NumberUtils.clip(to.y * -1.0) + " " + NumberUtils.clip(to.z) + "\n");
        b.append("Scale 1 1 -1");
        textarea.setText(header.append(b).toString());
        String[] out = new String[]{header.toString(), b.toString()};
        return out;
    }

    private void doApply() {
        int[] endOffset;
        int[] beginOffset;
        String[] replacementTransforms = this.doCalc();
        if (replacementTransforms == null) {
            return;
        }
        if (!BBxt.isRibDocument()) {
            return;
        }
        Segment srcStr = BBxt.getWindowText(null);
        if (srcStr == null) {
            Cutter.setLog("    Warning: PlaceCameraTool.doCalc() front window has no text!");
            return;
        }
        String cameraBlock = RibScriptHandler.getCameraBlock(srcStr);
        if (cameraBlock == null) {
            Cutter.setLog("    Warning: PlaceCameraTool.doCalc() cannot find any camera statement before WorldBegin!");
            return;
        }
        int[] lineOffsets = RibScriptHandler.getOffsetsOfCameraTransforms(cameraBlock);
        if (lineOffsets == null) {
            Cutter.setLog("    Warning: PlaceCameraTool.doCalc() cannot find the camera transformations!");
            int linenum = BBxt.getLineNumberAtOffset(cameraBlock.length() > 1 ? cameraBlock.length() - 1 : 0);
            beginOffset = BBxt.getOffsetsOfLine(linenum);
            endOffset = BBxt.getOffsetsOfLine(linenum);
        } else {
            beginOffset = BBxt.getOffsetsOfLine(lineOffsets[0]);
            endOffset = BBxt.getOffsetsOfLine(lineOffsets[1]);
        }
        if (beginOffset == null || endOffset == null) {
            Cutter.setLog("    Warning: PlaceCameraTool.doCalc() cannot find the character offsets of the camera transformations!");
            return;
        }
        BBxt.setSelection(beginOffset[1], endOffset[2]);
        BBxt.paste(replacementTransforms[1] + "\n");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BBxt.execute();
            }
        });
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
        StringBuffer buf = new StringBuffer();
        buf.append(xyzFrom[0].getText() + " " + xyzFrom[1].getText() + " " + xyzFrom[2].getText() + " ");
        buf.append(xyzTo[0].getText() + " " + xyzTo[1].getText() + " " + xyzTo[2].getText());
        Preferences.write(Preferences.TOOL_RENDERMAN_PLACECAMERA_YUP_FROMTO, buf.toString());
    }

    private void initFields() {
        String str = Preferences.get(Preferences.TOOL_RENDERMAN_PLACECAMERA_YUP_FROMTO);
        if (str == null || str.trim().length() == 0) {
            return;
        }
        String[] tokens = TextUtils.tokenize(str);
        if (tokens.length != 6) {
            return;
        }
        xyzFrom[0].setText(tokens[0]);
        xyzFrom[1].setText(tokens[1]);
        xyzFrom[2].setText(tokens[2]);
        xyzTo[0].setText(tokens[3]);
        xyzTo[1].setText(tokens[4]);
        xyzTo[2].setText(tokens[5]);
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }

    static {
        fromPanel = new JPanel();
        toPanel = new JPanel();
        xyzFrom = new KTextField[3];
        xyzTo = new KTextField[3];
        textarea = new KTextArea(6, 17);
        tool = null;
    }
}

