/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Preferences.PrefsPanels.CutterUI;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KLabel;
import UI_Components.KTextField.KIntTextField;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Components.PrefsReadWriters.PrefColorFields;
import UI_Components.PrefsReadWriters.PrefTextFields;
import UI_Desktop.Cutter;
import UI_Script.Help.KCompletionManager;
import UI_Script.SyntaxListener;
import UI_Tools.KTools;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import Utilities.NumberUtils;
import Utilities.ResourceUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class UIGeneral
extends PrefsPanel {
    private static final long serialVersionUID = 1L;
    private static int[] maxSizePrefIDs = new int[]{Preferences.WINDOW_LOG_MAX_CHARS};
    private static final int FIELDWIDTH = 12;
    private KTitledPanel docPanel = new KTitledPanel(" Documents ");
    private TextPanel textPanel = new TextPanel();
    private RecentDocsPanel recentPanel = new RecentDocsPanel();
    private KTitledPanel logPanel = new KTitledPanel(" Log Window ");
    private PrefTextFields logFields = new PrefTextFields();
    private MetalPanel metalPanel = new MetalPanel();
    private String panelName = "ui general";
    private RightMarginPanel marginPanel = new RightMarginPanel();

    public UIGeneral() {
        String[] singleKey = new String[]{"user"};
        this.contentPanel.add(this.metalPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 11, 2, new Insets(0, 2, 2, 0)));
        this.contentPanel.add(this.docPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 11, 2, new Insets(0, 0, 2, 0)));
        this.contentPanel.add(this.marginPanel, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 2, 2, 0)));
        this.contentPanel.add(this.logPanel, new GBC(0, 3, 1, 1, 1.0, 1.0, 0, 0, 11, 2, new Insets(0, 2, 2, 0)));
        this.logFields.addField("Max Bytes ", singleKey, maxSizePrefIDs, 6, 3, false, false);
        this.logPanel.add(this.logFields, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 11, new Insets(0, 2, 2, 0)));
        this.docPanel.add(this.textPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 2, 2, 0)));
        this.docPanel.add(this.recentPanel, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 2, 2, 0)));
    }

    @Override
    public void readFromPrefs() {
        this.logFields.readFromPrefs();
    }

    @Override
    public void writeToPrefs() {
        this.textPanel.writeToPrefs();
        this.recentPanel.writeToPrefs();
        this.logFields.writeToPrefs();
        this.metalPanel.writeToPrefs();
        this.marginPanel.writeToPrefs();
        BBxt.setMarginWidth(this.marginPanel.getMarginWidth());
        super.writeToPrefs();
    }

    @Override
    public String getName() {
        return this.panelName;
    }

    private class TextPanel
    extends KTitledPanel {
        private int[] userFontSizePrefID;
        private int[] userFontWtPrefID;
        private String[] docColorAlt;
        private String[] caretColorAlt;
        private String[] hiliteColorAlt;
        private String[] secondariesColorAlt;
        private String[] dfHiliteColorAlt;
        private String[] notused;
        private int[] docColorPrefID;
        private int[] caretColorPrefID;
        private int[] hiliteColorPrefID;
        private int[] secondariesColorPrefID;
        private int[] dfHiliteColorPrefID;
        private PrefColorFields docBackColor;
        private PrefColorFields caretColor;
        private PrefColorFields hiliteColor;
        private PrefColorFields secondariesColor;
        private PrefColorFields dfHiliteColor;
        private FontComboGroup fontGroup;
        private KLabel synColorLabel;
        public KTextField maxBytesField;
        private JCheckBox syntaxOnOff;
        private JCheckBox numberingOnOff;
        private JCheckBox completionOnOff;

        public TextPanel() {
            super(" Text ", "UIGeneral.TextPanel.info");
            this.userFontSizePrefID = new int[]{Preferences.TEXT_FONT_SIZE};
            this.userFontWtPrefID = new int[]{Preferences.TEXT_FONT_WEIGHT};
            this.docColorAlt = new String[]{"document "};
            this.caretColorAlt = new String[]{"cursor "};
            this.hiliteColorAlt = new String[]{"focused selection "};
            this.secondariesColorAlt = new String[]{"secondary selections"};
            this.dfHiliteColorAlt = new String[]{"defocused selection "};
            this.notused = new String[]{"dummy"};
            this.docColorPrefID = new int[]{Preferences.DOCUMENT_BACKGROUND_COLOR};
            this.caretColorPrefID = new int[]{Preferences.DOCUMENT_CARET_COLOR};
            this.hiliteColorPrefID = new int[]{Preferences.DOCUMENT_CARET_SELECTION_COLOR};
            this.secondariesColorPrefID = new int[]{Preferences.DOCUMENT_SECONDARY_SELECTIONS_COLOR};
            this.dfHiliteColorPrefID = new int[]{Preferences.DOCUMENT_CARET_DEFOCUSED_SELECTION_COLOR};
            this.docBackColor = new PrefColorFields();
            this.caretColor = new PrefColorFields();
            this.hiliteColor = new PrefColorFields();
            this.secondariesColor = new PrefColorFields();
            this.dfHiliteColor = new PrefColorFields();
            this.fontGroup = new FontComboGroup();
            this.synColorLabel = new KLabel("syntax color ");
            this.maxBytesField = new KTextField(6);
            this.syntaxOnOff = new JCheckBox("  syntax coloration");
            this.numberingOnOff = new JCheckBox("  line numbering");
            this.completionOnOff = new JCheckBox("  typing completion");
            this.readFromPrefs();
            this.docBackColor.addField("document ", this.notused, this.docColorPrefID, 6, this.docColorAlt);
            this.caretColor.addField("cursor ", this.notused, this.caretColorPrefID, 6, this.caretColorAlt);
            this.hiliteColor.addField("focused selection ", this.notused, this.hiliteColorPrefID, 6, this.hiliteColorAlt);
            this.secondariesColor.addField("secondary selections ", this.notused, this.secondariesColorPrefID, 6, this.secondariesColorAlt);
            this.dfHiliteColor.addField("defocused selections ", this.notused, this.dfHiliteColorPrefID, 6, this.dfHiliteColorAlt);
            this.maxBytesField.setText(Preferences.get(Preferences.TEXT_COLOR_MAXLENGTH));
            String str = Preferences.get(Preferences.TEXT_COLOR_ACTIVE);
            this.syntaxOnOff.setSelected(str.equals("true"));
            str = Preferences.get(Preferences.DOCUMENT_LINENUMBERING_ACTIVE);
            this.numberingOnOff.setSelected(str.equals("true"));
            str = Preferences.get(Preferences.DOCUMENT_TYPINGCOMPLETION_ACTIVE);
            this.completionOnOff.setSelected(str.equals("true"));
            JPanel holder = new JPanel();
            holder.setLayout(new GridBagLayout());
            holder.add((Component)this.synColorLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(1, 0, 5, 0)));
            holder.add((Component)this.maxBytesField, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(1, 2, 5, 0)));
            this.synColorLabel.setBold(false);
            this.add(this.fontGroup, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 0, new Insets(0, 10, 2, 0)));
            this.add(this.docBackColor, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 13, 0, new Insets(5, 10, 0, 0)));
            this.add(this.caretColor, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 13, 0, new Insets(0, 10, 0, 0)));
            this.add(this.hiliteColor, new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 13, 0, new Insets(0, 10, 0, 0)));
            this.add(this.secondariesColor, new GBC(0, 4, 1, 1, 1.0, 0.0, 0, 0, 13, 0, new Insets(0, 10, 0, 0)));
            this.add(this.dfHiliteColor, new GBC(0, 5, 1, 1, 1.0, 0.0, 0, 0, 13, 0, new Insets(0, 10, 0, 0)));
            this.add(holder, new GBC(0, 6, 1, 1, 1.0, 0.0, 0, 0, 13, 0, new Insets(0, 2, 0, 5)));
            this.add(this.syntaxOnOff, new GBC(0, 7, 1, 1, 1.0, 0.0, 0, 0, 17, 0, new Insets(0, 10, 0, 5)));
            this.add(this.numberingOnOff, new GBC(0, 8, 1, 1, 1.0, 0.0, 0, 0, 17, 0, new Insets(0, 10, 0, 5)));
            this.add(this.completionOnOff, new GBC(0, 9, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 10, 0, 5)));
            this.syntaxOnOff.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean b = KTools.getCheckBoxState(e);
                    SyntaxListener.setUserWantsColoration(KTools.getCheckBoxState(e));
                }
            });
            this.numberingOnOff.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String str = TextPanel.this.numberingOnOff.isSelected() ? "true" : "false";
                    Preferences.write(Preferences.DOCUMENT_LINENUMBERING_ACTIVE, str);
                }
            });
            this.completionOnOff.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String str = TextPanel.this.completionOnOff.isSelected() ? "true" : "false";
                    Preferences.write(Preferences.DOCUMENT_TYPINGCOMPLETION_ACTIVE, str);
                    KCompletionManager.globalIsActive = str.equals("true");
                }
            });
        }

        public void writeToPrefs() {
            this.fontGroup.writeToPrefs();
            this.docBackColor.writeToPrefs();
            this.caretColor.writeToPrefs();
            this.hiliteColor.writeToPrefs();
            this.secondariesColor.writeToPrefs();
            this.dfHiliteColor.writeToPrefs();
            Preferences.write(Preferences.TEXT_COLOR_MAXLENGTH, this.maxBytesField.getText());
            String str = this.syntaxOnOff.isSelected() ? "true" : "false";
            Preferences.write(Preferences.TEXT_COLOR_ACTIVE, str);
            str = this.numberingOnOff.isSelected() ? "true" : "false";
            Preferences.write(Preferences.DOCUMENT_LINENUMBERING_ACTIVE, str);
            str = this.completionOnOff.isSelected() ? "true" : "false";
            Preferences.write(Preferences.DOCUMENT_TYPINGCOMPLETION_ACTIVE, str);
        }

        public void readFromPrefs() {
            this.fontGroup.readFromPrefs();
        }
    }

    private class RecentDocsPanel
    extends KTitledPanel {
        private MaxItemsCombo maxCombo;

        public RecentDocsPanel() {
            super(" Recent Documents ");
            this.maxCombo = new MaxItemsCombo();
            this.add(this.maxCombo, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 2, 2, 0)));
        }

        public void writeToPrefs() {
            this.maxCombo.writeToPrefs();
        }

        private class MaxItemsCombo
        extends JPanel {
            private final String[] items = new String[]{"10", "20", "30"};
            private JComboBox<String> maxCombo = new JComboBox<String>(this.items);
            private JLabel maxLabel = new JLabel("items ");

            public MaxItemsCombo() {
                this.readFromPrefs();
                this.maxCombo.setPreferredSize(new Dimension(45, 20));
                this.setLayout(new GridBagLayout());
                this.add((Component)this.maxLabel, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 10, 0, 0)));
                this.add(this.maxCombo, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 0, 0)));
            }

            public void writeToPrefs() {
                Preferences.write(Preferences.DOCUMENT_RECENT_MAX, (String)this.maxCombo.getSelectedItem());
            }

            public void readFromPrefs() {
                this.maxCombo.setSelectedItem(Preferences.get(Preferences.DOCUMENT_RECENT_MAX));
            }
        }
    }

    public class MetalPanel
    extends KTitledPanel {
        private ButtonGroup buttonGroup;
        private JRadioButton steelButton;
        private JRadioButton slateButton;
        private ImageIcon steelIcon;
        private ImageIcon graphiteIcon;

        public MetalPanel() {
            super(" GUI Theme ", "UIGeneral.MetalPanel.info");
            this.buttonGroup = new ButtonGroup();
            this.steelButton = new JRadioButton("steel");
            this.slateButton = new JRadioButton("slate");
            this.steelIcon = ResourceUtils.getIconResource("/resources/swing_steel.gif");
            this.graphiteIcon = ResourceUtils.getIconResource("/resources/swing_slate.gif");
            JPanel buttonPanel = new JPanel();
            JPanel samplePanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            samplePanel.setLayout(new GridBagLayout());
            this.add(buttonPanel, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 18, 11, new Insets(0, 0, 0, 10)));
            this.add(samplePanel, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 11, new Insets(0, 0, 5, 0)));
            buttonPanel.add((Component)this.steelButton, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 11, 2, new Insets(0, 5, -2, 0)));
            buttonPanel.add((Component)this.slateButton, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 11, 2, new Insets(-2, 5, 0, 0)));
            this.buttonGroup.add(this.steelButton);
            this.buttonGroup.add(this.slateButton);
            final JLabel sampleLabel = new JLabel(this.steelIcon);
            samplePanel.add((Component)sampleLabel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 10, 2, new Insets(0, 0, 0, 0)));
            String theme = Preferences.get(Preferences.GUI_SWING_THEME);
            if (theme.equals("metal")) {
                this.steelButton.setSelected(true);
                sampleLabel.setIcon(this.steelIcon);
            } else {
                this.slateButton.setSelected(true);
                sampleLabel.setIcon(this.graphiteIcon);
            }
            this.steelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sampleLabel.setIcon(MetalPanel.this.steelIcon);
                }
            });
            this.slateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sampleLabel.setIcon(MetalPanel.this.graphiteIcon);
                }
            });
        }

        public void writeToPrefs() {
            if (this.steelButton.isSelected()) {
                Preferences.write(Preferences.GUI_SWING_THEME, "metal");
            } else {
                Preferences.write(Preferences.GUI_SWING_THEME, "ktheme");
            }
        }
    }

    private class RightMarginPanel
    extends KTitledPanel {
        public KLabel marginLabel;
        public KIntTextField marginField;
        private PrefColorFields lineColor;
        private int[] lineColorPrefID;
        private String[] notused;
        private String[] altTitle;

        public RightMarginPanel() {
            super(" Right Margin Guide ");
            this.marginLabel = new KLabel("Chars");
            this.marginField = new KIntTextField(3);
            this.lineColor = new PrefColorFields();
            this.lineColorPrefID = new int[]{Preferences.DOCUMENT_RIGHT_MARGIN_COLOR};
            this.notused = new String[]{"dummy"};
            this.altTitle = new String[]{"Color "};
            String str = Preferences.get(Preferences.DOCUMENT_RIGHT_MARGIN_WIDTH);
            int width = NumberUtils.strToInt(str, 100);
            this.marginField.setText("" + width);
            this.lineColor.addField("Color ", this.notused, this.lineColorPrefID, 6, this.altTitle);
            this.add(this.marginLabel, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 10, 0, 0)));
            this.add(this.marginField, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 0, new Insets(0, 10, 0, 0)));
            this.add(this.lineColor, new GBC(2, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 10, 0, 0)));
        }

        public void writeToPrefs() {
            Preferences.write(Preferences.DOCUMENT_RIGHT_MARGIN_WIDTH, this.marginField.getText());
            this.lineColor.writeToPrefs();
        }

        public int getMarginWidth() {
            return NumberUtils.strToInt(this.marginField.getText(), 100);
        }
    }

    private class ColorationPanel
    extends KTitledPanel {
        private JLabel maxBytesLabel;
        public KTextField maxBytesField;
        private JLabel in_bytes_label;
        private JCheckBox onOff;

        public ColorationPanel() {
            super(" Text Coloration ");
            this.maxBytesLabel = new JLabel("Maximum Length");
            this.maxBytesField = new KTextField(5);
            this.in_bytes_label = new JLabel("(bytes)");
            this.onOff = new JCheckBox(" active ");
            this.maxBytesField.setMargin(new Insets(1, 0, 1, 0));
            this.maxBytesField.setMinimumSize(this.maxBytesField.getPreferredSize());
            this.in_bytes_label.setFont(Cutter.defaultFont.font);
            this.in_bytes_label.setMinimumSize(this.in_bytes_label.getPreferredSize());
            this.readFromPrefs();
            this.add(this.maxBytesLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 11, new Insets(1, 10, 5, 0)));
            this.add(this.maxBytesField, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 13, 11, new Insets(1, 2, 5, 5)));
            this.add(this.in_bytes_label, new GBC(2, 0, 1, 1, 1.0, 1.0, 0, 0, 13, 11, new Insets(1, 2, 5, 2)));
            this.add(this.onOff, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 11, new Insets(1, 5, 0, 5)));
        }

        public void writeToPrefs() {
            Preferences.write(Preferences.TEXT_COLOR_MAXLENGTH, this.maxBytesField.getText());
            String str = this.onOff.isSelected() ? "true" : "false";
            Preferences.write(Preferences.TEXT_COLOR_ACTIVE, str);
        }

        public void readFromPrefs() {
            this.maxBytesField.setText(Preferences.get(Preferences.TEXT_COLOR_MAXLENGTH));
            String str = Preferences.get(Preferences.TEXT_COLOR_ACTIVE);
            this.onOff.setSelected(str.equals("true"));
        }
    }

    private class FontComboGroup
    extends JPanel {
        private final String[] sizes = new String[]{"10", "12", "14", "16", "18", "20", "26", "30"};
        private final String[] weights = new String[]{"plain", "bold"};
        private JComboBox<String> sizeCombo = new JComboBox<String>(this.sizes);
        private JComboBox<String> weightCombo = new JComboBox<String>(this.weights);
        private JLabel sizeLabel = new JLabel("Size ");
        private JLabel weightLabel = new JLabel("Weight ");
        FontNamePanel fontNamePanel = new FontNamePanel();

        public FontComboGroup() {
            this.setLayout(new GridBagLayout());
            this.readFromPrefs();
            this.sizeCombo.setPreferredSize(new Dimension(45, 20));
            this.weightCombo.setPreferredSize(new Dimension(60, 20));
            this.add((Component)this.fontNamePanel, new GBC(0, 0, 4, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 0, 10, 0)));
            this.add((Component)this.sizeLabel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 0, new Insets(0, 0, 0, 0)));
            this.add(this.sizeCombo, new GBC(1, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 0, new Insets(0, 0, 0, 0)));
            this.add((Component)this.weightLabel, new GBC(2, 1, 1, 1, 1.0, 0.0, 0, 0, 13, 0, new Insets(0, 15, 0, 0)));
            this.add(this.weightCombo, new GBC(3, 1, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 0, 0)));
        }

        public void writeToPrefs() {
            Preferences.write(Preferences.TEXT_FONT_SIZE, (String)this.sizeCombo.getSelectedItem());
            Preferences.write(Preferences.TEXT_FONT_WEIGHT, (String)this.weightCombo.getSelectedItem());
        }

        public void readFromPrefs() {
            this.sizeCombo.setSelectedItem(Preferences.get(Preferences.TEXT_FONT_SIZE));
            this.weightCombo.setSelectedItem(Preferences.get(Preferences.TEXT_FONT_WEIGHT));
        }

        private class FontNamePanel
        extends JPanel
        implements ActionListener {
            JLabel label = new JLabel("Font Name ");
            KTextField field = new KTextField(7);
            KButton checkButton = new KButton("List");
            String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

            public FontNamePanel() {
                this.setLayout(new GridBagLayout());
                this.add((Component)this.label, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
                this.add((Component)this.field, new GBC(1, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 5, 0, 0)));
                this.add((Component)this.checkButton, new GBC(2, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 5, 0, 0)));
                this.field.usesModelDialog = true;
                this.field.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.checkValidity();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.checkValidity();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.checkValidity();
                    }

                    private void checkValidity() {
                        String fname = FontNamePanel.this.field.getText();
                        if (FontNamePanel.this.fontNames == null) {
                            return;
                        }
                        for (int n = 0; n < FontNamePanel.this.fontNames.length; ++n) {
                            if (!FontNamePanel.this.fontNames[n].equals(fname)) continue;
                            FontNamePanel.this.field.setForeground(Color.black);
                            FontNamePanel.this.writeToPrefs();
                            return;
                        }
                        FontNamePanel.this.field.setForeground(Color.red);
                    }
                });
                String fname = Preferences.get(Preferences.TEXT_FONT_NAME);
                this.field.setText(Preferences.TEXT_FONT_NAME, fname);
                this.checkButton.addActionListener(this);
                this.checkButton.setMargin(new Insets(0, 6, 0, 6));
            }

            public void writeToPrefs() {
                Cutter.defaultTextPaneFontName = this.field.getText();
                this.field.writeToPrefs();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                if (fontNames == null || fontNames.length == 0) {
                    return;
                }
                StringBuffer buf = new StringBuffer();
                for (int n = 0; n < fontNames.length; ++n) {
                    buf.append(fontNames[n]).append("\n");
                }
                BBxt.newDocument("Available_Fonts.txt", buf);
            }
        }
    }
}

