/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Preferences.PrefsPanels.Languages;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTitledPanel;
import UI_Components.PrefsReadWriters.DirectoryPathPanel;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;

public class AiDevkitPanel
extends PrefsPanel
implements ItemListener {
    private static DirectoryPathPanel devkitPanel = new DirectoryPathPanel(" SDK Location ", "path", Preferences.PATH_ARNOLD_DEVKIT, 16, "AiDevkitPanel.devkitPanel.info");
    private static DirectoryPathPanel sourcePanel = new DirectoryPathPanel(" C++ Source Code ", "path", Preferences.PATH_ARNOLD_USER_SHADER_SRC, 16, "AiDevkitPanel.shadersSrc.info");
    private static DirectoryPathPanel shadersPanel = new DirectoryPathPanel(" Compiled Shaders ", "path", Preferences.PATH_ARNOLD_USER_SHADER_DST, 16, "AiDevkitPanel.shaderDest.info");
    private static DirectoryPathPanel aeTemplatesPanel = new DirectoryPathPanel(" AETemplates ", "path", Preferences.PATH_ARNOLD_USER_AETEMPLATES, 16, "AiDevkitPanel.aeTemplates.info");
    private JCheckBox useIPR = new JCheckBox(" Use IPR");
    private static KTitledPanel mtdStylePanel = new KTitledPanel(" MTD Style ");
    private static JRadioButton mayaButton = new JRadioButton("Maya");
    private static JRadioButton houdiniButton = new JRadioButton("Houdini");
    private static ButtonGroup styleGroup = new ButtonGroup();
    private String panelName = "AiDevkit panel";

    public AiDevkitPanel() {
        this.contentPanel.add(devkitPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        this.contentPanel.add(sourcePanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        this.contentPanel.add(shadersPanel, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        this.contentPanel.add(aeTemplatesPanel, new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        this.contentPanel.add(this.useIPR, new GBC(0, 4, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(10, 0, 2, 0)));
        String str = Preferences.get(Preferences.ARNOLD_RENDER_IPR);
        this.useIPR.setSelected(str.equals("true"));
        this.useIPR.addItemListener(this);
        styleGroup.add(mayaButton);
        styleGroup.add(houdiniButton);
        mayaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.write(Preferences.ARNOLD_DEVKIT_MTD_STYLE, "MAYA");
            }
        });
        houdiniButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.write(Preferences.ARNOLD_DEVKIT_MTD_STYLE, "HOUDINI");
            }
        });
        mtdStylePanel.add(mayaButton, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
        mtdStylePanel.add(houdiniButton, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
        if (Preferences.get(Preferences.ARNOLD_DEVKIT_MTD_STYLE).equalsIgnoreCase("MAYA")) {
            mayaButton.setSelected(true);
        } else {
            houdiniButton.setSelected(true);
        }
        this.contentPanel.add(mtdStylePanel, new GBC(0, 5, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(10, 0, 2, 0)));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int state = e.getStateChange();
        Object src = e.getSource();
        if (src == this.useIPR) {
            Preferences.write(Preferences.ARNOLD_RENDER_IPR, "" + this.useIPR.isSelected());
        }
    }

    @Override
    public void writeToPrefs() {
        devkitPanel.writeToPrefs();
        sourcePanel.writeToPrefs();
        shadersPanel.writeToPrefs();
        Preferences.write(Preferences.ARNOLD_RENDER_IPR, "" + this.useIPR.isSelected());
        aeTemplatesPanel.writeToPrefs();
        super.writeToPrefs();
    }

    @Override
    public void readFromPrefs() {
        devkitPanel.readFromPrefs();
        sourcePanel.readFromPrefs();
        shadersPanel.readFromPrefs();
        aeTemplatesPanel.readFromPrefs();
    }

    @Override
    public String getName() {
        return this.panelName;
    }
}

