/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Preferences.PrefsPanels.Languages;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KCheckBox;
import UI_Components.KTitledPanel;
import UI_Components.PrefsReadWriters.DirectoryPathPanel;
import UI_Components.PrefsReadWriters.PrefTextField;
import UI_Components.PrefsReadWriters.PrefTextFields;
import UI_Desktop.Cutter;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import UI_Tools.Rman.RenderInfo;
import Utilities.EnvUtils;
import java.awt.Insets;
import java.io.File;

public class CPPPanel
extends PrefsPanel {
    private static final long serialVersionUID = 1L;
    private DirectoryPathPanel compilerDirPanel = new DirectoryPathPanel(" Compiler Path ", "bin   ", Preferences.PATH_CPP_COMPILER_BIN, 14);
    private int[] windowsVcvarsID = new int[]{Preferences.PATH_CPP_VCVARSX86_AMD64_BAT};
    private DirectoryPathPanel vcvarsPathPanel = new DirectoryPathPanel(" vcvars64.bat ", "path", Preferences.PATH_CPP_VCVARSX86_AMD64_BAT, 17, 7);
    private String panelName = "CPP panel";
    private KTitledPanel commandsPanel = new KTitledPanel(" Commands ");
    private String[] dummy = new String[]{"dummy"};
    private int[] compileID = new int[]{Preferences.EXE_CPP_COMPILE};
    private int[] makeID = new int[]{Preferences.EXE_CPP_MAKE};
    private int[] flagsID = new int[]{Preferences.EXE_CPP_FLAGS};
    private PrefTextField compileTF = new PrefTextField("compiler", this.dummy, this.compileID, 9, 1, true);
    private PrefTextField makeTF = new PrefTextField("   make", this.dummy, this.makeID, 9, 1, true);
    private PrefTextField flagsTF = new PrefTextField("extra flags", this.dummy, this.flagsID, 9, 1, true);
    private PrefTextFields commandsFields = new PrefTextFields();
    private PrefTextFields vcvarFields = new PrefTextFields();
    private static KCheckBox checkbox;

    public CPPPanel() {
        this.commandsFields.addField("    compiler ", this.dummy, this.compileID, 13, 9, false, true);
        this.commandsFields.addField("        make ", this.dummy, this.makeID, 13, 9, false, true);
        this.commandsFields.addField(" extra flags ", this.dummy, this.flagsID, 13, 9, false, true);
        this.commandsPanel.add(this.commandsFields, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 13, 2, new Insets(0, 0, 2, 0)));
        KTitledPanel linuxOsxPanel = new KTitledPanel(" Linux & OSX ");
        linuxOsxPanel.add(this.compilerDirPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 13, 2, new Insets(0, 0, 2, 0)));
        linuxOsxPanel.add(this.commandsPanel, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 13, 2, new Insets(0, 0, 2, 0)));
        KTitledPanel windowsPanel = new KTitledPanel(" Microsoft Visual Studio ", "VcvarsPanel.batpath.info");
        windowsPanel.add(this.vcvarsPathPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 13, 2, new Insets(0, 0, 2, 0)));
        this.vcvarsPathPanel.readFromPrefs();
        String label = EnvUtils.isWinEnvironment() ? "Cleanup Build.bat Files" : "Cleanup Makefiles";
        checkbox = new KCheckBox(label);
        String boolStr = Preferences.get(Preferences.CPP_MAKEFILE_CLEANUP);
        checkbox.setSelected(boolStr.equals("true"));
        if (EnvUtils.isWinEnvironment()) {
            this.contentPanel.add(windowsPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        } else {
            this.contentPanel.add(linuxOsxPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        }
        this.contentPanel.add(checkbox, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(5, 5, 2, 0)));
        this.defaultFocusedField = this.compileTF.field;
    }

    @Override
    public void setVisible(boolean flag) {
        String batPath;
        super.setVisible(flag);
        if (!flag) {
            return;
        }
        if (RenderInfo.prmanMajorVersionNumber() < 21) {
            return;
        }
        if (EnvUtils.isWinEnvironment() && (batPath = Preferences.get(Preferences.PATH_CPP_VCVARSX86_AMD64_BAT)).trim().length() > 0) {
            File bat = new File(batPath);
            String batName = bat.getName();
            File parent = bat.getParentFile();
            Cutter.setLog("CPPanel.setVisible() parent = " + parent.getPath());
            String parentName = parent.getName();
            if (parentName.equals("amd64")) {
                // empty if block
            }
        }
    }

    @Override
    public void writeToPrefs() {
        this.compilerDirPanel.writeToPrefs();
        this.commandsFields.writeToPrefs();
        this.vcvarFields.writeToPrefs();
        this.vcvarsPathPanel.writeToPrefs();
        if (checkbox.isSelected()) {
            Preferences.write(Preferences.CPP_MAKEFILE_CLEANUP, "true");
        } else {
            Preferences.write(Preferences.CPP_MAKEFILE_CLEANUP, "false");
        }
        super.writeToPrefs();
    }

    @Override
    public void readFromPrefs() {
        this.compilerDirPanel.readFromPrefs();
        this.commandsFields.readFromPrefs();
        this.vcvarsPathPanel.readFromPrefs();
    }

    @Override
    public String getName() {
        return this.panelName;
    }
}

