/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Preferences.PrefsPanels.Languages;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTitledPanel;
import UI_Components.PrefsReadWriters.PrefTextField;
import UI_Components.PrefsReadWriters.PrefTextFields;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OSLPanel
extends PrefsPanel {
    private static final long serialVersionUID = 1L;
    static String BIN_PATH_LABEL = " bin path ";
    static String OSL_SOURCE_LABEL = " source ";
    static String COMPILED_SHADERS_LABEL = " shaders ";
    static String OSL_INCLUDES_LABEL = " includes ";
    static String OSL_DUPLICATION_DIR_LABEL = " dest dir ";
    static String ARNOLD_DO_DUPLICATE_LABEL = " Duplicate Shaders and MTD Files ";
    static String PIXAR_DO_DUPLICATE_LABEL = " Duplicate Shaders ";
    private static KTitledPanel pixarPanel = new KTitledPanel(" Pixar ", "OSLPanel.BinDirPanel.info");
    private static KTitledPanel arnoldPanel = new KTitledPanel(" Arnold ", "OSLPanel.ArnoldPanel.info");
    private static KTitledPanel keyboardPanel = new KTitledPanel(" Compilation Environment ", "OSLPanel.KeyboardPanel.info");
    private static PrefTextFields pixarFields = new PrefTextFields();
    private static PrefTextFields arnoldFields = new PrefTextFields();
    private static PrefTextField pixarBinPrefField = null;
    private static String panelName = "osl panel";
    private static JRadioButton pixarButton = new JRadioButton("Pixar's RenderMan");
    private static JRadioButton arnoldButton = new JRadioButton("SolidAngle Arnold");
    private static ButtonGroup oslSysGroup = new ButtonGroup();
    private static PrefTextFields pixarDupField = new PrefTextFields();
    private static JCheckBox pixarDupicateCB = new JCheckBox();
    private static JLabel pixarCBLabel = new JLabel(PIXAR_DO_DUPLICATE_LABEL);
    private static PrefTextFields arnoldDupField = new PrefTextFields();
    private static JCheckBox arnoldDupicateCB = new JCheckBox();
    private static JLabel arnoldCBLabel = new JLabel(ARNOLD_DO_DUPLICATE_LABEL);
    private static KTitledPanel mtdStylePanel = new KTitledPanel(" MTD Style ");
    private static JRadioButton mayaButton = new JRadioButton("Maya");
    private static JRadioButton houdiniButton = new JRadioButton("Houdini");
    private static ButtonGroup styleGroup = new ButtonGroup();

    public OSLPanel() {
        String[] singleKey = new String[]{"user"};
        int[] pixarBinPathID = new int[]{Preferences.PATH_OSL_COMPILER_BIN};
        int[] pixarSourceID = new int[]{Preferences.PATH_USER_OSL_SOURCE};
        int[] pixarShadersID = new int[]{Preferences.PATH_USER_OSL_SHADERS};
        pixarPanel.add(pixarFields, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 5, 0)));
        pixarBinPrefField = pixarFields.addField(BIN_PATH_LABEL, singleKey, pixarBinPathID, 15, 1, true, true);
        pixarFields.addField(OSL_SOURCE_LABEL, singleKey, pixarSourceID, 15, 1, true, true);
        pixarFields.addField(COMPILED_SHADERS_LABEL, singleKey, pixarShadersID, 15, 1, true, true);
        JPanel rmanDupHolder = new JPanel();
        rmanDupHolder.add((Component)pixarDupicateCB, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 0, 0)));
        rmanDupHolder.add((Component)pixarCBLabel, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 5, 0)));
        String rmanDupFlag = Preferences.get(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION);
        if (rmanDupFlag.equals("true")) {
            pixarDupicateCB.setSelected(true);
        } else {
            pixarDupicateCB.setSelected(false);
        }
        pixarDupicateCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (pixarDupicateCB.isSelected()) {
                    Preferences.write(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION, "true");
                    pixarDupField.setEnabled(true);
                } else {
                    Preferences.write(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION, "false");
                    pixarDupField.setEnabled(false);
                }
                String text = pixarDupField.getFieldText(OSL_DUPLICATION_DIR_LABEL);
                Preferences.write(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION_PATH, text);
            }
        });
        pixarPanel.add(rmanDupHolder, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        int[] pixarDupPathID = new int[]{Preferences.TOOL_RENDERMAN_OSO_DUPLICATION_PATH};
        pixarPanel.add(pixarDupField, new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        pixarDupField.addField(OSL_DUPLICATION_DIR_LABEL, singleKey, pixarDupPathID, 14, 1, true, true);
        rmanDupFlag = Preferences.get(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION);
        if (rmanDupFlag.equals("true")) {
            pixarDupField.setEnabled(true);
        } else {
            pixarDupField.setEnabled(false);
        }
        int[] arnoldBinPathID = new int[]{Preferences.PATH_ARNOLD_BIN};
        int[] arnoldSourceID = new int[]{Preferences.PATH_USER_ARNOLD_OSL_SOURCE};
        int[] arnoldShadersID = new int[]{Preferences.PATH_USER_ARNOLD_OSL_SHADERS};
        int[] arnoldIncludesID = new int[]{Preferences.PATH_USER_ARNOLD_OSL_INCLUDES};
        arnoldPanel.add(arnoldFields, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 5, 0)));
        arnoldFields.addField(BIN_PATH_LABEL, singleKey, arnoldBinPathID, 15, 1, true, true);
        arnoldFields.addField(OSL_INCLUDES_LABEL, singleKey, arnoldIncludesID, 15, 1, true, true);
        arnoldFields.addField(OSL_SOURCE_LABEL, singleKey, arnoldSourceID, 15, 1, true, true);
        arnoldFields.addField(COMPILED_SHADERS_LABEL, singleKey, arnoldShadersID, 15, 1, true, true);
        JPanel arnoldDupHolder = new JPanel();
        arnoldDupHolder.add((Component)arnoldDupicateCB, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 0, 0)));
        arnoldDupHolder.add((Component)arnoldCBLabel, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 5, 0)));
        String arnoldDupFlag = Preferences.get(Preferences.ARNOLD_DO_OSO_MTD_DUPLICATION);
        if (arnoldDupFlag.equals("true")) {
            arnoldDupicateCB.setSelected(true);
        } else {
            arnoldDupicateCB.setSelected(false);
        }
        arnoldDupicateCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (arnoldDupicateCB.isSelected()) {
                    Preferences.write(Preferences.ARNOLD_DO_OSO_MTD_DUPLICATION, "true");
                    arnoldDupField.setEnabled(true);
                } else {
                    Preferences.write(Preferences.ARNOLD_DO_OSO_MTD_DUPLICATION, "false");
                    arnoldDupField.setEnabled(false);
                }
                String text = arnoldDupField.getFieldText(OSL_DUPLICATION_DIR_LABEL);
                Preferences.write(Preferences.PATH_USER_ARNOLD_OSO_MTD_DUPLICATION, text);
            }
        });
        arnoldPanel.add(arnoldDupHolder, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        int[] arnoldDupPathID = new int[]{Preferences.PATH_USER_ARNOLD_OSO_MTD_DUPLICATION};
        arnoldPanel.add(arnoldDupField, new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        arnoldDupField.addField(OSL_DUPLICATION_DIR_LABEL, singleKey, arnoldDupPathID, 14, 1, true, true);
        arnoldDupFlag = Preferences.get(Preferences.ARNOLD_DO_OSO_MTD_DUPLICATION);
        if (arnoldDupFlag.equals("true")) {
            arnoldDupField.setEnabled(true);
        } else {
            arnoldDupField.setEnabled(false);
        }
        styleGroup.add(mayaButton);
        styleGroup.add(houdiniButton);
        mayaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.write(Preferences.ARNOLD_OSL_MTD_STYLE, "MAYA");
            }
        });
        houdiniButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.write(Preferences.ARNOLD_OSL_MTD_STYLE, "HOUDINI");
            }
        });
        mtdStylePanel.add(mayaButton, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
        mtdStylePanel.add(houdiniButton, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
        if (Preferences.get(Preferences.ARNOLD_OSL_MTD_STYLE).equalsIgnoreCase("MAYA")) {
            mayaButton.setSelected(true);
        } else {
            houdiniButton.setSelected(true);
        }
        arnoldPanel.add(mtdStylePanel, new GBC(0, 5, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(10, 0, 2, 0)));
        oslSysGroup.add(pixarButton);
        oslSysGroup.add(arnoldButton);
        pixarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.write(Preferences.OSL_COMPILE_KEYBOARD_SHORTCUT, "PRMAN");
            }
        });
        arnoldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.write(Preferences.OSL_COMPILE_KEYBOARD_SHORTCUT, "ARNOLD");
            }
        });
        if (Preferences.get(Preferences.OSL_COMPILE_KEYBOARD_SHORTCUT).equalsIgnoreCase("PRMAN")) {
            pixarButton.setSelected(true);
        } else {
            arnoldButton.setSelected(true);
        }
        keyboardPanel.add(pixarButton, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
        keyboardPanel.add(arnoldButton, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 0, 0)));
        this.contentPanel.add(pixarPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        this.contentPanel.add(arnoldPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(5, 0, 2, 0)));
        this.contentPanel.add(keyboardPanel, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(5, 0, 2, 0)));
        this.defaultFocusedField = pixarFields.getFieldTitled(BIN_PATH_LABEL);
    }

    @Override
    public void focusDefaultField() {
        super.focusDefaultField();
    }

    public static void setPixarBinPath(String pth) {
        if (pixarBinPrefField != null) {
            OSLPanel.pixarBinPrefField.field.setText(pth);
        }
    }

    @Override
    public void writeToPrefs() {
        pixarFields.writeToPrefs();
        arnoldFields.writeToPrefs();
        arnoldDupField.writeToPrefs();
        pixarDupField.writeToPrefs();
        super.writeToPrefs();
    }

    @Override
    public void readFromPrefs() {
        pixarFields.readFromPrefs();
        arnoldFields.readFromPrefs();
        arnoldDupField.readFromPrefs();
        pixarDupField.readFromPrefs();
    }

    @Override
    public String getName() {
        return panelName;
    }
}

