/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Preferences;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTabbedPane.KTabGroup;
import UI_Components.KTabbedPane.KTabbedPane;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Tools.KTools;
import UI_Tools.Preferences.PrefsPanels.CutterUI.UIGeneral;
import UI_Tools.Preferences.PrefsPanels.CutterUI.UIHistory;
import UI_Tools.Preferences.PrefsPanels.CutterUI.UINetworkPanel;
import UI_Tools.Preferences.PrefsPanels.CutterUI.UITemplatesPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.AiDevkitPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.CPPPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.DevkitPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.HTMLPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.MELPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.MayaNodeIDPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.OSLPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.PyPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.SyntaxColorPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.TCLPanel;
import UI_Tools.Preferences.PrefsPanels.Languages.VFLPanel;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import UI_Tools.Preferences.PrefsPanels.RenderMan.RmanDocsPanel;
import UI_Tools.Preferences.PrefsPanels.RenderMan.RmanPluginsPathsPanel;
import UI_Tools.Preferences.PrefsPanels.RenderMan.RmanRibOptionsPanel;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.RmanTool;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class PrefsTool
extends KTools {
    private static final long serialVersionUID = 1L;
    protected static final String PREFS_HELP_PATH = "preferences/index.html";
    public static KTabbedPane tabbedPane = new KTabbedPane();
    public static KTabbedPane rmanTab = new KTabbedPane();
    public static KTabbedPane languagesTab = new KTabbedPane();
    public static KTabbedPane uiTab = new KTabbedPane();
    private static PrefsTool tool = null;
    private static RmanRibOptionsPanel rmanRibOptionsPanel = null;
    private static RmanDocsPanel rmanDocsPanel = null;
    private static RmanPluginsPathsPanel rmanDevkitPanel = null;
    private static UIGeneral uiGenPanel = null;
    private static UINetworkPanel uiNetPanel = null;
    private static UIHistory uiHistPanel = null;
    private static UITemplatesPanel uiTmplPanel = null;
    private static SyntaxColorPanel syntaxColorPanel = null;
    public static VFLPanel vflPanel = null;
    private static MELPanel melPanel = null;
    private static TCLPanel tclPanel = null;
    private static PyPanel pyPanel = null;
    private static CPPPanel cppPanel = null;
    private static DevkitPanel devkitPanel = null;
    private static OSLPanel oslPanel = null;
    private static HTMLPanel htmlPanel = null;
    private static AiDevkitPanel aiDevkitPanel = null;
    private static MayaNodeIDPanel mayaNodeIdPanel = null;
    protected static JButton closeButton = new JButton("Close");
    protected static JButton saveButton = new JButton("Save Documentation");
    protected static JButton discardButton = new JButton("Discard");
    public static final String UNKNOWNTAB = "unknown";
    public static final String RMAN_TAB = "Rman";
    public static final String UI_TAB = "UI Prefs";
    public static final String LANG_TAB = "Languages";
    private static final String RMAN_TAB_OTHERS = "Vendors";
    private static final String RMAN_TAB_PLUGINS_PATHS = "Plugins Paths";
    private static final String LANG_TAB_SYNTAX = "Colors";
    private static final String LANG_TAB_MI = "Mi";
    private static final String LANG_TAB_DSO = "Pixar DevKit";
    private static final String RMAN_TAB_PIXAR = "Pixar";
    private static final String LANG_TAB_VFL = "Vfl";
    private static final String RMAN_TAB_RIB_OPTIONS = "Rib Options";
    private static final String LANG_TAB_MEL = "Mel";
    private static final String RMAN_TAB_SLIM = "Slim-HyperShade";
    private static final String LANG_TAB_TCL = "Tcl";
    private static final String LANG_TAB_PY = "Python";
    private static final String LANG_TAB_CPP = "Cpp";
    private static final String LANG_TAB_OSL = "Osl";
    private static final String LANG_TAB_ARNOLD_DEVKIT = "Arnold SDK";
    private static final String LANG_TAB_MAYA_NODE_ID = "Maya Node Id";
    private static final String LANG_TAB_HTML = "Html";
    public static final String UI_TAB_GENERAL = "General";
    public static final String UI_TAB_NET = "Net";
    public static final String UI_TAB_HISTORY = "History";
    public static final String UI_TAB_TMPL = "Tmpl";
    private KTabGroup tabGroup;
    Vector<Component> listOfComps = new Vector();

    public static PrefsTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new PrefsTool(menuItem, PREFS_HELP_PATH);
        return tool;
    }

    public static PrefsTool init() {
        return PrefsTool.init(KDesktop.prefsGUIItem);
    }

    private PrefsTool(JMenuItem menuItem, String helpDocPath) {
        super("Preferences Tool", menuItem, Preferences.TOOL_PREFS, helpDocPath);
        rmanDocsPanel = new RmanDocsPanel();
        rmanDevkitPanel = new RmanPluginsPathsPanel();
        rmanRibOptionsPanel = new RmanRibOptionsPanel();
        rmanTab.addTab(RMAN_TAB_PIXAR, rmanDocsPanel);
        rmanTab.addTab(RMAN_TAB_RIB_OPTIONS, rmanRibOptionsPanel);
        rmanTab.addTab(RMAN_TAB_PLUGINS_PATHS, rmanDevkitPanel);
        rmanTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String name = PrefsTool.this.getTitleOfSelectedTab((JTabbedPane)e.getSource());
                saveButton.setText("Save " + name);
            }
        });
        uiGenPanel = new UIGeneral();
        uiNetPanel = new UINetworkPanel();
        uiHistPanel = new UIHistory();
        uiTmplPanel = new UITemplatesPanel();
        uiTab.addTab(UI_TAB_GENERAL, uiGenPanel);
        uiTab.addTab(UI_TAB_NET, uiNetPanel);
        uiTab.addTab(UI_TAB_HISTORY, uiHistPanel);
        uiTab.addTab(UI_TAB_TMPL, uiTmplPanel);
        uiTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String name = PrefsTool.this.getTitleOfSelectedTab((JTabbedPane)e.getSource());
                saveButton.setText("Save " + name);
            }
        });
        syntaxColorPanel = new SyntaxColorPanel();
        vflPanel = new VFLPanel();
        melPanel = new MELPanel();
        tclPanel = new TCLPanel();
        pyPanel = new PyPanel();
        cppPanel = new CPPPanel();
        devkitPanel = new DevkitPanel();
        oslPanel = new OSLPanel();
        aiDevkitPanel = new AiDevkitPanel();
        mayaNodeIdPanel = new MayaNodeIDPanel();
        htmlPanel = new HTMLPanel();
        languagesTab.addTab(LANG_TAB_MEL, melPanel);
        languagesTab.addTab(LANG_TAB_TCL, tclPanel);
        languagesTab.addTab(LANG_TAB_SYNTAX, syntaxColorPanel);
        languagesTab.addTab(LANG_TAB_VFL, vflPanel);
        languagesTab.addTab(LANG_TAB_PY, pyPanel);
        languagesTab.addTab(LANG_TAB_CPP, cppPanel);
        languagesTab.addTab(LANG_TAB_DSO, devkitPanel);
        languagesTab.addTab(LANG_TAB_OSL, oslPanel);
        languagesTab.addTab(LANG_TAB_ARNOLD_DEVKIT, aiDevkitPanel);
        languagesTab.addTab(LANG_TAB_MAYA_NODE_ID, mayaNodeIdPanel);
        languagesTab.addTab(LANG_TAB_HTML, htmlPanel);
        languagesTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String name = PrefsTool.this.getTitleOfSelectedTab((JTabbedPane)e.getSource());
                saveButton.setText("Save " + name);
            }
        });
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                saveButton.setText("Save " + PrefsTool.this.getTitleOfSelectedTab((JTabbedPane)e.getSource()));
            }
        });
        tabbedPane.addTab(RMAN_TAB, rmanTab);
        tabbedPane.addTab(UI_TAB, uiTab);
        tabbedPane.addTab(LANG_TAB, languagesTab);
        this.tabGroup = new KTabGroup(this, tabbedPane);
        closeButton.setMargin(new Insets(2, 5, 0, 5));
        discardButton.setMargin(new Insets(2, 5, 0, 5));
        saveButton.setMargin(new Insets(2, 5, 0, 5));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(true);
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.add((Component)closeButton, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 3, new Insets(8, 10, 5, 2)));
        buttonPanel.add((Component)discardButton, new GBC(4, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 3, new Insets(8, 0, 5, 0)));
        buttonPanel.add((Component)saveButton, new GBC(5, 1, 1, 1, 1.0, 1.0, 0, 0, 13, 3, new Insets(8, 10, 5, 5)));
        this.contentPane.add((Component)tabbedPane, new GBC(0, 0, 6, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(0, 0, 0, 0)));
        this.contentPane.add((Component)buttonPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsTool.this.showSelf();
            }
        });
        discardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsTool.this.getPrefsPanel(tabbedPane).readFromPrefs();
            }
        });
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsTool.this.getPrefsPanel(tabbedPane).writeToPrefs();
                RenderInfo.init();
            }
        });
        this.setTitle(this.title);
        this.pack();
        this.setInitialPosition();
        saveButton.setText("Save " + this.getTitleOfSelectedTab(tabbedPane));
        this.setVisible(false);
    }

    @Override
    public void showSelf() {
        super.showSelf();
        this.toolSelectionHappened();
    }

    public void updateSubPanels(String render_mode) {
        if (tool != null) {
            PrefsTool.init();
        }
        if (render_mode.equals(RmanTool.RENDER_MODE_RIS)) {
            // empty if block
        }
        tabbedPane.updateUI();
        tool.pack();
    }

    private String getTitleOfSelectedTab(JTabbedPane tab) {
        JTabbedPane selectedTab;
        Component c = tab.getSelectedComponent();
        if (c instanceof JTabbedPane && (selectedTab = (JTabbedPane)c).getTabCount() > 0) {
            int index = selectedTab.getSelectedIndex();
            return selectedTab.getTitleAt(index);
        }
        return tab.getTitleAt(tab.getSelectedIndex());
    }

    @Override
    protected void toolSelectionHappened() {
        Component tabPanel = tabbedPane.getSelectedComponent();
        while (tabPanel instanceof JTabbedPane) {
            tabPanel = ((JTabbedPane)tabPanel).getSelectedComponent();
        }
        if (tabPanel instanceof PrefsPanel) {
            ((PrefsPanel)tabPanel).focusDefaultField();
        } else {
            Cutter.setLog("    Debug:PrefsTool.toolSelectionHappened() tab is " + tabPanel.getClass().getName());
        }
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
        PrefsPanel pp = tabbedPane.getVisiblePrefsPanel();
        pp.defaultFocusedField = compLostFocus;
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    private PrefsPanel getPrefsPanel(JTabbedPane tabbedPane) {
        Component obj = tabbedPane.getSelectedComponent();
        if (obj instanceof JTabbedPane) {
            return (PrefsPanel)((JTabbedPane)obj).getSelectedComponent();
        }
        return (PrefsPanel)obj;
    }

    public void selectPanel(final KTabbedPane tab, final String name) {
        final Component[] comps = tab.getComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tabbedPane.setSelectedComponent(tab);
                PrefsTool.this.selectPanel(tab, comps, name);
            }
        });
    }

    public boolean selectPanel(final KTabbedPane parent, Component[] comps, String name) {
        for (int n = 0; n < comps.length; ++n) {
            String panelName;
            if (comps[n] instanceof JTabbedPane) {
                Component[] c = ((JTabbedPane)comps[n]).getComponents();
                if (c == null || c.length == 0) {
                    return false;
                }
                this.selectPanel(parent, c, name);
                continue;
            }
            if (comps[n] == null || !(comps[n] instanceof PrefsPanel) || (panelName = ((PrefsPanel)comps[n]).getName()) == null || !panelName.equals(name)) continue;
            final Component target = comps[n];
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    parent.setSelectedComponent(target);
                }
            });
            return true;
        }
        return false;
    }

    private String getPanelName(JTabbedPane tabbedPane) {
        Component comp;
        int index = tabbedPane.getSelectedIndex();
        String title = tabbedPane.getTitleAt(index);
        if (title.equals("RenderMan") && (comp = tabbedPane.getSelectedComponent()) instanceof JTabbedPane) {
            JTabbedPane tp = (JTabbedPane)comp;
            return tp.getTitleAt(tp.getSelectedIndex());
        }
        return title;
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }

    public static void openTabPanel(String parentName, String childName) {
        PrefsTool.init();
        if (!tool.isVisible()) {
            tool.showSelf();
        }
        if (parentName == null) {
            Cutter.setLog("    Error:PrefsTool.openTabPanel() parentName is null - cannot open prefs panel");
            return;
        }
        int parentIndex = tabbedPane.indexOfTab(parentName);
        if (parentIndex >= 0) {
            int childIndex;
            tabbedPane.setSelectedIndex(parentIndex);
            if (childName == null) {
                return;
            }
            Component obj = tabbedPane.getSelectedComponent();
            if (obj instanceof JTabbedPane && (childIndex = ((JTabbedPane)obj).indexOfTab(childName)) >= 0) {
                ((JTabbedPane)obj).setSelectedIndex(childIndex);
            }
        }
    }
}

