/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Qtvr;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KTitledPanel;
import UI_Components.LabelTextField;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Rib.Animation.MultiFramer;
import UI_Tools.KTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;

public class QtvrTool
extends KTools
implements ActionListener {
    public static int startVPan = -1;
    public static int endVPan = -1;
    public static int rows = -1;
    public static int cols = -1;
    public static float colAngle = 0.0f;
    public static float rowAngle = 0.0f;
    private static KTitledPanel inputPanel = new KTitledPanel(" Inputs ", "QtvrTool.InputPanel.info");
    private static KTitledPanel outputPanel = new KTitledPanel(" Camera ", "QtvrTool.OutputPanel.info");
    private static JButton hideButton = new JButton("Hide");
    private static JButton okButton = new JButton("Make Qtvr");
    private static JButton calcButton = new JButton("Calculate");
    private static LabelTextField rowfield = new LabelTextField("Rows", Preferences.get(Preferences.TOOL_RENDERMAN_QTVR_ROWS), 2, 10);
    private static LabelTextField columnfield = new LabelTextField("Columns", Preferences.get(Preferences.TOOL_RENDERMAN_QTVR_COLUMNS), 2, 10);
    private static LabelTextField startVpanfield = new LabelTextField("Start VPan", Preferences.get(Preferences.TOOL_RENDERMAN_QTVR_STARTVP), 2, 10);
    private static LabelTextField endVpanfield = new LabelTextField("End VPan", Preferences.get(Preferences.TOOL_RENDERMAN_QTVR_ENDVP), 2, 10);
    private static LabelTextField orbit = new LabelTextField("Column Angle:", " ", 2, 0, 12);
    private static LabelTextField elevation = new LabelTextField("Row Angle:", " ", 2, 18, 12);
    private static GBC gbc;
    protected static QtvrTool tool;

    public static QtvrTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new QtvrTool(menuItem);
        return tool;
    }

    private QtvrTool(JMenuItem menuItem) {
        super("Qtvr Tool", menuItem, Preferences.TOOL_RENDERMAN_QTVR);
        orbit.setEditable(false);
        orbit.setColor(Color.darkGray);
        elevation.setEditable(false);
        elevation.setColor(Color.darkGray);
        this.contentPane.add((Component)inputPanel, new GBC(0, 0, 4, 2, 1.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.contentPane.add((Component)outputPanel, new GBC(0, 2, 4, 2, 1.0, 1.0, 0, 0, 12, 2, new Insets(3, 5, 5, 5)));
        inputPanel.add(rowfield, new GBC(0, 0, 2, 1, 0.0, 0.0, 0, 0, 13, 0, new Insets(5, 5, 5, 0)));
        inputPanel.add(startVpanfield, new GBC(2, 0, 2, 1, 1.0, 0.0, 0, 0, 13, 0, new Insets(5, 5, 5, 5)));
        inputPanel.add(columnfield, new GBC(0, 1, 2, 1, 0.0, 0.0, 0, 0, 13, 0, new Insets(5, 5, 5, 0)));
        inputPanel.add(endVpanfield, new GBC(2, 1, 2, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(5, 5, 5, 5)));
        outputPanel.add(elevation, new GBC(0, 0, 4, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(5, 5, 5, 0)));
        outputPanel.add(orbit, new GBC(0, 1, 4, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(5, 5, 5, 0)));
        outputPanel.add(calcButton, new GBC(0, 2, 4, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(5, 5, 5, 17)));
        calcButton.setMargin(new Insets(2, 5, 0, 5));
        calcButton.addActionListener(this);
        hideButton.addActionListener(this);
        this.contentPane.add((Component)hideButton, new GBC(2, 5, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(5, 10, 10, 2)));
        okButton.addActionListener(this);
        this.contentPane.add((Component)okButton, new GBC(3, 5, 1, 1, 0.0, 0.0, 0, 0, 13, 0, new Insets(5, 2, 10, 5)));
        this.setTitle(this.title);
        this.pack();
        this.setInitialPosition();
        this.setVisible(false);
    }

    @Override
    protected void toolSelectionHappened() {
        if (this.lastFocusedComponent == null) {
            QtvrTool.rowfield.textfield.grabFocus();
            QtvrTool.rowfield.textfield.selectAll();
        } else {
            this.lastFocusedComponent.grabFocus();
            this.lastFocusedComponent.selectAll();
        }
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
        this.lastFocusedComponent = compLostFocus;
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == okButton) {
            this.saveSelf();
            if (!BBxt.isRibDocument()) {
                JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The Qtvr tool cannot produce a Qtvr animation unless\nthe front window is a RIB document.\n", "Missing Source Document", 0);
                return;
            }
            MultiFramer framer = new MultiFramer();
            framer.generateQTVR();
        } else if (e.getSource() == hideButton) {
            this.showSelf();
        } else if (e.getSource() == calcButton) {
            QtvrTool.doCalc();
        }
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
        Preferences.write(Preferences.TOOL_RENDERMAN_QTVR_COLUMNS, columnfield.getText());
        Preferences.write(Preferences.TOOL_RENDERMAN_QTVR_ROWS, rowfield.getText());
        Preferences.write(Preferences.TOOL_RENDERMAN_QTVR_STARTVP, QtvrTool.startVpanfield.textfield.getText());
        Preferences.write(Preferences.TOOL_RENDERMAN_QTVR_ENDVP, QtvrTool.endVpanfield.textfield.getText());
    }

    public static boolean doCalc() {
        startVPan = Integer.parseInt(QtvrTool.startVpanfield.textfield.getText());
        endVPan = Integer.parseInt(QtvrTool.endVpanfield.textfield.getText());
        rows = Integer.parseInt(QtvrTool.rowfield.textfield.getText());
        cols = Integer.parseInt(QtvrTool.columnfield.textfield.getText());
        if (startVPan == endVPan && rows > 1) {
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The \"Start VPan\" and \"End VPan\" are identical! \n\n\"Start VPan\" must be larger than \"End VPan\".", "Multiple Row Error", 0);
            return false;
        }
        if (rows - 1 > 0) {
            rowAngle = Math.abs((float)(endVPan - startVPan) / (float)(rows - 1));
        } else {
            QtvrTool.endVpanfield.textfield.setText(QtvrTool.startVpanfield.textfield.getText());
            rowAngle = 0.0f;
        }
        colAngle = (float)Math.abs(360.0 / (double)cols);
        elevation.setText(rowAngle + " degrees");
        orbit.setText(colAngle + " degrees");
        return true;
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }

    static {
        tool = null;
    }
}

