/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.RemoteBuild;

import ClientServer.ClientServer.client.KClient;
import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KCheckBox;
import UI_Components.KLabelledField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Script.Cutlet.CutletScriptHandler;
import UI_Tools.KTools;
import UI_Tools.Monitor.Monitor;
import Utilities.DevkitUtils;
import Utilities.DialogUtils;
import Utilities.FileUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class RemoteBuildTool
extends KTools {
    SourcePanel srcPanel = new SourcePanel();
    TargetPanel dstPanel1 = new TargetPanel(Preferences.TOOL_REMOTEBUILD_DST_IP_1, Preferences.TOOL_REMOTEBUILD_DST_H_DIR_1, Preferences.TOOL_REMOTEBUILD_DST_CPP_DIR_1, Preferences.TOOL_REMOTEBUILD_DST_ARGS_DIR_1, Preferences.TOOL_REMOTEBUILD_WRITE_1, Preferences.TOOL_REMOTEBUILD_ENABLED_IP_1);
    TargetPanel dstPanel2 = new TargetPanel(Preferences.TOOL_REMOTEBUILD_DST_IP_2, Preferences.TOOL_REMOTEBUILD_DST_H_DIR_2, Preferences.TOOL_REMOTEBUILD_DST_CPP_DIR_2, Preferences.TOOL_REMOTEBUILD_DST_ARGS_DIR_2, Preferences.TOOL_REMOTEBUILD_WRITE_2, Preferences.TOOL_REMOTEBUILD_ENABLED_IP_2);
    protected static RemoteBuildTool tool = null;
    private static String BUILD_REMOTELY = " Build Remotely ";
    private static String SAVE_REMOTELY = " Save Remotely ";
    JButton doItButton = new JButton(BUILD_REMOTELY);

    public static RemoteBuildTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new RemoteBuildTool(menuItem);
        return tool;
    }

    protected RemoteBuildTool(JMenuItem menuItem) {
        super("Remote Build Tool", menuItem, Preferences.TOOL_REMOTEBUILD);
        this.contentPane.add((Component)this.srcPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)this.dstPanel1, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)this.dstPanel2, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.doItButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RemoteBuildTool.this.doItButton.getText().equals(BUILD_REMOTELY)) {
                    RemoteBuildTool.this.remoteBuild();
                }
                if (RemoteBuildTool.this.doItButton.getText().equals(SAVE_REMOTELY)) {
                    RemoteBuildTool.this.remoteSave();
                }
            }
        });
        this.contentPane.add((Component)this.doItButton, new GBC(0, 3, 1, 1, 1.0, 1.0, 0, 0, 12, 0, new Insets(5, 5, 2, 5)));
        this.pack();
        this.setVisible(false);
        this.setInitialPosition();
    }

    private void remoteBuild() {
        this.saveSelf();
        String cPath = Preferences.get(Preferences.TOOL_REMOTEBUILD_SRC_CPP);
        File c = new File(cPath);
        int devkitType = DevkitUtils.getDevkitScriptType(c);
        if (devkitType == DevkitUtils.NOT_DEVKIT || devkitType == 0) {
            String[] msg = new String[]{"The Remote Build Tool only handles .cpp files that", "implement a Pixar devkit API.\n"};
            DialogUtils.showInfoMessage("Pixar Devkit Error", msg);
            return;
        }
        String ip1 = Preferences.get(Preferences.TOOL_REMOTEBUILD_DST_IP_1);
        String ip2 = Preferences.get(Preferences.TOOL_REMOTEBUILD_DST_IP_2);
        String dstC1 = Preferences.get(Preferences.TOOL_REMOTEBUILD_DST_CPP_DIR_1);
        String dstC2 = Preferences.get(Preferences.TOOL_REMOTEBUILD_DST_CPP_DIR_2);
        String write1 = Preferences.get(Preferences.TOOL_REMOTEBUILD_WRITE_1);
        String write2 = Preferences.get(Preferences.TOOL_REMOTEBUILD_WRITE_2);
        String enable1 = Preferences.get(Preferences.TOOL_REMOTEBUILD_ENABLED_IP_1);
        String enable2 = Preferences.get(Preferences.TOOL_REMOTEBUILD_ENABLED_IP_2);
        if (enable1.equals("true")) {
            this.sendBuildCutlet(cPath, ip1, dstC1, write1);
        }
        if (enable2.equals("true")) {
            this.sendBuildCutlet(cPath, ip2, dstC2, write2);
        }
    }

    private void sendBuildCutlet(String cPath, String ip, String dstC, String write) {
        if (ip.trim().length() == 0) {
            return;
        }
        if (dstC.trim().length() == 0) {
            if (write.equals("true")) {
                String[] msg = new String[]{"The path of the directory in which the .cpp file", "should be written on the computer with IP", "   " + ip, "has not been specified."};
                DialogUtils.showErrorMessage("Error: C++ File Destination", msg);
                return;
            }
            String[] msg = new String[]{"The path of the directory in which the .cpp file", "is located on the computer with IP", "   " + ip, "has not been specified."};
            DialogUtils.showErrorMessage("Error: C++ File Destination", msg);
            return;
        }
        StringBuffer cbuf = new StringBuffer();
        if (cPath.trim().length() > 0 && dstC.trim().length() > 0) {
            String permission = write.equals("true") ? "write" : "readonly";
            cbuf.append("build.").append(permission).append(" -src \"").append(cPath).append("\"");
            cbuf.append(" -target \"").append(dstC).append("\"");
            cbuf.append(" -sender \"").append(KClient.getLocalIP()).append("\"");
            cbuf.append(" -recipientIP \"").append(ip).append("\"\n");
        }
        Monitor.setPanelText(ip, "");
        cbuf.append(ip).append("\n");
        String script = cbuf.toString().trim();
        if (script.length() == 0) {
            return;
        }
        Cutter.setLog("    Debug:RemoteBuildTool.sendBuildCutlet()\n" + script + "\n--------------------------\n");
        File f = new File(FileUtils.getPWD(), "remote_build.cutlet");
        FileUtils.writeFile(f, script);
        CutletScriptHandler handler = new CutletScriptHandler();
        handler.execute(script);
    }

    private void remoteSave() {
        String path;
        this.saveSelf();
        boolean argsIsActive = false;
        if (this.srcPanel.aField.field.isEnabled()) {
            path = Preferences.get(Preferences.TOOL_REMOTEBUILD_SRC_ARGS);
            argsIsActive = true;
        } else {
            path = Preferences.get(Preferences.TOOL_REMOTEBUILD_SRC_H);
        }
        String ip1 = Preferences.get(Preferences.TOOL_REMOTEBUILD_DST_IP_1);
        String ip2 = Preferences.get(Preferences.TOOL_REMOTEBUILD_DST_IP_2);
        String dstH1 = Preferences.get(Preferences.TOOL_REMOTEBUILD_DST_H_DIR_1);
        String dstH2 = Preferences.get(Preferences.TOOL_REMOTEBUILD_DST_H_DIR_2);
        String dstA1 = Preferences.get(Preferences.TOOL_REMOTEBUILD_DST_ARGS_DIR_1);
        String dstA2 = Preferences.get(Preferences.TOOL_REMOTEBUILD_DST_ARGS_DIR_2);
        String enable1 = Preferences.get(Preferences.TOOL_REMOTEBUILD_ENABLED_IP_1);
        String enable2 = Preferences.get(Preferences.TOOL_REMOTEBUILD_ENABLED_IP_2);
        if (enable1.equals("true")) {
            this.sendSaveCutlet(path, ip1, argsIsActive ? dstA1 : dstH1);
        }
        if (enable2.equals("true")) {
            this.sendSaveCutlet(path, ip2, argsIsActive ? dstA2 : dstH2);
        }
    }

    private void sendSaveCutlet(String hPath, String ip, String dstH) {
        if (ip.trim().length() == 0) {
            return;
        }
        if (dstH.trim().length() == 0) {
            String[] msg = new String[]{"The path of the directory in which the header file", "should be written on the computer with IP", "   " + ip, "has not been specified."};
            DialogUtils.showErrorMessage("Error: Header File Destination", msg);
            return;
        }
        StringBuffer hbuf = new StringBuffer();
        if (hPath.trim().length() > 0 && dstH.trim().length() > 0) {
            hbuf.append("build.").append("write").append(" -src \"").append(hPath).append("\"");
            hbuf.append(" -target \"").append(dstH).append("\"");
            hbuf.append(" -sender \"").append(KClient.getLocalIP()).append("\"");
            hbuf.append(" -recipientIP \"").append(ip).append("\"\n");
        }
        Monitor.setPanelText(ip, "");
        hbuf.append(ip).append("\n");
        String script = hbuf.toString().trim();
        if (script.length() == 0) {
            return;
        }
        Cutter.setLog("    Debug:RemoteBuildTool.sendSaveCutlet()\n" + script + "\n--------------------------\n");
        File f = new File(FileUtils.getPWD(), "remote_save.cutlet");
        FileUtils.writeFile(f, script);
        CutletScriptHandler handler = new CutletScriptHandler();
        handler.execute(script);
    }

    @Override
    protected void toolSelectionHappened() {
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docname) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    protected void adjustUI(File file) {
        if (file == null) {
            this.deactivateSelf();
            this.srcPanel.updateUI(null);
            this.dstPanel1.adjustUI();
            this.dstPanel2.adjustUI();
        } else {
            this.activateSelf();
            this.srcPanel.updateUI(file);
            this.dstPanel1.adjustUI();
            this.dstPanel2.adjustUI();
        }
        if (file.getName().endsWith(".c") || file.getName().endsWith(".cpp") || file.getName().endsWith(".h") || file.getName().endsWith(".args")) {
            this.doItButton.setEnabled(true);
        } else {
            this.doItButton.setEnabled(false);
        }
    }

    @Override
    public void activateSelf() {
        super.activateSelf();
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
        this.srcPanel.saveSelf();
        this.dstPanel1.saveSelf();
        this.dstPanel2.saveSelf();
    }

    private class SourcePanel
    extends KTitledPanel {
        public KLabelledField hField;
        public KLabelledField cField;
        public KLabelledField aField;
        private File hFile;
        private File cFile;
        private File aFile;

        public SourcePanel() {
            super(" Local Files ", "RemoteBuild.SourcePanel.info");
            this.hField = new KLabelledField(".h", 40, "", 10);
            this.cField = new KLabelledField(".cpp", 40, "", 10);
            this.aField = new KLabelledField(".args", 40, "", 10);
            this.hFile = null;
            this.cFile = null;
            this.aFile = null;
            this.hField.field.setEditable(false);
            this.cField.field.setEditable(false);
            this.aField.field.setEditable(false);
            this.hFile = new File(Preferences.get(Preferences.TOOL_REMOTEBUILD_SRC_H));
            this.cFile = new File(Preferences.get(Preferences.TOOL_REMOTEBUILD_SRC_CPP));
            this.aFile = new File(Preferences.get(Preferences.TOOL_REMOTEBUILD_SRC_ARGS));
            this.hField.field.setText(this.hFile == null || !this.hFile.exists() ? "" : this.hFile.getName());
            this.cField.field.setText(this.cFile == null || !this.cFile.exists() ? "" : this.cFile.getName());
            this.aField.field.setText(this.aFile == null || !this.aFile.exists() ? "" : this.aFile.getName());
            this.add(this.hField, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 0, 2)));
            this.add(this.cField, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 5, 2, 2)));
            this.add(this.aField, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(0, 5, 2, 2)));
        }

        private void saveSelf() {
            Preferences.write(Preferences.TOOL_REMOTEBUILD_SRC_H, this.hFile.getPath());
            Preferences.write(Preferences.TOOL_REMOTEBUILD_SRC_CPP, this.cFile.getPath());
            Preferences.write(Preferences.TOOL_REMOTEBUILD_SRC_ARGS, this.aFile.getPath());
        }

        public void updateUI(File f) {
            this.hField.field.setEnabled(false);
            this.cField.field.setEnabled(false);
            this.aField.field.setEnabled(false);
            if (f == null) {
                return;
            }
            if (f.getName().endsWith(".c") || f.getName().endsWith(".cpp")) {
                this.cField.field.setText(f == null || !f.exists() ? "" : f.getName());
                this.cFile = f;
                RemoteBuildTool.this.doItButton.setText(BUILD_REMOTELY);
                this.cField.field.setEnabled(true);
            } else if (f.getName().endsWith(".h")) {
                this.hField.field.setText(f == null || !f.exists() ? "" : f.getName());
                this.hFile = f;
                RemoteBuildTool.this.doItButton.setText(SAVE_REMOTELY);
                this.hField.field.setEnabled(true);
            } else if (f.getName().endsWith(".args")) {
                this.aField.field.setText(f == null || !f.exists() ? "" : f.getName());
                this.aFile = f;
                RemoteBuildTool.this.doItButton.setText(SAVE_REMOTELY);
                this.aField.field.setEnabled(true);
            }
            this.saveSelf();
        }
    }

    private class TargetPanel
    extends KTitledPanel {
        public KLabelledField ip;
        public KLabelledField hDir;
        public KLabelledField cppDir;
        public KLabelledField argsDir;
        public KCheckBox writeCB;
        public KCheckBox enableCB;
        private int ipPref;
        private int hPref;
        private int cppPref;
        private int argsPref;
        private int writePref;
        private int enablePref;

        public TargetPanel(int ipPref, int hPref, int cppPref, int argsPref, int writePref, int enablePref) {
            super("Remote Directory Paths ", "RemoteBuild.TargetPanel.info");
            this.ip = new KLabelledField("IP Address ", 70, "", 12);
            this.hDir = new KLabelledField(".h Dir", 55, "", 14);
            this.cppDir = new KLabelledField(".cpp Dir ", 55, "", 14);
            this.argsDir = new KLabelledField(".args Dir", 55, "", 14);
            this.writeCB = new KCheckBox(".cpp write permission");
            this.enableCB = new KCheckBox("Enable");
            this.ipPref = ipPref;
            this.hPref = hPref;
            this.cppPref = cppPref;
            this.argsPref = argsPref;
            this.writePref = writePref;
            this.enablePref = enablePref;
            Font font = this.ip.label.getFont();
            font = new Font(font.getName(), 0, font.getSize());
            this.ip.label.setFont(font);
            this.hDir.label.setFont(font);
            this.cppDir.label.setFont(font);
            this.argsDir.label.setFont(font);
            this.ip.field.setText(Preferences.get(ipPref));
            this.hDir.field.setText(Preferences.get(hPref));
            this.cppDir.field.setText(Preferences.get(cppPref));
            this.argsDir.field.setText(Preferences.get(argsPref));
            this.writeCB.setSelected(Preferences.get(writePref).equals("true"));
            this.enableCB.setSelected(Preferences.get(enablePref).equals("true"));
            this.enableCB.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    Object obj = evt.getSource();
                    if (!(obj instanceof KCheckBox)) {
                        return;
                    }
                    TargetPanel.this.ip.field.setEnabled(((KCheckBox)obj).isSelected());
                }
            });
            String[] keys = new String[]{"user"};
            this.add(this.ip, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(2, 5, 0, 0)));
            this.add(this.hDir, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 5, 0, 0)));
            this.add(this.cppDir, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 5, 0, 0)));
            this.add(this.argsDir, new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 5, 0, 0)));
            this.add(this.writeCB, new GBC(0, 4, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 0, 0)));
            this.add(this.enableCB, new GBC(0, 5, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(-2, 5, 0, 0)));
        }

        private void saveSelf() {
            Preferences.write(this.ipPref, this.ip.field.getText());
            Preferences.write(this.hPref, this.hDir.field.getText());
            Preferences.write(this.cppPref, this.cppDir.field.getText());
            Preferences.write(this.argsPref, this.argsDir.field.getText());
            Preferences.write(this.writePref, this.writeCB.isSelected() ? "true" : "false");
            Preferences.write(this.enablePref, this.enableCB.isSelected() ? "true" : "false");
        }

        public void adjustUI() {
            if (Preferences.get(this.enablePref).equals("true")) {
                this.ip.field.setEnabled(true);
            } else {
                this.ip.field.setEnabled(false);
            }
        }
    }
}

