/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rif;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KButton.PathSearchButton;
import UI_Components.KButton.PathSearchListener;
import UI_Components.KLabelledField;
import UI_Components.KTextField.KLabelledSerialTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.Rif.RifTool;
import Utilities.EnvUtils;
import Utilities.ResourceUtils;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RifPanel
extends KTitledPanel
implements PathSearchListener {
    public final int MAX_POPUP_TEXT_LENGTH = 30;
    private final String UNKNOWN = "Unknown";
    private static final String EMPTY_LIST_STR = "no rifs";
    private RifsComboPanel rifsComboPanel = new RifsComboPanel();
    private KLabelledField rifPath = new KLabelledField(" Path", 20, "");
    private PathSearchButton search = new PathSearchButton(this.rifPath, "?", "Choose Rif", 0);
    private String cerealname = "RifArgs";
    private KLabelledSerialTextField rifArgs = new KLabelledSerialTextField(" Args", 20, "", this.cerealname);
    private JCheckBox enableCB = new JCheckBox("Enable");
    private JCheckBox disableAllCB = new JCheckBox("Disable All");

    public RifPanel(String title) {
        super(title);
        this.add(this.rifsComboPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        this.add(this.rifPath, new GBC(0, 1, 1, 1, 1.0, 0.0, -5, 0, 18, 2, new Insets(5, 0, 0, 0)));
        this.add(this.search, new GBC(1, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(5, 0, 0, 5)));
        this.add(this.rifArgs, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 2, 0)));
        this.add(this.enableCB, new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(-6, 50, -5, 0)));
        this.add(this.disableAllCB, new GBC(0, 4, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 0, 0)));
        this.disableAllCB.setHorizontalTextPosition(2);
        this.rifPath.field.usesModelDialog = true;
        this.rifArgs.field.usesModelDialog = true;
        this.rifPath.field.setHorizontalAlignment(2);
        if (EnvUtils.isWinEnvironment()) {
            this.search.setPreferredFileFilter("dll");
        } else {
            this.search.setPreferredFileFilter("so");
        }
        this.search.addPathSearchListener(this);
        this.enableCB.setSelected(true);
        this.enableCB.addActionListener(this.rifsComboPanel);
        this.rifPath.setMinimumSize(this.rifPath.getPreferredSize());
        this.rifArgs.setMinimumSize(this.rifArgs.getPreferredSize());
        this.rifPath.field.addActionListener(this.rifsComboPanel);
        this.rifPath.field.addKeyListener(this.rifsComboPanel);
        this.rifArgs.field.getDocument().addDocumentListener(this.rifsComboPanel);
        this.disableAllCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                RifTool.useRifs(!RifPanel.this.disableAllCB.isSelected());
                Cutter.setLog("    Debug:RifPanel.RifPanel() - disableAllCB changed.");
            }
        });
        String rawInput = Preferences.get(Preferences.TOOL_RIF_PATHS);
        if (rawInput != null && rawInput.trim().length() > 0) {
            String[] pathsTokens = TextUtils.tokenize(rawInput, '\u0010');
            rawInput = Preferences.get(Preferences.TOOL_RIF_ARGS);
            String enabled = Preferences.get(Preferences.TOOL_RIF_ENABLE);
            String[] argsTokens = TextUtils.tokenize(rawInput, '\u0010');
            for (int n = 0; n < pathsTokens.length; ++n) {
                File f = new File(pathsTokens[n]);
                RifItem item = new RifItem(f);
                String args = argsTokens[n];
                if (args != null && args.trim().length() > 0) {
                    item.args = this.replaceChars(args, '\u0081', '\"');
                }
                if (enabled.trim().length() != pathsTokens.length) {
                    item.setActive(true);
                } else {
                    item.setActive(enabled.charAt(n) == '1');
                }
                this.add(item);
            }
            this.rifsComboPanel.combo.setSelectedIndex(0);
        }
    }

    @Override
    public void pathSearchCompleted() {
        this.rifsComboPanel.updateComboText();
    }

    @Override
    public void pathSearchCancelled() {
    }

    private void add(RifItem item) {
        String path = item.getPath();
        for (int n = 0; n < this.rifsComboPanel.combo.getItemCount(); ++n) {
            RifItem i = (RifItem)this.rifsComboPanel.combo.getItemAt(n);
            if (i == null || !i.getPath().equals(path)) continue;
            Cutter.setLog("    Info:RifPanel not adding duplicate rif : \"" + path + "\"");
            this.rifsComboPanel.combo.setSelectedItem(i);
            return;
        }
        this.enableCB.setSelected(true);
        this.rifsComboPanel.combo.addItem(item);
        this.rifsComboPanel.combo.setSelectedItem(item);
        this.rifArgs.field.setText(item.getArgs());
    }

    private RifItem[] getActiveRifs() {
        Vector<RifItem> list = new Vector<RifItem>();
        for (int n = 0; n < this.rifsComboPanel.combo.getItemCount(); ++n) {
            RifItem item = (RifItem)this.rifsComboPanel.combo.getItemAt(n);
            if (!item.pathIsOK() || !item.active) continue;
            list.addElement(item);
        }
        return this.listToArray(list);
    }

    private RifItem[] listToArray(Vector<RifItem> list) {
        if (list.size() == 0) {
            return null;
        }
        RifItem[] out = new RifItem[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = list.elementAt(n);
        }
        return out;
    }

    public String[] getPaths() {
        RifItem[] rifs = this.getActiveRifs();
        if (rifs == null || rifs.length == 0) {
            return null;
        }
        String[] out = new String[rifs.length];
        for (int n = 0; n < rifs.length; ++n) {
            out[n] = rifs[n].getPath();
        }
        return out;
    }

    public String[] getArgs() {
        RifItem[] rifs = this.getActiveRifs();
        if (rifs == null || rifs.length == 0) {
            return null;
        }
        String[] out = new String[rifs.length];
        for (int n = 0; n < rifs.length; ++n) {
            out[n] = rifs[n].getArgs();
        }
        return out;
    }

    public void saveSelf() {
        StringBuffer pathsBuf = new StringBuffer();
        StringBuffer argsBuf = new StringBuffer();
        StringBuffer enableBuf = new StringBuffer();
        for (int n = 0; n < this.rifsComboPanel.combo.getItemCount(); ++n) {
            RifItem item = (RifItem)this.rifsComboPanel.combo.getItemAt(n);
            if (!item.pathIsOK()) continue;
            String args = this.replaceChars(item.getArgs(), '\"', '\u0081');
            argsBuf.append(args).append('\u0010');
            pathsBuf.append(item.getPath()).append('\u0010');
            enableBuf.append(item.getActive() ? "1" : "0");
        }
        Preferences.write(Preferences.TOOL_RIF_PATHS, pathsBuf.toString());
        Preferences.write(Preferences.TOOL_RIF_ARGS, argsBuf.toString());
        Preferences.write(Preferences.TOOL_RIF_ENABLE, enableBuf.toString());
    }

    private String replaceChars(String input, char target, char replacement) {
        if (input == null || input.trim().length() == 0) {
            return replacement + " " + replacement;
        }
        StringBuffer b = new StringBuffer();
        for (int n = 0; n < input.length(); ++n) {
            b.append(input.charAt(n) == target ? replacement : input.charAt(n));
        }
        return b.toString();
    }

    public class RifsComboPanel
    extends JPanel
    implements ActionListener,
    DocumentListener,
    KeyListener {
        private JComboBox<RifItem> combo = new JComboBox();
        private JButton up;
        private JButton down;
        private JButton add;
        private JButton sub;
        private ImageIcon upIcon = ResourceUtils.getIconResource("/resources/rifup.gif");
        private ImageIcon downIcon = ResourceUtils.getIconResource("/resources/rifdown.gif");
        private ImageIcon addIcon = ResourceUtils.getIconResource("/resources/rifadd.gif");
        private ImageIcon subIcon = ResourceUtils.getIconResource("/resources/rifsub.gif");
        private boolean addInProgress = false;

        public RifsComboPanel() {
            this.setLayout(new GridBagLayout());
            this.up = new JButton(this.upIcon);
            this.down = new JButton(this.downIcon);
            this.add = new JButton(this.addIcon);
            this.sub = new JButton(this.subIcon);
            this.up.setMargin(new Insets(-1, 0, 0, 0));
            this.down.setMargin(new Insets(-1, 0, 0, 0));
            this.add.setMargin(new Insets(-1, 0, 0, 0));
            this.sub.setMargin(new Insets(-1, 0, 0, 0));
            this.up.addActionListener(this);
            this.down.addActionListener(this);
            this.add.addActionListener(this);
            this.sub.addActionListener(this);
            this.up.setRequestFocusEnabled(false);
            this.down.setRequestFocusEnabled(false);
            this.add.setRequestFocusEnabled(false);
            this.sub.setRequestFocusEnabled(false);
            this.add((Component)this.add, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(5, 5, 5, 0)));
            this.add((Component)this.sub, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(5, 0, 5, 0)));
            this.add(this.combo, new GBC(2, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(5, 3, 5, 0)));
            this.add((Component)this.up, new GBC(3, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(5, 3, 5, 0)));
            this.add((Component)this.down, new GBC(4, 0, 1, 1, 0.0, 0.0, 1, 1, 18, 0, new Insets(5, 0, 5, 0)));
            this.combo.setFont(Cutter.defaultFont.font);
            this.combo.setPreferredSize(new Dimension(180, 21));
            this.combo.setMinimumSize(this.combo.getPreferredSize());
            this.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RifItem item = (RifItem)RifsComboPanel.this.combo.getSelectedItem();
                    if (item == null) {
                        return;
                    }
                    RifPanel.this.enableCB.setSelected(item.getActive());
                    ((RifPanel)RifPanel.this).rifArgs.field.setText(item.getArgs());
                    ((RifPanel)RifPanel.this).rifPath.field.setText(item.getPath());
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.up) {
                if (this.combo.getItemCount() < 2) {
                    return;
                }
                int n = this.combo.getSelectedIndex();
                if (n == 0) {
                    return;
                }
                RifItem item = this.combo.getItemAt(n);
                this.combo.removeItem(item);
                this.combo.insertItemAt(item, n - 1);
                return;
            }
            if (src == this.down) {
                if (this.combo.getItemCount() < 2) {
                    return;
                }
                int n = this.combo.getSelectedIndex();
                if (n == this.combo.getItemCount() - 1) {
                    return;
                }
                RifItem item = this.combo.getItemAt(n);
                this.combo.removeItem(item);
                this.combo.insertItemAt(item, n + 1);
                return;
            }
            if (src == this.sub) {
                RifItem item = (RifItem)this.combo.getSelectedItem();
                if (item != null) {
                    this.combo.removeItem(item);
                }
                if (this.combo.getItemCount() == 0) {
                    ((RifPanel)RifPanel.this).rifArgs.field.setText("");
                    ((RifPanel)RifPanel.this).rifPath.field.setText("");
                }
                return;
            }
            if (src == this.add) {
                this.addInProgress = true;
                RifPanel.this.search.doClick();
                String path = ((RifPanel)RifPanel.this).rifPath.field.getText();
                if (path.equals("")) {
                    return;
                }
                File f = new File(path);
                if (!f.exists()) {
                    Cutter.setLog("    Error:RifPanel.add - does not exist: \"" + path + "\"");
                    return;
                }
                RifItem item = new RifItem(f);
                RifPanel.this.enableCB.setSelected(true);
                this.combo.insertItemAt(item, 0);
                this.combo.setSelectedItem(item);
                RifPanel.this.rifArgs.setEnabled(!item.getFullName().equals("Unknown"));
                RifPanel.this.enableCB.setEnabled(!item.getFullName().equals("Unknown"));
                ((RifPanel)RifPanel.this).rifArgs.field.setText("");
                this.addInProgress = false;
            }
            if (src == RifPanel.this.enableCB) {
                RifItem item = (RifItem)this.combo.getSelectedItem();
                if (item != null) {
                    Cutter.setLog("RifComboPanel.actionPerformed() - setting " + item.getFullName() + " to " + RifPanel.this.enableCB.isSelected());
                    item.setActive(RifPanel.this.enableCB.isSelected());
                }
                return;
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.updateComboText();
            }
        }

        public void updateComboText() {
            RifItem item;
            if (this.addInProgress) {
                return;
            }
            String path = ((RifPanel)RifPanel.this).rifPath.field.getText();
            if (path == null || path.trim().length() == 0) {
                return;
            }
            if (((RifPanel)RifPanel.this).rifsComboPanel.combo.getItemCount() == 0) {
                item = new RifItem(new File(path));
                if (item == null) {
                    return;
                }
                this.combo.insertItemAt(item, 0);
                this.combo.setSelectedItem(item);
            } else {
                item = (RifItem)this.combo.getSelectedItem();
                item.setPath(path);
            }
            item.setPath(((RifPanel)RifPanel.this).rifPath.field.getText());
            item.setArgs(((RifPanel)RifPanel.this).rifArgs.field.getText());
            this.combo.repaint();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateRifItem();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateRifItem();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateRifItem();
        }

        private void updateRifItem() {
            RifItem item = (RifItem)this.combo.getSelectedItem();
            if (item == null) {
                return;
            }
            item.setArgs(((RifPanel)RifPanel.this).rifArgs.field.getText());
            RifPanel.this.rifArgs.setEnabled(!item.getFullName().equals("Unknown"));
            RifPanel.this.enableCB.setEnabled(!item.getFullName().equals("Unknown"));
        }
    }

    private class RifItem
    extends JComponent {
        private String fullpath = "";
        private String fullname = "";
        private String shortname = "";
        private String args = "";
        private boolean active = true;

        public RifItem(File f) {
            this.init(f);
        }

        private void init(File f) {
            this.init(f.getPath());
        }

        private void init(String path) {
            if (path.trim().length() == 0) {
                this.fullname = "Unknown";
            } else {
                File f = new File(path);
                this.fullname = TextUtils.removeExtension(f.getName());
            }
            this.shortname = this.fullname;
            if (this.fullname.length() > 30) {
                this.shortname = "..." + this.fullname.substring(this.fullname.length() - 30);
            }
            this.fullpath = path;
        }

        @Override
        public String toString() {
            return this.shortname;
        }

        public void setPath(File f) {
            this.init(f);
        }

        public void setPath(String s) {
            this.init(s);
        }

        public void setArgs(String s) {
            this.args = s;
        }

        public void setActive(boolean f) {
            this.active = f;
        }

        public String getFullName() {
            return this.fullname;
        }

        public String getShortName() {
            return this.shortname;
        }

        public String getPath() {
            return this.fullpath;
        }

        public boolean getActive() {
            return this.active;
        }

        public String getArgs() {
            return this.args;
        }

        public boolean pathIsOK() {
            if (this.fullname.trim().length() == 0 || this.fullpath.trim().length() == 0) {
                return false;
            }
            if (this.fullname.equals("Unknown")) {
                return false;
            }
            File f = new File(this.fullpath);
            return f.exists();
        }
    }
}

