/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rif;

import Preferences.Preferences;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KButton.PathSearchButton;
import UI_Components.KLabel;
import UI_Components.KLabelledField;
import UI_Components.KTextField.KIntTextField;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.KTools;
import UI_Tools.Rif.RifPanel;
import UI_Tools.Rman.RenderInfo;
import Utilities.DialogUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class RifTool
extends KTools {
    protected static RifTool tool = null;
    private RifPanel rifPanel;
    private RibPanel ribPanel;
    private JButton renderButton = new JButton(" prman ");
    private JButton catribButton = new JButton(" catrib ");
    private final int DIRECT_RENDER = 1;
    private final int CATRIB = 2;
    private static boolean useRifs = true;

    public static RifTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new RifTool(menuItem);
        return tool;
    }

    protected RifTool(JMenuItem menuItem) {
        super("Rif Tool", menuItem, Preferences.TOOL_RIF);
        Cutter.DefaultFont df = Cutter.defaultFont;
        --df.size;
        String title = EnvUtils.isWinEnvironment() ? " Rif ( .dll ) " : " Rif ( .so ) ";
        this.rifPanel = new RifPanel(title);
        this.ribPanel = new RibPanel(" Ribs ");
        this.contentPane.add((Component)this.rifPanel, new GBC(0, 0, 2, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)this.ribPanel, new GBC(0, 1, 2, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.renderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RifTool.this.applyRif(1);
            }
        });
        this.catribButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RifTool.this.applyRif(2);
            }
        });
        this.contentPane.add((Component)this.catribButton, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(5, 8, 10, 6)));
        this.contentPane.add((Component)this.renderButton, new GBC(1, 2, 1, 1, 1.0, 1.0, 0, 0, 12, 0, new Insets(5, 2, 10, 8)));
        this.setTitle("Rif Tool");
        this.pack();
        this.setVisible(false);
    }

    public static void useRifs(boolean f) {
        useRifs = f;
        RifTool.tool.catribButton.setEnabled(f);
    }

    private void applyRif(int mode) {
        String ribInPath = ((RibPanel)this.ribPanel).ribInPath.field.getText();
        File f = new File(ribInPath);
        if (!f.exists()) {
            String[] msg = new String[]{"The target rib file:", "", "does not exist!"};
            msg[1] = "\"" + ribInPath + "\"";
            DialogUtils.showErrorMessage("Cannot Find Input Rib", msg);
            return;
        }
        String scriptname = EnvUtils.isWinEnvironment() ? "test_rif.bat" : "test_rif";
        File tmp = new File(FileUtils.getPWDFile(), scriptname);
        String[] rifPaths = this.rifPanel.getPaths();
        String[] rifArgs = this.rifPanel.getArgs();
        if (rifPaths == null || rifPaths.length == 0) {
            Cutter.setLog("    Warning:RifTool.applyRifs no rifs to apply. Will render rib directly.");
            mode = 1;
            useRifs = false;
        }
        if (rifPaths != null && rifPaths.length > 0) {
            useRifs = true;
        }
        if (mode == 1 && !useRifs) {
            StringBuffer b = new StringBuffer();
            b.append("prman -t:all \"").append(ribInPath).append("\"");
            FileUtils.writeFile(tmp, b.toString());
            Cutter.setLog("    Debug:RifTool.applyRif() - direct render without rifs:\n           " + b.toString());
            this.executeScript(tmp);
            return;
        }
        Cutter.setLog("    Debug:RifTool.applyRifs PATHS:");
        Cutter.setLog(rifPaths, 3);
        Cutter.setLog("    Info:RifTool.applyRifs ARGS (the arg strings may be empty):");
        Cutter.setLog(rifArgs, 3);
        if (rifPaths.length != rifArgs.length) {
            Cutter.setLog("    Error:RifTool.applyRifs() - cannot continue: number of paths and args do not match.");
            return;
        }
        ProcessManager fp = new ProcessManager("RifTest");
        if (mode == 1) {
            String cmd = this.makePrmanScript(rifPaths, rifArgs, ribInPath);
            FileUtils.writeFile(tmp, cmd);
            this.executeScript(tmp);
            return;
        }
        String ribOutPath = ((RibPanel)this.ribPanel).ribOutPath.field.getText();
        File outrib = new File(ribOutPath);
        if (mode == 2) {
            StringBuffer b = new StringBuffer();
            String binPath = RenderInfo.getRPSBinPath();
            File binDir = new File(binPath);
            if (!binDir.exists()) {
                Cutter.setLog("    Warning: RifTool.applyRif() - \"Preferences.PATH_PIXAR_PROSERVER\" is incorrect.");
            } else if (EnvUtils.isWinEnvironment()) {
                StringBuffer out = new StringBuffer();
                for (int n = 0; n < binPath.length(); ++n) {
                    char c = binPath.charAt(n);
                    if (c == '/') {
                        out.append('\\');
                        continue;
                    }
                    out.append(c);
                }
                binPath = out.toString();
                b.append("\"").append(binPath).append("\"\\");
            } else {
                b.append(binPath).append("/");
            }
            b.append("prman -catrib \"").append(ribOutPath).append("\" ");
            for (int n = 0; n < rifPaths.length; ++n) {
                b.append(" -rif \"").append(rifPaths[n]).append("\"");
                if (rifArgs[n] == null || rifArgs[n].trim().length() == 0) {
                    b.append(" -rifargs -rifend ");
                    continue;
                }
                if (rifArgs[n].trim().length() == 1 && rifArgs[n].trim().charAt(0) == '\"') {
                    b.append(" -rifargs \" -rifend ");
                    continue;
                }
                if (rifArgs[n].trim().length() == 2 && rifArgs[n].charAt(0) == '\"' && rifArgs[n].charAt(1) == '\"') {
                    b.append(" -rifargs -rifend ");
                    continue;
                }
                b.append(" -rifargs \"").append(rifArgs[n]).append("\" -rifend ");
            }
            b.append("\"").append(ribInPath).append("\"");
            Cutter.setLog("    Info:RifTool.applyRif() - writing the following catrib script:");
            Cutter.setLog("           " + b.toString());
            FileUtils.writeFile(tmp, b.toString());
            this.executeScript(tmp);
        }
    }

    private String makePrmanScript(String[] rifPaths, String[] rifArgs, String ribInPath) {
        File ribsDir;
        StringBuffer b = new StringBuffer();
        File ribfile = new File(ribInPath);
        String ribName = ribfile.getName();
        int begin = this.ribPanel.getStartFrame();
        int end = this.ribPanel.getEndFrame();
        Cutter.setLog("    Debug:RifTool.makePrmanScript() - frame range: " + begin + " to " + end);
        String binpath = RenderInfo.getRPSBinPath();
        File binDir = new File(binpath);
        if (!binDir.exists()) {
            Cutter.setLog("    Warning: RifTool.applyRif() - \"Preferences.PATH_PIXAR_PROSERVER\" is incorrect.");
        } else if (EnvUtils.isWinEnvironment()) {
            StringBuffer out = new StringBuffer();
            for (int n = 0; n < binpath.length(); ++n) {
                char c = binpath.charAt(n);
                if (c == '/') {
                    out.append('\\');
                    continue;
                }
                out.append(c);
            }
            binpath = out.toString();
            b.append("\"").append(binpath).append("\"\\");
        } else {
            b.append(binpath).append("/");
        }
        b.append("prman ");
        for (int n = 0; n < rifPaths.length; ++n) {
            b.append(" -rif \"").append(rifPaths[n]).append("\"");
            if (rifArgs[n] == null || rifArgs[n].trim().length() == 0) {
                b.append(" -rifargs  -rifend ");
                continue;
            }
            if (rifArgs[n].trim().length() == 1 && rifArgs[n].trim().charAt(0) == '\"') {
                b.append(" -rifargs \" -rifend ");
                continue;
            }
            if (rifArgs[n].trim().length() == 2 && rifArgs[n].charAt(0) == '\"' && rifArgs[n].charAt(1) == '\"') {
                b.append(" -rifargs -rifend ");
                continue;
            }
            b.append(" -rifargs \"").append(rifArgs[n]).append("\" -rifend ");
        }
        b.append("\"").append(ribInPath).append("\"");
        String renderSingleFrameScript = b.toString();
        if (begin == -1 || end == -1) {
            Cutter.setLog("    Debug:RifTool.makePrmanScript() - writing a SINGLE frame prman script:\n           " + renderSingleFrameScript);
            return renderSingleFrameScript;
        }
        File parentFile = ribfile.getParentFile();
        if (parentFile == null || !parentFile.exists()) {
            Cutter.setLog("    Error:RifTool.makePrmanScript() - cannot find the parent directory of:");
            Cutter.setLog("           " + ribfile.getPath());
            return renderSingleFrameScript;
        }
        String parentName = parentFile.getName();
        if (parentName == null) {
            Cutter.setLog("    Error:RifTool.makePrmanScript() - cannot find the parent directory of:");
            Cutter.setLog("           " + ribfile.getPath());
            return renderSingleFrameScript;
        }
        String[] tokens = TextUtils.tokenize(ribName, ".");
        String stippedRibName = tokens == null || tokens.length == 0 ? ribName : tokens[0];
        int numPadChars = 4;
        if (tokens != null && tokens.length >= 3) {
            String numericStr = tokens[tokens.length - 2];
            numPadChars = numericStr.length();
            Cutter.setLog("    Info:makePrmanScript() - found " + numPadChars + " digits of padding.");
        }
        b.setLength(0);
        if (parentName.length() == 4 && Character.isDigit(parentName.charAt(0)) && Character.isDigit(parentName.charAt(1)) && Character.isDigit(parentName.charAt(2)) && Character.isDigit(parentName.charAt(3))) {
            ribsDir = parentFile.getParentFile();
            for (int n = begin; n <= end; ++n) {
                String padding = FileUtils.getPaddedInt(n, numPadChars);
                String ribname = stippedRibName + "." + padding + ".rib";
                File f = new File(ribsDir, padding);
                if (!(f = new File(f, ribname)).exists()) continue;
                b.append("prman ");
                for (int i = 0; i < rifPaths.length; ++i) {
                    b.append(" -rif \"").append(rifPaths[i]).append("\"");
                    b.append(" -rifargs \"").append(rifArgs[i]).append("\" -rifend ");
                }
                b.append("\"").append(f.getPath()).append("\"\n");
            }
        } else {
            ribsDir = parentFile;
            Cutter.setLog("    Info:RifTool.makeScript() - processing Houdini ribs in \"" + ribsDir + "\"");
            Cutter.setLog("    Info:RifTool.makeScript() - frames " + begin + " to " + end);
            for (int n = begin; n <= end; ++n) {
                String padding = FileUtils.getPaddedInt(n, numPadChars);
                String ribname = stippedRibName + "." + padding + ".rib";
                File f = new File(ribsDir, ribname);
                if (!f.exists()) {
                    Cutter.setLog("    Info:RifTool.makeScript() - skipping \"" + f.getPath() + "\"");
                    continue;
                }
                b.append("prman ");
                for (int i = 0; i < rifPaths.length; ++i) {
                    b.append(" -rif \"").append(rifPaths[i]).append("\"");
                    b.append(" -rifargs \"").append(rifArgs[i]).append("\" -rifend ");
                }
                b.append("\"").append(f.getPath()).append("\"\n");
            }
        }
        Cutter.setLog("    Info:RifTool.makePrmanScript() - writing a MULTI frame prman script:");
        Cutter.setLog(b.toString());
        return b.toString();
    }

    private void executeScript(final File f) {
        ProcessManager fp1;
        if (!EnvUtils.isWinEnvironment()) {
            String[] items = new String[]{"chmod", "777", f.getPath()};
            fp1 = new ProcessManager("RifTest");
            fp1.launch(items, null, false, null, true);
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        File envDir = f.getParentFile();
                        String[] item = new String[]{"./" + f.getName()};
                        ProcessManager fp2 = new ProcessManager("RifTest");
                        fp2.launch(item, envDir, false, null, false);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (EnvUtils.isWinEnvironment()) {
            String[] item1 = new String[]{"cmd", "/Q", "/C", f.getPath()};
            fp1 = new ProcessManager("RifTest");
            File dir = f.getParentFile();
            fp1.launch(item1, dir, false, null, false);
        }
    }

    @Override
    protected void saveSelf() {
        this.rifPanel.saveSelf();
        String ribInPath = ((RibPanel)this.ribPanel).ribInPath.field.getText();
        String ribOutPath = ((RibPanel)this.ribPanel).ribOutPath.field.getText();
        Preferences.write(Preferences.TOOL_RIF_RIBIN_PATH, ribInPath);
        Preferences.write(Preferences.TOOL_RIF_RIBOUT_PATH, ribOutPath);
        super.saveSelf();
    }

    @Override
    protected void toolSelectionHappened() {
        if (this.lastFocusedComponent != null) {
            this.lastFocusedComponent.requestFocus();
            this.lastFocusedComponent.selectAll();
        }
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docname) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    private class RibPanel
    extends KTitledPanel
    implements FocusListener,
    ActionListener {
        private KLabelledField ribInPath;
        private PathSearchButton inButton;
        private KLabelledField ribOutPath;
        private PathSearchButton outButton;
        private OpenRibButton openRib;
        private JCheckBox animCB;
        private KIntTextField startFrame;
        private KLabel to;
        private KIntTextField endFrame;

        public RibPanel(String title) {
            super(title);
            this.ribInPath = new KLabelledField("Source", 13, "", new Insets(0, 5, 5, 5));
            this.inButton = new PathSearchButton(this.ribInPath, "?", "Choose Rib", 0);
            this.ribOutPath = new KLabelledField("Filtered", 13, "", new Insets(0, 5, 5, 0));
            this.outButton = new PathSearchButton(this.ribOutPath, "?", "Choose Rib", 0);
            this.openRib = new OpenRibButton();
            this.animCB = new JCheckBox("Frames");
            this.startFrame = new KIntTextField("1", 3);
            this.to = new KLabel("To");
            this.endFrame = new KIntTextField("1", 3);
            this.add(this.ribInPath, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 2, new Insets(5, 0, 0, 0)));
            this.add(this.inButton, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 2, new Insets(5, 0, 0, 5)));
            this.add(this.ribOutPath, new GBC(0, 1, 1, 1, 0.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 0, 0)));
            this.add(this.outButton, new GBC(1, 1, 1, 1, 0.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 0, 5)));
            JPanel ribPanel = new JPanel();
            ribPanel.setLayout(new GridBagLayout());
            JPanel animPanel = new JPanel();
            animPanel.setLayout(new GridBagLayout());
            this.endFrame.setEnabled(false);
            this.to.setEnabled(false);
            this.animCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    RibPanel.this.startFrame.setEnabled(RibPanel.this.animCB.isSelected());
                    RibPanel.this.to.setEnabled(RibPanel.this.animCB.isSelected());
                    RibPanel.this.endFrame.setEnabled(RibPanel.this.animCB.isSelected());
                    RifTool.this.catribButton.setEnabled(!RibPanel.this.animCB.isSelected());
                }
            });
            ribPanel.add((Component)this.openRib, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
            ribPanel.add((Component)new JPanel(), new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 12, 2, new Insets(0, 0, 0, 0)));
            ribPanel.add((Component)animPanel, new GBC(2, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 2, new Insets(0, 0, 0, 0)));
            animPanel.add((Component)this.animCB, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 16, 0, new Insets(0, 0, 0, 0)));
            animPanel.add((Component)this.startFrame, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 16, 0, new Insets(0, 10, 0, 0)));
            animPanel.add((Component)this.to, new GBC(2, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 0, new Insets(0, 3, 0, 5)));
            animPanel.add((Component)this.endFrame, new GBC(3, 0, 1, 1, 1.0, 1.0, 0, 0, 16, 0, new Insets(0, 0, 0, 0)));
            this.add(ribPanel, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(5, 5, 10, 0)));
            this.ribInPath.setMinimumSize(this.ribInPath.getPreferredSize());
            this.ribOutPath.setMinimumSize(this.ribOutPath.getPreferredSize());
            this.startFrame.setMargin(new Insets(2, 0, 2, 0));
            this.startFrame.setMinimumSize(this.startFrame.getPreferredSize());
            this.startFrame.setEnabled(false);
            this.endFrame.setMargin(new Insets(2, 0, 2, 0));
            this.endFrame.setMinimumSize(this.endFrame.getPreferredSize());
            this.endFrame.setEnabled(false);
            this.inButton.setPreferredFileFilter("rib");
            this.ribInPath.field.setText(Preferences.get(Preferences.TOOL_RIF_RIBIN_PATH));
            this.ribOutPath.field.setText(Preferences.get(Preferences.TOOL_RIF_RIBOUT_PATH));
            this.ribInPath.field.addFocusListener(this);
            this.ribOutPath.field.addFocusListener(this);
            this.ribInPath.field.addActionListener(this);
            this.ribOutPath.field.addActionListener(this);
        }

        public int getStartFrame() {
            if (!this.animCB.isSelected()) {
                return -1;
            }
            Integer i = this.startFrame.getInt();
            if (i == null) {
                return -1;
            }
            return i;
        }

        public int getEndFrame() {
            if (!this.animCB.isSelected()) {
                return -1;
            }
            Integer i = this.endFrame.getInt();
            if (i == null) {
                return -1;
            }
            return i;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (!ev.getActionCommand().equals("released")) {
                return;
            }
            KTextField field = (KTextField)ev.getSource();
            this.openRib.setEnabled(this.fileExists(field));
        }

        @Override
        public void focusGained(FocusEvent fe) {
            if (fe.getSource() == this.ribInPath.field && this.fileExists(this.ribInPath.field)) {
                this.openRib.setText("Open Source");
                this.openRib.setEnabled(true);
            }
            if (fe.getSource() == this.ribOutPath.field && this.fileExists(this.ribOutPath.field)) {
                this.openRib.setText("Open Filtered");
                this.openRib.setEnabled(true);
            }
        }

        private boolean fileExists(KTextField field) {
            String path = field.getText();
            return new File(path).exists();
        }

        @Override
        public void focusLost(FocusEvent fe) {
            this.openRib.setEnabled(false);
        }

        public class OpenRibButton
        extends KButton
        implements ActionListener {
            public OpenRibButton() {
                super("Open Source");
                this.setMargin(new Insets(1, 5, 1, 5));
                this.setRequestFocusEnabled(false);
                this.addActionListener(this);
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = "";
                if (((RibPanel)RibPanel.this).ribInPath.field.hasFocus()) {
                    path = ((RibPanel)RibPanel.this).ribInPath.field.getText();
                } else if (((RibPanel)RibPanel.this).ribOutPath.field.hasFocus()) {
                    path = ((RibPanel)RibPanel.this).ribOutPath.field.getText();
                }
                if (!path.equals("")) {
                    BBxt.newDocument(new File(path));
                }
            }
        }
    }
}

