/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.RIS;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.KMenuItem;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslShader;
import UI_Script.Osl.OslinfoParser;
import Utilities.DialogUtils;
import Utilities.FileUtils;
import Utilities.OslUtils;
import Utilities.ResourceUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;

public class OslShaderReader
extends Thread {
    ImageIcon rgbIcon = ResourceUtils.getIconResource("/resources/rgb.png");
    ImageIcon rgbaIcon = ResourceUtils.getIconResource("/resources/rgb_a.png");
    ImageIcon floatIcon = ResourceUtils.getIconResource("/resources/float.png");
    ImageIcon vectIcon = ResourceUtils.getIconResource("/resources/vector.png");
    ImageIcon intIcon = ResourceUtils.getIconResource("/resources/int.png");
    ImageIcon manIcon = ResourceUtils.getIconResource("/resources/manifold.png");
    private File usrOSODir = null;
    private JMenu parentMenu;
    private OslinfoParser osoParser = new OslinfoParser(OslUtils.getAnyBin());

    public OslShaderReader(JMenu parentMenu) {
        this.parentMenu = parentMenu;
        String usrOSODirPath = Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
        this.usrOSODir = new File(usrOSODirPath);
        if (!this.usrOSODir.exists()) {
            this.usrOSODir = null;
        }
    }

    public OslShaderReader() {
        String usrOSODirPath = Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
        this.usrOSODir = new File(usrOSODirPath);
        if (!this.usrOSODir.exists()) {
            this.usrOSODir = null;
        }
    }

    public String[] getUsrShaderNames() {
        if (this.usrOSODir == null) {
            return null;
        }
        return this.getShaderNames(this.usrOSODir);
    }

    public String getRibDeclaration(String name) {
        if (this.usrOSODir == null || name == null) {
            return null;
        }
        return this.getRibDeclaration(name, new File(this.usrOSODir, name));
    }

    public void updateMenuItems(boolean silent) {
        String usrOSODirPath = Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
        this.usrOSODir = new File(usrOSODirPath);
        if (this.usrOSODir == null || !this.usrOSODir.exists()) {
            if (!silent) {
                String[] msg = new String[]{"Unable to relaod user OSL shaders because the", "path specified in Preferences cannot be found.", "Open the Preferences->Rman-User tab and", "ensure \"osl source\" and \"osl shaders\" are set", "correctly. Don't forget to click \"Save User\"."};
                DialogUtils.showErrorMessage("Location of OSL Compiled Shaders Error", msg);
            }
            Cutter.setLog("    Debug:OslShaderReader.updateMenuItems() - usrOSODir is null");
            return;
        }
        String[] names = this.getShaderNames(this.usrOSODir);
        if (names == null || names.length == 0) {
            if (!silent) {
                String[] msg = new String[]{"Unable to relaod user OSL shaders because no", "compiled shaders were found in,\n", "  \"" + this.usrOSODir.getPath() + "\"\n", "Open the Preferences->Rman-User tab and", "ensure \"osl source\" and \"osl shaders\" are set", "correctly. Don't forget to click \"Save User\"."};
                DialogUtils.showErrorMessage("No User Compiled Shaders Error", msg);
            }
            Cutter.setLog("    Debug:OslShaderReader.updateMenuItems - no shaders in \"" + this.usrOSODir.getPath() + "\"");
            return;
        }
        this.parentMenu.removeAll();
        for (int n = 0; n < names.length; ++n) {
            String osoName = names[n];
            File osoFile = new File(this.usrOSODir.getPath(), osoName);
            OslinfoParser.RibInfo ribInfo = this.osoParser.getRibInfo(osoName, osoFile);
            if (ribInfo == null) continue;
            ImageIcon icon = this.getMenuItemIcon(osoName, osoFile);
            this.addMenuItem(osoName, icon, ribInfo);
        }
    }

    private void addMenuItem(String shaderName, ImageIcon icon, final OslinfoParser.RibInfo ribInfo) {
        KMenuItem item = new KMenuItem(shaderName, icon);
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.paste(ribInfo.toString(0));
            }
        };
        item.addActionListener(action);
        this.parentMenu.add(item);
    }

    private String getRibDeclaration(String name, File osoFile) {
        OslinfoParser.RibInfo ribInfo = this.osoParser.getRibInfo(name, osoFile);
        if (ribInfo == null) {
            return null;
        }
        return ribInfo.toString(0);
    }

    private ImageIcon getMenuItemIcon(String name, File osoFile) {
        boolean b_rgb = false;
        boolean b_float = false;
        boolean b_vector = false;
        boolean b_int = false;
        boolean b_manifold = false;
        OslinfoParser.RibInfo ribInfo = this.osoParser.getRibInfo(name, osoFile);
        if (ribInfo == null) {
            return null;
        }
        Object icon = null;
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < ribInfo.outputs.length; ++i) {
            OslShader.Parameter param = ribInfo.outputs[i];
            String typeStr = param.getDataType();
            if (typeStr.equalsIgnoreCase("unknown")) continue;
            list.add(typeStr);
        }
        String[] types = VectorUtils.toStringArray(list);
        b_manifold = TextUtils.isInList(types, "manifold");
        b_rgb = TextUtils.isInList(types, "color");
        b_float = TextUtils.isInList(types, "float");
        b_vector = TextUtils.isInList(types, "vector");
        b_vector = TextUtils.isInList(types, "normal");
        boolean bl = b_int = TextUtils.isInList(types, "int");
        if (b_manifold) {
            return this.manIcon;
        }
        if (b_rgb && b_float) {
            return this.rgbaIcon;
        }
        if (b_rgb) {
            return this.rgbIcon;
        }
        if (b_float) {
            return this.floatIcon;
        }
        if (b_vector) {
            return this.vectIcon;
        }
        return this.intIcon;
    }

    private String[] getShaderNames(File hostDir) {
        if (hostDir == null || !hostDir.exists()) {
            return null;
        }
        FileUtils.SourceFileFilter filter = new FileUtils.SourceFileFilter(".oso");
        return hostDir.list(filter);
    }
}

