/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.RIS;

import UI_BBXT.BBxt;
import UI_Components.KMenu;
import UI_Desktop.MenuItems.KMenuListenerAdapter;
import UI_Script.Rib.Parsers.ShadowParser;
import UI_Script.Rib.RibTokenizer;
import UI_Tools.Rman.RIS.Ris20MenuActions;
import UI_Tools.Rman.Ris20RibStrings;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class Ris20DocumentsMenu
extends KMenu {
    private static int oslDocCounter = 1;
    private static File oslDir = new File(FileUtils.getPWD(), "Cutter_Help/rman_tool_docs/osl");
    JMenu beautyPassesMenu = new JMenu("Beauty Passes");
    JMenuItem basicRisBeautyItem = new JMenuItem("New Rib...");
    JMenu shadowPassMenu = new JMenu("Shadow Pass");
    JMenuItem deepShdItem = new JMenuItem("Deep Shadow Rib");
    JMenuItem multiDocItem = new JMenuItem("Convert to KeyFrame...");
    JMenuItem addDenoiseItem = new JMenuItem("Enable Frame Denoise");
    JMenu oslPatternDocsItem = new JMenu("OSL Source Code");

    public Ris20DocumentsMenu() {
        super("Docs");
        this.add(this.beautyPassesMenu);
        this.add(this.shadowPassMenu);
        this.addSeparator();
        this.add(this.multiDocItem);
        this.add(this.addDenoiseItem);
        this.addDenoiseItem.addActionListener(new addDenoiseAction());
        this.addSeparator();
        this.add(this.oslPatternDocsItem);
        Ris20MenuActions menuActions = new Ris20MenuActions();
        this.beautyPassesMenu.add(this.basicRisBeautyItem);
        this.basicRisBeautyItem.addActionListener(menuActions.getBasicRISAction());
        this.basicRisBeautyItem.setEnabled(true);
        this.multiDocItem.addActionListener(menuActions.getMultiFrameAction());
        this.shadowPassMenu.add(this.deepShdItem);
        this.deepShdItem.addActionListener(menuActions.getShadowDocAction(ShadowParser.DEEP_SHADOW));
        this.addOslPatternItems(this.oslPatternDocsItem);
        this.shadowPassMenu.addMenuListener(new KMenuListenerAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                KAbstractWindow fw = BBxt.frontWindow();
                if (fw != null && !fw.isSelected()) {
                    Ris20DocumentsMenu.this.deepShdItem.setEnabled(false);
                } else if (fw != null && fw.isSelected()) {
                    String title = fw.getTitle();
                    String ext = FileUtils.getExtension(title);
                    if (ext == null || !ext.equalsIgnoreCase(".rib")) {
                        Ris20DocumentsMenu.this.multiDocItem.setEnabled(false);
                        Ris20DocumentsMenu.this.addDenoiseItem.setEnabled(false);
                    } else if (ext.equalsIgnoreCase(".rib")) {
                        Ris20DocumentsMenu.this.multiDocItem.setEnabled(true);
                        Ris20DocumentsMenu.this.addDenoiseItem.setEnabled(true);
                    }
                }
            }
        });
        this.addMenuListener(new KMenuListenerAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                KAbstractWindow fw = BBxt.frontWindow();
                if (fw != null && !fw.isSelected()) {
                    Ris20DocumentsMenu.this.multiDocItem.setEnabled(false);
                } else if (fw != null && fw.isSelected()) {
                    String title = fw.getTitle();
                    String ext = FileUtils.getExtension(title);
                    if (ext == null || !ext.equalsIgnoreCase(".rib")) {
                        Ris20DocumentsMenu.this.multiDocItem.setEnabled(false);
                    } else if (ext.equalsIgnoreCase(".rib")) {
                        Ris20DocumentsMenu.this.multiDocItem.setEnabled(true);
                    }
                }
            }
        });
    }

    private void addOslPatternItems(JMenu menu) {
        JMenuItem subItem = new JMenuItem("'st input' -> float output");
        subItem.addActionListener(new stFloatAction());
        menu.add(subItem);
        subItem = new JMenuItem("'st input' -> color output");
        subItem.addActionListener(new stColorAction());
        menu.add(subItem);
        menu.add(new JSeparator());
        subItem = new JMenuItem("metadata summary");
        subItem.addActionListener(new metadataAction());
        menu.add(subItem);
    }

    public static void createDocument(File file) {
        String str = FileUtils.read(file);
        if (str == null || str.trim().length() == 0) {
            str = "Error:DocumentsMenu(RIS).createDocument(File) - cannot find file \"" + file.getPath() + "\"";
        }
        BBxt.newDocument("untitled" + oslDocCounter++ + ".osl", str);
    }

    public static void addDenoise() {
        String ribname = TextUtils.removeExtension(BBxt.getWindowTitle());
        ribname = ribname + "_";
        String str = Ris20RibStrings.denoiseOptions;
        str = str.replaceAll("(__IMAGE_PATH__)", ribname);
        File f = new File(FileUtils.getPWD(), "DenoiseOptions.rib");
        FileUtils.writeFile(f, str);
        str = Ris20RibStrings.denoise;
        str = str.replaceAll("(__IMAGE_PATH__)", ribname);
        f = new File(FileUtils.getPWD(), "Denoise.rib");
        FileUtils.writeFile(f, str);
        JEditorPane textpane = BBxt.getTextPane();
        Document document = textpane.getDocument();
        Segment segment = DocumentUtils.getSegment(textpane.getDocument(), 0, document.getLength());
        int buffIndex = 0;
        RibTokenizer ribtok = new RibTokenizer();
        ribtok.setBuffer(segment);
        String nextStatment = ribtok.getNextRibStatement(null, true);
        while (!nextStatment.equals("")) {
            nextStatment = ribtok.getNextRibStatement(null, false);
            buffIndex = ribtok.getBufferIndex();
            if (nextStatment.equals("Display")) {
                BBxt.insertStringAt(document, buffIndex + 1, 0, "ReadArchive \"./DenoiseOptions.rib\"\n#");
                break;
            }
            nextStatment = ribtok.getNextRibStatement(null, true);
        }
        int len = document.getLength();
        BBxt.insertStringAt(document, len, 0, "\nReadArchive \"./Denoise.rib\"\n");
        BBxt.parseAll();
    }

    private static class addDenoiseAction
    extends AbstractAction {
        private addDenoiseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Ris20DocumentsMenu.addDenoise();
        }
    }

    private static class stFloatAction
    extends AbstractAction {
        private stFloatAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Ris20DocumentsMenu.createDocument(new File(oslDir, "st_float.osl"));
        }
    }

    private static class stColorAction
    extends AbstractAction {
        private stColorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Ris20DocumentsMenu.createDocument(new File(oslDir, "st_color.osl"));
        }
    }

    private static class metadataAction
    extends AbstractAction {
        private metadataAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Ris20DocumentsMenu.createDocument(new File(oslDir, "metadata.osl"));
        }
    }
}

