/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.RIS;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Osl.OslRis20RibGenerator;
import UI_Script.Rib.Animation.MultiFramer;
import UI_Script.Rib.Parsers.ShadowParser;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.Ris20RibStrings;
import Utilities.TextUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.text.Segment;

public class Ris20MenuActions {
    public static int untitledCounter = 1;
    public static int INITIAL_LIGHT_TAG_INDEX = 3;
    public int lightTag = INITIAL_LIGHT_TAG_INDEX;

    public AbstractAction getMultiFrameAction() {
        return new MultiFrameAction();
    }

    public AbstractAction getPxrOslBeautyAction() {
        return new PxrOslBeautyAction();
    }

    public AbstractAction getBasicRISAction() {
        return new BasicRISAction();
    }

    public AbstractAction getShadowDocAction(String shadowType) {
        return new ShadowDocAction(shadowType);
    }

    public class MultiFrameAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            MultiFramer multiframer = new MultiFramer();
            multiframer.generateKeyFrames();
        }
    }

    public class PxrOslBeautyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            OslRis20RibGenerator.createDocument("untitled" + untitledCounter++ + ".rib", "PxrDefault.rib", BBxt.getWindowFile());
        }
    }

    public class BasicRISAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            int majorVersion = RenderInfo.prmanMajorVersionNumber();
            Cutter.setLog("    Info: RmanMenus.DocumentsMenu() - prman major version number is " + majorVersion);
            StringBuffer ribBuf = new StringBuffer();
            ribBuf.append(RenderInfo.getOption("ribparse", ""));
            String rmspath = Preferences.get(Preferences.PATH_PIXAR_RMS);
            if (rmspath.trim().length() > 0) {
                rmspath = rmspath.replace('\\', '/');
                rmspath = TextUtils.trimTrailingChar(rmspath, '/');
                ribBuf.append("IfBegin \"!defined(RMSTREE)\"\n");
                ribBuf.append("\tOption \"user\" \"string RMSTREE\" [\"" + rmspath + "/\"]\n");
                ribBuf.append("IfEnd\n");
            }
            String oslShadersPath = Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
            File oslShadersFile = new File(oslShadersPath);
            String rslShadersPath = Preferences.get(Preferences.PATH_USER_SHADERS);
            File rslShadersFile = new File(rslShadersPath);
            String paths = "";
            paths = paths + (oslShadersFile.exists() ? oslShadersPath + ":" : "");
            paths = paths + (rslShadersFile.exists() ? rslShadersPath : "");
            ribBuf.append("Option \"searchpath\" \"shader\"    [\"" + paths + ":@\"]\n");
            ribBuf.append(RenderInfo.getOption("searchpath", "rixplugin"));
            ribBuf.append(RenderInfo.getOption("searchpath", "texture"));
            ribBuf.append(RenderInfo.getOption("searchpath", "archive"));
            String basicRisBeauty = majorVersion >= 20 ? Ris20RibStrings.basicBeauty_20 : Ris20RibStrings.basicBeauty_19;
            basicRisBeauty = basicRisBeauty.replaceAll("(__LIGHT_ID__)", "" + Ris20MenuActions.this.lightTag);
            ++Ris20MenuActions.this.lightTag;
            ribBuf.append(basicRisBeauty);
            int counter = KAbstractDesktop.getFrameCount();
            String docname = "BasicRis_" + counter + ".rib";
            BBxt.newDocument(docname, ribBuf);
            KAbstractDesktop.incrFrameCount();
        }
    }

    public class ShadowDocAction
    extends AbstractAction {
        private String shadowType = ShadowParser.STANDARD_SHADOW;

        public ShadowDocAction(String shadowType) {
            this.shadowType = shadowType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Segment str = BBxt.getWindowText(null);
            if (str == null) {
                Cutter.setLog("    Error: RmanMenus.ShadowDocAction() BBxt.getWindowText(null) returned null");
                return;
            }
            ShadowParser parser = new ShadowParser(str);
            parser.generateShadow(null, this.shadowType);
        }
    }
}

