/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.RIS;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Tools.Rman.RIS.OslShaderReader;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.Ris20IntegratorStrings;
import UI_Tools.Rman.Ris20PluginArgsReader;
import UI_Tools.Rman.Ris20RibStrings;
import Utilities.MayaNodeIdUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class Ris20PluginsMenu
extends JMenu {
    private Ris20PluginArgsReader argsReader = null;
    private JMenu integratorsMenu = new JMenu("Integrators");
    private JMenu bxdfMenu = new JMenu("Materials");
    private JMenu patternsMenu = new JMenu("PxrPatterns");
    private JMenu mayaMenu = new JMenu("MayaPatterns");
    private JMenu userPatternsMenu = new JMenu("User Patterns");
    private JMenu userOSLMenu = new JMenu("User OSL Shaders");
    private JMenuItem geoAreaLightMenuItem = new JMenuItem("GeoAreaLight");
    private JMenuItem envMenuItem = new JMenuItem("EnvLight");
    private JMenuItem dayMenuItem = new JMenuItem("DayLight");
    private JMenuItem displMenuItem = new JMenuItem("Displacement");
    private JMenuItem reloadPluginsItem = new JMenuItem("Reload All Plugins...");
    private static int INITIAL_LIGHT_TAG_INDEX = 3;
    private int lightTag = INITIAL_LIGHT_TAG_INDEX;
    private OslShaderReader oslReader = new OslShaderReader(this.userOSLMenu);

    public Ris20PluginsMenu() {
        super("Plugins");
        this.addIntegratorItems();
        this.add(this.geoAreaLightMenuItem);
        this.geoAreaLightMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String lightStr = RenderInfo.prmanMajorVersionNumber() >= 20 ? Ris20RibStrings.pxrStdAreaLight : Ris20RibStrings.pxrStdAreaLight;
                lightStr = lightStr.replaceAll("(__LIGHT_ID__)", "" + Ris20PluginsMenu.this.lightTag++);
                BBxt.paste(lightStr);
            }
        });
        this.add(this.envMenuItem);
        this.envMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String lightStr = RenderInfo.prmanMajorVersionNumber() >= 20 ? Ris20RibStrings.pxrStdEnvMapLight : Ris20RibStrings.envlight;
                lightStr = lightStr.replaceAll("(__LIGHT_ID__)", "" + Ris20PluginsMenu.this.lightTag++);
                BBxt.paste(lightStr);
            }
        });
        if (RenderInfo.prmanMajorVersionNumber() >= 20) {
            this.add(this.dayMenuItem);
            this.dayMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String lightStr = Ris20RibStrings.pxrStdEnvDayLight.replaceAll("(__LIGHT_ID__)", "" + Ris20PluginsMenu.this.lightTag++);
                    BBxt.paste(lightStr);
                }
            });
        }
        this.add(this.displMenuItem);
        this.displMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.paste(Ris20RibStrings.displacment);
            }
        });
        this.addSeparator();
        this.add(this.integratorsMenu);
        this.add(this.bxdfMenu);
        this.add(this.patternsMenu);
        this.add(this.mayaMenu);
        this.add(this.userPatternsMenu);
        this.add(this.userOSLMenu);
        this.oslReader.updateMenuItems(true);
        this.argsReader = new Ris20PluginArgsReader();
        this.argsReader.addBxdfMenuItems(this.bxdfMenu);
        this.argsReader.addPatternMenuItems(this.patternsMenu);
        this.argsReader.addUserPluginItems(this.userPatternsMenu);
        this.argsReader.addMayaMenuItems(this.mayaMenu);
        this.addSeparator();
        JMenuItem reportItem = new JMenuItem("View User nodeid's...");
        ActionListener report_action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MayaNodeIdUtils.writeFullReport();
            }
        };
        reportItem.addActionListener(report_action);
        this.add(reportItem);
        ActionListener reloadPluginsAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.init();
                Ris20PluginsMenu.this.argsReader = new Ris20PluginArgsReader();
                Ris20PluginsMenu.this.argsReader.resetDatabase();
                Ris20PluginsMenu.this.argsReader.readDirectories();
                Ris20PluginsMenu.this.argsReader.addBxdfMenuItems(Ris20PluginsMenu.this.bxdfMenu);
                Ris20PluginsMenu.this.argsReader.addPatternMenuItems(Ris20PluginsMenu.this.patternsMenu);
                Ris20PluginsMenu.this.argsReader.addMayaMenuItems(Ris20PluginsMenu.this.mayaMenu);
                Ris20PluginsMenu.this.argsReader.addUserPluginItems(Ris20PluginsMenu.this.userPatternsMenu);
            }
        };
        this.reloadPluginsItem.addActionListener(reloadPluginsAction);
        this.reloadPluginsItem.setEnabled(true);
        this.add(this.reloadPluginsItem);
        JMenuItem item = new JMenuItem("Reload User OSL Shaders...");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ris20PluginsMenu.this.oslReader.updateMenuItems(false);
            }
        };
        item.addActionListener(action);
        this.add(item);
    }

    private void addIntegratorItems() {
        JMenuItem pathItem = new JMenuItem("Path Tracer");
        JMenuItem vcmItem = new JMenuItem("VCM");
        JMenuItem directItem = new JMenuItem("Direct Lighting");
        JMenuItem defaultItem = new JMenuItem("Default");
        JMenuItem visualizerItem = new JMenuItem("Visualizer");
        pathItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.paste(Ris20IntegratorStrings.PathTracer);
            }
        });
        vcmItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.paste(Ris20IntegratorStrings.VCM);
            }
        });
        directItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.paste(Ris20IntegratorStrings.Direct);
            }
        });
        defaultItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.paste(Ris20IntegratorStrings.Default);
            }
        });
        visualizerItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.paste(Ris20IntegratorStrings.Visualizer);
            }
        });
        this.integratorsMenu.add(pathItem);
        this.integratorsMenu.add(vcmItem);
        this.integratorsMenu.add(directItem);
        this.integratorsMenu.add(defaultItem);
        this.integratorsMenu.add(visualizerItem);
    }
}

