/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.RIS;

import UI_BBXT.BBxt;
import UI_Components.KMenu;
import UI_Desktop.MenuItems.KMenuListenerAdapter;
import UI_Script.Rib.RibTokenizer;
import UI_Tools.Rman.RIS.Ris21MenuActions;
import UI_Tools.Rman.Ris21RibStrings;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class Ris21DocumentsMenu
extends KMenu {
    private static int oslDocCounter = 1;
    private static File oslDir = new File(FileUtils.getPWD(), "Cutter_Help/rman_tool_docs/osl");
    JMenuItem basicRisBeautyItem = new JMenuItem("New Beauty Pass Rib");
    JMenuItem multiDocItem = new JMenuItem("Convert to KeyFrame");
    JMenuItem addDenoiseItem = new JMenuItem("Enable Frame Denoise");
    JMenu oslPatternDocsItem = new JMenu("OSL Source Code");

    public Ris21DocumentsMenu() {
        super("Docs");
        this.add(this.basicRisBeautyItem);
        this.addSeparator();
        this.add(this.multiDocItem);
        this.add(this.addDenoiseItem);
        this.addDenoiseItem.addActionListener(new addDenoiseAction());
        this.addSeparator();
        this.add(this.oslPatternDocsItem);
        Ris21MenuActions menuActions = new Ris21MenuActions();
        this.basicRisBeautyItem.addActionListener(menuActions.getPxrSurfRibAction());
        this.basicRisBeautyItem.setEnabled(true);
        this.multiDocItem.addActionListener(menuActions.getMultiFrameAction());
        this.addOslPatternItems(this.oslPatternDocsItem);
        this.addMenuListener(new KMenuListenerAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                KAbstractWindow fw = BBxt.frontWindow();
                if (fw != null && !fw.isSelected()) {
                    Ris21DocumentsMenu.this.multiDocItem.setEnabled(false);
                } else if (fw != null && fw.isSelected()) {
                    String title = fw.getTitle();
                    String ext = FileUtils.getExtension(title);
                    if (ext == null || !ext.equalsIgnoreCase(".rib")) {
                        Ris21DocumentsMenu.this.multiDocItem.setEnabled(false);
                        Ris21DocumentsMenu.this.addDenoiseItem.setEnabled(false);
                    } else if (ext != null && ext != null && ext.equalsIgnoreCase(".rib")) {
                        Ris21DocumentsMenu.this.multiDocItem.setEnabled(true);
                        Ris21DocumentsMenu.this.addDenoiseItem.setText("Enable Frame Denoise");
                        Ris21DocumentsMenu.this.addDenoiseItem.setEnabled(true);
                    } else if (ext != null && ext != null && ext.equalsIgnoreCase(".key")) {
                        Ris21DocumentsMenu.this.addDenoiseItem.setText("Enable XFrame Denoise");
                        Ris21DocumentsMenu.this.addDenoiseItem.setEnabled(true);
                    }
                }
            }
        });
    }

    private void addOslPatternItems(JMenu menu) {
        JMenuItem subItem = new JMenuItem("'st input' -> float output");
        subItem.addActionListener(new stFloatAction());
        menu.add(subItem);
        subItem = new JMenuItem("'st input' -> color output");
        subItem.addActionListener(new stColorAction());
        menu.add(subItem);
        menu.add(new JSeparator());
        subItem = new JMenuItem("metadata summary");
        subItem.addActionListener(new metadataAction());
        menu.add(subItem);
    }

    public static void createDocument(File file) {
        String str = FileUtils.read(file);
        if (str == null || str.trim().length() == 0) {
            str = "Error:Ris21DocumentsMenu.createDocument(File) - cannot find file \"" + file.getPath() + "\"";
        }
        BBxt.newDocument("untitled" + oslDocCounter++ + ".osl", str);
    }

    public static void addDenoise(boolean isXFrame) {
        String ribname = TextUtils.removeExtension(BBxt.getWindowTitle());
        ribname = ribname + "_";
        String str = Ris21RibStrings.denoiseOptions;
        str = str.replaceAll("(__IMAGE_PATH__)", ribname);
        File f = new File(FileUtils.getPWD(), "DenoiseOptions.rib");
        FileUtils.writeFile(f, str);
        str = Ris21RibStrings.denoise;
        str = str.replaceAll("(__IMAGE_PATH__)", ribname);
        f = new File(FileUtils.getPWD(), "Denoise.rib");
        FileUtils.writeFile(f, str);
        JEditorPane textpane = BBxt.getTextPane();
        Document document = textpane.getDocument();
        Segment segment = DocumentUtils.getSegment(textpane.getDocument(), 0, document.getLength());
        int buffIndex = 0;
        RibTokenizer ribtok = new RibTokenizer();
        ribtok.setBuffer(segment);
        String nextStatment = ribtok.getNextRibStatement(null, true);
        while (!nextStatment.equals("")) {
            nextStatment = ribtok.getNextRibStatement(null, false);
            buffIndex = ribtok.getBufferIndex();
            if (nextStatment.equals("Display")) {
                BBxt.insertStringAt(document, buffIndex + 1, 0, "ReadArchive \"./DenoiseOptions.rib\"\n#");
                break;
            }
            nextStatment = ribtok.getNextRibStatement(null, true);
        }
        int len = document.getLength();
        document = textpane.getDocument();
        segment = DocumentUtils.getSegment(document, 0, len);
        ribtok.setBuffer(segment);
        nextStatment = ribtok.getNextRibStatement(null, true);
        buffIndex = 0;
        while (!nextStatment.equals("")) {
            nextStatment = ribtok.getNextRibStatement(null, false);
            buffIndex = ribtok.getBufferIndex();
            if (nextStatment.equals("ReadArchive")) {
                ribtok.setBufferIndex(buffIndex + 12);
                String temp = ribtok.getNextStr();
                if (temp.equals("\"./XFrameDenoise.rib\"") || temp.equals("\"./Denoise.rib\"")) {
                    nextStatment = ribtok.getNextRibStatement(null, false);
                    int nextIndex = ribtok.getBufferIndex();
                    int lenn = nextIndex - buffIndex - 1;
                    if (nextIndex == len) {
                        ++lenn;
                    }
                    BBxt.insertStringAt(document, buffIndex, lenn, "");
                }
                ribtok.setBufferIndex(buffIndex);
            }
            nextStatment = ribtok.getNextRibStatement(null, true);
        }
        len = document.getLength();
        if (isXFrame) {
            BBxt.insertStringAt(document, len, 0, "\nReadArchive \"./XFrameDenoise.rib\"\n");
        } else {
            BBxt.insertStringAt(document, len, 0, "\nReadArchive \"./Denoise.rib\"\n");
        }
        BBxt.parseAll();
    }

    private static class addDenoiseAction
    extends AbstractAction {
        private addDenoiseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            KAbstractWindow fw = BBxt.frontWindow();
            if (fw == null || fw != null && !fw.isSelected()) {
                return;
            }
            String title = fw.getTitle();
            String ext = FileUtils.getExtension(title);
            if (ext.equalsIgnoreCase(".key")) {
                Ris21DocumentsMenu.addDenoise(true);
            } else {
                Ris21DocumentsMenu.addDenoise(false);
            }
        }
    }

    private static class stFloatAction
    extends AbstractAction {
        private stFloatAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Ris21DocumentsMenu.createDocument(new File(oslDir, "st_float.osl"));
        }
    }

    private static class stColorAction
    extends AbstractAction {
        private stColorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Ris21DocumentsMenu.createDocument(new File(oslDir, "st_color.osl"));
        }
    }

    private static class metadataAction
    extends AbstractAction {
        private metadataAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Ris21DocumentsMenu.createDocument(new File(oslDir, "metadata.osl"));
        }
    }
}

