/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.RIS;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Osl.OslRis22RibGenerator;
import UI_Script.Rib.Animation.MultiFramer;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.Ris22RibStrings;
import Utilities.TextUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class Ris22MenuActions {
    public static int untitledCounter = 1;
    public static int INITIAL_LIGHT_TAG_INDEX = 3;
    public int lightTag = INITIAL_LIGHT_TAG_INDEX;

    public AbstractAction getMultiFrameAction() {
        return new MultiFrameAction();
    }

    public AbstractAction getPxrOslBeautyAction() {
        return new PxrOslBeautyAction();
    }

    public AbstractAction getPxrSurfRibAction() {
        return new PxrSurfRibAction();
    }

    public static String getSharedOptions() {
        String options = Ris22RibStrings.basicOptions;
        String rmspath = Preferences.get(Preferences.PATH_PIXAR_RMS);
        if (rmspath.trim().length() > 0) {
            rmspath = rmspath.replace('\\', '/');
            rmspath = TextUtils.trimTrailingChar(rmspath, '/');
            options = options.replaceAll("(__RMSTREE__)", rmspath);
        }
        String path = RenderInfo.get(27);
        options = options.replaceAll("(__OSL_SHADERS__)", path);
        path = RenderInfo.get(26);
        options = options.replaceAll("(__RIXPLUGINS__)", path);
        path = RenderInfo.get(14);
        options = options.replaceAll("(__TEXTURES__)", path);
        path = RenderInfo.get(20);
        options = options.replaceAll("(__ARCHIVES__)", path);
        return options;
    }

    public class MultiFrameAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            MultiFramer multiframer = new MultiFramer();
            multiframer.generateKeyFrames();
        }
    }

    public class PxrOslBeautyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            OslRis22RibGenerator.createBeauty("untitled" + untitledCounter++ + ".rib", BBxt.getWindowFile());
        }
    }

    public class PxrSurfRibAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String beautyRib = Ris22RibStrings.pxrSurfBeautyRib;
            beautyRib = beautyRib.replaceAll("(__LIGHT_ID__)", "" + Ris22MenuActions.this.lightTag);
            ++Ris22MenuActions.this.lightTag;
            String options = Ris22MenuActions.getSharedOptions();
            beautyRib = beautyRib.replaceAll("(__SHARED_OPTIONS__)", options);
            String frameSizeStr = Preferences.get(Preferences.FRAME_SIZE);
            beautyRib = frameSizeStr != null && frameSizeStr.trim().length() > 0 ? beautyRib.replaceAll("(__WIDTH_HEIGHT__)", frameSizeStr) : beautyRib.replaceAll("(__WIDTH_HEIGHT__)", "640 360");
            int counter = KAbstractDesktop.getFrameCount();
            String docname = "BasicRis_" + counter + ".rib";
            BBxt.newDocument(docname, beautyRib);
            KAbstractDesktop.incrFrameCount();
        }
    }
}

